/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.swtgui;

import java.util.Arrays;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.swtgui.JSmoothApplication;
import net.charabia.jsmoothgen.application.swtgui.JSmoothPage;
import net.charabia.jsmoothgen.application.swtgui.SkeletonPropertiesDialog;
import net.charabia.jsmoothgen.application.swtgui.resources.JSmoothResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SkeletonPage
extends JSmoothPage {
    private Dialog propsDialog;
    private Combo skelcombo;
    private JSmoothApplication js;
    private String[] skeletons;

    public SkeletonPage(JSmoothApplication js) {
        super(js);
    }

    public Control createPageArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(top, 0);
        label.setText("Skeleton:");
        this.skelcombo = new Combo(top, 8);
        GridData grid = new GridData(4);
        grid.widthHint = 120;
        this.skelcombo.setLayoutData((Object)grid);
        this.loadSkeleton(this.getApplication().getInitialSkeletonName());
        this.skelcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SkeletonPage.this.setSkeletonName(SkeletonPage.this.skelcombo.getText());
            }
        });
        Button button = new Button(top, 8);
        grid = new GridData(4);
        grid.widthHint = 120;
        button.setLayoutData((Object)grid);
        button.setText("Properties...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new SkeletonPropertiesDialog(SkeletonPage.this).open();
            }
        });
        return top;
    }

    public void setSkeletonName(String name) {
        System.out.println("[DEBUG] Setting skeleton name: " + name);
        JSmoothModelBean jsmodel = this.getApplication().getModelBean();
        jsmodel.setSkeletonName(name);
        this.getApplication().setSkeletonProperties(this.getApplication().getInititalSkeletonProperties());
    }

    protected void configureResources() {
        this.setImage(JSmoothResources.IMG_SWITCHER_SKELETON_PAGE);
        this.setToolTip("Skeleton");
    }

    private void loadSkeleton(String skelname) {
        Object[] skeletons = this.getApplication().getAllSkeletonNames();
        this.skelcombo.setItems((String[])skeletons);
        System.out.println("[DEBUG] Loading skeleton : " + skelname);
        int index = Arrays.binarySearch(skeletons, skelname);
        this.skelcombo.select(index);
    }

    public void load() {
        this.loadSkeleton(this.getApplication().getModelBean().getSkeletonName());
    }
}

