/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import se.datadosen.component.RiverLayout;

public class SkeletonChooser
extends Editor
implements JSmoothModelBean.SkeletonChangedListener {
    private JComboBox m_skelcombo = new JComboBox();
    private JEditorPane m_skeldesc = new JEditorPane("text/html", "<html></html>");

    public SkeletonChooser() {
        this.setLayout((LayoutManager)new RiverLayout());
        this.m_skelcombo.addItem("<none>");
        Iterator i = Main.SKELETONS.getIteratorNoDebugName();
        while (i.hasNext()) {
            this.m_skelcombo.addItem(i.next().toString());
        }
        this.add("hfill", this.m_skelcombo);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)new JScrollPane(this.m_skeldesc){

            public Dimension getMinimumSize() {
                return new Dimension(10, 100);
            }

            public Dimension getPreferredSize() {
                return new Dimension(10, 100);
            }
        }, "Center");
        this.add("br hfill", jp);
        this.m_skeldesc.setEditable(false);
        this.m_skelcombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonChooser.this.updateModel();
                SkeletonChooser.this.doLayout();
                SkeletonChooser.this.validate();
                SkeletonChooser.this.repaint();
            }
        });
    }

    private void updateSkeletonData() {
        String skelname = (String)this.m_skelcombo.getSelectedItem();
        if (skelname == null) {
            return;
        }
        SkeletonBean skel = Main.SKELETONS.getSkeleton(skelname);
        if (skel != null) {
            this.m_skeldesc.setText(Main.local(skel.getDescription()));
            this.m_skeldesc.setCaretPosition(0);
        }
    }

    public void dataChanged() {
        String skelname = this.m_model.getSkeletonName();
        if (skelname != null) {
            SkeletonBean skel = Main.SKELETONS.getSkeleton(skelname);
            if (skel != null) {
                this.m_skeldesc.setText(Main.local(skel.getDescription()));
                this.m_skeldesc.setCaretPosition(0);
                this.m_skelcombo.setSelectedItem(skelname);
            } else {
                this.m_skelcombo.setSelectedItem("");
                this.m_skeldesc.setText("");
                this.m_skeldesc.setCaretPosition(0);
            }
        } else {
            this.m_skelcombo.setSelectedItem("");
            this.m_skeldesc.setText(Main.local("SKEL_CHOOSER_NONE"));
            this.m_skeldesc.setCaretPosition(0);
        }
    }

    public void updateModel() {
        String skelname = (String)this.m_skelcombo.getSelectedItem();
        if (skelname == null) {
            return;
        }
        if (skelname.equals("<none>")) {
            skelname = "<none>";
        }
        this.m_model.setSkeletonName(skelname);
    }

    public String getLabel() {
        return "SKELETONCHOOSER_LABEL";
    }

    public String getDescription() {
        return "SKELETONCHOOSER_HELP";
    }

    public void skeletonChanged() {
        this.dataChanged();
    }

    public boolean needsBigSpace() {
        return true;
    }
}

