/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.gui.AboutBox;
import net.charabia.jsmoothgen.application.gui.MasterPanel;
import net.charabia.jsmoothgen.application.gui.Splash;
import net.charabia.jsmoothgen.application.gui.util.CompilationDialog;
import net.charabia.jsmoothgen.application.gui.util.RecentFileMenu;
import net.charabia.jsmoothgen.application.gui.util.SimpleFileFilter;
import net.charabia.jsmoothgen.skeleton.SkeletonList;

public class Main
extends JFrame {
    public static final SkeletonList SKELETONS = new SkeletonList(new File("skeletons"));
    public static final String VERSION = "@{VERSION}@";
    public static final String RELEASEINFO = "@{RELEASEINFO}@";
    public static final ResourceBundle TEXTS = PropertyResourceBundle.getBundle("locale.Texts");
    public static Main MAIN;
    private MasterPanel m_panel;
    private JFileChooser m_projectFileChooser = new JFileChooser();
    private RecentFileMenu m_recentFiles = null;
    private final Icon ICON_NEW = new ImageIcon(this.getClass().getResource("/icons/stock_new.png"));
    public final Action NEW = new AbstractAction(Main.local("NEW"), this.ICON_NEW){

        public void actionPerformed(ActionEvent e) {
            Main.this.m_panel.newModel();
            Main.this.setTitle("Untitled");
        }
    };
    private final Icon ICON_OPEN = new ImageIcon(this.getClass().getResource("/icons/stock_open.png"));
    public final Action OPEN = new AbstractAction(Main.local("OPEN"), this.ICON_OPEN){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.m_projectFileChooser.showOpenDialog(Main.this) == 0) {
                File f = Main.this.m_projectFileChooser.getSelectedFile();
                if (Main.this.m_panel.openFile(f)) {
                    Main.this.m_recentFiles.add(f.getAbsolutePath());
                    Main.this.setTitle(f.getAbsolutePath());
                }
            }
        }
    };
    private final Icon ICON_SAVE = new ImageIcon(this.getClass().getResource("/icons/stock_save.png"));
    public final Action SAVE = new AbstractAction(Main.local("SAVE"), this.ICON_SAVE){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.m_panel.getProjectFile() == null) {
                Main.this.SAVE_AS.actionPerformed(e);
            } else {
                Main.this.m_panel.save();
            }
        }
    };
    private final Icon ICON_SAVE_AS = new ImageIcon(this.getClass().getResource("/icons/stock_save_as.png"));
    public final Action SAVE_AS = new AbstractAction(Main.local("SAVE_AS"), this.ICON_SAVE_AS){

        public void actionPerformed(ActionEvent e) {
            if (Main.this.m_projectFileChooser.showSaveDialog(Main.this) == 0) {
                File nf;
                String suf;
                if (Main.this.m_panel.getModel() != null && Main.this.m_panel.getProjectFile() != null) {
                    Main.this.m_panel.getModel().normalizePaths(Main.this.m_panel.getProjectFile().getParentFile(), false);
                }
                if (!"jsmooth".equalsIgnoreCase(suf = Main.this.getSuffix(nf = Main.this.m_projectFileChooser.getSelectedFile()))) {
                    nf = new File(nf.toString() + ".jsmooth");
                }
                if (Main.this.m_panel.getModel() != null) {
                    Main.this.m_panel.getModel().normalizePaths(nf.getParentFile(), true);
                }
                Main.this.m_panel.setProjectFile(nf);
                Main.this.setTitle(nf.getAbsolutePath());
                Main.this.m_panel.save();
                Main.this.m_recentFiles.add(nf.getAbsolutePath());
            }
        }
    };
    private final Icon ICON_EXIT = new ImageIcon(this.getClass().getResource("/icons/stock_exit-16.png"));
    public final Action EXIT = new AbstractAction(Main.local("EXIT"), this.ICON_EXIT){

        public void actionPerformed(ActionEvent e) {
            Main.this.m_recentFiles.savePrefs();
            Main.this.saveWindowSettings();
            if (Main.this.m_panel.getProjectFile() != null) {
                Main.this.m_panel.save();
            }
            System.exit(0);
        }
    };
    private final Icon ICON_COMPILE = new ImageIcon(this.getClass().getResource("/icons/stock_autopilot-24.png"));
    public final Action COMPILE = new AbstractAction(Main.local("COMPILE"), this.ICON_COMPILE){

        public void actionPerformed(ActionEvent e) {
            Main.this.m_panel.fireUpdateModel();
            Main.this.SAVE.actionPerformed(e);
            if (Main.this.m_panel.getProjectFile() == null) {
                return;
            }
            ExeCompiler.CompilerRunner compiler = Main.this.m_panel.getCompiler();
            CompilationDialog dia = new CompilationDialog((Frame)Main.this, true);
            dia.setTitle(Main.local("COMPILATION_DIALOG_TITLE"));
            dia.pack();
            if (compiler != null) {
                dia.setCompiler(compiler.getCompiler());
                dia.compile(compiler);
            } else {
                dia.setNewState(100, "Error, compiler couldn't be created. Error description should follow:");
                Vector v = Main.this.m_panel.getLastErrors();
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    dia.setNewState(100, "- " + i.next().toString());
                }
                dia.setVisible(true);
            }
        }
    };
    private final Icon ICON_RUNEXE = new ImageIcon(this.getClass().getResource("/icons/stock_next.png"));
    public final Action RUNEXE = new AbstractAction(Main.local("RUNEXE"), this.ICON_RUNEXE){

        public void actionPerformed(ActionEvent e) {
            Main.this.m_panel.runexe();
        }
    };
    private final Icon ICON_ABOUT = new ImageIcon(this.getClass().getResource("/icons/stock_about.png"));
    public final Action ABOUT = new AbstractAction(Main.local("ABOUT"), this.ICON_ABOUT){

        public void actionPerformed(ActionEvent e) {
            AboutBox ab = new AboutBox((Frame)Main.this, true);
            ab.setVersion("@{VERSION}@ (@{RELEASEINFO}@)");
            ab.setVisible(true);
        }
    };

    private Main() {
        Splash splash = new Splash(this, "/icons/splash.png", false);
        splash.setVersion(VERSION);
        splash.show();
        this.m_projectFileChooser.addChoosableFileFilter(new SimpleFileFilter("jsmooth", "JSmooth Project Files"));
        this.getContentPane().setLayout(new BorderLayout());
        this.m_panel = new MasterPanel();
        this.getContentPane().add("Center", this.m_panel);
        this.setupMenus();
        this.setupToolBar();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Main.this.EXIT.actionPerformed(null);
            }
        });
        this.setTitle("Untitled");
        this.loadWindowSettings();
        splash.dispose();
    }

    private void setupMenus() {
        JMenuBar bar = new JMenuBar();
        this.setJMenuBar(bar);
        JMenu menu = new JMenu(Main.local("MENU_SYSTEM"));
        menu.add(new JMenuItem(this.NEW));
        menu.addSeparator();
        menu.add(new JMenuItem(this.OPEN));
        menu.add(new JMenuItem(this.SAVE));
        menu.add(new JMenuItem(this.SAVE_AS));
        menu.addSeparator();
        JMenu recentfiles = new JMenu(Main.local("MENU_RECENT"));
        this.m_recentFiles = new RecentFileMenu(recentfiles, 5, Main.class, new RecentFileMenu.Action(){

            public void action(String path) {
                if (Main.this.m_panel.openFile(new File(path))) {
                    Main.this.setTitle(path);
                }
            }
        });
        menu.add(recentfiles);
        menu.addSeparator();
        menu.add(new JMenuItem(this.EXIT));
        bar.add(menu);
        menu = new JMenu(Main.local("MENU_PROJECT"));
        menu.add(new JMenuItem(this.COMPILE));
        menu.add(new JMenuItem(this.RUNEXE));
        bar.add(menu);
        menu = new JMenu(Main.local("MENU_HELP"));
        menu.add(new JMenuItem(this.ABOUT));
        bar.add(menu);
    }

    private void setupToolBar() {
        JToolBar bar = new JToolBar();
        bar.add(this.NEW);
        bar.addSeparator();
        bar.add(this.OPEN);
        bar.add(this.SAVE);
        bar.add(this.SAVE_AS);
        bar.addSeparator();
        bar.add(this.COMPILE);
        bar.add(this.RUNEXE);
        bar.addSeparator();
        bar.add(this.ABOUT);
        this.getContentPane().add("North", bar);
    }

    public static String local(String key) {
        try {
            String value = TEXTS.getString(key);
            return value;
        }
        catch (Exception exception) {
            return "[" + key + "]";
        }
    }

    private String getSuffix(File f) {
        String fstr = f.getAbsolutePath();
        int lastDot = fstr.lastIndexOf(46);
        if (lastDot >= 0 && lastDot + 1 < fstr.length()) {
            return fstr.substring(lastDot + 1);
        }
        return "";
    }

    public void setTitle(String title) {
        super.setTitle("JSmooth @{VERSION}@: " + title);
    }

    public void saveWindowSettings() {
        Preferences prefs = Preferences.systemNodeForPackage(this.getClass());
        prefs.putInt("window-state", this.getExtendedState());
        prefs.putInt("window-x", (int)this.getLocation().getX());
        prefs.putInt("window-y", (int)this.getLocation().getY());
        prefs.putInt("window-width", this.getWidth());
        prefs.putInt("window-height", this.getHeight());
    }

    public void loadWindowSettings() {
        Preferences prefs = Preferences.systemNodeForPackage(this.getClass());
        this.setExtendedState(prefs.getInt("window-state", 0));
        if (prefs.getInt("window-x", -1) > 0) {
            this.setLocation(prefs.getInt("window-x", 10), prefs.getInt("window-y", 10));
            int w = prefs.getInt("window-width", 500);
            int h = prefs.getInt("window-height", 400);
            if (w <= 0) {
                w = 400;
            }
            if (h <= 0) {
                h = 400;
            }
            this.setSize(w, h);
            this.setExtendedState(prefs.getInt("window-state", 0));
        } else {
            this.setSize(500, 400);
            this.setExtendedState(prefs.getInt("window-state", 0));
        }
    }

    public static void main(String[] args) {
        System.out.println("Running JSmooth...");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MAIN = new Main();
        if (args.length > 0) {
            File f = new File(args[0]);
            if (f.exists()) {
                Main.MAIN.m_panel.openFile(f);
                MAIN.setTitle(f.toString());
            } else {
                JOptionPane.showMessageDialog(null, Main.local("GENERAL_CANTOPENFILE"), Main.local("GENERAL_ERROR_LABEL"), 0);
            }
        }
        MAIN.setVisible(true);
    }
}

