/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application;

import java.io.File;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.JavaPropertyPair;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;

public class PropertiesBuilder {
    public static String makeProperties(File basedir, JSmoothModelBean obj) {
        JavaPropertyPair[] javapairs;
        int i;
        File curdir;
        StringBuffer out = new StringBuffer();
        PropertiesBuilder.addPair("arguments", obj.getArguments(), out);
        PropertiesBuilder.addPair("mainclassname", obj.getMainClassName(), out);
        PropertiesBuilder.addPair("jvmsearch", PropertiesBuilder.makePathConc(obj.getJVMSearchPath()), out);
        PropertiesBuilder.addPair("minversion", obj.getMinimumVersion(), out);
        PropertiesBuilder.addPair("maxversion", obj.getMaximumVersion(), out);
        PropertiesBuilder.addPair("currentdir", obj.getCurrentDirectory(), out);
        if (obj.getEmbeddedJar() && obj.getJarLocation().trim().length() > 0) {
            PropertiesBuilder.addPair("embedjar", "true", out);
        } else {
            PropertiesBuilder.addPair("embedjar", "false", out);
        }
        if (obj.getMaximumMemoryHeap() > 1) {
            PropertiesBuilder.addPair("maxheap", Integer.toString(obj.getMaximumMemoryHeap()), out);
        }
        if (obj.getInitialMemoryHeap() > 1) {
            PropertiesBuilder.addPair("initialheap", Integer.toString(obj.getInitialMemoryHeap()), out);
        }
        if (obj.getVmParameter() != null && !obj.getVmParameter().isEmpty()) {
            PropertiesBuilder.addPair("vmparameter", obj.getVmParameter(), out);
        }
        if ((curdir = new File(obj.getExecutableName()).getParentFile()) == null) {
            curdir = basedir.getAbsoluteFile();
        }
        if (!curdir.isAbsolute()) {
            curdir = new File(basedir, curdir.toString());
        }
        if (obj.getCurrentDirectory() != null) {
            File newcurdir = new File(obj.getCurrentDirectory());
            if (!"${EXECUTABLEPATH}".equalsIgnoreCase(obj.getCurrentDirectory())) {
                curdir = !newcurdir.isAbsolute() ? new File(curdir, newcurdir.toString()) : newcurdir;
            }
        }
        if (obj.getBundledJVMPath() != null) {
            PropertiesBuilder.addPair("bundledvm", PropertiesBuilder.getRenormalizedPathIfNeeded(obj.getBundledJVMPath(), basedir, curdir), out);
        }
        if (obj.getClassPath() != null) {
            String[] relcp = new String[obj.getClassPath().length];
            for (i = 0; i < relcp.length; ++i) {
                relcp[i] = PropertiesBuilder.getRenormalizedPathIfNeeded(obj.getClassPath()[i], basedir, curdir);
            }
            PropertiesBuilder.addPair("classpath", PropertiesBuilder.makePathConc(relcp), out);
        }
        if (obj.getSkeletonProperties() != null) {
            for (int i2 = 0; i2 < obj.getSkeletonProperties().length; ++i2) {
                JSmoothModelBean.Property prop = obj.getSkeletonProperties()[i2];
                if (prop.getKey() == null) continue;
                String val = prop.getValue();
                if (val == null) {
                    val = "";
                }
                PropertiesBuilder.addPair("skel_" + prop.getKey(), val, out);
            }
        }
        if ((javapairs = obj.getJavaProperties()) != null) {
            PropertiesBuilder.addPair("javapropertiescount", new Integer(javapairs.length).toString(), out);
            for (i = 0; i < javapairs.length; ++i) {
                PropertiesBuilder.addPair("javaproperty_name_" + i, javapairs[i].getName(), out);
                PropertiesBuilder.addPair("javaproperty_value_" + i, javapairs[i].getValue(), out);
            }
        }
        return out.toString();
    }

    public static String makeManifest(JSmoothModelBean data, SkeletonBean skel) {
        StringBuilder retVal = new StringBuilder();
        String platform = "x86";
        String shortName = skel.getShortName();
        if (shortName.contains("64")) {
            platform = "ia64";
        }
        retVal.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>").append("\n");
        retVal.append("<assembly xmlns=\"urn:schemas-microsoft-com:asm.v1\" manifestVersion=\"1.0\">").append("\n");
        retVal.append("  <assemblyIdentity type=\"win32\"").append("\n");
        retVal.append("    name=\"").append(shortName).append("\"").append("\n");
        retVal.append("    version=\"1.0.0.0\"").append("\n");
        retVal.append("    processorArchitecture=\"").append(platform).append("\"").append("\n");
        retVal.append("  />").append("\n");
        retVal.append("  <dependency>").append("\n");
        retVal.append("    <dependentAssembly>").append("\n");
        retVal.append("      <assemblyIdentity type=\"win32\" name=\"Microsoft.Windows.Common-Controls\" version=\"6.0.0.0\" processorArchitecture=\"*\" publicKeyToken=\"6595b64144ccf1df\" language=\"*\"/>").append("\n");
        retVal.append("    </dependentAssembly>").append("\n");
        retVal.append("  </dependency>").append("\n");
        if (data.isUacRequireAdmin()) {
            retVal.append("  <trustInfo xmlns=\"urn:schemas-microsoft-com:asm.v2\">").append("\n");
            retVal.append("    <security>").append("\n");
            retVal.append("      <requestedPrivileges>").append("\n");
            retVal.append("        <requestedExecutionLevel level=\"requireAdministrator\"/>").append("\n");
            retVal.append("      </requestedPrivileges>").append("\n");
            retVal.append("    </security>").append("\n");
            retVal.append("  </trustInfo>").append("\n");
        }
        retVal.append("</assembly>");
        return retVal.toString();
    }

    public static String getRenormalizedPathIfNeeded(String value, File previousbasedir, File newbasedir) {
        if (newbasedir == null) {
            return value;
        }
        if (value == null) {
            return "";
        }
        File abs = new File(previousbasedir, value).getAbsoluteFile();
        File n = JSmoothModelPersistency.makePathRelativeIfPossible(newbasedir, abs);
        return n.toString();
    }

    public static String escapeString(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    out.append("\\n");
                    continue block6;
                }
                case '\t': {
                    out.append("\\t");
                    continue block6;
                }
                case '\r': {
                    out.append("\\r");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static void addPair(String name, String value, StringBuffer out) {
        out.append(PropertiesBuilder.escapeString(name));
        out.append("=");
        out.append(PropertiesBuilder.escapeString(value));
        out.append("\n");
    }

    public static String makePathConc(String[] elements) {
        StringBuffer buf = new StringBuffer();
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                buf.append(elements[i]);
                if (i + 1 >= elements.length) continue;
                buf.append(";");
            }
        }
        return buf.toString();
    }
}

