/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.redline.header;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.freecompany.redline.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeader {
    protected static final int HEADER_HEADER_SIZE = 16;
    protected static final int ENTRY_SIZE = 16;
    protected static final int MAGIC_WORD = -1901205503;
    protected final Map<Integer, Tag> tags = new HashMap<Integer, Tag>();
    protected final Map<Integer, Entry<?>> entries = new TreeMap();
    protected final Map<Entry<?>, Integer> pending = new LinkedHashMap();

    protected abstract boolean pad();

    public int read(ReadableByteChannel in) throws IOException {
        ByteBuffer header = Util.fill(in, 16);
        int magic = header.getInt();
        if (magic == 0) {
            header.compact();
            Util.fill(in, header);
            magic = header.getInt();
        }
        Util.check(-1901205503, magic);
        header.getInt();
        ByteBuffer index = Util.fill(in, header.getInt() * 16);
        int total = header.getInt();
        int pad = this.pad() ? Util.round(total, 7) - total : 0;
        ByteBuffer data = Util.fill(in, total + pad);
        int count = 0;
        while (index.remaining() >= 16) {
            this.readEntry(index.getInt(), index.getInt(), index.getInt(), index.getInt(), data);
            ++count;
        }
        return count;
    }

    public int write(WritableByteChannel out) throws IOException {
        ByteBuffer header = this.getHeader();
        ByteBuffer index = this.getIndex();
        ByteBuffer data = this.getData(index);
        data.flip();
        int pad = this.pad() ? Util.round(data.remaining(), 7) - data.remaining() : 0;
        header.putInt(data.remaining());
        Util.empty(out, (ByteBuffer)header.flip());
        Util.empty(out, (ByteBuffer)index.flip());
        Util.empty(out, data);
        return pad;
    }

    public int count() {
        return this.entries.size();
    }

    protected ByteBuffer getHeader() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(-1901205503);
        buffer.putInt(0);
        buffer.putInt(this.count());
        return buffer;
    }

    protected ByteBuffer getIndex() throws IOException {
        return ByteBuffer.allocate(this.count() * 16);
    }

    protected ByteBuffer getData(ByteBuffer index) throws IOException {
        int offset = 0;
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        Iterator<Integer> i = this.entries.keySet().iterator();
        index.position(16);
        Entry<?> first = this.entries.get(i.next());
        Entry<?> entry = null;
        try {
            while (i.hasNext()) {
                entry = this.entries.get(i.next());
                offset = this.writeData(buffers, index, entry, offset);
            }
            index.position(0);
            offset = this.writeData(buffers, index, first, offset);
            index.position(index.limit());
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while writing '" + entry + "'.", t);
        }
        ByteBuffer data = ByteBuffer.allocate(offset);
        for (ByteBuffer buffer : buffers) {
            data.put(buffer);
        }
        return data;
    }

    protected int writeData(Collection<ByteBuffer> buffers, ByteBuffer index, Entry<?> entry, int offset) {
        int shift = entry.getOffset(offset) - offset;
        if (shift > 0) {
            buffers.add(ByteBuffer.allocate(shift));
        }
        int size = entry.size();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        entry.index(index, offset += shift);
        if (entry.ready()) {
            entry.write(buffer);
            buffer.flip();
        } else {
            this.pending.put(entry, offset);
        }
        buffers.add(buffer);
        return offset + size;
    }

    public void writePending(FileChannel channel) {
        for (Entry<?> entry : this.pending.keySet()) {
            try {
                ByteBuffer data = ByteBuffer.allocate(entry.size());
                entry.write(data);
                channel.position(112 + this.count() * 16 + this.pending.get(entry));
                Util.empty(channel, (ByteBuffer)data.flip());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error writing pending entry '" + entry.getTag() + "'.", t);
            }
        }
    }

    public Map<Entry<?>, Integer> getPending() {
        return this.pending;
    }

    public void removeEntry(Entry<?> entry) {
        this.entries.remove(entry.getTag());
    }

    public Entry<?> getEntry(Tag tag) {
        return this.getEntry(tag.getCode());
    }

    public Entry<?> getEntry(int tag) {
        return this.entries.get(tag);
    }

    public Entry<String[]> createEntry(Tag tag, CharSequence value) {
        Entry<String[]> entry = this.createEntry(tag.getCode(), tag.getType(), 1);
        entry.setValues(new String[]{((Object)value).toString()});
        return entry;
    }

    public Entry<int[]> createEntry(Tag tag, int value) {
        Entry<int[]> entry = this.createEntry(tag.getCode(), tag.getType(), 1);
        entry.setValues(new int[]{value});
        return entry;
    }

    public <T> Entry<T> createEntry(Tag tag, T values) {
        Entry<?> entry = this.createEntry(tag.getCode(), tag.getType(), values.getClass().isArray() ? Array.getLength(values) : 1);
        entry.setValues(values);
        return entry;
    }

    public <T> Entry<T> createEntry(Tag tag, int type, T values) {
        Entry<?> entry = this.createEntry(tag.getCode(), type, values.getClass().isArray() ? Array.getLength(values) : 1);
        entry.setValues(values);
        return entry;
    }

    public <T> Entry<T> createEntry(int tag, int type, T values) {
        Entry<?> entry = this.createEntry(tag, type, values.getClass().isArray() ? Array.getLength(values) : 1);
        entry.setValues(values);
        return entry;
    }

    public Entry<?> addEntry(Tag tag, int count) {
        return this.createEntry(tag.getCode(), tag.getType(), count);
    }

    public Entry<?> readEntry(int tag, int type, int offset, int count, ByteBuffer data) {
        Entry<?> entry = this.createEntry(tag, type, count);
        ByteBuffer buffer = data.duplicate();
        buffer.position(offset);
        entry.read(buffer);
        entry.setOffset(offset);
        return entry;
    }

    public Entry<?> createEntry(int tag, int type, int count) {
        Entry<?> entry = this.createEntry(type);
        entry.setTag(tag);
        entry.setCount(count);
        this.entries.put(tag, entry);
        return entry;
    }

    protected Entry<?> createEntry(int type) {
        switch (type) {
            case 0: {
                return new NullEntry();
            }
            case 1: {
                return new CharEntry();
            }
            case 2: {
                return new Int8Entry();
            }
            case 3: {
                return new Int16Entry();
            }
            case 4: {
                return new Int32Entry();
            }
            case 5: {
                return new Int64Entry();
            }
            case 6: {
                return new StringEntry();
            }
            case 7: {
                return new BinEntry();
            }
            case 8: {
                return new StringArrayEntry();
            }
            case 9: {
                return new I18NStringEntry();
            }
        }
        throw new IllegalStateException("Unknown entry type '" + type + "'.");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Start Header ( ").append(this.getClass()).append(")").append("\n");
        int count = 0;
        for (int tag : this.entries.keySet()) {
            builder.append(count++).append(": ").append(this.entries.get(tag)).append("\n");
        }
        return builder.toString();
    }

    class I18NStringEntry
    extends StringEntry {
        I18NStringEntry() {
        }

        public int getType() {
            return 9;
        }
    }

    class StringArrayEntry
    extends StringEntry {
        StringArrayEntry() {
        }

        public int getType() {
            return 8;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BinEntry
    extends AbstractEntry<byte[]> {
        BinEntry() {
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void read(ByteBuffer buffer) {
            byte[] values = new byte[this.count];
            buffer.get(values);
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            data.put((byte[])this.values);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            if (this.values != null) {
                builder.append("\n");
                Util.dump((byte[])this.values, (Appendable)builder);
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringEntry
    extends AbstractEntry<String[]> {
        StringEntry() {
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public int size() {
            if (this.size != 0) {
                return this.size;
            }
            for (String s : (String[])this.values) {
                this.size += Charset.forName("UTF-8").encode(s).remaining() + 1;
            }
            return this.size;
        }

        @Override
        public void read(ByteBuffer buffer) {
            String[] values = new String[this.count];
            for (int x = 0; x < this.count; ++x) {
                int length = 0;
                while (buffer.get(buffer.position() + length) != 0) {
                    ++length;
                }
                byte[] bytes = new byte[length];
                ByteBuffer slice = buffer.slice();
                buffer.position(buffer.position() + length + 1);
                slice.limit(length);
                values[x] = Charset.forName("UTF-8").decode(slice).toString();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (String s : (String[])this.values) {
                data.put(Charset.forName("UTF-8").encode(s)).put((byte)0);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            if (this.values != null) {
                for (String s : (String[])this.values) {
                    builder.append("\n\t");
                    builder.append(s);
                }
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Int64Entry
    extends AbstractEntry<long[]> {
        Int64Entry() {
        }

        @Override
        public int getOffset(int offset) {
            return Util.round(offset, 7);
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public int size() {
            return this.count * 8;
        }

        @Override
        public void read(ByteBuffer buffer) {
            long[] values = new long[this.count];
            for (int x = 0; x < this.count; ++x) {
                values[x] = buffer.getLong();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (long l : (long[])this.values) {
                data.putLong(l);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            builder.append("\n\t");
            for (long l : (long[])this.values) {
                builder.append(l).append(", ");
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Int32Entry
    extends AbstractEntry<int[]> {
        Int32Entry() {
        }

        @Override
        public int getOffset(int offset) {
            return Util.round(offset, 3);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public int size() {
            return this.count * 4;
        }

        @Override
        public void read(ByteBuffer buffer) {
            int[] values = new int[this.count];
            for (int x = 0; x < this.count; ++x) {
                values[x] = buffer.getInt();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (int i : (int[])this.values) {
                data.putInt(i);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            builder.append("\n\t");
            for (int i : (int[])this.values) {
                builder.append(i).append(", ");
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Int16Entry
    extends AbstractEntry<short[]> {
        Int16Entry() {
        }

        @Override
        public int getOffset(int offset) {
            return Util.round(offset, 1);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public int size() {
            return this.count * 2;
        }

        @Override
        public void read(ByteBuffer buffer) {
            short[] values = new short[this.count];
            for (int x = 0; x < this.count; ++x) {
                values[x] = buffer.getShort();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (short s : (short[])this.values) {
                data.putShort(s);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            builder.append("\n\t");
            for (short s : (short[])this.values) {
                builder.append(s).append(", ");
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Int8Entry
    extends AbstractEntry<byte[]> {
        Int8Entry() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public int size() {
            return this.count * 1;
        }

        @Override
        public void read(ByteBuffer buffer) {
            byte[] values = new byte[this.count];
            for (int x = 0; x < this.count; ++x) {
                values[x] = buffer.get();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (byte b : (byte[])this.values) {
                data.put(b);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            builder.append("\n\t");
            for (byte b : (byte[])this.values) {
                builder.append(b).append(", ");
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CharEntry
    extends AbstractEntry<byte[]> {
        CharEntry() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int size() {
            return this.count * 1;
        }

        @Override
        public void read(ByteBuffer buffer) {
            byte[] values = new byte[this.count];
            for (int x = 0; x < this.count; ++x) {
                values[x] = buffer.get();
            }
            this.setValues(values);
        }

        @Override
        public void write(ByteBuffer data) {
            for (byte c : (byte[])this.values) {
                data.put(c);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.toString());
            for (byte c : (byte[])this.values) {
                builder.append(c);
            }
            builder.append("\n\t");
            return builder.toString();
        }
    }

    class NullEntry
    extends AbstractEntry {
        NullEntry() {
        }

        public int getType() {
            return 0;
        }

        public int size() {
            return 0;
        }

        public void read(ByteBuffer buffer) {
        }

        public void write(ByteBuffer data) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractEntry<T>
    implements Entry<T> {
        protected int size;
        protected int tag;
        protected int count;
        protected int offset;
        protected T values;

        public void setTag(Tag tag) {
            this.tag = tag.getCode();
        }

        @Override
        public void setTag(int tag) {
            this.tag = tag;
        }

        @Override
        public void setSize(int size) {
            this.size = size;
        }

        @Override
        public void setCount(int count) {
            this.count = count;
        }

        @Override
        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void setValues(T values) {
            this.values = values;
        }

        @Override
        public T getValues() {
            return this.values;
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        @Override
        public int getOffset(int offset) {
            return offset;
        }

        @Override
        public boolean ready() {
            return this.values != null;
        }

        @Override
        public abstract int getType();

        @Override
        public abstract int size();

        @Override
        public abstract void read(ByteBuffer var1);

        @Override
        public abstract void write(ByteBuffer var1);

        @Override
        public void index(ByteBuffer index, int position) {
            index.putInt(this.tag).putInt(this.getType()).putInt(position).putInt(this.count);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (AbstractHeader.this.tags.containsKey(this.tag)) {
                builder.append(AbstractHeader.this.tags.get(this.tag).getName());
            } else {
                builder.append(super.toString());
            }
            builder.append("[tag=").append(this.tag);
            builder.append(",type=").append(this.getType());
            builder.append(",count=").append(this.count);
            builder.append(",size=").append(this.size());
            builder.append(",offset=").append(this.offset);
            builder.append("]");
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<T> {
        public void setTag(int var1);

        public void setSize(int var1);

        public void setCount(int var1);

        public void setOffset(int var1);

        public void setValues(T var1);

        public T getValues();

        public int getTag();

        public int getType();

        public int getOffset(int var1);

        public int size();

        public boolean ready();

        public void read(ByteBuffer var1);

        public void write(ByteBuffer var1);

        public void index(ByteBuffer var1, int var2);
    }

    public static interface Tag {
        public int getCode();

        public int getType();

        public String getName();
    }
}

