/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class Version {
    private static String PROPERTIES_PATH = "/svnkit.build.properties";
    private static final String SHORT_VERSION_STRING_PROPERTY = "svnkit.version";
    private static final String VERSION_STRING_PROPERTY = "svnkit.version.string";
    private static final String VERSION_MAJOR_PROPERTY = "svnkit.version.major";
    private static final String VERSION_MINOR_PROPERTY = "svnkit.version.minor";
    private static final String VERSION_MICRO_PROPERTY = "svnkit.version.micro";
    private static final String VERSION_REVISION_PROPERTY = "svnkit.version.revision";
    private static final String SVN_VERSION_PROPERTY = "svnkit.svn.version";
    private static final String VERSION_STRING_DEFAULT = "SVN/1.7.0 SVNKit/1.7.0-dev (http://svnkit.com/) rSNAPSHOT";
    private static final String VERSION_MAJOR_DEFAULT = "1";
    private static final String VERSION_MINOR_DEFAULT = "7";
    private static final String VERSION_MICRO_DEFAULT = "0";
    private static final String VERSION_REVISION_DEFAULT = "SNAPSHOT";
    private static final String SVN_VERSION_DEFAULT = "1.7.0";
    private static String ourUserAgent = System.getProperty("svnkit.http.userAgent");
    private static Properties ourProperties;

    public static String getVersionString() {
        Version.loadProperties();
        return ourProperties.getProperty(VERSION_STRING_PROPERTY, VERSION_STRING_DEFAULT);
    }

    public static String getShortVersionString() {
        Version.loadProperties();
        return ourProperties.getProperty(SHORT_VERSION_STRING_PROPERTY, VERSION_STRING_DEFAULT);
    }

    public static String getSVNVersion() {
        Version.loadProperties();
        return ourProperties.getProperty(SVN_VERSION_PROPERTY, SVN_VERSION_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserAgent(String userAgent) {
        Class<Version> clazz = Version.class;
        synchronized (Version.class) {
            ourUserAgent = userAgent;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getUserAgent() {
        if (ourUserAgent != null) {
            return ourUserAgent;
        }
        return Version.getVersionString();
    }

    public static int getMajorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MAJOR_PROPERTY, VERSION_MAJOR_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MAJOR_DEFAULT);
        }
    }

    public static int getMinorVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MINOR_PROPERTY, VERSION_MINOR_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MINOR_DEFAULT);
        }
    }

    public static int getMicroVersion() {
        Version.loadProperties();
        try {
            return Integer.parseInt(ourProperties.getProperty(VERSION_MICRO_PROPERTY, VERSION_MICRO_DEFAULT));
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(VERSION_MICRO_DEFAULT);
        }
    }

    @Deprecated
    public static long getRevisionNumber() {
        Version.loadProperties();
        try {
            return Long.parseLong(ourProperties.getProperty(VERSION_REVISION_PROPERTY, VERSION_REVISION_DEFAULT));
        }
        catch (NumberFormatException nfe) {
            try {
                return Long.parseLong(VERSION_REVISION_DEFAULT);
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }
    }

    public static String getRevisionString() {
        Version.loadProperties();
        return ourProperties.getProperty(VERSION_REVISION_PROPERTY, VERSION_REVISION_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        Class<Version> clazz = Version.class;
        synchronized (Version.class) {
            if (ourProperties != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ourProperties = new Properties();
            URL resourceURL = Version.class.getResource(PROPERTIES_PATH);
            if (resourceURL != null && resourceURL.toString().lastIndexOf(".jar!/") < 0) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            InputStream is = Version.class.getResourceAsStream(PROPERTIES_PATH);
            if (is == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                ourProperties.load(is);
            }
            catch (IOException iOException) {
            }
            finally {
                SVNFileUtil.closeFile(is);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

