/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnTarget {
    private SVNURL url;
    private File file;
    private SVNRevision pegRevision;

    public static SvnTarget fromFile(File file) {
        return SvnTarget.fromFile(file, SVNRevision.UNDEFINED);
    }

    public static SvnTarget fromFile(File file, SVNRevision pegRevision) {
        return new SvnTarget(file, pegRevision);
    }

    public static SvnTarget fromURL(SVNURL url) {
        return SvnTarget.fromURL(url, SVNRevision.UNDEFINED);
    }

    public static SvnTarget fromURL(SVNURL url, SVNRevision pegRevision) {
        return new SvnTarget(url, pegRevision);
    }

    private SvnTarget(File file, SVNRevision pegRevision) {
        this.file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath()));
        this.setPegRevision(pegRevision);
    }

    private SvnTarget(SVNURL url, SVNRevision pegRevision) {
        this.url = url;
        this.setPegRevision(pegRevision);
    }

    public boolean isLocal() {
        return this.isFile() && this.getResolvedPegRevision().isLocal();
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean isURL() {
        return this.url != null;
    }

    public SVNURL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision;
    }

    public SVNRevision getResolvedPegRevision() {
        return this.getResolvedPegRevision(SVNRevision.HEAD, SVNRevision.WORKING);
    }

    public SVNRevision getResolvedPegRevision(SVNRevision defaultRemote, SVNRevision defaultLocal) {
        if (this.getPegRevision() == null || this.getPegRevision() == SVNRevision.UNDEFINED) {
            if (defaultLocal == null) {
                defaultLocal = SVNRevision.WORKING;
            }
            if (defaultRemote == null) {
                defaultRemote = SVNRevision.HEAD;
            }
            return this.isURL() ? defaultRemote : defaultLocal;
        }
        return this.getPegRevision();
    }

    private void setPegRevision(SVNRevision revision) {
        if (revision == null) {
            revision = SVNRevision.UNDEFINED;
        }
        this.pegRevision = revision;
    }

    public String toString() {
        if (this.isFile()) {
            return this.getFile().getAbsolutePath() + '@' + this.getPegRevision();
        }
        if (this.isURL()) {
            return this.getURL().toString() + '@' + this.getPegRevision();
        }
        return "INVALID TARGET";
    }
}

