/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnSetChangelist
extends SvnOperation<Void> {
    private String changelistName;
    private boolean remove;

    protected SvnSetChangelist(SvnOperationFactory factory) {
        super(factory);
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public void setChangelistName(String changelistName) {
        this.changelistName = changelistName;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        super.ensureArgumentsAreValid();
        if (!this.isRemove() && "".equals(this.getChangelistName())) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_CHANGELIST_NAME, "Target changelist name must not be empty");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.hasRemoteTargets()) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)this.getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }
}

