/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnOperation<V> {
    private SVNDepth depth;
    private Collection<SvnTarget> targets;
    private SVNRevision revision;
    private Collection<String> changelists;
    private SvnOperationFactory operationFactory;
    private boolean isSleepForTimestamp;
    private volatile boolean isCancelled;

    protected SvnOperation(SvnOperationFactory factory) {
        this.operationFactory = factory;
        this.initDefaults();
    }

    public ISVNEventHandler getEventHandler() {
        return this.getOperationFactory().getEventHandler();
    }

    public ISVNOptions getOptions() {
        return this.getOperationFactory().getOptions();
    }

    protected void initDefaults() {
        this.setDepth(SVNDepth.UNKNOWN);
        this.setSleepForTimestamp(true);
        this.setRevision(SVNRevision.UNDEFINED);
        this.targets = new ArrayList<SvnTarget>();
    }

    public void setDepth(SVNDepth depth) {
        this.depth = depth;
    }

    public void setSingleTarget(SvnTarget target) {
        this.targets = new ArrayList<SvnTarget>();
        if (target != null) {
            this.targets.add(target);
        }
    }

    protected void setTwoTargets(SvnTarget target1, SvnTarget target2) {
        this.targets = new ArrayList<SvnTarget>();
        this.addTarget(target1);
        this.addTarget(target2);
    }

    public void addTarget(SvnTarget target) {
        this.targets.add(target);
    }

    public Collection<SvnTarget> getTargets() {
        return Collections.unmodifiableCollection(this.targets);
    }

    public SvnTarget getFirstTarget() {
        return this.targets != null && !this.targets.isEmpty() ? this.targets.iterator().next() : null;
    }

    public SVNDepth getDepth() {
        return this.depth;
    }

    public void setRevision(SVNRevision revision) {
        this.revision = revision;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public void setApplicalbeChangelists(Collection<String> changelists) {
        this.changelists = changelists;
    }

    public Collection<String> getApplicableChangelists() {
        if (this.changelists == null || this.changelists.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableCollection(this.changelists);
    }

    public SvnOperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    public boolean hasLocalTargets() {
        for (SvnTarget target : this.getTargets()) {
            if (!target.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemoteTargets() {
        for (SvnTarget target : this.getTargets()) {
            if (target.isLocal()) continue;
            return true;
        }
        return false;
    }

    protected void ensureEnoughTargets() throws SVNException {
        SVNErrorMessage err;
        int targetsCount = this.getTargets().size();
        if (targetsCount < this.getMinimumTargetsCount()) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Wrong number of targets has been specified ({0}), at least {1} is required.", new Object[]{new Integer(targetsCount), new Integer(this.getMinimumTargetsCount())}, 0);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (targetsCount > this.getMaximumTargetsCount()) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Wrong number of targets has been specified ({0}), no more that {1} may be specified.", new Object[]{new Integer(targetsCount), new Integer(this.getMaximumTargetsCount())}, 0);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    protected int getMinimumTargetsCount() {
        return 1;
    }

    protected int getMaximumTargetsCount() {
        return 1;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public V run() throws SVNException {
        this.ensureArgumentsAreValid();
        return (V)this.getOperationFactory().run(this);
    }

    protected void ensureArgumentsAreValid() throws SVNException {
        this.ensureEnoughTargets();
        this.ensureHomohenousTargets();
    }

    protected boolean needsHomohenousTargets() {
        return true;
    }

    protected void ensureHomohenousTargets() throws SVNException {
        if (this.getTargets().size() <= 1) {
            return;
        }
        if (!this.needsHomohenousTargets()) {
            return;
        }
        if (this.hasLocalTargets() && this.hasRemoteTargets()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot mix repository and working copy targets"), SVNLogType.WC);
        }
    }

    public ISVNRepositoryPool getRepositoryPool() {
        return this.getOperationFactory().getRepositoryPool();
    }

    public ISVNAuthenticationManager getAuthenticationManager() {
        return this.getOperationFactory().getAuthenticationManager();
    }

    public ISVNCanceller getCanceller() {
        return this.getOperationFactory().getCanceller();
    }

    public boolean isSleepForTimestamp() {
        return this.isSleepForTimestamp;
    }

    public void setSleepForTimestamp(boolean isSleepForTimestamp) {
        this.isSleepForTimestamp = isSleepForTimestamp;
    }

    public boolean hasFileTargets() {
        for (SvnTarget target : this.getTargets()) {
            if (!target.isFile()) continue;
            return true;
        }
        return false;
    }

    public boolean isUseParentWcFormat() {
        return false;
    }

    protected File getOperationalWorkingCopy() {
        if (this.hasFileTargets()) {
            return this.getFirstTarget().getFile();
        }
        return null;
    }
}

