/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnMerge
extends SvnOperation<Void> {
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private boolean ignoreAncestry;
    private boolean force;
    private boolean recordOnly;
    private boolean dryRun;
    private boolean allowMixedRevisions;
    private SvnTarget source;
    private boolean reintegrate;
    private Collection<SvnRevisionRange> ranges;
    private SVNDiffOptions mergeOptions;

    protected SvnMerge(SvnOperationFactory factory) {
        super(factory);
    }

    public void addRevisionRange(SvnRevisionRange range) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<SvnRevisionRange>();
        }
        SVNRevision start = range.getStart();
        SVNRevision end = range.getEnd();
        if (start == SVNRevision.UNDEFINED && end == SVNRevision.UNDEFINED) {
            start = SVNRevision.create(0L);
            end = this.getSource().getResolvedPegRevision();
            range = SvnRevisionRange.create(start, end);
        }
        this.ranges.add(range);
    }

    public Collection<SvnRevisionRange> getRevisionRanges() {
        return this.ranges;
    }

    public void setSource(SvnTarget source, boolean reintegrate) {
        this.source = source;
        this.reintegrate = reintegrate;
        if (source != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget source1, SvnTarget source2) {
        this.firstSource = source1;
        this.secondSource = source2;
        if (this.firstSource != null) {
            this.setSource(null, false);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public boolean isReintegrate() {
        return this.reintegrate;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isRecordOnly() {
        return this.recordOnly;
    }

    public void setRecordOnly(boolean recordOnly) {
        this.recordOnly = recordOnly;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isAllowMixedRevisions() {
        return this.allowMixedRevisions;
    }

    public void setAllowMixedRevisions(boolean allowMixedRevisions) {
        this.allowMixedRevisions = allowMixedRevisions;
    }

    public SVNDiffOptions getMergeOptions() {
        return this.mergeOptions;
    }

    public void setMergeOptions(SVNDiffOptions mergeOptions) {
        this.mergeOptions = mergeOptions;
    }
}

