/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnLog
extends SvnReceivingOperation<SVNLogEntry> {
    private long limit;
    private boolean useMergeHistory;
    private boolean stopOnCopy;
    private boolean discoverChangedPaths;
    private String[] targetPaths;
    private String[] revisionProperties;
    private Collection<SvnRevisionRange> revisionRanges;

    protected SvnLog(SvnOperationFactory factory) {
        super(factory);
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean isUseMergeHistory() {
        return this.useMergeHistory;
    }

    public void setUseMergeHistory(boolean useMergeHistory) {
        this.useMergeHistory = useMergeHistory;
    }

    public boolean isDiscoverChangedPaths() {
        return this.discoverChangedPaths;
    }

    public void setDiscoverChangedPaths(boolean discoverChangedPaths) {
        this.discoverChangedPaths = discoverChangedPaths;
    }

    public boolean isStopOnCopy() {
        return this.stopOnCopy;
    }

    public void setStopOnCopy(boolean stopOnCopy) {
        this.stopOnCopy = stopOnCopy;
    }

    public Collection<SvnRevisionRange> getRevisionRanges() {
        return this.revisionRanges;
    }

    public void setRevisionRanges(Collection<SvnRevisionRange> revisionRanges) {
        this.revisionRanges = revisionRanges;
    }

    public String[] getTargetPaths() {
        return this.targetPaths;
    }

    public void setTargetPaths(String[] targetPaths) {
        this.targetPaths = targetPaths;
    }

    public String[] getRevisionProperties() {
        return this.revisionProperties;
    }

    public void setRevisionProperties(String[] revisionProperties) {
        this.revisionProperties = revisionProperties;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        super.ensureArgumentsAreValid();
        if (this.getLimit() > Long.MAX_VALUE) {
            this.setLimit(Long.MAX_VALUE);
        }
        if (this.getRevisionRanges() == null || this.getRevisionRanges().size() == 0) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.hasRemoteTargets() && this.getTargets().size() > 1) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "When specifying URL, only one target may be given.");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }

    public void addRange(SvnRevisionRange range) {
        if (range != null) {
            if (this.getRevisionRanges() == null) {
                this.revisionRanges = new ArrayList<SvnRevisionRange>();
            }
            this.revisionRanges.add(range);
        }
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }
}

