/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnDiff
extends SvnOperation<Void> {
    private ISVNDiffGenerator diffGenerator;
    private SVNDiffOptions diffOptions;
    private OutputStream output;
    private SVNRevision startRevision;
    private SVNRevision endRevision;
    private boolean ignoreAncestry;
    private boolean noDiffDeleted;
    private boolean showCopiesAsAdds;
    private boolean ignoreContentType;
    private File relativeToDirectory;

    protected SvnDiff(SvnOperationFactory factory) {
        super(factory);
    }

    public void setTarget(SvnTarget source, SVNRevision start, SVNRevision end) {
        this.setSingleTarget(source);
        this.startRevision = start;
        this.endRevision = end;
    }

    public void setTargets(SvnTarget target1, SvnTarget target2) {
        this.setTwoTargets(target1, target2);
        this.startRevision = target1.getPegRevision();
        this.endRevision = target2.getPegRevision();
    }

    public void setStartRevision(SVNRevision startRevision) {
        this.startRevision = startRevision;
    }

    public void setEndRevision(SVNRevision endRevision) {
        this.endRevision = endRevision;
    }

    public SVNRevision getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision getEndRevision() {
        return this.endRevision;
    }

    public void setRelativeToDirectory(File relativeToDirectory) {
        this.relativeToDirectory = relativeToDirectory;
    }

    public File getRelativeToDirectory() {
        return this.relativeToDirectory;
    }

    public ISVNDiffGenerator getDiffGenerator() {
        return this.diffGenerator;
    }

    public void setDiffGenerator(ISVNDiffGenerator diffGenerator) {
        this.diffGenerator = diffGenerator;
    }

    public SVNDiffOptions getDiffOptions() {
        return this.diffOptions;
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        this.diffOptions = diffOptions;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public boolean isNoDiffDeleted() {
        return this.noDiffDeleted;
    }

    public void setNoDiffDeleted(boolean noDiffDeleted) {
        this.noDiffDeleted = noDiffDeleted;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public void setShowCopiesAsAdds(boolean showCopiesAsAdds) {
        this.showCopiesAsAdds = showCopiesAsAdds;
    }

    public boolean isIgnoreContentType() {
        return this.ignoreContentType;
    }

    public void setIgnoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
    }

    public SvnTarget getSecondTarget() {
        if (this.getTargets().size() < 2) {
            return null;
        }
        Iterator<SvnTarget> iterator = this.getTargets().iterator();
        iterator.next();
        return iterator.next();
    }

    @Override
    protected int getMinimumTargetsCount() {
        return super.getMinimumTargetsCount();
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        if (this.getRelativeToDirectory() != null && this.hasRemoteTargets()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Relative directory cannot be specified with remote targets");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (this.getOutput() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "No output is specified.");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getTargets().size() == 1 && this.getFirstTarget().isFile()) {
            return this.getFirstTarget().getFile();
        }
        if (this.getTargets().size() == 2 && this.getFirstTarget() != null && this.getFirstTarget().isFile()) {
            return this.getFirstTarget().getFile();
        }
        if (this.getTargets().size() == 2 && this.getSecondTarget() != null && this.getSecondTarget().isFile()) {
            return this.getSecondTarget().getFile();
        }
        return null;
    }
}

