/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCommitPacket {
    private Map<SVNURL, Collection<SvnCommitItem>> items = new HashMap<SVNURL, Collection<SvnCommitItem>>();
    private Map<File, SvnCommitItem> itemsByPath = new HashMap<File, SvnCommitItem>();
    private Object lockingContext;
    private ISvnCommitRunner runner;
    private Map<SVNURL, String> lockTokens = new HashMap<SVNURL, String>();

    public boolean hasItem(File path) {
        return this.itemsByPath.containsKey(path);
    }

    public SvnCommitItem getItem(File path) {
        return this.itemsByPath.get(path);
    }

    public Collection<SVNURL> getRepositoryRoots() {
        return Collections.unmodifiableCollection(this.items.keySet());
    }

    public Collection<SvnCommitItem> getItems(SVNURL url) {
        return Collections.unmodifiableCollection(this.items.get(url));
    }

    public void addItem(SvnCommitItem item, SVNURL repositoryRoot) {
        if (!this.items.containsKey(repositoryRoot)) {
            this.items.put(repositoryRoot, new HashSet());
        }
        this.items.get(repositoryRoot).add(item);
        this.itemsByPath.put(item.getPath(), item);
    }

    public SvnCommitItem addItem(File path, SVNNodeKind kind, SVNURL repositoryRoot, String repositoryPath, long revision, String copyFromPath, long copyFromRevision, int flags) throws SVNException {
        SvnCommitItem item = new SvnCommitItem();
        item.setPath(path);
        item.setKind(kind);
        item.setUrl(repositoryRoot.appendPath(repositoryPath, false));
        item.setRevision(revision);
        if (copyFromPath != null) {
            item.setCopyFromUrl(repositoryRoot.appendPath(copyFromPath, false));
            item.setCopyFromRevision(copyFromRevision);
        } else {
            item.setCopyFromRevision(-1L);
        }
        item.setFlags(flags);
        this.addItem(item, repositoryRoot);
        return item;
    }

    public SvnCommitItem addItem(File path, SVNURL rootUrl, SVNNodeKind kind, SVNURL url, long revision, SVNURL copyFromUrl, long copyFromRevision, int flags) throws SVNException {
        SvnCommitItem item = new SvnCommitItem();
        item.setPath(path);
        item.setKind(kind);
        item.setUrl(url);
        item.setRevision(revision);
        if (copyFromUrl != null) {
            item.setCopyFromUrl(copyFromUrl);
            item.setCopyFromRevision(copyFromRevision);
        } else {
            item.setCopyFromRevision(-1L);
        }
        item.setFlags(flags);
        if (!this.items.containsKey(rootUrl)) {
            this.items.put(rootUrl, new HashSet());
        }
        this.items.get(rootUrl).add(item);
        this.itemsByPath.put(path, item);
        return item;
    }

    public void setLockingContext(ISvnCommitRunner commitRunner, Object context) {
        this.lockingContext = context;
        this.runner = commitRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws SVNException {
        try {
            if (this.runner != null) {
                this.runner.disposeCommitPacket(this.lockingContext);
            }
        }
        finally {
            this.runner = null;
            this.lockingContext = null;
        }
    }

    public void setLockTokens(Map<SVNURL, String> lockTokens) {
        this.lockTokens = lockTokens;
    }

    public Map<SVNURL, String> getLockTokens() {
        return this.lockTokens;
    }

    public boolean isEmpty() {
        for (SVNURL rootUrl : this.getRepositoryRoots()) {
            if (this.isEmpty(rootUrl)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(SVNURL repositoryRootUrl) {
        for (SvnCommitItem item : this.getItems(repositoryRootUrl)) {
            if (item.getFlags() == 32) continue;
            return false;
        }
        return true;
    }

    public Object getLockingContext() {
        return this.lockingContext;
    }

    public ISvnCommitRunner getRunner() {
        return this.runner;
    }
}

