/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnImport;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnRemoteMkDir;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitClient
extends SVNBasicClient {
    private ISVNCommitHandler commitHandler;
    private ISVNCommitParameters commitParameters;

    public SVNCommitClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public SVNCommitClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public void setCommitHander(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        if (parameters == null) {
            parameters = new DefaultSVNCommitParameters();
        }
        this.commitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.commitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage) throws SVNException {
        SvnRemoteDelete delete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            delete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i = 0; i < urls.length; ++i) {
            delete.addTarget(SvnTarget.fromURL(urls[i]));
        }
        delete.setCommitMessage(commitMessage);
        return (SVNCommitInfo)delete.run();
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SvnRemoteDelete delete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            delete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i = 0; i < urls.length; ++i) {
            delete.addTarget(SvnTarget.fromURL(urls[i]));
        }
        delete.setCommitMessage(commitMessage);
        delete.setRevisionProperties(revisionProperties);
        return (SVNCommitInfo)delete.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage) throws SVNException {
        SvnRemoteMkDir mkdir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            mkdir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i = 0; i < urls.length; ++i) {
            mkdir.addTarget(SvnTarget.fromURL(urls[i]));
        }
        mkdir.setCommitMessage(commitMessage);
        return (SVNCommitInfo)mkdir.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties, boolean makeParents) throws SVNException {
        SvnRemoteMkDir mkdir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            mkdir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        for (int i = 0; i < urls.length; ++i) {
            mkdir.addTarget(SvnTarget.fromURL(urls[i]));
        }
        mkdir.setCommitMessage(commitMessage);
        mkdir.setRevisionProperties(revisionProperties);
        mkdir.setMakeParents(makeParents);
        return (SVNCommitInfo)mkdir.run();
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, true, true, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean useGlobalIgnores, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, useGlobalIgnores, true, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, SVNProperties revisionProperties, boolean useGlobalIgnores, boolean ignoreUnknownNodeTypes, SVNDepth depth) throws SVNException {
        SvnImport svnImport = this.getOperationsFactory().createImport();
        svnImport.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnImport.setCommitMessage(commitMessage);
        svnImport.setRevisionProperties(revisionProperties);
        svnImport.addTarget(SvnTarget.fromURL(dstURL));
        svnImport.setSource(path);
        svnImport.setUseGlobalIgnores(useGlobalIgnores);
        return (SVNCommitInfo)svnImport.run();
    }

    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, boolean force, boolean recursive) throws SVNException {
        return this.doCommit(paths, keepLocks, commitMessage, null, null, false, force, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, SVNProperties revisionProperties, String[] changelists, boolean keepChangelist, boolean force, SVNDepth depth) throws SVNException {
        SVNCommitInfo[] infos;
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, depth, false, changelists);
        if (packets != null && (infos = this.doCommit(packets, keepLocks, keepChangelist, commitMessage, revisionProperties)) != null && infos.length > 0) {
            return infos[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPacket, keepLocks, false, commitMessage, null);
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SVNCommitInfo[] infos = this.doCommit(new SVNCommitPacket[]{commitPacket}, keepLocks, keepChangelist, commitMessage, revisionProperties);
        if (infos != null && infos.length > 0) {
            return infos[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPackets, keepLocks, false, commitMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        infos = new SVNCommitInfo[commitPackets.length];
        for (i = 0; i < commitPackets.length; ++i) {
            block21: {
                block20: {
                    commit = ((SvnCodec.SVNCommitPacketWrapper)commitPackets[i]).getOperation();
                    commit.setCommitMessage(commitMessage);
                    if (this.getCommitHandler() == null) ** GOTO lbl31
                    items = commitPackets[i].getCommitItems();
                    if (items != null && items.length != 0) break block20;
                    infos[i] = SVNCommitInfo.NULL;
                    try {
                        commitPackets[i].dispose();
                    }
                    catch (SVNException e) {}
                    continue;
                }
                message = this.getCommitHandler().getCommitMessage(commitMessage, items);
                if (message == null) break block21;
                commit.setCommitMessage(message);
            }
            try {
                commitPackets[i].dispose();
            }
            catch (SVNException e) {}
            continue;
            try {
                revisionProperties = this.getCommitHandler().getRevisionProperties(message, items, revisionProperties);
lbl31:
                // 2 sources

                if (revisionProperties != null) {
                    for (String propertyName : revisionProperties.nameSet()) {
                        value = revisionProperties.getSVNPropertyValue(propertyName);
                        if (value == null) continue;
                        commit.setRevisionProperty(propertyName, value);
                    }
                }
                commit.setKeepLocks(keepLocks);
                commit.setKeepChangelists(keepChangelist);
                {
                    catch (SVNCancelException e) {
                        throw e;
                    }
                    catch (SVNException e) {
                        err = e.getErrorMessage().wrap("Commit failed (details follow):");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                info = commit.run();
                if (info == null) continue;
                infos[i] = info;
                continue;
            }
            catch (Throwable var12_17) {
                throw var12_17;
            }
            finally {
                try {
                    commitPackets[i].dispose();
                }
                catch (SVNException e) {}
            }
        }
        return infos;
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive) throws SVNException {
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, SVNDepth.fromRecurse(recursive), true, null);
        if (packets != null && packets.length > 0) {
            return packets[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, String[] changelists) throws SVNException {
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, depth, true, changelists);
        if (packets != null && packets.length > 0) {
            return packets[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive, boolean combinePackets) throws SVNException {
        return this.doCollectCommitItems(paths, keepLocks, force, SVNDepth.fromRecurse(recursive), combinePackets, null);
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, boolean combinePackets, String[] changelists) throws SVNException {
        SvnCommit commit = this.getOperationsFactory().createCommit();
        for (int i = 0; i < paths.length; ++i) {
            commit.addTarget(SvnTarget.fromFile(paths[i]));
        }
        commit.setKeepLocks(keepLocks);
        commit.setDepth(depth);
        commit.setForce(force);
        if (changelists != null && changelists.length > 0) {
            commit.setApplicalbeChangelists(Arrays.asList(changelists));
        }
        SvnCommitPacket packet = commit.collectCommitItems();
        return new SVNCommitPacket[]{SvnCodec.commitPacket(commit, packet)};
    }
}

