/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNAnnotationGenerator;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnAnnotate;
import org.tmatesoft.svn.core.wc2.SvnAnnotateItem;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteAnnotate
extends SvnRemoteOperationRunner<SvnAnnotateItem, SvnAnnotate>
implements ISVNAnnotateHandler {
    @Override
    public boolean isApplicable(SvnAnnotate operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.hasRemoteTargets() || wcGeneration == SvnWcGeneration.V17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SvnAnnotateItem run() throws SVNException {
        String path;
        File tmpFile;
        if (((SvnAnnotate)this.getOperation()).getEndRevision() == SVNRevision.UNDEFINED) {
            if (((SvnAnnotate)this.getOperation()).hasRemoteTargets()) {
                ((SvnAnnotate)this.getOperation()).setEndRevision(SVNRevision.HEAD);
            } else {
                ((SvnAnnotate)this.getOperation()).setEndRevision(SVNRevision.WORKING);
            }
        }
        if (((SvnAnnotate)this.getOperation()).getStartRevision() == null || !((SvnAnnotate)this.getOperation()).getStartRevision().isValid() || ((SvnAnnotate)this.getOperation()).getEndRevision() == null || !((SvnAnnotate)this.getOperation()).getEndRevision().isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(((SvnAnnotate)this.getOperation()).getFirstTarget(), ((SvnAnnotate)this.getOperation()).getEndRevision(), ((SvnAnnotate)this.getOperation()).getFirstTarget().getResolvedPegRevision(), null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        Structure<SvnRepositoryAccess.RevisionsPair> pair = this.getRepositoryAccess().getRevisionNumber(repository, ((SvnAnnotate)this.getOperation()).getFirstTarget(), ((SvnAnnotate)this.getOperation()).getStartRevision(), null);
        long startRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        pair = this.getRepositoryAccess().getRevisionNumber(repository, ((SvnAnnotate)this.getOperation()).getFirstTarget(), ((SvnAnnotate)this.getOperation()).getEndRevision(), pair);
        long endRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        pair.release();
        if (endRev < startRev) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Start revision must precede end revision"), SVNLogType.DEFAULT);
        }
        if (((SvnAnnotate)this.getOperation()).hasRemoteTargets()) {
            tmpFile = SVNFileUtil.createTempDirectory("annotate");
            path = repository.getLocation().toDecodedString();
        } else {
            tmpFile = this.getWcContext().getDb().getWCRootTempDir(((SvnAnnotate)this.getOperation()).getFirstTarget().getFile());
            tmpFile = SVNFileUtil.createUniqueFile(tmpFile, "annotate", ".tmp", false);
            SVNFileUtil.deleteAll(tmpFile, true);
            SVNFileUtil.ensureDirectoryExists(tmpFile);
            path = ((SvnAnnotate)this.getOperation()).getFirstTarget().getFile().getAbsolutePath();
        }
        SVNAnnotationGenerator generator = new SVNAnnotationGenerator(path, tmpFile, startRev, ((SvnAnnotate)this.getOperation()).isIgnoreMimeType(), ((SvnAnnotate)this.getOperation()).isUseMergeHistory(), ((SvnAnnotate)this.getOperation()).getDiffOptions(), ((SvnAnnotate)this.getOperation()).getInputEncoding(), this, this);
        try {
            repository.getFileRevisions("", startRev > 0L ? startRev - 1L : startRev, endRev, ((SvnAnnotate)this.getOperation()).isUseMergeHistory(), generator);
            if (((SvnAnnotate)this.getOperation()).getEndRevision() == SVNRevision.WORKING) {
                File target = ((SvnAnnotate)this.getOperation()).getFirstTarget().getFile();
                SvnStatus status = SVNStatusEditor17.internalStatus(this.getWcContext(), target);
                if (status.getTextStatus() != SVNStatusType.STATUS_NORMAL) {
                    SVNProperties properties = this.getWcContext().getActualProps(target);
                    String keywords = properties.getStringValue("svn:keywords");
                    InputStream source = null;
                    OutputStream dst = null;
                    try {
                        source = SVNFileUtil.openFileForReading(target);
                        Map keywordsMap = keywords != null ? SVNTranslator.computeKeywords(keywords, null, null, null, null, ((SvnAnnotate)this.getOperation()).getOptions()) : null;
                        source = new SVNTranslatorInputStream(source, new byte[]{10}, false, keywordsMap, false);
                        SVNFileRevision localRevision = new SVNFileRevision(path, -1L, new SVNProperties(), new SVNProperties());
                        generator.openRevision(localRevision);
                        generator.addFileBlame(source);
                        generator.closeRevision(null);
                    }
                    finally {
                        SVNFileUtil.closeFile(dst);
                        SVNFileUtil.closeFile(source);
                    }
                }
            }
            if (!generator.isLastRevisionReported()) {
                generator.reportAnnotations(this, ((SvnAnnotate)this.getOperation()).getInputEncoding());
            }
            generator.dispose();
            SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
        }
        catch (Throwable throwable) {
            generator.dispose();
            SVNFileUtil.deleteAll(tmpFile, !"text-base".equals(tmpFile.getName()), null);
            throw throwable;
        }
        return (SvnAnnotateItem)((SvnAnnotate)this.getOperation()).first();
    }

    @Override
    public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
        ((SvnAnnotate)this.getOperation()).receive(((SvnAnnotate)this.getOperation()).getFirstTarget(), new SvnAnnotateItem(date, revision, author, line, mergedDate, mergedRevision, mergedAuthor, mergedPath, lineNumber));
    }

    @Override
    public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
        SvnAnnotateItem item = new SvnAnnotateItem(date, revision, author, contents);
        ((SvnAnnotate)this.getOperation()).receive(((SvnAnnotate)this.getOperation()).getFirstTarget(), item);
        return item.getReturnResult();
    }

    @Override
    public void handleLine(Date date, long revision, String author, String line) throws SVNException {
    }

    @Override
    public void handleEOF() {
        try {
            ((SvnAnnotate)this.getOperation()).receive(((SvnAnnotate)this.getOperation()).getFirstTarget(), new SvnAnnotateItem(true));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }
}

