/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldUpgrade;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnOldUpgradeEntries {
    public static WriteBaton writeUpgradedEntries(WriteBaton parentNode, SVNWCDb db, ISVNWCDb.SVNWCDbUpgradeData upgradeData, File dirAbsPath, Map<String, SVNEntry> entries, SVNHashMap textBases) throws SVNException {
        WriteBaton dirNode = new WriteBaton();
        SVNEntry thisDir = entries.get("");
        if (thisDir == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No default entry in directory '{0}'", (Object)dirAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File oldRootAbsPath = SVNFileUtil.createFilePath(SVNPathUtil.getCommonPathAncestor(SVNPathUtil.getAbsolutePath(dirAbsPath.getAbsolutePath()), SVNPathUtil.getAbsolutePath(upgradeData.rootAbsPath.getAbsolutePath())));
        assert (oldRootAbsPath != null);
        File dirRelPath = SVNWCUtils.skipAncestor(oldRootAbsPath, dirAbsPath);
        dirNode = SvnOldUpgradeEntries.writeEntry(true, parentNode, db, upgradeData, thisDir, null, dirRelPath, SVNFileUtil.createFilePath(upgradeData.rootAbsPath, dirRelPath), oldRootAbsPath, thisDir, false);
        for (String name : entries.keySet()) {
            SVNEntry entry = entries.get(name);
            SvnOldUpgrade.TextBaseInfo info = (SvnOldUpgrade.TextBaseInfo)textBases.get(name);
            if ("".equals(name)) continue;
            File childAbsPath = SVNFileUtil.createFilePath(dirAbsPath, name);
            File childRelPath = SVNWCUtils.skipAncestor(oldRootAbsPath, childAbsPath);
            SvnOldUpgradeEntries.writeEntry(false, dirNode, db, upgradeData, entry, info, childRelPath, SVNFileUtil.createFilePath(upgradeData.rootAbsPath, childRelPath), oldRootAbsPath, thisDir, true);
        }
        if (dirNode.treeConflicts != null) {
            SvnOldUpgradeEntries.writeActualOnlyEntries(dirNode.treeConflicts, upgradeData.root.getSDb(), upgradeData.workingCopyId, SVNFileUtil.getFilePath(dirRelPath));
        }
        return dirNode;
    }

    private static WriteBaton writeEntry(boolean isCalculateEntryNode, WriteBaton parentNode, SVNWCDb db, ISVNWCDb.SVNWCDbUpgradeData upgradeData, SVNEntry entry, SvnOldUpgrade.TextBaseInfo textBaseInfo, File localRelPath, File tmpEntryAbsPath, File rootAbsPath, SVNEntry thisDir, boolean isCreateLocks) throws SVNException {
        String treeConflictData;
        DbNode baseNode = null;
        DbNode workingNode = null;
        DbNode belowWorkingNode = null;
        DbActualNode actualNode = null;
        String parentRelPath = null;
        if (localRelPath != null) {
            parentRelPath = SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelPath));
        }
        assert (parentNode != null || entry.getSchedule() == null);
        assert (parentNode == null || parentNode.base != null || parentNode.belowWork != null || parentNode.work != null);
        if (entry.getSchedule() == null) {
            if (entry.isCopied() || entry.getDepth() == SVNDepth.EXCLUDE && parentNode != null && parentNode.base == null && parentNode.work != null) {
                workingNode = new DbNode();
            } else {
                baseNode = new DbNode();
            }
        } else if (entry.isScheduledForAddition()) {
            workingNode = new DbNode();
            if (entry.isDeleted()) {
                if (parentNode != null && parentNode.base != null) {
                    baseNode = new DbNode();
                } else {
                    belowWorkingNode = new DbNode();
                }
            }
        } else if (entry.isScheduledForDeletion()) {
            workingNode = new DbNode();
            if (parentNode != null && parentNode.base != null) {
                baseNode = new DbNode();
            }
            if (parentNode != null && parentNode.work != null) {
                belowWorkingNode = new DbNode();
            }
        } else if (entry.isScheduledForReplacement()) {
            workingNode = new DbNode();
            if (parentNode != null && parentNode.base != null) {
                baseNode = new DbNode();
            } else {
                belowWorkingNode = new DbNode();
            }
        }
        if (entry.isDeleted()) {
            assert (baseNode != null || belowWorkingNode != null);
            assert (!entry.isIncomplete());
            if (baseNode != null) {
                baseNode.presence = ISVNWCDb.SVNWCDbStatus.NotPresent;
            } else {
                belowWorkingNode.presence = ISVNWCDb.SVNWCDbStatus.NotPresent;
            }
        } else if (entry.isAbsent()) {
            assert (baseNode != null && workingNode == null && belowWorkingNode == null);
            assert (!entry.isIncomplete());
            baseNode.presence = ISVNWCDb.SVNWCDbStatus.ServerExcluded;
        }
        if (entry.isCopied()) {
            if (entry.getCopyFromSVNURL() != null) {
                workingNode.reposId = upgradeData.repositoryId;
                String relPath = SVNURLUtil.getRelativeURL(thisDir.getRepositoryRootURL(), entry.getCopyFromSVNURL(), false);
                workingNode.reposRelPath = relPath == null ? null : relPath;
                workingNode.revision = entry.getCopyFromRevision();
                workingNode.opDepth = SVNWCUtils.relpathDepth(localRelPath);
            } else if (parentNode != null && parentNode.work != null && parentNode.work.reposRelPath != null) {
                workingNode.reposId = upgradeData.repositoryId;
                workingNode.reposRelPath = SVNPathUtil.append(parentNode.work.reposRelPath, SVNFileUtil.getFileName(localRelPath));
                workingNode.revision = parentNode.work.revision;
                workingNode.opDepth = parentNode.work.opDepth;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "No copyfrom URL for '{0}'", (Object)localRelPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (entry.getConflictOld() != null) {
            actualNode = new DbActualNode();
            actualNode.conflictOld = parentRelPath != null && entry.getConflictOld() != null ? SVNPathUtil.append(parentRelPath, entry.getConflictOld()) : entry.getConflictOld();
            actualNode.conflictNew = parentRelPath != null && entry.getConflictNew() != null ? SVNPathUtil.append(parentRelPath, entry.getConflictNew()) : entry.getConflictNew();
            actualNode.conflictWorking = parentRelPath != null && entry.getConflictWorking() != null ? SVNPathUtil.append(parentRelPath, entry.getConflictWorking()) : entry.getConflictWorking();
        }
        if (entry.getPropRejectFile() != null) {
            actualNode = new DbActualNode();
            actualNode.propReject = SVNPathUtil.append(entry.isDirectory() ? SVNFileUtil.getFilePath(localRelPath) : parentRelPath, entry.getPropRejectFile());
        }
        if (entry.getChangelistName() != null) {
            actualNode = new DbActualNode();
            actualNode.changelist = entry.getChangelistName();
        }
        HashMap<String, String> treeConflicts = null;
        if (isCalculateEntryNode && entry.getTreeConflictData() != null) {
            treeConflicts = new HashMap<String, String>();
            Map<File, SVNTreeConflictDescription> tcs = entry.getTreeConflicts();
            for (File entryPath : tcs.keySet()) {
                SVNTreeConflictDescription conflict = tcs.get(entryPath);
                assert (conflict.isTreeConflict());
                if (conflict.getConflictReason() == SVNConflictReason.ADDED) {
                    conflict.setSourceLeftVersion(null);
                }
                String key = SVNFileUtil.getFilePath(SVNWCUtils.skipAncestor(rootAbsPath, conflict.getPath()));
                treeConflicts.put(key, SVNTreeConflictUtil.getSingleTreeConflictData(conflict));
            }
        }
        if (parentNode != null && parentNode.treeConflicts != null && (treeConflictData = parentNode.treeConflicts.get(SVNFileUtil.getFilePath(localRelPath))) != null) {
            actualNode = new DbActualNode();
            actualNode.treeConflictData = treeConflictData;
            parentNode.treeConflicts.remove(SVNFileUtil.getFilePath(localRelPath));
        }
        if (entry.getExternalFilePath() != null) {
            baseNode = new DbNode();
        }
        if (baseNode != null) {
            baseNode.wcId = upgradeData.workingCopyId;
            baseNode.localRelPath = SVNFileUtil.getFilePath(localRelPath);
            baseNode.opDepth = 0L;
            baseNode.parentRelPath = parentRelPath;
            baseNode.revision = entry.getRevision();
            baseNode.lastModTime = SVNDate.parseDate(entry.getTextTime());
            baseNode.translatedSize = entry.getWorkingSize();
            if (entry.getDepth() != SVNDepth.EXCLUDE) {
                baseNode.depth = entry.getDepth();
            } else {
                baseNode.presence = ISVNWCDb.SVNWCDbStatus.Excluded;
                baseNode.depth = SVNDepth.INFINITY;
            }
            if (entry.isDeleted()) {
                assert (baseNode.presence == ISVNWCDb.SVNWCDbStatus.NotPresent);
                baseNode.kind = entry.getKind();
            } else if (entry.isAbsent()) {
                assert (baseNode.presence == ISVNWCDb.SVNWCDbStatus.ServerExcluded);
                baseNode.kind = entry.getKind();
                if (baseNode.revision == -1L && parentNode != null && parentNode.base != null) {
                    baseNode.revision = parentNode.base.revision;
                }
            } else {
                baseNode.kind = entry.getKind();
                if (baseNode.presence != ISVNWCDb.SVNWCDbStatus.Excluded) {
                    if (entry.isDirectory() && !"".equals(entry.getName())) {
                        baseNode.presence = ISVNWCDb.SVNWCDbStatus.Incomplete;
                        if (parentNode != null && parentNode.base != null) {
                            baseNode.revision = parentNode.base.revision;
                        }
                    } else if (entry.isIncomplete()) {
                        assert (baseNode.presence == ISVNWCDb.SVNWCDbStatus.Normal);
                        baseNode.presence = ISVNWCDb.SVNWCDbStatus.Incomplete;
                    }
                }
            }
            if (entry.isDirectory()) {
                baseNode.checksum = null;
            } else {
                baseNode.checksum = textBaseInfo != null && textBaseInfo.revertBase != null && textBaseInfo.revertBase.sha1Checksum != null ? textBaseInfo.revertBase.sha1Checksum : (textBaseInfo != null && textBaseInfo.normalBase != null && textBaseInfo.normalBase.sha1Checksum != null ? textBaseInfo.normalBase.sha1Checksum : null);
                if (workingNode == null || !entry.isCopied()) {
                    SvnChecksum entryMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, entry.getChecksum());
                    SvnChecksum foundMd5Checksum = null;
                    if (textBaseInfo != null && textBaseInfo.revertBase != null && textBaseInfo.revertBase.md5Checksum != null) {
                        foundMd5Checksum = textBaseInfo.revertBase.md5Checksum;
                    } else if (textBaseInfo != null && textBaseInfo.normalBase != null && textBaseInfo.normalBase.md5Checksum != null) {
                        foundMd5Checksum = textBaseInfo.normalBase.md5Checksum;
                    }
                    if (entryMd5Checksum.getDigest() != null && foundMd5Checksum != null && !entryMd5Checksum.equals(foundMd5Checksum)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Bad base MD5 checksum for '{0}'; expected: '{1}'; found '{2}';", SVNFileUtil.createFilePath(rootAbsPath, localRelPath), entryMd5Checksum, foundMd5Checksum);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
            }
            if (thisDir.getRepositoryRootURL() != null) {
                String relPath;
                baseNode.reposId = upgradeData.repositoryId;
                baseNode.reposRelPath = entry.getSVNURL() != null ? ((relPath = SVNURLUtil.getRelativeURL(thisDir.getRepositoryRootURL(), entry.getSVNURL(), false)) != null ? relPath : "") : ((relPath = SVNURLUtil.getRelativeURL(thisDir.getRepositoryRootURL(), thisDir.getSVNURL(), false)) == null ? entry.getName() : SVNPathUtil.append(relPath, entry.getName()));
            }
            baseNode.changedRev = entry.getCommittedRevision();
            baseNode.changedDate = SVNDate.parseDate(entry.getCommittedDate());
            baseNode.changedAuthor = entry.getAuthor();
            if (entry.getExternalFilePath() != null) {
                baseNode.isFileExternal = true;
            }
            SvnOldUpgradeEntries.insertNode(upgradeData.root.getSDb(), baseNode);
            if (entry.getLockToken() != null && isCreateLocks) {
                ISVNWCDb.SVNWCDbLock lock = new ISVNWCDb.SVNWCDbLock();
                lock.token = entry.getLockToken();
                lock.owner = entry.getLockOwner();
                lock.comment = entry.getLockComment();
                lock.date = SVNDate.parseDate(entry.getLockCreationDate());
                db.addLock(tmpEntryAbsPath, lock);
            }
        }
        if (belowWorkingNode != null) {
            DbNode work = parentNode.belowWork != null ? parentNode.belowWork : parentNode.work;
            belowWorkingNode.wcId = upgradeData.workingCopyId;
            belowWorkingNode.localRelPath = SVNFileUtil.getFilePath(localRelPath);
            belowWorkingNode.opDepth = work.opDepth;
            belowWorkingNode.parentRelPath = parentRelPath;
            belowWorkingNode.presence = ISVNWCDb.SVNWCDbStatus.Normal;
            belowWorkingNode.kind = entry.getKind();
            belowWorkingNode.reposId = upgradeData.repositoryId;
            belowWorkingNode.reposRelPath = work.reposRelPath != null ? SVNPathUtil.append(work.reposRelPath, entry.getName()) : null;
            belowWorkingNode.revision = parentNode.work.revision;
            belowWorkingNode.checksum = null;
            if (textBaseInfo != null) {
                belowWorkingNode.checksum = entry.isScheduledForDeletion() ? textBaseInfo.normalBase.sha1Checksum : textBaseInfo.revertBase.sha1Checksum;
            }
            belowWorkingNode.translatedSize = 0L;
            belowWorkingNode.changedRev = -1L;
            belowWorkingNode.changedDate = null;
            belowWorkingNode.changedAuthor = null;
            belowWorkingNode.depth = SVNDepth.INFINITY;
            belowWorkingNode.lastModTime = null;
            belowWorkingNode.properties = null;
            SvnOldUpgradeEntries.insertNode(upgradeData.root.getSDb(), belowWorkingNode);
        }
        if (workingNode != null) {
            workingNode.wcId = upgradeData.workingCopyId;
            workingNode.localRelPath = SVNFileUtil.getFilePath(localRelPath);
            workingNode.parentRelPath = parentRelPath;
            workingNode.changedRev = -1L;
            workingNode.lastModTime = SVNDate.parseDate(entry.getTextTime());
            workingNode.translatedSize = entry.getWorkingSize();
            if (entry.getDepth() != SVNDepth.EXCLUDE) {
                workingNode.depth = entry.getDepth();
            } else {
                workingNode.presence = ISVNWCDb.SVNWCDbStatus.Excluded;
                workingNode.depth = SVNDepth.INFINITY;
            }
            if (entry.isDirectory()) {
                workingNode.checksum = null;
            } else if (textBaseInfo != null) {
                workingNode.checksum = textBaseInfo.normalBase.sha1Checksum;
            }
            workingNode.kind = entry.getKind();
            if (workingNode.presence != ISVNWCDb.SVNWCDbStatus.Excluded) {
                if (entry.isDirectory() && !"".equals(entry.getName())) {
                    workingNode.presence = ISVNWCDb.SVNWCDbStatus.Incomplete;
                    workingNode.kind = SVNNodeKind.DIR;
                } else if (entry.isScheduledForDeletion()) {
                    workingNode.presence = ISVNWCDb.SVNWCDbStatus.BaseDeleted;
                    workingNode.kind = entry.getKind();
                } else {
                    workingNode.kind = entry.getKind();
                    if (entry.isIncomplete()) {
                        assert (workingNode.presence == ISVNWCDb.SVNWCDbStatus.Normal);
                        workingNode.presence = ISVNWCDb.SVNWCDbStatus.Incomplete;
                    }
                }
            }
            if (workingNode.presence != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                workingNode.changedRev = entry.getCommittedRevision();
                workingNode.changedDate = SVNDate.parseDate(entry.getCommittedDate());
                workingNode.changedAuthor = entry.getAuthor();
            }
            if (entry.isScheduledForDeletion() && parentNode != null && parentNode.work != null && parentNode.work.presence == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                workingNode.opDepth = parentNode.work.opDepth;
            } else if (!entry.isCopied()) {
                workingNode.opDepth = SVNWCUtils.relpathDepth(localRelPath);
            }
            SvnOldUpgradeEntries.insertNode(upgradeData.root.getSDb(), workingNode);
        }
        if (actualNode != null) {
            actualNode.wcId = upgradeData.workingCopyId;
            actualNode.localRelPath = SVNFileUtil.getFilePath(localRelPath);
            actualNode.parentRelPath = parentRelPath;
            SvnOldUpgradeEntries.insertActualNode(upgradeData.root.getSDb(), actualNode);
        }
        WriteBaton entryNode = null;
        if (isCalculateEntryNode) {
            entryNode = new WriteBaton();
            entryNode.base = baseNode;
            entryNode.work = workingNode;
            entryNode.belowWork = belowWorkingNode;
            entryNode.treeConflicts = treeConflicts;
        }
        if (entry.getExternalFilePath() != null) {
            // empty if block
        }
        return entryNode;
    }

    private static void insertNode(SVNSqlJetDb sDb, DbNode node) throws SVNException {
        assert (node.opDepth > 0L || node.reposRelPath != null);
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.INSERT_NODE);
        stmt.bindf("isisnnnnsnrisnnni", node.wcId, node.localRelPath == null ? "" : node.localRelPath, node.opDepth, node.parentRelPath, node.kind == SVNNodeKind.DIR ? SVNDepth.asString(node.depth) : null, node.changedRev, node.changedDate != null ? node.changedDate : Integer.valueOf(0), node.changedAuthor, node.lastModTime);
        if (node.reposRelPath != null) {
            stmt.bindLong(5, node.reposId);
            stmt.bindString(6, node.reposRelPath);
            stmt.bindLong(7, node.revision);
        }
        stmt.bindString(8, SvnWcDbStatementUtil.getPresenceText(node.presence));
        if (node.kind == SVNNodeKind.NONE) {
            stmt.bindString(10, "unknown");
        } else {
            stmt.bindString(10, node.kind.toString());
        }
        if (node.kind == SVNNodeKind.FILE) {
            stmt.bindChecksum(14, node.checksum);
        }
        if (node.properties != null) {
            stmt.bindProperties(15, node.properties);
        }
        if (node.translatedSize != -1L) {
            stmt.bindLong(16, node.translatedSize);
        }
        if (node.isFileExternal) {
            stmt.bindLong(20, 1L);
        }
        stmt.done();
    }

    private static void insertActualNode(SVNSqlJetDb sDb, DbActualNode actualNode) throws SVNException {
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.INSERT_ACTUAL_NODE);
        stmt.bindLong(1, actualNode.wcId);
        stmt.bindString(2, actualNode.localRelPath);
        stmt.bindString(3, actualNode.parentRelPath);
        if (actualNode.properties != null) {
            stmt.bindProperties(4, actualNode.properties);
        }
        if (actualNode.conflictOld != null) {
            stmt.bindString(5, actualNode.conflictOld);
            stmt.bindString(6, actualNode.conflictNew);
            stmt.bindString(7, actualNode.conflictWorking);
        }
        if (actualNode.propReject != null) {
            stmt.bindString(8, actualNode.propReject);
        }
        if (actualNode.changelist != null) {
            stmt.bindString(9, actualNode.changelist);
        }
        if (actualNode.treeConflictData != null) {
            stmt.bindString(10, actualNode.treeConflictData);
        }
        stmt.done();
    }

    private static void writeActualOnlyEntries(Map<String, String> treeConflicts, SVNSqlJetDb sDb, long wcId, String dirRelPath) throws SVNException {
        for (String path : treeConflicts.keySet()) {
            DbActualNode actualNode = new DbActualNode();
            actualNode.wcId = wcId;
            actualNode.localRelPath = path;
            actualNode.parentRelPath = dirRelPath;
            actualNode.treeConflictData = treeConflicts.get(path);
            SvnOldUpgradeEntries.insertActualNode(sDb, actualNode);
        }
    }

    static class WriteBaton {
        DbNode base;
        DbNode work;
        DbNode belowWork;
        Map<String, String> treeConflicts;

        WriteBaton() {
        }
    }

    private static class DbActualNode {
        long wcId;
        String localRelPath;
        String parentRelPath;
        SVNProperties properties;
        String conflictOld;
        String conflictNew;
        String conflictWorking;
        String propReject;
        String changelist;
        String treeConflictData;

        private DbActualNode() {
        }
    }

    private static class DbNode {
        long wcId;
        String localRelPath;
        long opDepth;
        long reposId;
        String reposRelPath;
        String parentRelPath;
        ISVNWCDb.SVNWCDbStatus presence = ISVNWCDb.SVNWCDbStatus.Normal;
        long revision;
        SVNNodeKind kind;
        SvnChecksum checksum;
        long translatedSize;
        long changedRev;
        SVNDate changedDate;
        String changedAuthor;
        SVNDepth depth;
        SVNDate lastModTime;
        SVNProperties properties;
        boolean isFileExternal;

        private DbNode() {
        }
    }
}

