/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnOldRemoteCopy
extends SvnOldRunner<SVNCommitInfo, SvnRemoteCopy> {
    @Override
    public boolean isApplicable(SvnRemoteCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (operation.getFirstTarget().isURL()) {
            for (SvnCopySource source : operation.getSources()) {
                SvnWcGeneration sourceFormat;
                if (source.getSource().getFile() == null || (sourceFormat = SvnOperationFactory.detectWcGeneration(source.getSource().getFile(), false)) == SvnWcGeneration.V16) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected SVNCommitInfo run() throws SVNException {
        SVNCopyClient16 client = new SVNCopyClient16(((SvnRemoteCopy)this.getOperation()).getRepositoryPool(), ((SvnRemoteCopy)this.getOperation()).getOptions());
        client.setEventHandler(((SvnRemoteCopy)this.getOperation()).getEventHandler());
        client.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        client.setOptions(((SvnRemoteCopy)this.getOperation()).getOptions());
        client.setCommitHandler(SvnCodec.commitHandler(((SvnRemoteCopy)this.getOperation()).getCommitHandler()));
        client.setExternalsHandler(SvnCodec.externalsHandler(((SvnRemoteCopy)this.getOperation()).getExternalsHandler()));
        client.setDisableLocalModificationCopying(((SvnRemoteCopy)this.getOperation()).isDisableLocalModifications());
        SvnTarget target = ((SvnRemoteCopy)this.getOperation()).getFirstTarget();
        SVNCopySource[] sources = new SVNCopySource[((SvnRemoteCopy)this.getOperation()).getSources().size()];
        int i = 0;
        for (SvnCopySource newSource : ((SvnRemoteCopy)this.getOperation()).getSources()) {
            sources[i] = SvnCodec.copySource(newSource);
            ++i;
        }
        SVNCommitInfo info = client.doCopy(sources, target.getURL(), ((SvnRemoteCopy)this.getOperation()).isMove(), ((SvnRemoteCopy)this.getOperation()).isMakeParents(), ((SvnRemoteCopy)this.getOperation()).isFailWhenDstExists(), ((SvnRemoteCopy)this.getOperation()).getCommitMessage(), ((SvnRemoteCopy)this.getOperation()).getRevisionProperties());
        if (info != null) {
            ((SvnRemoteCopy)this.getOperation()).receive(((SvnRemoteCopy)this.getOperation()).getFirstTarget(), info);
        }
        return info;
    }
}

