/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgPropertiesManager {
    public static Collection<String> getGlobalIgnores(ISVNOptions options) {
        HashSet<String> allPatterns = new HashSet<String>();
        String[] ignores = options.getIgnorePatterns();
        for (int i = 0; ignores != null && i < ignores.length; ++i) {
            allPatterns.add(ignores[i]);
        }
        return allPatterns;
    }

    public static Collection<String> getEffectiveIgnores(SVNWCContext context, File absPath, Collection<String> globalIgnores) {
        HashSet<String> allPatterns = new HashSet<String>();
        if (globalIgnores != null) {
            allPatterns.addAll(globalIgnores);
        } else {
            allPatterns.addAll(SvnNgPropertiesManager.getGlobalIgnores(context.getOptions()));
        }
        if (context != null && absPath != null) {
            try {
                String ignoreProperty = context.getProperty(absPath, "svn:ignore");
                if (ignoreProperty != null) {
                    StringTokenizer tokens = new StringTokenizer(ignoreProperty, "\r\n");
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken().trim();
                        if (token.length() <= 0) continue;
                        allPatterns.add(token);
                    }
                }
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        return allPatterns;
    }

    public static boolean isIgnored(String name, Collection<String> patterns) {
        if (patterns == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (!DefaultSVNOptions.matches(pattern, name)) continue;
            return true;
        }
        return false;
    }

    public static void setProperty(final SVNWCContext context, File path, final String propertyName, final SVNPropertyValue propertyValue, SVNDepth depth, final boolean skipChecks, final ISVNEventHandler eventHandler, Collection<String> changelists) throws SVNException {
        if (SVNProperty.isEntryProperty(propertyName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            return;
        }
        SVNNodeKind kind = context.readKind(path, true);
        File dirPath = kind == SVNNodeKind.DIR ? path : SVNFileUtil.getParentFile(path);
        context.writeCheck(dirPath);
        if (depth == SVNDepth.EMPTY) {
            if (!context.matchesChangelist(path, changelists)) {
                return;
            }
            SvnNgPropertiesManager.setProperty(context, path, kind, propertyName, propertyValue, skipChecks, eventHandler);
        } else {
            context.nodeWalkChildren(path, new SVNWCContext.ISVNWCNodeHandler(){

                public void nodeFound(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
                    try {
                        SvnNgPropertiesManager.setProperty(context, localAbspath, kind.toNodeKind(), propertyName, propertyValue, skipChecks, eventHandler);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_INVALID_SCHEDULE) {
                            return;
                        }
                        throw e;
                    }
                }
            }, false, depth, changelists);
        }
    }

    private static void setProperty(final SVNWCContext context, final File path, SVNNodeKind kind, String propertyName, SVNPropertyValue value, boolean skipChecks, ISVNEventHandler eventHandler) throws SVNException {
        SVNEventAction action;
        String oldValue;
        Structure<StructureFields.NodeInfo> nodeInfo = context.getDb().readInfo(path, StructureFields.NodeInfo.status);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        if (status != ISVNWCDb.SVNWCDbStatus.Normal && status != ISVNWCDb.SVNWCDbStatus.Added && status != ISVNWCDb.SVNWCDbStatus.Incomplete) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Can''t set properties on ''{0}'': invalid status for updating properties.", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (value != null && SVNProperty.isSVNProperty(propertyName)) {
            SVNPropertyValue pv;
            ISVNFileContentFetcher fetcher = new ISVNFileContentFetcher(){

                public SVNPropertyValue getProperty(String propertyName) throws SVNException {
                    return context.getPropertyValue(path, propertyName);
                }

                public boolean fileIsBinary() throws SVNException {
                    SVNPropertyValue mimeType = context.getPropertyValue(path, "svn:mime-type");
                    return mimeType != null && SVNProperty.isBinaryMimeType(mimeType.getString());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fetchFileContent(OutputStream os) throws SVNException {
                    InputStream is = null;
                    try {
                        is = SVNFileUtil.openFileForReading(path);
                        SVNTranslator.copy(is, os);
                    }
                    catch (IOExceptionWrapper ioew) {
                        throw ioew.getOriginalException();
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    finally {
                        SVNFileUtil.closeFile(is);
                    }
                }
            };
            value = pv = SVNPropertiesManager.validatePropertyValue(path, kind, propertyName, value, skipChecks, context.getOptions(), fetcher);
        }
        SVNSkel workItems = null;
        if (kind == SVNNodeKind.FILE && ("svn:executable".equals(propertyName) || "svn:needs-lock".equals(propertyName))) {
            workItems = context.wqBuildSyncFileFlags(path);
        }
        SVNProperties properties = new SVNProperties();
        try {
            properties = context.getDb().readProperties(path);
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage().wrap("Failed to load current properties");
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        boolean clearRecordedInfo = false;
        if (kind == SVNNodeKind.FILE && "svn:keywords".equals(propertyName)) {
            HashMap newKeywords;
            oldValue = properties.getStringValue("svn:keywords");
            Map keywords = oldValue != null ? context.getKeyWords(path, oldValue) : new HashMap();
            Map map = newKeywords = value != null ? context.getKeyWords(path, value.getString()) : new HashMap();
            if (!((Object)keywords).equals(newKeywords)) {
                clearRecordedInfo = true;
            }
        } else if (kind == SVNNodeKind.FILE && "svn:eol-style".equals(propertyName)) {
            oldValue = properties.getStringValue("svn:eol-style");
            if (oldValue == null || value == null) {
                clearRecordedInfo = oldValue != null && value == null || oldValue == null && value != null;
            } else {
                boolean bl = clearRecordedInfo = !SVNPropertyValue.create(oldValue).equals(value);
            }
        }
        if (!properties.containsName(propertyName)) {
            action = value == null ? SVNEventAction.PROPERTY_DELETE_NONEXISTENT : SVNEventAction.PROPERTY_ADD;
        } else {
            SVNEventAction sVNEventAction = action = value == null ? SVNEventAction.PROPERTY_DELETE : SVNEventAction.PROPERTY_MODIFY;
        }
        if (value != null) {
            properties.put(propertyName, value);
        } else {
            properties.remove(propertyName);
        }
        context.getDb().opSetProps(path, properties, null, clearRecordedInfo, workItems);
        if (workItems != null) {
            context.wqRun(path);
        }
        if (eventHandler != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.NONE, null, -1L, action, action, null, null, 1L, 1L, null, propertyName);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    public static void checkPropertyName(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        SVNErrorMessage err;
        if (SVNRevisionProperty.isRevisionProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (propertyValue != null && !SVNPropertiesManager.isValidPropertyName(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name: ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public static void categorizeProperties(SVNProperties props, SVNProperties regular, SVNProperties entry, SVNProperties working) {
        for (String name : props.nameSet()) {
            SVNPropertyValue pv = props.getSVNPropertyValue(name);
            if (SVNProperty.isEntryProperty(name) && entry != null) {
                entry.put(name, pv);
                continue;
            }
            if (SVNProperty.isRegularProperty(name) && regular != null) {
                regular.put(name, pv);
                continue;
            }
            if (!SVNProperty.isWorkingCopyProperty(name) || working == null) continue;
            working.put(name, pv);
        }
    }
}

