/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgExport
extends SvnNgOperationRunner<Long, SvnExport> {
    @Override
    protected Long run(SVNWCContext context) throws SVNException {
        SVNRevision revision = ((SvnExport)this.getOperation()).getRevision();
        File to = ((SvnExport)this.getOperation()).getFirstTarget().getFile();
        File from = ((SvnExport)this.getOperation()).getSource().getFile();
        String eolStyle = ((SvnExport)this.getOperation()).getEolStyle();
        boolean ignoreKeywords = !((SvnExport)this.getOperation()).isExpandKeywords();
        boolean force = ((SvnExport)this.getOperation()).isForce();
        SVNDepth depth = ((SvnExport)this.getOperation()).getDepth();
        if (revision == SVNRevision.UNDEFINED) {
            revision = SVNRevision.WORKING;
        }
        if (SVNFileType.getType(from) == SVNFileType.FILE && SVNFileType.getType(to) == SVNFileType.DIRECTORY) {
            to = new File(to, from.getName());
        }
        this.copyVersionedDir(from, to, revision, eolStyle, ignoreKeywords, force, depth);
        this.handleEvent(SVNEventFactory.createSVNEvent(to, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return revision.getNumber();
    }

    private void copyVersionedDir(File from, File to, SVNRevision revision, String eolStyle, boolean ignoreKeywords, boolean force, SVNDepth depth) throws SVNException {
        if (revision != SVNRevision.WORKING) {
            Structure<StructureFields.NodeOriginInfo> originInfo = this.getWcContext().getNodeOrigin(from, false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.reposRelpath);
            if (originInfo.is(StructureFields.NodeOriginInfo.isCopy) && !originInfo.hasValue(StructureFields.NodeOriginInfo.reposRelpath)) {
                return;
            }
            originInfo.release();
        } else {
            boolean isDeleted = this.getWcContext().isNodeStatusDeleted(from);
            if (isDeleted) {
                return;
            }
        }
        SVNNodeKind fromKind = this.getWcContext().readKind(from, false);
        if (fromKind == SVNNodeKind.DIR) {
            String externalProperty;
            if (to.exists() && !force) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination directory exists, and will not be overwritten unless forced");
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            SVNFileUtil.ensureDirectoryExists(to);
            List<File> children = this.getWcContext().getNodeChildren(from, false);
            for (File child : children) {
                this.checkCancelled();
                File targetPath = new File(to, child.getName());
                SVNNodeKind childKind = this.getWcContext().readKind(child, false);
                if (childKind == SVNNodeKind.DIR && depth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                    this.handleEvent(SVNEventFactory.createSVNEvent(targetPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
                    if (depth == SVNDepth.INFINITY) {
                        this.copyVersionedDir(child, targetPath, revision, eolStyle, ignoreKeywords, force, depth);
                        continue;
                    }
                    SVNFileUtil.ensureDirectoryExists(targetPath);
                    continue;
                }
                if (childKind != SVNNodeKind.FILE || depth.compareTo(SVNDepth.FILES) < 0) continue;
                ISVNWCDb.SVNWCDbKind externalKind = null;
                try {
                    Structure<StructureFields.ExternalNodeInfo> info = SvnWcDbExternals.readExternal(this.getWcContext(), child, child, StructureFields.ExternalNodeInfo.kind);
                    externalKind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.ExternalNodeInfo.kind));
                    info.release();
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw e;
                    }
                    externalKind = null;
                }
                if (externalKind == ISVNWCDb.SVNWCDbKind.File) continue;
                this.copyVersionedFile(child, targetPath, revision, eolStyle, ignoreKeywords);
            }
            SVNDepth nodeDepth = this.getWcContext().getNodeDepth(from);
            if (!((SvnExport)this.getOperation()).isIgnoreExternals() && depth == SVNDepth.INFINITY && nodeDepth == SVNDepth.INFINITY && (externalProperty = this.getWcContext().getProperty(from, "svn:externals")) != null) {
                SVNExternal[] externals = SVNExternal.parseExternals(from, externalProperty);
                for (int i = 0; i < externals.length; ++i) {
                    File extFrom = new File(from, externals[i].getPath());
                    File extTo = new File(to, externals[i].getPath());
                    if (extTo.getParentFile() != null) {
                        SVNFileUtil.ensureDirectoryExists(extTo.getParentFile());
                    }
                    this.copyVersionedDir(extFrom, extTo, revision, eolStyle, ignoreKeywords, force, SVNDepth.INFINITY);
                }
            }
        } else if (fromKind == SVNNodeKind.FILE) {
            SVNFileType toType = SVNFileType.getType(to);
            if (!(toType != SVNFileType.FILE && toType != SVNFileType.UNKNOWN || force)) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination file ''{0}'' exists, and will not be overwritten unless forced", (Object)to);
                SVNErrorManager.error(error, SVNLogType.WC);
            } else if (toType == SVNFileType.DIRECTORY) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination ''{0}'' exists. Cannot overwrite directory with non-directory", (Object)to);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            this.copyVersionedFile(from, to, revision, eolStyle, ignoreKeywords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File from, File to, SVNRevision revision, String eolStyle, boolean ignoreKeywords) throws SVNException {
        SVNDate committedDate;
        long timestamp;
        byte[] eols;
        boolean isDeleted = this.getWcContext().isNodeStatusDeleted(from);
        if (revision == SVNRevision.WORKING && isDeleted) {
            return;
        }
        File source = null;
        SVNProperties properties = null;
        boolean modified = false;
        if (revision != SVNRevision.WORKING) {
            SVNWCContext.PristineContentsInfo pristine = this.getWcContext().getPristineContents(from, false, true);
            if (pristine != null) {
                source = pristine.path;
            }
            if (source == null) {
                return;
            }
            properties = this.getWcContext().getPristineProps(from);
        } else {
            properties = this.getWcContext().getDb().readProperties(from);
            SvnStatus fromStatus = SVNStatusEditor17.internalStatus(this.getWcContext(), from);
            modified = fromStatus.getTextStatus() != SVNStatusType.STATUS_NORMAL;
            source = from;
        }
        boolean special = properties.getStringValue("svn:special") != null;
        boolean executable = properties.getStringValue("svn:executable") != null;
        String keywords = properties.getStringValue("svn:keywords");
        String charsetProp = properties.getStringValue("svnkit:charset");
        String mimeType = properties.getStringValue("svn:mime-type");
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, from, ((SvnExport)this.getOperation()).getOptions());
        if (special && SVNFileUtil.symlinksSupported()) {
            String linkTarget = SVNFileUtil.getSymlinkName(from);
            SVNFileUtil.createSymlink(to, linkTarget);
            return;
        }
        byte[] byArray = eols = eolStyle != null ? SVNTranslator.getEOL(eolStyle, ((SvnExport)this.getOperation()).getOptions()) : null;
        if (eols == null) {
            eolStyle = properties.getStringValue("svn:eol-style");
            eols = SVNTranslator.getEOL(eolStyle, ((SvnExport)this.getOperation()).getOptions());
        }
        if (modified) {
            timestamp = from.lastModified();
            committedDate = new SVNDate(timestamp, 0);
        } else {
            Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(from, StructureFields.NodeInfo.changedDate);
            committedDate = (SVNDate)nodeInfo.get(StructureFields.NodeInfo.changedDate);
            timestamp = committedDate.getTime();
            nodeInfo.release();
        }
        Map keywordsMap = null;
        if (keywords != null) {
            Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(from, StructureFields.NodeInfo.changedAuthor, StructureFields.NodeInfo.changedRev);
            String rev = Long.toString(nodeInfo.lng(StructureFields.NodeInfo.changedRev));
            String author = (String)nodeInfo.get(StructureFields.NodeInfo.changedAuthor);
            nodeInfo.release();
            if (modified) {
                author = "(local)";
                rev = rev + "M";
            }
            SVNURL nodeUrl = this.getWcContext().getNodeUrl(from);
            keywordsMap = SVNTranslator.computeKeywords(keywords, nodeUrl.toString(), author, SVNDate.formatDate(committedDate), rev, ((SvnExport)this.getOperation()).getOptions());
        }
        File tmpFile = SVNFileUtil.createUniqueFile(to.getParentFile(), "svnkit", ".tmp", false);
        try {
            OutputStream os = null;
            InputStream is = null;
            try {
                is = SVNFileUtil.openFileForReading(source);
                os = SVNFileUtil.openFileForWriting(tmpFile);
                if (eols != null || keywordsMap != null) {
                    os = SVNTranslator.getTranslatingOutputStream(os, charset, eols, false, keywordsMap, !ignoreKeywords);
                }
                SVNTranslator.copy(is, os);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile(is);
                SVNFileUtil.closeFile(os);
            }
            SVNFileUtil.rename(tmpFile, to);
        }
        finally {
            SVNFileUtil.deleteFile(tmpFile);
        }
        if (executable) {
            SVNFileUtil.setExecutable(to, true);
        }
        if (!special && timestamp > 0L) {
            SVNFileUtil.setLastModified(to, timestamp);
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(to, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
    }
}

