/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNAmbientDepthFilterEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNDiffEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnDiff;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgDiff
extends SvnNgOperationRunner<Void, SvnDiff> {
    @Override
    public boolean isApplicable(SvnDiff operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (wcGeneration != SvnWcGeneration.V17) {
            return false;
        }
        Collection<SvnTarget> targets = operation.getTargets();
        for (SvnTarget target : targets) {
            if (!target.isFile()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        if (this.isPeggedDiff()) {
            this.doPeggedDiff();
        } else {
            this.doTwoSourcesDiff();
        }
        return null;
    }

    private void doPeggedDiff() throws SVNException {
        boolean endRevisionIsLocal;
        SvnTarget target = ((SvnDiff)this.getOperation()).getFirstTarget();
        SVNRevision pegRevision = target.getPegRevision();
        if (!pegRevision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Peg revision is not specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNRevision startRevision = ((SvnDiff)this.getOperation()).getStartRevision();
        SVNRevision endRevision = ((SvnDiff)this.getOperation()).getEndRevision();
        if (startRevision == null || endRevision == null || !startRevision.isValid() || !endRevision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean startRevisionIsLocal = startRevision == SVNRevision.BASE || startRevision == SVNRevision.WORKING;
        boolean bl = endRevisionIsLocal = endRevision == SVNRevision.BASE || endRevision == SVNRevision.WORKING;
        if (startRevisionIsLocal && endRevisionIsLocal) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        File targetFile = target.getFile().getAbsoluteFile();
        ISVNDiffGenerator generator = this.getDiffGenerator();
        generator.init(targetFile.getAbsolutePath(), targetFile.getAbsolutePath());
        if (endRevision != SVNRevision.BASE && endRevision != SVNRevision.WORKING && endRevision != SVNRevision.COMMITTED) {
            if (startRevision == SVNRevision.BASE || startRevision == SVNRevision.WORKING || startRevision == SVNRevision.COMMITTED) {
                this.doDiffURLWC(targetFile, endRevision, pegRevision, targetFile, startRevision, true, ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getOutput(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), generator);
            } else {
                this.doDiffURLURL(null, targetFile, startRevision, null, targetFile, endRevision, pegRevision, generator);
            }
        } else {
            this.doDiffURLWC(targetFile, startRevision, pegRevision, targetFile, endRevision, false, ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getOutput(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), generator);
        }
    }

    private ISVNDiffGenerator getDiffGenerator() {
        return ((SvnDiff)this.getOperation()).getDiffGenerator() != null ? ((SvnDiff)this.getOperation()).getDiffGenerator() : new DefaultSVNDiffGenerator();
    }

    private void doTwoSourcesDiff() throws SVNException {
        SvnTarget firstTarget = ((SvnDiff)this.getOperation()).getFirstTarget();
        SvnTarget secondTarget = ((SvnDiff)this.getOperation()).getSecondTarget();
        if (firstTarget.isURL() && secondTarget.isFile()) {
            this.doDiffURLWC(firstTarget, secondTarget);
        } else if (firstTarget.isFile() && secondTarget.isURL()) {
            this.doDiffWCURL(firstTarget, secondTarget);
        } else if (firstTarget.isFile() && secondTarget.isFile()) {
            this.doDiffWCWC(firstTarget, secondTarget);
        } else {
            throw new UnsupportedOperationException("URL-URL diff is not supported");
        }
    }

    private void doDiffWCURL(SvnTarget firstTarget, SvnTarget secondTarget) throws SVNException {
        SVNRevision startRevision = ((SvnDiff)this.getOperation()).getStartRevision();
        SVNRevision endRevision = ((SvnDiff)this.getOperation()).getEndRevision();
        if (startRevision == null || endRevision == null || !startRevision.isValid() || !endRevision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ISVNDiffGenerator generator = this.getDiffGenerator();
        generator.init(firstTarget.getFile().getAbsolutePath(), secondTarget.getURL().toString());
        if (startRevision == SVNRevision.BASE || endRevision == SVNRevision.WORKING) {
            this.doDiffURLWC(secondTarget.getURL(), endRevision, SVNRevision.UNDEFINED, firstTarget.getFile(), startRevision, true, generator);
        } else {
            this.doDiffURLURL(null, firstTarget.getFile(), startRevision, secondTarget.getURL(), null, endRevision, SVNRevision.UNDEFINED, generator);
        }
    }

    private void doDiffURLWC(SvnTarget firstTarget, SvnTarget secondTarget) throws SVNException {
        SVNRevision startRevision = ((SvnDiff)this.getOperation()).getStartRevision();
        SVNRevision endRevision = ((SvnDiff)this.getOperation()).getEndRevision();
        if (startRevision == null || endRevision == null || !startRevision.isValid() || !endRevision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ISVNDiffGenerator generator = this.getDiffGenerator();
        generator.init(firstTarget.getURL().toString(), secondTarget.getFile().getAbsolutePath());
        if (startRevision == SVNRevision.BASE || endRevision == SVNRevision.WORKING) {
            this.doDiffURLWC(firstTarget.getURL(), startRevision, SVNRevision.UNDEFINED, secondTarget.getFile(), endRevision, false, generator);
        } else {
            this.doDiffURLURL(firstTarget.getURL(), null, startRevision, null, secondTarget.getFile(), endRevision, SVNRevision.UNDEFINED, generator);
        }
    }

    private void doDiffWCWC(SvnTarget firstTarget, SvnTarget secondTarget) throws SVNException {
        SVNRevision startRevision = ((SvnDiff)this.getOperation()).getStartRevision();
        SVNRevision endRevision = ((SvnDiff)this.getOperation()).getEndRevision();
        if (startRevision == null || endRevision == null || !startRevision.isValid() || !endRevision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Both rN and rM revisions should be specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        boolean startRevisionIsLocal = startRevision == SVNRevision.WORKING || startRevision == SVNRevision.BASE;
        boolean endRevisionIsLocal = endRevision == SVNRevision.WORKING || endRevision == SVNRevision.BASE;
        ISVNDiffGenerator generator = this.getDiffGenerator();
        generator.init(firstTarget.getFile().getAbsolutePath(), secondTarget.getFile().toString());
        if (startRevisionIsLocal && endRevisionIsLocal) {
            this.doDiffWCWC(firstTarget.getFile(), startRevision, secondTarget.getFile(), endRevision);
        } else if (startRevisionIsLocal) {
            this.doDiffURLWC(secondTarget.getFile(), endRevision, SVNRevision.UNDEFINED, firstTarget.getFile(), startRevision, true, ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getOutput(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), generator);
        } else if (endRevisionIsLocal) {
            this.doDiffURLWC(firstTarget.getFile(), startRevision, SVNRevision.UNDEFINED, secondTarget.getFile(), endRevision, false, ((SvnDiff)this.getOperation()).getDepth(), !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getOutput(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), generator);
        } else {
            this.doDiffURLURL(null, firstTarget.getFile(), startRevision, null, secondTarget.getFile(), endRevision, SVNRevision.UNDEFINED, generator);
        }
    }

    private boolean isPeggedDiff() {
        return ((SvnDiff)this.getOperation()).getTargets().size() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(SVNURL url1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, ISVNDiffGenerator generator) throws SVNException {
        boolean isRoot = this.getWcContext().getDb().isWCRoot(path2);
        String target = isRoot ? null : SVNFileUtil.getFileName(path2);
        File pathForUrl = isRoot ? path2 : SVNFileUtil.getParentFile(path2);
        SVNURL anchorUrl = this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(pathForUrl));
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)pathForUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (pegRevision.isValid()) {
            SVNURL startUrl;
            Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, SvnTarget.fromURL(url1), pegRevision, revision1, revision2);
            url1 = startUrl = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
            String anchorPath2 = SVNPathUtil.append(anchorUrl.toString(), target == null ? "" : target);
            if (!reverse) {
                generator.init(url1.toString(), anchorPath2);
            } else {
                generator.init(anchorPath2, url1.toString());
            }
        }
        SVNRepository repository = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        long revNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromURL(url1), revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = new SvnDiffCallback(generator, reverse ? -1L : revNumber, reverse ? revNumber : -1L, ((SvnDiff)this.getOperation()).getOutput());
        SVNDiffEditor17 editor = new SVNDiffEditor17(this.getWcContext(), pathForUrl, null, ((SvnDiff)this.getOperation()).getDepth(), revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, reverse, callback, !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), false, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds());
        boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
        SVNReporter17 reporter17 = new SVNReporter17(path2, this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        long pegRevisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromFile(path2), revision2, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        try {
            repository.diff(url1, revNumber, pegRevisionNumber, target, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, (ISVNReporterBaton)reporter17, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
        }
        finally {
            editor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(File path1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, SVNDepth depth, boolean useAncestry, OutputStream result, Collection changeLists) throws SVNException {
        SVNURL url1;
        ISVNDiffGenerator generator = this.getDiffGenerator();
        boolean isRoot = this.getWcContext().getDb().isWCRoot(path2);
        String target = isRoot ? null : SVNFileUtil.getFileName(path2);
        File pathForUrl = isRoot ? path2 : SVNFileUtil.getParentFile(path2);
        SVNURL anchorUrl = this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(pathForUrl));
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)pathForUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (pegRevision.isValid()) {
            SVNURL startUrl;
            Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, SvnTarget.fromFile(path1), pegRevision, revision1, revision2);
            url1 = startUrl = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
            String anchorPath2 = SVNPathUtil.append(anchorUrl.toString(), target == null ? "" : target);
            generator.init(url1.toString(), anchorPath2);
        } else {
            url1 = this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(path1));
        }
        SVNRepository repository = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        long revNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromFile(path1), revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = new SvnDiffCallback(generator, reverse ? -1L : revNumber, reverse ? revNumber : -1L, ((SvnDiff)this.getOperation()).getOutput());
        SVNDiffEditor17 editor = new SVNDiffEditor17(this.getWcContext(), pathForUrl, null, ((SvnDiff)this.getOperation()).getDepth(), revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, reverse, callback, !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), false, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds());
        boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
        SVNReporter17 reporter17 = new SVNReporter17(path2, this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        long pegRevisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromFile(path2), revision2, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SVNAmbientDepthFilterEditor17.wrap(this.getWcContext(), pathForUrl, target, editor, false);
        try {
            repository.diff(url1, revNumber, pegRevisionNumber, target, !useAncestry, depth, true, (ISVNReporterBaton)reporter17, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
        }
        finally {
            editor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffWCWC(File path1, SVNRevision revision1, File path2, SVNRevision revision2) throws SVNException {
        if (!path1.equals(path2) || revision1 != SVNRevision.BASE || revision2 != SVNRevision.WORKING) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only diffs between a path's text-base and its working files are supported at this time (-rBASE:WORKING)");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ISVNDiffGenerator generator = this.getDiffGenerator();
        boolean isRoot = this.getWcContext().getDb().isWCRoot(path2);
        String target = isRoot ? null : SVNFileUtil.getFileName(path2);
        File pathForUrl = isRoot ? path2 : SVNFileUtil.getParentFile(path2);
        long revNumber = 0L;
        try {
            revNumber = this.getRepositoryAccess().getRevisionNumber(null, SvnTarget.fromFile(path1), revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_BAD_REVISION) {
                revNumber = 0L;
            }
            throw e;
        }
        SvnDiffCallback callback = new SvnDiffCallback(generator, revNumber, -1L, ((SvnDiff)this.getOperation()).getOutput());
        SVNDiffEditor17 editor = new SVNDiffEditor17(this.getWcContext(), pathForUrl, path2, ((SvnDiff)this.getOperation()).getDepth(), revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, false, callback, !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), false, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds());
        try {
            editor.closeEdit();
        }
        finally {
            editor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLURL(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision, ISVNDiffGenerator generator) throws SVNException {
        File basePath;
        SvnTarget target2;
        SvnTarget target1;
        block21: {
            target1 = url1 != null ? SvnTarget.fromURL(url1) : SvnTarget.fromFile(path1);
            target2 = url2 != null ? SvnTarget.fromURL(url2) : SvnTarget.fromFile(path2);
            basePath = null;
            if (path1 != null) {
                basePath = path1;
            }
            if (path2 != null) {
                basePath = path2;
            }
            url1 = this.getRepositoryAccess().getTargetURL(target1);
            url2 = this.getRepositoryAccess().getTargetURL(target2);
            if (pegRevision.isValid()) {
                try {
                    Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, target2, pegRevision, revision1, revision2);
                    url1 = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                    url2 = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.endUrl);
                    generator.init(url1.toString(), url2.toString());
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block21;
                    throw e;
                }
            }
        }
        SVNRepository repository1 = this.getRepositoryAccess().createRepository(url1, null, true);
        SVNRepository repository2 = this.getRepositoryAccess().createRepository(url2, null, false);
        final long rev1 = this.getRepositoryAccess().getRevisionNumber(repository1, target1, revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        long rev2 = -1L;
        String target1String = null;
        SVNNodeKind kind1 = null;
        SVNNodeKind kind2 = null;
        try {
            rev2 = this.getRepositoryAccess().getRevisionNumber(repository2, target2, revision2, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            kind1 = repository1.checkPath("", rev1);
            kind2 = repository2.checkPath("", rev2);
            if (kind1 == SVNNodeKind.NONE && kind2 == SVNNodeKind.NONE) {
                SVNErrorMessage err;
                if (url1.equals(url2)) {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url1, new Long(rev1), new Long(rev2));
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff targets ''{0}'' and ''{1}'' were not found in the repository at revisions ''{2}'' and ''{3}''", url1, url2, new Long(rev1), new Long(rev2));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else if (kind1 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url1, rev2, rev1, repository1);
            } else if (kind2 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(url2, rev1, rev2, repository2);
            }
        }
        finally {
            repository2.closeSession();
        }
        if (kind1 == SVNNodeKind.FILE || kind2 == SVNNodeKind.FILE) {
            target1String = SVNPathUtil.tail(url1.getPath());
            if (basePath != null) {
                basePath = basePath.getParentFile();
            }
            url1 = SVNURL.parseURIEncoded(SVNPathUtil.removeTail(url1.toString()));
            repository1 = this.getRepositoryAccess().createRepository(url1, null, true);
        }
        repository2 = this.getRepositoryAccess().createRepository(url1, null, false);
        SvnNgRemoteDiffEditor editor = null;
        try {
            SvnDiffCallback callback = new SvnDiffCallback(generator, rev1, rev2, ((SvnDiff)this.getOperation()).getOutput());
            editor = SvnNgRemoteDiffEditor.createEditor(this.getWcContext(), basePath, ((SvnDiff)this.getOperation()).getDepth(), repository2, rev1, false, false, callback, ((SvnDiff)this.getOperation()).getEventHandler());
            ISVNReporterBaton reporter = new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, rev1, SVNDepth.INFINITY, false);
                    reporter.finishReport();
                }
            };
            repository1.diff(url2, rev2, rev1, target1String, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, reporter, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
        }
        finally {
            if (editor != null) {
                editor.cleanup();
            }
            repository2.closeSession();
        }
    }

    private void checkDiffTargetExists(SVNURL url1, long revision, long otherRevision, SVNRepository repository) throws SVNException {
        SVNNodeKind kind = repository.checkPath("", revision);
        if (kind == SVNNodeKind.NONE) {
            if (revision == otherRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}''", url1, new Long(revision));
                SVNErrorManager.error(err, SVNLogType.WC);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", url1, new Long(revision), new Long(otherRevision));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffURLWC(File path1, SVNRevision revision1, SVNRevision pegRevision, File path2, SVNRevision revision2, boolean reverse, SVNDepth depth, boolean b, OutputStream output, Collection<String> applicableChangelists, ISVNDiffGenerator generator) throws SVNException {
        SVNURL url1;
        boolean isRoot = this.getWcContext().getDb().isWCRoot(path2);
        String target = isRoot ? null : SVNFileUtil.getFileName(path2);
        File pathForUrl = isRoot ? path2 : SVNFileUtil.getParentFile(path2);
        SVNURL anchorUrl = this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(pathForUrl));
        if (anchorUrl == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)pathForUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (pegRevision.isValid()) {
            SVNURL startUrl;
            Structure<SvnRepositoryAccess.LocationsInfo> locations = this.getRepositoryAccess().getLocations(null, SvnTarget.fromFile(path1), pegRevision, revision1, revision2);
            url1 = startUrl = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
            String anchorPath2 = SVNPathUtil.append(anchorUrl.toString(), target == null ? "" : target);
            if (!reverse) {
                generator.init(url1.toString(), anchorPath2);
            } else {
                generator.init(anchorPath2, url1.toString());
            }
        } else {
            url1 = this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(path1));
        }
        SVNRepository repository = this.getRepositoryAccess().createRepository(anchorUrl, null, true);
        long revNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromURL(url1, pegRevision), revision1, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        SvnDiffCallback callback = new SvnDiffCallback(generator, reverse ? -1L : revNumber, reverse ? revNumber : -1L, ((SvnDiff)this.getOperation()).getOutput());
        SVNDiffEditor17 editor = new SVNDiffEditor17(this.getWcContext(), pathForUrl, null, ((SvnDiff)this.getOperation()).getDepth(), revision2 == SVNRevision.BASE || revision2 == SVNRevision.COMMITTED, reverse, callback, !((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getApplicableChangelists(), false, ((SvnDiff)this.getOperation()).isShowCopiesAsAdds());
        boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
        SVNReporter17 reporter17 = new SVNReporter17(path2, this.getWcContext(), false, !serverSupportsDepth, ((SvnDiff)this.getOperation()).getDepth(), false, false, true, false, SVNDebugLog.getDefaultLog());
        long pegRevisionNumber = this.getRepositoryAccess().getRevisionNumber(repository, SvnTarget.fromFile(path2), revision2, null).lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        try {
            repository.diff(url1, revNumber, pegRevisionNumber, target, ((SvnDiff)this.getOperation()).isIgnoreAncestry(), ((SvnDiff)this.getOperation()).getDepth(), true, (ISVNReporterBaton)reporter17, SVNCancellableEditor.newInstance(editor, this, SVNDebugLog.getDefaultLog()));
        }
        finally {
            editor.cleanup();
        }
    }
}

