/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgCleanup
extends SvnNgOperationRunner<Void, SvnCleanup> {
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        if (((SvnCleanup)this.getOperation()).getFirstTarget().isURL()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)((SvnCleanup)this.getOperation()).getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File localAbsPath = ((SvnCleanup)this.getOperation()).getFirstTarget().getFile().getAbsoluteFile();
        SVNWCDb db = new SVNWCDb();
        SVNWCContext wcContext = new SVNWCContext(db, context.getEventHandler());
        this.cleanup(wcContext, localAbsPath);
        this.sleepForTimestamp();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        try {
            wcContext.getDb().open(ISVNWCDb.SVNWCDbOpenMode.ReadWrite, null, true, false);
            this.cleanupInternal(wcContext, localAbsPath);
            wcContext.getDb().clearDavCacheRecursive(localAbsPath);
        }
        finally {
            wcContext.getDb().close();
        }
    }

    private int canBeCleaned(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        SVNErrorMessage err;
        int wcFormat = wcContext.checkWC(localAbsPath);
        if (wcFormat == 0) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy directory", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (wcFormat < 12) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Log format too old, please use Subversion 1.6 or earlier");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return wcFormat;
    }

    private void cleanupInternal(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        File cleanupWCRoot;
        int wcFormat = this.canBeCleaned(wcContext, localAbsPath);
        wcContext.getDb().obtainWCLock(localAbsPath, -1, true);
        if (wcFormat >= 13) {
            wcContext.wqRun(localAbsPath);
        }
        if ((cleanupWCRoot = wcContext.getDb().getWCRoot(localAbsPath)).equals(localAbsPath)) {
            SVNWCUtils.admCleanupTmpArea(wcContext, localAbsPath);
            wcContext.getDb().cleanupPristine(localAbsPath);
        }
        this.repairTimestamps(wcContext, localAbsPath);
        wcContext.getDb().releaseWCLock(localAbsPath);
    }

    private void repairTimestamps(SVNWCContext wcContext, File localAbsPath) throws SVNException {
        wcContext.checkCancelled();
        ISVNWCDb.WCDbInfo info = wcContext.getDb().readInfo(localAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind);
        if (info.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || info.status == ISVNWCDb.SVNWCDbStatus.Deleted || info.status == ISVNWCDb.SVNWCDbStatus.Excluded || info.status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            return;
        }
        if (info.kind == ISVNWCDb.SVNWCDbKind.File || info.kind == ISVNWCDb.SVNWCDbKind.Symlink) {
            wcContext.isTextModified(localAbsPath, false);
        } else if (info.kind == ISVNWCDb.SVNWCDbKind.Dir) {
            Set<String> children = wcContext.getDb().readChildren(localAbsPath);
            for (String childPath : children) {
                File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, childPath);
                this.repairTimestamps(wcContext, childAbsPath);
            }
        }
    }
}

