/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRevert;
import org.tmatesoft.svn.core.wc.ISVNAddParameters;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgAdd
extends SvnNgOperationRunner<Void, SvnScheduleForAddition> {
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        for (SvnTarget target : ((SvnScheduleForAddition)this.getOperation()).getTargets()) {
            this.add(target);
        }
        return null;
    }

    private void add(SvnTarget target) throws SVNException {
        File path;
        if (target.isURL()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)target.getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File existingParent = path = target.getFile();
        File parentPath = path;
        if (!this.getWcContext().getDb().isWCRoot(path)) {
            existingParent = parentPath = SVNFileUtil.getParentFile(path);
            if (((SvnScheduleForAddition)this.getOperation()).isAddParents()) {
                existingParent = this.findExistingParent(parentPath);
            }
        }
        SVNFileType targetType = SVNFileType.getType(path);
        if (!((SvnScheduleForAddition)this.getOperation()).isAddParents() && ((SvnScheduleForAddition)this.getOperation()).isMkDir() && targetType != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Can''t create directory ''{0}'': Cannot create a file when that file already exists.", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (((SvnScheduleForAddition)this.getOperation()).isMkDir() && ((SvnScheduleForAddition)this.getOperation()).isAddParents()) {
            SVNFileUtil.ensureDirectoryExists(path);
        } else if (targetType == SVNFileType.NONE && ((SvnScheduleForAddition)this.getOperation()).isMkDir()) {
            SVNFileUtil.ensureDirectoryExists(path);
        }
        File lockRoot = this.getWcContext().acquireWriteLock(existingParent, false, true);
        try {
            this.add(path, parentPath, existingParent);
        }
        catch (SVNException e) {
            if (targetType == SVNFileType.NONE) {
                SVNFileUtil.deleteAll(path, true);
            }
            throw e;
        }
        finally {
            this.getWcContext().releaseWriteLock(lockRoot);
        }
    }

    private void add(File path, File parentPath, File existingParentPath) throws SVNException {
        block11: {
            if (!existingParentPath.equals(parentPath)) {
                String parent = parentPath.getAbsolutePath().replace(File.separatorChar, '/');
                String existingParent = existingParentPath.getAbsolutePath().replace(File.separatorChar, '/');
                String relativeChildPath = SVNPathUtil.getRelativePath(existingParent, parent);
                parentPath = existingParentPath;
                StringTokenizer components = new StringTokenizer(relativeChildPath, "/");
                while (components.hasMoreTokens()) {
                    String component = components.nextToken();
                    this.checkCancelled();
                    parentPath = SVNFileUtil.createFilePath(parentPath, component);
                    SVNFileType pathType = SVNFileType.getType(parentPath);
                    if (pathType != SVNFileType.NONE && pathType != SVNFileType.DIRECTORY) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT, "''{0}'' prevents creating of '''{1}''", parentPath, path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    SVNFileUtil.ensureDirectoryExists(parentPath);
                    this.addFromDisk(parentPath, true);
                }
            }
            SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(path));
            try {
                if (kind == SVNNodeKind.DIR) {
                    this.addDirectory(path, ((SvnScheduleForAddition)this.getOperation()).getDepth());
                    break block11;
                }
                if (kind == SVNNodeKind.FILE) {
                    this.addFile(path);
                    break block11;
                }
                if (kind == SVNNodeKind.NONE) {
                    SVNErrorMessage err;
                    SVNWCContext.ConflictInfo conflictInfo = null;
                    try {
                        conflictInfo = this.getWcContext().getConflicted(path, false, false, true);
                    }
                    catch (SVNException e) {
                        // empty catch block
                    }
                    if (conflictInfo != null && conflictInfo.treeConflicted) {
                        err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "''{0}'' is an existing item in conflict; please mark the conflict as resolved before adding a new item here", (Object)path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    break block11;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for path ''{0}''", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            catch (SVNException e) {
                if (((SvnScheduleForAddition)this.getOperation()).isForce() && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block11;
                throw e;
            }
        }
    }

    private void addFile(File path) throws SVNException {
        boolean special = SVNFileType.getType(path) == SVNFileType.SYMLINK;
        SVNProperties properties = null;
        String mimeType = null;
        if (!special) {
            Map autoProps = SVNPropertiesManager.computeAutoProperties(((SvnScheduleForAddition)this.getOperation()).getOptions(), path, null);
            properties = SVNProperties.wrap(autoProps);
            mimeType = properties.getStringValue("svn:mime-type");
        } else {
            properties = new SVNProperties();
            properties.put("svn:special", "*");
        }
        this.addFromDisk(path, false);
        if (properties != null) {
            for (String propertyName : properties.nameSet()) {
                SVNPropertyValue value = properties.getSVNPropertyValue(propertyName);
                if (value == null) continue;
                try {
                    SvnNgPropertiesManager.setProperty(this.getWcContext(), path, propertyName, value, SVNDepth.EMPTY, false, null, null);
                }
                catch (SVNException e) {
                    if ("svn:eol-style".equals(propertyName) && e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && e.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                        ISVNAddParameters addParameters = ((SvnScheduleForAddition)this.getOperation()).getAddParameters() == null ? SVNWCClient.DEFAULT_ADD_PARAMETERS : ((SvnScheduleForAddition)this.getOperation()).getAddParameters();
                        ISVNAddParameters.Action action = addParameters.onInconsistentEOLs(path);
                        if (action == ISVNAddParameters.REPORT_ERROR) {
                            this.doRevert(path);
                            throw e;
                        }
                        if (action == ISVNAddParameters.ADD_AS_IS) {
                            SvnNgPropertiesManager.setProperty(this.getWcContext(), path, propertyName, null, SVNDepth.EMPTY, false, null, null);
                            continue;
                        }
                        if (action != ISVNAddParameters.ADD_AS_BINARY) continue;
                        SvnNgPropertiesManager.setProperty(this.getWcContext(), path, propertyName, null, SVNDepth.EMPTY, false, null, null);
                        mimeType = "application/octet-stream";
                        continue;
                    }
                    this.doRevert(path);
                    throw e;
                }
            }
            if (mimeType != null) {
                SvnNgPropertiesManager.setProperty(this.getWcContext(), path, "svn:mime-type", SVNPropertyValue.create(mimeType), SVNDepth.EMPTY, false, null, null);
            } else {
                mimeType = properties.getStringValue("svn:mime-type");
            }
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(path, SVNNodeKind.FILE, mimeType, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRevert(File path) {
        try {
            try {
                this.getWcContext().getDb().opRevert(path, SVNDepth.EMPTY);
                SvnNgRevert.restore(this.getWcContext(), path, SVNDepth.EMPTY, false, null);
            }
            finally {
                SvnWcDbRevert.dropRevertList(this.getWcContext(), path);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    private void addDirectory(File path, SVNDepth depth) throws SVNException {
        block9: {
            this.checkCancelled();
            try {
                this.addFromDisk(path, true);
            }
            catch (SVNException e) {
                if (((SvnScheduleForAddition)this.getOperation()).isForce() && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block9;
                throw e;
            }
        }
        if (depth.compareTo(SVNDepth.EMPTY) <= 0) {
            return;
        }
        Collection<String> ignorePatterns = null;
        if (!((SvnScheduleForAddition)this.getOperation()).isIncludeIgnored()) {
            ignorePatterns = SvnNgPropertiesManager.getEffectiveIgnores(this.getWcContext(), path, null);
        }
        File[] children = SVNFileListUtil.listFiles(path);
        for (int i = 0; children != null && i < children.length; ++i) {
            this.checkCancelled();
            String name = children[i].getName();
            if (name.equals(SVNFileUtil.getAdminDirectoryName()) || ignorePatterns != null && SvnNgPropertiesManager.isIgnored(name, ignorePatterns)) continue;
            SVNNodeKind childKind = SVNFileType.getNodeKind(SVNFileType.getType(children[i]));
            if (childKind == SVNNodeKind.DIR && depth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                SVNDepth depthBelow = depth;
                if (depth == SVNDepth.IMMEDIATES) {
                    depthBelow = SVNDepth.EMPTY;
                }
                this.addDirectory(children[i], depthBelow);
                continue;
            }
            if (childKind != SVNNodeKind.FILE || depth.compareTo(SVNDepth.FILES) < 0) continue;
            try {
                this.addFile(children[i]);
                continue;
            }
            catch (SVNException e) {
                if (((SvnScheduleForAddition)this.getOperation()).isForce() && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) continue;
                throw e;
            }
        }
    }

    private void addFromDisk(File path, boolean fireEvent) throws SVNException {
        SVNNodeKind kind = this.checkCanAddNode(path);
        this.checkCanAddtoParent(path);
        if (kind == SVNNodeKind.FILE) {
            this.getWcContext().getDb().opAddFile(path, null);
        } else {
            this.getWcContext().getDb().opAddDirectory(path, null);
        }
        if (fireEvent) {
            this.handleEvent(SVNEventFactory.createSVNEvent(path, kind, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L));
        }
    }

    private void checkCanAddtoParent(File path) throws SVNException {
        File parentPath = SVNFileUtil.getParentFile(path);
        this.getWcContext().writeCheck(parentPath);
        try {
            SVNErrorMessage err;
            Structure<StructureFields.NodeInfo> info = this.getWcContext().getDb().readInfo(parentPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
            ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.NodeInfo.kind));
            if (status == ISVNWCDb.SVNWCDbStatus.NotPresent || status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s node while trying to add ''{0}''", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to a parent directory scheduled for deletion", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t schedule an addition of ''{0}'' below a not-directory node", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            info.release();
        }
        catch (SVNException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s node while trying to add ''{0}''", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private SVNNodeKind checkCanAddNode(File path) throws SVNException {
        SVNFileType pathType;
        block10: {
            SVNErrorMessage err;
            String name = SVNFileUtil.getFileName(path);
            if (SVNFileUtil.getAdminDirectoryName().equals(name)) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_FORBIDDEN, "Can''t create an entry with a reserved name while trying to add ''{0}''", (Object)path);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if ((pathType = SVNFileType.getType(path)) == SVNFileType.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (pathType == SVNFileType.UNKNOWN) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for ''{0}''", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            try {
                SVNErrorMessage err3;
                Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(path, StructureFields.NodeInfo.status, StructureFields.NodeInfo.conflicted);
                if (nodeInfo.is(StructureFields.NodeInfo.conflicted)) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "''{0}'' is an existing item in conflict; please mark the conflict as resolved before adding a new item here", (Object)path);
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
                switch ((ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status))) {
                    case NotPresent: {
                        break;
                    }
                    case Deleted: {
                        break;
                    }
                    default: {
                        err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)path);
                        SVNErrorManager.error(err3, SVNLogType.WC);
                    }
                }
                nodeInfo.release();
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block10;
                throw e;
            }
        }
        return SVNFileType.getNodeKind(pathType);
    }

    private File findExistingParent(File parentPath) throws SVNException {
        SVNErrorMessage err;
        SVNNodeKind kind = this.getWcContext().readKind(parentPath, false);
        if (kind == SVNNodeKind.DIR && !this.getWcContext().isNodeStatusDeleted(parentPath)) {
            return parentPath;
        }
        if (parentPath.getParentFile() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(SVNFileUtil.getFileName(parentPath))) {
            err = SVNErrorMessage.create(SVNErrorCode.RESERVED_FILENAME_SPECIFIED, "''{0}'' ends in a reserved name", (Object)parentPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        parentPath = SVNFileUtil.getParentFile(parentPath);
        this.checkCancelled();
        return this.findExistingParent(parentPath);
    }
}

