/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffCallback
implements ISvnDiffCallback {
    private ISVNDiffGenerator myGenerator;
    private OutputStream myResult;
    private long myRevision2;
    private long myRevision1;

    public SvnDiffCallback(ISVNDiffGenerator generator, long rev1, long rev2, OutputStream result) {
        this.myGenerator = generator;
        this.myResult = result;
        this.myRevision1 = rev1;
        this.myRevision2 = rev2;
    }

    public void fileOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
    }

    public void fileChanged(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        if (leftFile != null) {
            this.displayFileDiff(path, leftFile, rightFile, rev1, rev2, mimeType1, mimeType2, originalProperties, propChanges);
        }
        if (propChanges != null && !propChanges.isEmpty()) {
            this.propertiesChanged(path, originalProperties, propChanges);
        }
    }

    public void fileAdded(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, File copyFromPath, long copyFromRevision, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        if (!this.myGenerator.isDiffAdded()) {
            return;
        }
        if (rightFile != null) {
            this.displayFileDiff(path, null, rightFile, rev1, rev2, mimeType1, mimeType2, originalProperties, propChanges);
        }
        if (propChanges != null && !propChanges.isEmpty()) {
            this.propertiesChanged(path, originalProperties, propChanges);
        }
    }

    public void fileDeleted(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, String mimeType1, String mimeType2, SVNProperties originalProperties) throws SVNException {
        if (!this.myGenerator.isDiffDeleted()) {
            return;
        }
        if (leftFile != null) {
            this.displayFileDiff(path, leftFile, rightFile, this.myRevision1, this.myRevision2, mimeType1, mimeType2, originalProperties, null);
        }
    }

    public void dirDeleted(SvnDiffCallbackResult result, File path) throws SVNException {
        this.myGenerator.displayDeletedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(this.myRevision2));
    }

    public void dirOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
    }

    public void dirAdded(SvnDiffCallbackResult result, File path, long revision, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myGenerator.displayAddedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(revision));
    }

    public void dirPropsChanged(SvnDiffCallbackResult result, File path, boolean isAdded, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        originalProperties = originalProperties == null ? new SVNProperties() : originalProperties;
        SVNProperties regularDiff = SvnDiffCallback.getRegularProperties(propChanges = propChanges == null ? new SVNProperties() : propChanges);
        if (regularDiff == null || regularDiff.isEmpty()) {
            return;
        }
        this.myGenerator.displayPropDiff(this.getDisplayPath(path), originalProperties, regularDiff, this.myResult);
    }

    public void dirClosed(SvnDiffCallbackResult result, File path, boolean isAdded) throws SVNException {
    }

    protected String getDisplayPath(File path) {
        return path.getPath().replace(File.separatorChar, '/');
    }

    private String getRevision(long revision) {
        if (revision >= 0L) {
            return "(revision " + revision + ")";
        }
        return "(working copy)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFileDiff(File path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff) throws SVNException {
        boolean resetEncoding = false;
        OutputStream result = this.myResult;
        String encoding = this.defineEncoding(originalProperties, diff);
        if (encoding != null) {
            this.myGenerator.setEncoding(encoding);
            resetEncoding = true;
        } else {
            String conversionEncoding = this.defineConversionEncoding(originalProperties, diff);
            if (conversionEncoding != null) {
                resetEncoding = this.adjustDiffGenerator("UTF-8");
                result = new SVNCharsetOutputStream(result, Charset.forName("UTF-8"), Charset.forName(conversionEncoding), CodingErrorAction.IGNORE, CodingErrorAction.IGNORE);
            }
        }
        try {
            this.myGenerator.displayFileDiff(this.getDisplayPath(path), file1, file2, this.getRevision(revision1), this.getRevision(revision2), mimeType1, mimeType2, result);
        }
        finally {
            if (resetEncoding) {
                this.myGenerator.setEncoding(null);
                this.myGenerator.setEOL(null);
            }
            if (result instanceof SVNCharsetOutputStream) {
                try {
                    result.flush();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), e, SVNLogType.WC);
                }
            }
        }
    }

    private String defineEncoding(SVNProperties properties, SVNProperties diff) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultGenerator.hasEncoding()) {
                return null;
            }
            String originalEncoding = this.getCharsetByMimeType(properties, defaultGenerator);
            if (originalEncoding != null) {
                return originalEncoding;
            }
            String changedEncoding = this.getCharsetByMimeType(diff, defaultGenerator);
            if (changedEncoding != null) {
                return changedEncoding;
            }
        }
        return null;
    }

    private String getCharsetByMimeType(SVNProperties properties, DefaultSVNDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String mimeType = properties.getStringValue("svn:mime-type");
        String charset = SVNPropertiesManager.determineEncodingByMimeType(mimeType);
        return this.getCharset(charset, generator, false);
    }

    private String getCharset(SVNProperties properties, DefaultSVNDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String charset = properties.getStringValue("svnkit:charset");
        return this.getCharset(charset, generator, true);
    }

    private String getCharset(String charset, DefaultSVNDiffGenerator generator, boolean allowNative) {
        if (charset == null) {
            return null;
        }
        if (allowNative && "native".equals(charset)) {
            return generator.getEncoding();
        }
        if (Charset.isSupported(charset)) {
            return charset;
        }
        return null;
    }

    private String defineConversionEncoding(SVNProperties properties, SVNProperties diff) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultGenerator.hasEncoding()) {
                return null;
            }
            String originalCharset = this.getCharset(properties, defaultGenerator);
            if (originalCharset != null) {
                return originalCharset;
            }
            String changedCharset = this.getCharset(diff, defaultGenerator);
            if (changedCharset != null) {
                return changedCharset;
            }
            String globalEncoding = this.getCharset(defaultGenerator.getGlobalEncoding(), defaultGenerator, false);
            if (globalEncoding != null) {
                return globalEncoding;
            }
        }
        return null;
    }

    public void propertiesChanged(File path, SVNProperties originalProperties, SVNProperties diff) throws SVNException {
        originalProperties = originalProperties == null ? new SVNProperties() : originalProperties;
        diff = diff == null ? new SVNProperties() : diff;
        SVNProperties regularDiff = SvnDiffCallback.getRegularProperties(diff);
        if (diff == null || diff.isEmpty()) {
            return;
        }
        this.myGenerator.displayPropDiff(this.getDisplayPath(path), originalProperties, regularDiff, this.myResult);
    }

    private boolean adjustDiffGenerator(String charset) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator generator = (DefaultSVNDiffGenerator)this.myGenerator;
            boolean encodingAdjusted = false;
            if (!generator.hasEncoding()) {
                generator.setEncoding(charset);
                encodingAdjusted = true;
            }
            if (!generator.hasEOL()) {
                byte[] eol;
                String eolString = System.getProperty("line.separator");
                try {
                    eol = eolString.getBytes(charset);
                }
                catch (UnsupportedEncodingException e) {
                    eol = eolString.getBytes();
                }
                generator.setEOL(eol);
            }
            return encodingAdjusted;
        }
        return false;
    }

    private static SVNProperties getRegularProperties(SVNProperties propChanges) {
        if (propChanges == null) {
            return null;
        }
        SVNProperties regularPropertiesChanges = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(propChanges, regularPropertiesChanges, null, null);
        return regularPropertiesChanges;
    }
}

