/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc2.SvnOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRepositoryAccess;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SvnRemoteOperationRunner<V, T extends SvnOperation<V>>
extends SvnOperationRunner<V, T> {
    private SvnRepositoryAccess repositoryAccess;
    private SvnWcGeneration detectedWcGeneration;

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        super.reset(wcGeneration);
        this.repositoryAccess = null;
        this.detectedWcGeneration = wcGeneration;
    }

    @Override
    public boolean isApplicable(T operation, SvnWcGeneration wcGeneration) throws SVNException {
        return ((SvnOperation)operation).hasRemoteTargets() || !this.isRevisionLocalToWc(((SvnOperation)operation).getRevision());
    }

    protected SvnRepositoryAccess getRepositoryAccess() throws SVNException {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = this.getDetectedWcGeneration() == SvnWcGeneration.V16 ? new SvnOldRepositoryAccess((SvnOperation<?>)this.getOperation()) : new SvnNgRepositoryAccess((SvnOperation<?>)this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }

    private SvnWcGeneration getDetectedWcGeneration() {
        return this.detectedWcGeneration;
    }

    protected boolean isRevisionLocalToWc(SVNRevision revision) {
        return revision == SVNRevision.BASE || revision == SVNRevision.WORKING || revision == SVNRevision.COMMITTED;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }
}

