/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWCDbInsertDeleteList
extends SVNSqlJetInsertStatement {
    private SVNSqlJetSelectStatement select;
    private Map<String, Object> insertValues;

    public SVNWCDbInsertDeleteList(SVNSqlJetDb sDb) throws SVNException {
        super(sDb.getTemporaryDb(), SVNWCDbSchema.DELETE_LIST);
        this.select = new SVNSqlJetSelectStatement(sDb, (Enum)SVNWCDbSchema.NODES){
            long previousDepth;
            {
                this.previousDepth = -1L;
            }

            protected Object[] getWhere() throws SVNException {
                return new Object[]{this.getBind(1)};
            }

            protected ISqlJetCursor openCursor() throws SVNException {
                try {
                    return super.openCursor().reverse();
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                    return null;
                }
            }

            protected boolean isFilterPassed() throws SVNException {
                String rowPath;
                long selectOpDepth = (Long)this.getBind(3);
                if (this.previousDepth > selectOpDepth) {
                    return false;
                }
                this.previousDepth = selectOpDepth;
                String presence = this.getColumnString(SVNWCDbSchema.NODES__Fields.presence);
                if ("base-deleted".equals(presence) || "not-present".equals(presence) || "excluded".equals(presence) || "absent".equals(presence)) {
                    return false;
                }
                String selectPath = (String)this.getBind(2);
                if (!("".equals(selectPath) || selectPath.equals(rowPath = this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath)) || rowPath.startsWith(selectPath + "/"))) {
                    return false;
                }
                long rowOpDepth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                if (rowOpDepth < selectOpDepth) {
                    return false;
                }
                return super.isFilterPassed();
            }
        };
    }

    @Override
    protected Map<String, Object> getInsertValues() throws SVNException {
        Map<String, Object> selectedRow = this.select.getRowValues();
        if (this.insertValues == null) {
            this.insertValues = new HashMap<String, Object>();
        }
        this.insertValues.clear();
        this.insertValues.put(SVNWCDbSchema.DELETE_LIST__Fields.local_relpath.toString(), selectedRow.get(SVNWCDbSchema.NODES__Fields.local_relpath.toString()));
        return this.insertValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long exec() throws SVNException {
        this.select.bindf("isi", this.getBind(1), this.getBind(2), this.getBind(3));
        try {
            int n = 0;
            while (this.select.next()) {
                super.exec();
                ++n;
            }
            long l = n;
            return l;
        }
        finally {
            this.select.reset();
        }
    }
}

