/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertActualNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnRevertNodesTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbRevert
extends SvnWcDbShared {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(SVNWCDbRoot root, File localRelPath) throws SVNException {
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        SvnRevertActualNodesTrigger actualNodesTableTrigger = new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        stmt.bindf("is", root.getWcId(), localRelPath);
        if (!stmt.next()) {
            SvnWcDbStatementUtil.reset(stmt);
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE);
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            long affectedRows = stmt.done();
            if (affectedRows > 0L) {
                stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
                try {
                    stmt.bindf("is", root.getWcId(), localRelPath);
                    if (stmt.next()) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                finally {
                    SvnWcDbStatementUtil.reset(stmt);
                }
                return;
            }
            SvnWcDbRevert.nodeNotFound(root, localRelPath);
        }
        long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
        SvnWcDbStatementUtil.reset(stmt);
        if (opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err;
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_GE_OP_DEPTH_CHILDREN);
            stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
            boolean haveRow = stmt.next();
            SvnWcDbStatementUtil.reset(stmt);
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_CHILDREN_INFO);
            stmt.bindf("is", root.getWcId(), localRelPath);
            haveRow = stmt.next();
            SvnWcDbStatementUtil.reset(stmt);
            if (haveRow) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting children", (Object)root.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            stmt = sdb.getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_INCREASE_RECURSIVE);
            ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
            stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
            stmt.done();
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WORKING_NODE);
            ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST);
        ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
        stmt.bindf("is", root.getWcId(), localRelPath);
        long affectedRows = stmt.done();
        if (affectedRows == 0L) {
            stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST);
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.done();
        }
    }

    public static void revertRecursive(SVNWCDbRoot root, File localRelPath) throws SVNException {
        SVNSqlJetDb sdb = root.getSDb();
        SvnRevertNodesTrigger nodesTableTrigger = new SvnRevertNodesTrigger(sdb);
        SvnRevertActualNodesTrigger actualNodesTableTrigger = new SvnRevertActualNodesTrigger(sdb);
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        stmt.bindf("is", root.getWcId(), localRelPath);
        if (!stmt.next()) {
            SvnWcDbStatementUtil.reset(stmt);
            stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_RECURSIVE);
            ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
            stmt.bindf("is", root.getWcId(), localRelPath);
            long affectedRows = stmt.done();
            if (affectedRows > 0L) {
                return;
            }
            SvnWcDbRevert.nodeNotFound(root, localRelPath);
        }
        long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
        SvnWcDbStatementUtil.reset(stmt);
        if (opDepth > 0L && opDepth != (long)SVNWCUtils.relpathDepth(localRelPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH, "Can''t revert ''{0}'' without reverting parent", (Object)root.getAbsPath(localRelPath));
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (opDepth == 0L) {
            opDepth = 1L;
        }
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_NODES_RECURSIVE);
        ((SVNSqlJetTableStatement)stmt).addTrigger(nodesTableTrigger);
        stmt.bindf("isi", root.getWcId(), localRelPath, opDepth);
        stmt.done();
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
        stmt.bindf("is", root.getWcId(), localRelPath);
        stmt.done();
        stmt = sdb.getStatement(SVNWCDbStatements.CLEAR_ACTUAL_NODE_LEAVING_CHANGELIST_RECURSIVE);
        ((SVNSqlJetTableStatement)stmt).addTrigger(actualNodesTableTrigger);
        stmt.bindf("is", root.getWcId(), localRelPath);
        stmt.done();
        stmt = sdb.getStatement(SVNWCDbStatements.DELETE_WC_LOCK_ORPHAN_RECURSIVE);
        stmt.bindf("is", root.getWcId(), localRelPath);
        stmt.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<File, ISVNWCDb.SVNWCDbKind> readRevertCopiedChildren(SVNWCContext context, File localAbsPath) throws SVNException {
        TreeMap<File, ISVNWCDb.SVNWCDbKind> result = new TreeMap<File, ISVNWCDb.SVNWCDbKind>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String path1 = o1.getAbsolutePath();
                String path2 = o2.getAbsolutePath();
                return -SVNPathUtil.PATH_COMPARATOR.compare(path1, path2);
            }
        });
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        root.getSDb().getTemporaryDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
        try {
            SVNSqlJetStatement stmt = root.getSDb().getTemporaryDb().getStatement(SVNWCDbStatements.SELECT_REVERT_LIST_COPIED_CHILDREN);
            stmt.bindf("si", localRelpath, SVNWCUtils.relpathDepth(localRelpath));
            while (stmt.next()) {
                String relpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                File childFile = SVNFileUtil.createFilePath(root.getAbsPath(), relpath);
                result.put(childFile, SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.REVERT_LIST__Fields.kind));
            }
            SvnWcDbStatementUtil.reset(stmt);
        }
        finally {
            root.getSDb().getTemporaryDb().commit();
        }
        return result;
    }

    public static Structure<RevertInfo> readRevertInfo(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        root.getSDb().getTemporaryDb().beginTransaction(SqlJetTransactionMode.WRITE);
        Object result = Structure.obtain(RevertInfo.class);
        ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Unknown);
        ((Structure)result).set((RevertInfo)RevertInfo.reverted, false);
        ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, false);
        try {
            SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

                protected ISqlJetCursor openCursor() throws SVNException {
                    try {
                        return super.openCursor().reverse();
                    }
                    catch (SqlJetException e) {
                        SVNSqlJetDb.createSqlJetError(e);
                        return null;
                    }
                }
            };
            stmt.bindf("s", localRelpath);
            boolean haveRow = ((SVNSqlJetStatement)stmt).next();
            if (haveRow) {
                boolean isActual = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.REVERT_LIST__Fields.actual);
                boolean anotherRow = false;
                if (isActual) {
                    String path;
                    ((Structure)result).set((RevertInfo)RevertInfo.reverted, !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.notify));
                    if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_old)) {
                        path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_old);
                        ((Structure)result).set((RevertInfo)RevertInfo.conflictOld, SVNFileUtil.createFilePath(root.getAbsPath(), path));
                    }
                    if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_new)) {
                        path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_new);
                        ((Structure)result).set((RevertInfo)RevertInfo.conflictNew, SVNFileUtil.createFilePath(root.getAbsPath(), path));
                    }
                    if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_working)) {
                        path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.conflict_working);
                        ((Structure)result).set((RevertInfo)RevertInfo.conflictWorking, SVNFileUtil.createFilePath(root.getAbsPath(), path));
                    }
                    if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.prop_reject)) {
                        path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.REVERT_LIST__Fields.prop_reject);
                        ((Structure)result).set((RevertInfo)RevertInfo.propReject, SVNFileUtil.createFilePath(root.getAbsPath(), path));
                    }
                    anotherRow = ((SVNSqlJetStatement)stmt).next();
                }
                if (!isActual || anotherRow) {
                    ((Structure)result).set((RevertInfo)RevertInfo.reverted, true);
                    if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.REVERT_LIST__Fields.repos_id)) {
                        long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.REVERT_LIST__Fields.op_depth);
                        ((Structure)result).set((RevertInfo)RevertInfo.copiedHere, opDepth == (long)SVNWCUtils.relpathDepth(localRelpath));
                    }
                    ((Structure)result).set((RevertInfo)RevertInfo.kind, (Object)SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.REVERT_LIST__Fields.kind));
                }
            }
            SvnWcDbStatementUtil.reset(stmt);
            if (haveRow) {
                stmt = new SVNSqlJetDeleteStatement(root.getSDb().getTemporaryDb(), SVNWCDbSchema.REVERT_LIST);
                stmt.bindf("s", localRelpath);
                stmt.done();
            }
        }
        catch (SVNException e) {
            root.getSDb().getTemporaryDb().rollback();
            throw e;
        }
        finally {
            root.getSDb().getTemporaryDb().commit();
        }
        return result;
    }

    public static void dropRevertList(SVNWCContext context, File localAbsPath) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SVNWCDbCreateSchema stmt = new SVNWCDbCreateSchema(root.getSDb(), SVNWCDbCreateSchema.DROP_REVERT_LIST, -1);
        stmt.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRevert(SVNWCContext context, File localAbsPath, ISVNEventHandler eventHandler) throws SVNException {
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

            protected boolean isFilterPassed() throws SVNException {
                String rowPath = this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                String selectPath = (String)this.getBind(1);
                if (selectPath.equals(rowPath) || "".equals(selectPath) || rowPath.startsWith(selectPath + "/")) {
                    return !this.isColumnNull(SVNWCDbSchema.REVERT_LIST__Fields.notify) || this.getColumnLong(SVNWCDbSchema.REVERT_LIST__Fields.actual) == 0L;
                }
                return false;
            }

            protected Object[] getWhere() throws SVNException {
                return new Object[0];
            }
        };
        stmt.bindf("s", localRelpath);
        try {
            if (eventHandler != null) {
                File previousPath = null;
                while (((SVNSqlJetStatement)stmt).next()) {
                    File notifyRelPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                    if (previousPath != null && notifyRelPath.equals(previousPath)) continue;
                    previousPath = notifyRelPath;
                    File notifyAbsPath = SVNFileUtil.createFilePath(root.getAbsPath(), notifyRelPath);
                    eventHandler.handleEvent(SVNEventFactory.createSVNEvent(notifyAbsPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
                }
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        stmt = new SVNSqlJetDeleteStatement(root.getSDb().getTemporaryDb(), (Enum)SVNWCDbSchema.REVERT_LIST){

            protected Object[] getWhere() throws SVNException {
                return new Object[0];
            }

            protected boolean isFilterPassed() throws SVNException {
                String selectPath = (String)this.getBind(1);
                if ("".equals(selectPath)) {
                    return true;
                }
                String rowPath = this.getColumnString(SVNWCDbSchema.REVERT_LIST__Fields.local_relpath);
                return rowPath.equals(selectPath) || rowPath.startsWith(selectPath + "/");
            }
        };
        stmt.bindf("s", localRelpath);
        stmt.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RevertInfo {
        reverted,
        conflictOld,
        conflictNew,
        conflictWorking,
        propReject,
        copiedHere,
        kind;

    }
}

