/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbPristines {
    private static final String PRISTINE_STORAGE_EXT = ".svn-base";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupPristine(SVNWCDbRoot root, File localAbsPath) throws SVNException {
        SVNSqlJetStatement selectList = root.getSDb().getStatement(SVNWCDbStatements.SELECT_UNREFERENCED_PRISTINES);
        try {
            while (selectList.next()) {
                SvnChecksum sha1_checksum = SvnChecksum.fromString(selectList.getColumnString(SVNWCDbSchema.PRISTINE__Fields.checksum));
                SvnWcDbPristines.removePristineIfUnreferenced(root, localAbsPath, sha1_checksum);
            }
        }
        finally {
            selectList.reset();
        }
    }

    private static void removePristineIfUnreferenced(SVNWCDbRoot root, File localAbsPath, SvnChecksum sha1_checksum) throws SVNException {
        RemoveUnreferencedPristine rup = new RemoveUnreferencedPristine();
        rup.sha1_checksum = sha1_checksum;
        rup.pristineAbsPath = SvnWcDbPristines.getPristineFileName(root, sha1_checksum, false);
        rup.root = root;
        root.getSDb().runTransaction(rup);
    }

    public static File getPristineTempDir(SVNWCDbRoot root, File wcRootAbsPath) throws SVNException {
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(root.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "");
    }

    public static File getPristineFuturePath(SVNWCDbRoot root, SvnChecksum sha1Checksum) {
        return SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
    }

    public static File getPristineFileName(SVNWCDbRoot root, SvnChecksum sha1Checksum, boolean createSubdir) {
        assert (root != null);
        assert (sha1Checksum != null);
        assert (sha1Checksum.getKind() == SvnChecksum.Kind.sha1);
        File base_dir_abspath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(root.getAbsPath(), SVNFileUtil.getAdminDirectoryName()), "pristine");
        String hexdigest = sha1Checksum.getDigest();
        assert (hexdigest != null);
        String subdir = hexdigest.substring(0, 2);
        if (createSubdir) {
            File subdirAbspath = SVNFileUtil.createFilePath(base_dir_abspath, subdir);
            subdirAbspath.mkdirs();
        }
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(base_dir_abspath, subdir), hexdigest + PRISTINE_STORAGE_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPristine(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        File pristineAbspath;
        SVNNodeKind kindOnDisk;
        boolean haveRow = false;
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_SHA1_CHECKSUM);
        stmt.bindf("s", sha1Checksum);
        try {
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow && (kindOnDisk = SVNFileType.getNodeKind(SVNFileType.getType(pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false)))) != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with checksum ''{0}'' was found in the DB but not on disk", (Object)sha1Checksum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return haveRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SvnChecksum getPristineSHA1(SVNWCDbRoot root, SvnChecksum md5Checksum) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_PRISTINE_MD5_CHECKSUM);
        try {
            stmt.bindChecksum(1, md5Checksum);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "The pristine text with MD5 checksum ''{0}'' not found", (Object)md5Checksum.toString());
                SVNErrorManager.error(err, SVNLogType.WC);
                SvnChecksum svnChecksum = null;
                return svnChecksum;
            }
            SvnChecksum sha1_checksum = SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.PRISTINE__Fields.checksum);
            assert (sha1_checksum.getKind() == SvnChecksum.Kind.sha1);
            SvnChecksum svnChecksum = sha1_checksum;
            return svnChecksum;
        }
        finally {
            stmt.reset();
        }
    }

    public static File getPristinePath(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        boolean present = SvnWcDbPristines.checkPristine(root, sha1Checksum);
        if (!present) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_DB_ERROR, "Pristine text not found");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePristine(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        boolean haveRow;
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.LOOK_FOR_WORK);
        try {
            haveRow = stmt.next();
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            return;
        }
        SvnWcDbPristines.pristineRemove(root, sha1Checksum);
    }

    private static void pristineRemove(SVNWCDbRoot root, SvnChecksum sha1Checksum) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.DELETE_PRISTINE);
        stmt.bindChecksum(1, sha1Checksum);
        if (stmt.done() != 0L) {
            File pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, true);
            SVNFileUtil.deleteFile(pristineAbspath);
        }
    }

    public static void installPristine(SVNWCDbRoot root, File tempfileAbspath, SvnChecksum sha1Checksum, SvnChecksum md5Checksum) throws SVNException {
        File pristineAbspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, true);
        SVNNodeKind kind = SVNFileType.getNodeKind(SVNFileType.getType(pristineAbspath));
        if (kind == SVNNodeKind.FILE) {
            SVNFileUtil.deleteFile(tempfileAbspath);
            return;
        }
        SVNFileUtil.rename(tempfileAbspath, pristineAbspath);
        long size = pristineAbspath.length();
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.INSERT_PRISTINE);
        stmt.bindChecksum(1, sha1Checksum);
        stmt.bindChecksum(2, md5Checksum);
        stmt.bindLong(3, size);
        stmt.done();
    }

    public static InputStream readPristine(SVNWCDbRoot root, File wcRootAbsPath, SvnChecksum sha1Checksum) throws SVNException {
        File pristine_abspath = SvnWcDbPristines.getPristineFileName(root, sha1Checksum, false);
        return SVNFileUtil.openFileForReading(pristine_abspath);
    }

    private static class RemoveUnreferencedPristine
    implements SVNSqlJetTransaction {
        public SvnChecksum sha1_checksum;
        public File pristineAbsPath;
        SVNWCDbRoot root;

        private RemoveUnreferencedPristine() {
        }

        public void transaction(SVNSqlJetDb db) throws SqlJetException, SVNException {
            SVNSqlJetStatement stmt = db.getStatement(SVNWCDbStatements.DELETE_PRISTINE_IF_UNREFERENCED);
            stmt.bindf("s", this.sha1_checksum);
            Long affectedRows = stmt.done();
            if (affectedRows > 0L) {
                this.pristineRemoveFile(true);
            }
        }

        private void pristineRemoveFile(boolean ignoreEnoent) throws SVNException {
            block3: {
                if (SVNFileUtil.isWindows) {
                    File temDirAbsPath = SvnWcDbPristines.getPristineTempDir(this.root, this.root.getAbsPath());
                    File tempAbsPath = SVNFileUtil.createUniqueFile(temDirAbsPath, "pristine", ".tmp", false);
                    try {
                        SVNFileUtil.rename(this.pristineAbsPath, tempAbsPath);
                        this.pristineAbsPath = tempAbsPath;
                    }
                    catch (SVNException e) {
                        if (ignoreEnoent && SVNFileType.getType(tempAbsPath) == SVNFileType.NONE) break block3;
                        throw e;
                    }
                }
            }
            SVNFileUtil.deleteFile(this.pristineAbsPath);
        }
    }
}

