/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure<T extends Enum<T>> {
    private static final StructuresPool globalPool = new StructuresPool();
    private static final Object LONG_MARKER = Long.TYPE;
    private static final Object BOOLEAN_MARKER = Boolean.TYPE;
    private Class<?> enumClass;
    private long requestedFields;
    private Object[] nonPrimitiveValues;
    private long[] longValues;
    private T[] copySource;

    public static <X extends Structure<T>, T extends Enum<T>> X obtain(Class<T> e, Enum<T> ... fields) {
        assert (e != null && e.isEnum());
        return (X)globalPool.obtain(e, fields);
    }

    public static <X extends Structure<T>, T extends Enum<T>> X obtain(Class<T> e) {
        assert (e != null && e.isEnum());
        return (X)globalPool.obtain(e, new Enum[0]);
    }

    private static void release(Structure<?> e) {
        if (e != null) {
            globalPool.release(e);
        }
    }

    private Structure(Class<T> enumClass, Enum<T> ... fields) {
        this.init(enumClass, fields);
    }

    public long lng(T e) {
        assert (e.getClass() == this.enumClass);
        this.assertSafeType(e, Long.TYPE);
        if (this.nonPrimitiveValues[((Enum)e).ordinal()] == LONG_MARKER) {
            return this.longValues[((Enum)e).ordinal()];
        }
        assert (false);
        return 0L;
    }

    public String text(T e) {
        assert (e.getClass() == this.enumClass);
        this.assertSafeType(e, String.class);
        return (String)this.nonPrimitiveValues[((Enum)e).ordinal()];
    }

    public boolean is(T e) {
        assert (e.getClass() == this.enumClass);
        this.assertSafeType(e, Boolean.TYPE);
        if (this.nonPrimitiveValues[((Enum)e).ordinal()] == BOOLEAN_MARKER) {
            return this.longValues[((Enum)e).ordinal()] != 0L;
        }
        assert (false);
        return false;
    }

    public boolean hasValue(Enum<?> e) {
        assert (e.getClass() == this.enumClass);
        return this.nonPrimitiveValues[e.ordinal()] != null;
    }

    public <X> X get(T e) {
        Object value;
        assert (e.getClass() == this.enumClass);
        Class<?> expectedType = null;
        if (e instanceof TypeSafety) {
            expectedType = ((TypeSafety)e).getType();
        }
        if ((value = this.nonPrimitiveValues[((Enum)e).ordinal()]) == null) {
            return null;
        }
        assert (value != LONG_MARKER && value != BOOLEAN_MARKER);
        if (expectedType != null) assert (expectedType.isAssignableFrom(value.getClass()));
        return (X)value;
    }

    public void set(T x, Object v) {
        if (v == null) {
            this.unset(x);
            return;
        }
        if (x instanceof TypeSafety) assert (v == LONG_MARKER || v == BOOLEAN_MARKER || v == null || ((TypeSafety)x).getType().isAssignableFrom(v.getClass()));
        this.nonPrimitiveValues[((Enum)x).ordinal()] = v;
    }

    public void unset(T x) {
        if ((this.requestedFields & (long)(1 << ((Enum)x).ordinal())) == 0L) {
            return;
        }
        this.nonPrimitiveValues[((Enum)x).ordinal()] = null;
        this.longValues[((Enum)x).ordinal()] = 0L;
    }

    public void set(T x, long v) {
        if (x instanceof TypeSafety) assert (((TypeSafety)x).getType() == Long.TYPE);
        this.longValues[((Enum)x).ordinal()] = v;
        this.set(x, LONG_MARKER);
    }

    public void set(T x, boolean v) {
        if (x instanceof TypeSafety) assert (((TypeSafety)x).getType() == Boolean.TYPE);
        this.longValues[((Enum)x).ordinal()] = v ? 1L : 0L;
        this.set(x, BOOLEAN_MARKER);
    }

    public boolean hasField(Enum<T> field) {
        return (this.requestedFields & (long)(1 << field.ordinal())) != 0L;
    }

    public void clear() {
        this.copySource = null;
        Arrays.fill(this.nonPrimitiveValues, null);
        Arrays.fill(this.longValues, 0L);
    }

    public void release() {
        Structure.release(this);
    }

    public Structure<T> from(T ... fields) {
        assert (this.copySource == null);
        assert (fields != null);
        this.copySource = fields;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X extends Enum<X>> void into(Structure<X> target, X ... fields) {
        assert (this.copySource != null);
        assert (fields != null);
        assert (fields.length == this.copySource.length);
        assert (target != null);
        try {
            for (int i = 0; i < this.copySource.length; ++i) {
                int valueIndex = ((Enum)this.copySource[i]).ordinal();
                Object v = this.nonPrimitiveValues[((Enum)this.copySource[i]).ordinal()];
                if (v == BOOLEAN_MARKER) {
                    target.set(fields[i], this.longValues[valueIndex] != 0L);
                    continue;
                }
                if (v == LONG_MARKER) {
                    target.set(fields[i], this.longValues[valueIndex]);
                    continue;
                }
                if (v == null) {
                    target.unset(fields[i]);
                    continue;
                }
                target.set(fields[i], v);
            }
        }
        finally {
            this.copySource = null;
        }
    }

    public int hashCode() {
        int i;
        int code = this.enumClass.hashCode();
        for (i = 0; i < this.nonPrimitiveValues.length; ++i) {
            if (this.nonPrimitiveValues == null) continue;
            code += 13 * this.nonPrimitiveValues[i].hashCode();
        }
        for (i = 0; i < this.longValues.length; ++i) {
            code = (int)((long)code + 17L * this.longValues[i]);
        }
        return code;
    }

    public boolean equals(Object e) {
        if (e == null || e.getClass() != Structure.class) {
            return false;
        }
        Structure other = (Structure)e;
        if (other.enumClass == this.enumClass) {
            return Arrays.equals(other.nonPrimitiveValues, this.nonPrimitiveValues) && Arrays.equals(this.longValues, other.longValues);
        }
        return false;
    }

    private void assertSafeType(T e, Class<?> c) {
        if (e instanceof TypeSafety) assert (((TypeSafety)e).getType() == c);
    }

    private void init(Class<?> enumClass, Enum<?> ... fields) {
        this.enumClass = enumClass;
        if (fields != null && fields.length > 0) {
            this.requestedFields = 0L;
            for (Enum<?> field : fields) {
                this.requestedFields |= (long)(1 << field.ordinal());
            }
        } else {
            this.requestedFields = -1L;
        }
        ?[] enumConstants = enumClass.getEnumConstants();
        assert (enumConstants != null);
        this.nonPrimitiveValues = Structure.adjustArraySize(this.nonPrimitiveValues, enumConstants.length);
        this.longValues = Structure.adjustArraySize(this.longValues, enumConstants.length);
        this.clear();
    }

    private static Object[] adjustArraySize(Object[] array, int desiredSize) {
        if (array == null || array.length < desiredSize) {
            return new Object[desiredSize];
        }
        return array;
    }

    private static long[] adjustArraySize(long[] array, int desiredSize) {
        if (array == null || array.length < desiredSize) {
            return new long[desiredSize];
        }
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(this.enumClass.getSimpleName());
        sb.append(">\n");
        for (Object field : this.enumClass.getEnumConstants()) {
            Enum e = (Enum)field;
            Object o = this.nonPrimitiveValues[e.ordinal()];
            if (o == null) continue;
            sb.append(e.name());
            sb.append(" = ");
            if (o == LONG_MARKER) {
                sb.append(Long.toString(this.lng(e)));
            } else if (o == BOOLEAN_MARKER) {
                sb.append(this.is(e));
            } else {
                sb.append(o);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StructuresPool {
        private BlockingQueue<Structure<?>> objectsQueues = new LinkedBlockingQueue(23);

        private StructuresPool() {
        }

        public Structure<?> obtain(Class<?> enumClass, Enum<?> ... fields) {
            Structure t = (Structure)this.objectsQueues.poll();
            if (t == null) {
                t = new Structure((Class)enumClass, fields);
            } else {
                t.init(enumClass, fields);
            }
            return t;
        }

        public void release(Structure<?> t) {
            this.objectsQueues.offer(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeSafety {
        public Class<?> getType();
    }
}

