/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.CramMD5;
import org.tmatesoft.svn.core.internal.io.svn.SVNAuthenticator;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPlainAuthenticator
extends SVNAuthenticator {
    public SVNPlainAuthenticator(SVNConnection connection) throws SVNException {
        super(connection);
    }

    public void authenticate(List mechs, String realm, SVNRepositoryImpl repos) throws SVNException {
        SVNErrorMessage failureReason;
        block25: {
            failureReason = null;
            if (mechs == null || mechs.size() == 0) {
                return;
            }
            ISVNAuthenticationManager authManager = repos.getAuthenticationManager();
            if (authManager != null && authManager.isAuthenticationForced() && mechs.contains("ANONYMOUS") && mechs.contains("CRAM-MD5")) {
                mechs.remove("ANONYMOUS");
            }
            SVNURL location = repos.getLocation();
            SVNAuthentication auth = null;
            if (repos.getExternalUserName() != null && mechs.contains("EXTERNAL")) {
                this.getConnection().write("(w(s))", new Object[]{"EXTERNAL", ""});
                failureReason = this.readAuthResponse();
            } else if (mechs.contains("ANONYMOUS")) {
                this.getConnection().write("(w(s))", new Object[]{"ANONYMOUS", ""});
                failureReason = this.readAuthResponse();
            } else {
                if (mechs.contains("CRAM-MD5")) {
                    block4: while (true) {
                        CramMD5 authenticator = new CramMD5();
                        if (location != null) {
                            realm = "<" + location.getProtocol() + "://" + location.getHost() + ":" + location.getPort() + "> " + realm;
                        }
                        try {
                            if (auth == null && authManager != null) {
                                auth = (SVNPasswordAuthentication)authManager.getFirstAuthentication("svn.simple", realm, location);
                            } else if (authManager != null) {
                                authManager.acknowledgeAuthentication(false, "svn.simple", realm, failureReason, auth);
                                auth = (SVNPasswordAuthentication)authManager.getNextAuthentication("svn.simple", realm, location);
                            }
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CANCELLED) {
                                throw e;
                            }
                            if (this.getLastError() != null) {
                                SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
                            }
                            throw e;
                        }
                        if (auth == null) {
                            failureReason = SVNErrorMessage.create(SVNErrorCode.CANCELLED, "Authentication cancelled");
                            this.setLastError(failureReason);
                            break block25;
                        }
                        if (auth.getUserName() == null || ((SVNPasswordAuthentication)auth).getPassword() == null) {
                            failureReason = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Can''t get password. Authentication is required for ''{0}''", (Object)realm);
                            break block25;
                        }
                        this.getConnection().write("(w())", new Object[]{"CRAM-MD5"});
                        while (true) {
                            authenticator.setUserCredentials((SVNPasswordAuthentication)auth);
                            List items = this.getConnection().readTuple("w(?s)", true);
                            String status = SVNReader.getString(items, 0);
                            if ("success".equals(status)) {
                                authManager.acknowledgeAuthentication(true, "svn.simple", realm, null, auth);
                                return;
                            }
                            if ("failure".equals(status)) {
                                failureReason = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {0}", (Object)SVNReader.getString(items, 1));
                                String message = SVNReader.getString(items, 1);
                                if (message == null) continue block4;
                                this.setLastError(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, message));
                                continue block4;
                            }
                            if (!"step".equals(status)) continue;
                            try {
                                byte[] response = authenticator.buildChallengeResponse(SVNReader.getBytes(items, 1));
                                this.getConnectionOutputStream().write(response);
                                this.getConnectionOutputStream().flush();
                            }
                            catch (IOException e) {
                                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e, SVNLogType.NETWORK);
                            }
                        }
                        break;
                    }
                }
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Cannot negotiate authentication mechanism"), SVNLogType.NETWORK);
            }
        }
        if (failureReason != null) {
            if (this.getLastError() != null) {
                SVNErrorManager.error(this.getLastError(), SVNLogType.NETWORK);
            }
            SVNErrorManager.error(failureReason, SVNLogType.NETWORK);
        }
    }

    protected SVNErrorMessage readAuthResponse() throws SVNException {
        List items = this.getConnection().readTuple("w(?s)", true);
        if ("success".equals(SVNReader.getString(items, 0))) {
            return null;
        }
        if ("failure".equals(SVNReader.getString(items, 0))) {
            return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Authentication error from server: {0}", (Object)SVNReader.getString(items, 1));
        }
        return SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Unexpected server response to authentication");
    }
}

