/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNSqlJetSelectStatement
extends SVNSqlJetTableStatement {
    private String indexName;

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        this(sDb, fromTable.toString());
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, Enum<?> fromTable, Enum<?> indexName) throws SVNException {
        this(sDb, fromTable.toString(), indexName != null ? indexName.toString() : null);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, String fromTable) throws SVNException {
        super(sDb, fromTable);
    }

    public SVNSqlJetSelectStatement(SVNSqlJetDb sDb, String fromTable, String indexName) throws SVNException {
        this(sDb, fromTable);
        this.indexName = indexName;
    }

    @Override
    protected ISqlJetCursor openCursor() throws SVNException {
        try {
            return this.getTable().lookup(this.getIndexName(), this.getWhere());
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }

    protected String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    protected Object[] getWhere() throws SVNException {
        if (this.binds.size() == 0) {
            return null;
        }
        return this.binds.toArray();
    }

    @Override
    public boolean next() throws SVNException {
        boolean next = super.next();
        while (next && !this.isFilterPassed()) {
            next = super.next();
        }
        return next;
    }

    protected boolean isFilterPassed() throws SVNException {
        return true;
    }

    @Override
    public boolean eof() throws SVNException {
        boolean eof = super.eof();
        while (!eof && !this.isFilterPassed()) {
            eof = !super.next();
        }
        return eof;
    }

    public Map<String, Object> getRowValues2() throws SVNException {
        HashMap<String, Object> v = new HashMap<String, Object>();
        try {
            Object[] values = this.getCursor().getRowValues();
            List columns = this.getTable().getDefinition().getColumns();
            for (int i = 0; i < values.length; ++i) {
                String colName = ((ISqlJetColumnDef)columns.get(i)).getName();
                v.put(colName, values[i]);
            }
            return v;
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getRowValues() throws SVNException {
        HashMap<String, Object> v = new HashMap<String, Object>();
        try {
            List columns = this.getTable().getDefinition().getColumns();
            for (ISqlJetColumnDef column : columns) {
                String colName = column.getName();
                SqlJetValueType fieldType = this.getCursor().getFieldType(colName);
                if (fieldType == SqlJetValueType.NULL) {
                    v.put(colName, null);
                    continue;
                }
                if (fieldType == SqlJetValueType.BLOB) {
                    v.put(colName, this.getCursor().getBlobAsArray(colName));
                    continue;
                }
                v.put(colName, this.getCursor().getValue(colName));
            }
            return v;
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return null;
        }
    }
}

