/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.EnumMap;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetBusyHandler;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetTimeoutBusyHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDeleteStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTransaction;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNSqlJetDb {
    private static final ISqlJetBusyHandler DEFAULT_BUSY_HANDLER = new SqlJetTimeoutBusyHandler(10000);
    private SqlJetDb db;
    private EnumMap<SVNWCDbStatements, SVNSqlJetStatement> statements;
    private int openCount = 0;
    private SVNSqlJetDb temporaryDb;

    private SVNSqlJetDb(SqlJetDb db) {
        this.db = db;
        this.statements = new EnumMap(SVNWCDbStatements.class);
    }

    public SqlJetDb getDb() {
        return this.db;
    }

    public int getOpenCount() {
        return this.openCount;
    }

    public void close() throws SVNException {
        if (this.temporaryDb != null) {
            try {
                this.temporaryDb.close();
            }
            catch (SVNException e) {
                // empty catch block
            }
            this.temporaryDb = null;
        }
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (SqlJetException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    public static SVNSqlJetDb open(File sdbAbsPath, Mode mode) throws SVNException {
        if (mode != Mode.RWCreate && !sdbAbsPath.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "File not found ''{0}''", (Object)sdbAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        try {
            SqlJetDb db = SqlJetDb.open((File)sdbAbsPath, (mode != Mode.ReadOnly ? 1 : 0) != 0);
            db.setBusyHandler(DEFAULT_BUSY_HANDLER);
            SVNSqlJetDb sDb = new SVNSqlJetDb(db);
            return sDb;
        }
        catch (SqlJetException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    public SVNSqlJetDb getTemporaryDb() throws SVNException {
        if (this.temporaryDb == null) {
            try {
                this.temporaryDb = new SVNSqlJetDb(this.getDb().getTemporaryDatabase());
            }
            catch (SqlJetException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
                return null;
            }
        }
        return this.temporaryDb;
    }

    public SVNSqlJetStatement getStatement(SVNWCDbStatements statementIndex) throws SVNException {
        assert (statementIndex != null);
        SVNSqlJetStatement stmt = this.statements.get((Object)statementIndex);
        if (stmt == null) {
            stmt = this.prepareStatement(statementIndex);
            this.statements.put(statementIndex, stmt);
        }
        if (stmt != null && stmt.isNeedsReset()) {
            stmt.reset();
        }
        if (stmt instanceof SVNSqlJetInsertStatement || stmt instanceof SVNSqlJetUpdateStatement || stmt instanceof SVNSqlJetDeleteStatement) {
            String targetTableName = ((SVNSqlJetTableStatement)stmt).getTableName();
            if (SVNWCDbSchema.NODES.toString().equals(targetTableName)) {
                SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
                ((SVNSqlJetTableStatement)stmt).addTrigger(trigger);
            }
        }
        return stmt;
    }

    private SVNSqlJetStatement prepareStatement(SVNWCDbStatements statementIndex) throws SVNException {
        Class<? extends SVNSqlJetStatement> statementClass = statementIndex.getStatementClass();
        SVNErrorManager.assertionFailure(statementClass != null, String.format("Statement '%s' not defined", statementIndex.toString()), SVNLogType.WC);
        if (statementClass == null) {
            return null;
        }
        try {
            Constructor<? extends SVNSqlJetStatement> constructor = statementClass.getConstructor(SVNSqlJetDb.class);
            SVNSqlJetStatement stmt = constructor.newInstance(this);
            return stmt;
        }
        catch (Exception e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, e);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    public void execStatement(SVNWCDbStatements statementIndex) throws SVNException {
        SVNSqlJetStatement statement = this.getStatement(statementIndex);
        if (statement != null) {
            statement.exec();
        }
    }

    public static void createSqlJetError(SqlJetException e) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    public void beginTransaction(SqlJetTransactionMode mode) throws SVNException {
        if (mode != null) {
            ++this.openCount;
            if (this.isNeedStartTransaction(mode)) {
                try {
                    this.db.beginTransaction(mode);
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(mode != null, "transaction mode is null", SVNLogType.WC);
        }
    }

    private boolean isNeedStartTransaction(SqlJetTransactionMode mode) {
        if (!this.db.isInTransaction()) {
            return true;
        }
        SqlJetTransactionMode dbMode = this.db.getTransactionMode();
        return mode != dbMode && (SqlJetTransactionMode.WRITE == mode || SqlJetTransactionMode.EXCLUSIVE == mode) && SqlJetTransactionMode.READ_ONLY == dbMode;
    }

    public void commit() throws SVNException {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                try {
                    this.db.commit();
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                }
            }
        } else {
            SVNErrorManager.assertionFailure(this.openCount > 0, "no opened transactions", SVNLogType.WC);
        }
    }

    public void verifyNoWork() {
    }

    public void runTransaction(SVNSqlJetTransaction transaction) throws SVNException {
        this.runTransaction(transaction, SqlJetTransactionMode.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(SVNSqlJetTransaction transaction, SqlJetTransactionMode mode) throws SVNException {
        try {
            this.beginTransaction(mode);
            transaction.transaction(this);
        }
        catch (SqlJetException e) {
            try {
                this.db.rollback();
            }
            catch (SqlJetException e1) {
                e1.initCause((Throwable)e);
                SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e1);
                SVNErrorManager.error(err1, SVNLogType.DEFAULT);
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        finally {
            this.commit();
        }
    }

    public void rollback() throws SVNException {
        try {
            this.db.rollback();
        }
        catch (SqlJetException e1) {
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e1);
            SVNErrorManager.error(err1, SVNLogType.DEFAULT);
        }
    }

    public boolean hasTable(String tableName) throws SVNException {
        try {
            return tableName != null && this.db.getSchema().getTableNames().contains(tableName);
        }
        catch (SqlJetException e) {
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err1, SVNLogType.DEFAULT);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ReadOnly,
        ReadWrite,
        RWCreate;

    }
}

