/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.OS;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String CF_DIB = "CF_DIB";
    private static final int CF_DIBID = 8;

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        ImageData imageData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imageData = (ImageData)object) == null) {
            SWT.error(4);
        }
        int n = imageData.data.length;
        int n2 = imageData.height;
        int n3 = imageData.bytesPerLine;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biSizeImage = n;
        bITMAPINFOHEADER.biWidth = imageData.width;
        bITMAPINFOHEADER.biHeight = n2;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)imageData.depth;
        bITMAPINFOHEADER.biCompression = 0;
        int n4 = 0;
        if (bITMAPINFOHEADER.biBitCount <= 8) {
            n4 += (1 << bITMAPINFOHEADER.biBitCount) * 4;
        }
        byte[] byArray = new byte[BITMAPINFOHEADER.sizeof + n4];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        RGB[] rGBArray = imageData.palette.getRGBs();
        if (rGBArray != null && n4 > 0) {
            int n5 = BITMAPINFOHEADER.sizeof;
            int n6 = 0;
            while (n6 < rGBArray.length) {
                byArray[n5] = (byte)rGBArray[n6].blue;
                byArray[n5 + 1] = (byte)rGBArray[n6].green;
                byArray[n5 + 2] = (byte)rGBArray[n6].red;
                byArray[n5 + 3] = 0;
                n5 += 4;
                ++n6;
            }
        }
        long l = OS.GlobalAlloc(64, BITMAPINFOHEADER.sizeof + n4 + n);
        OS.MoveMemory(l, byArray, byArray.length);
        long l2 = l + (long)BITMAPINFOHEADER.sizeof + (long)n4;
        if (n2 <= 0) {
            OS.MoveMemory(l2, imageData.data, n);
        } else {
            int n7 = 0;
            l2 += (long)(n3 * (n2 - 1));
            byte[] byArray2 = new byte[n3];
            int n8 = 0;
            while (n8 < n2) {
                System.arraycopy(imageData.data, n7, byArray2, 0, n3);
                OS.MoveMemory(l2, byArray2, n3);
                n7 += n3;
                l2 -= (long)n3;
                ++n8;
            }
        }
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = l;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        ImageData imageData;
        long l;
        block16: {
            block15: {
                if (!this.isSupportedType(transferData)) return null;
                if (transferData.pIDataObject == 0L) {
                    return null;
                }
                IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
                iDataObject.AddRef();
                FORMATETC fORMATETC = new FORMATETC();
                fORMATETC.cfFormat = 8;
                fORMATETC.ptd = 0L;
                fORMATETC.dwAspect = 1;
                fORMATETC.lindex = -1;
                fORMATETC.tymed = 1;
                STGMEDIUM sTGMEDIUM = new STGMEDIUM();
                sTGMEDIUM.tymed = 1;
                transferData.result = this.getData(iDataObject, fORMATETC, sTGMEDIUM);
                if (transferData.result != 0) {
                    return null;
                }
                l = sTGMEDIUM.unionField;
                iDataObject.Release();
                try {
                    long l2 = OS.GlobalLock(l);
                    if (l2 == 0L) {
                        Object var26_7 = null;
                        break block15;
                    }
                    try {
                        Object object;
                        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                        OS.MoveMemory(bITMAPINFOHEADER, l2, BITMAPINFOHEADER.sizeof);
                        long[] lArray = new long[1];
                        long l3 = OS.CreateDIBSection(0L, l2, 0, lArray, 0L, 0);
                        if (l3 == 0L) {
                            SWT.error(2);
                        }
                        long l4 = l2 + (long)bITMAPINFOHEADER.biSize;
                        if (bITMAPINFOHEADER.biBitCount <= 8) {
                            l4 += (long)((bITMAPINFOHEADER.biClrUsed == 0 ? 1 << bITMAPINFOHEADER.biBitCount : bITMAPINFOHEADER.biClrUsed) * 4);
                        } else if (bITMAPINFOHEADER.biCompression == 3) {
                            l4 += 12L;
                        }
                        if (bITMAPINFOHEADER.biHeight < 0) {
                            OS.MoveMemory(lArray[0], l4, bITMAPINFOHEADER.biSizeImage);
                        } else {
                            object = new DIBSECTION();
                            OS.GetObject(l3, DIBSECTION.sizeof, (DIBSECTION)object);
                            int n = ((DIBSECTION)object).biHeight;
                            int n2 = ((DIBSECTION)object).biSizeImage / n;
                            long l5 = lArray[0];
                            long l6 = l4 + (long)(n2 * (n - 1));
                            int n3 = 0;
                            while (n3 < n) {
                                OS.MoveMemory(l5, l6, n2);
                                l5 += (long)n2;
                                l6 -= (long)n2;
                                ++n3;
                            }
                        }
                        object = Image.win32_new(null, 0, l3);
                        ImageData imageData2 = ((Image)object).getImageData();
                        OS.DeleteObject(l3);
                        ((Resource)object).dispose();
                        imageData = imageData2;
                        Object var23_22 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_23 = null;
                        OS.GlobalUnlock(l);
                        throw throwable;
                    }
                    OS.GlobalUnlock(l);
                    break block16;
                }
                catch (Throwable throwable) {
                    Object var26_9 = null;
                    OS.GlobalFree(l);
                    throw throwable;
                }
            }
            OS.GlobalFree(l);
            return null;
        }
        Object var26_8 = null;
        OS.GlobalFree(l);
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{8};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_DIB};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

