#!/bin/bash
#
# Build the release directory for the web, and the .orig.tar.gz
# for the debian package.
#
set -e

ME=$(basename $PWD)
PACKAGE=${ME%-*}
VERSION=${ME#*-}
YEAR=$(date +%Y)
MONTH=$(date +%b)
DATE=$(date +%Y-%m-%d)

#
# Update all the version numbers and dates.
#
sed -i "s/^\([.].\" Copyright (c) \)2[0-9]*/\1${YEAR}/" ${PACKAGE}.1
sed -i "s/^\([.]TH [A-Z]* 1 \"\)[^\"]*\(\".*Version[ 	]\+\)[1-9][0-9]*[.][0-9]\+/\1${MONTH} ${YEAR}\2${VERSION}/" ${PACKAGE}.1
sed -i "/${YEAR}/!s/^\( [*].*Copyright (c) .*2[0-9]*\)\([ ]*Russell Stuart\)/\1,${YEAR}\2/" ${PACKAGE}.c
sed -i "s/^\(static.*_version..[ 	]*=[ 	]*\"\)[^\"]*/\1${VERSION}/" ${PACKAGE}.c
sed -i "s/^\(static.*_date..[ 	]*=[ 	]*\"\)[^\"]*/\1${DATE}/" ${PACKAGE}.c
sed -i "/${YEAR}/!s/\(.* is copyright &copy; .*2[0-9]*\)\([ ]*Russell Stuart\)/\1,${YEAR}\2/" ${PACKAGE}.c
sed -i "s/${PACKAGE}-[1-9][0-9]*[.][0-9]\+/${ME}/g" ${PACKAGE}.html
sed -i "s/\(Version:[ 	]\+\)[1-9][0-9]*[.][0-9]\+/\1${VERSION}/" ${PACKAGE}.spec
sed -i "s/\(AM_INIT_AUTOMAKE(${PACKAGE}, \+\)[1-9][0-9]*[.][0-9]\+/\1${VERSION}/" configure.in

#
# Run automake and friends.
#
touch NEWS 
aclocal
autoconf
automake --add-missing
./configure
debian/rules clean
rm -f NEWS
rm -f COPYING missing config.guess config.sub
keep() { cp -p $1 $1.new; mv $1.new $1; }
keep install-sh
keep mkinstalldirs

#
# Build the www directory.
#
rm -rf ${PACKAGE}
mkdir -p ${PACKAGE}/rpm/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
(cd ..; tar cfz ${ME}/${PACKAGE}/${ME}.tar.gz --exclude=${ME}/debian --exclude=${ME}/${PACKAGE} ${ME})
cp AUTHORS README epl-v10.html ${PACKAGE}.html ${PACKAGE}
man2html <${PACKAGE}.1 | sed >${PACKAGE}/conspy.1.html -e 1,2d -e 7,8d -e '/^<HR>/,/^Time: /d'
echo >${PACKAGE}/rpm/rpmrc "macrofiles : /usr/lib/rpm/macros:/usr/lib/rpm/i686-linux/macros:/etc/rpm/macros.specspo:/etc/rpm/macros.db1:/etc/rpm/macros.cdb:/etc/rpm/macros:/etc/rpm/i686-linux/macros:${PWD}/${PACKAGE}/rpm/rpmmacros"
echo >${PACKAGE}/rpm/rpmmacros "%_topdir ${PWD}/${PACKAGE}/rpm"
rpmbuild -ta --rcfile /usr/lib/rpm/rpmrc:${PACKAGE}/rpm/rpmrc ${PACKAGE}/${ME}.tar.gz
mv ${PACKAGE}/rpm/SRPMS/${ME}-1ras.src.rpm ${PACKAGE}
mv ${PACKAGE}/rpm/RPMS/i386/${ME}-1ras.i386.rpm ${PACKAGE}
rm -r ${PACKAGE}/rpm
cp ${PACKAGE}/${ME}.tar.gz ../${PACKAGE}_${VERSION}.orig.tar.gz
