/*
 * xvmalloc_int.c
 *
 * Copyright (C) 2008  Nitin Gupta
 *
 * This code is released using a dual license strategy: GPL/LGPL
 * You can choose the licence that better fits your requirements.
 *
 * Released under the terms of the GNU General Public License Version 2.0
 * Released under the terms of the GNU Lesser General Public License Version 2.1
 */

#ifndef _XVMALLOC_INT_H_
#define _XVMALLOC_INT_H_

#include <linux/types.h>

#define ROUNDUP(x,y)	((x) + (y) / (y) * (y))
// Each individual bitmap is 32-bit
#define BITMAP_BITS	32
#define BITMAP_SHIFT	5
#define BITMAP_MASK	(BITMAP_BITS - 1)

// User configurable params

// This must be greater than sizeof(LinkFree)
#define XV_MIN_ALLOC_SIZE       32
#define XV_MAX_ALLOC_SIZE       (4096 - XV_MIN_ALLOC_SIZE)

// Must be power of two
#define XV_ALIGN_SHIFT	2
#define XV_ALIGN	(1 << XV_ALIGN_SHIFT)
#define XV_ALIGN_MASK	(XV_ALIGN - 1)

// Free lists are separated by FL_DELTA bytes
#define FL_DELTA_SHIFT	3
#define FL_DELTA	(1 << FL_DELTA_SHIFT)
#define FL_DELTA_MASK	(FL_DELTA - 1)
#define NUM_FREE_LISTS	((XV_MAX_ALLOC_SIZE - XV_MIN_ALLOC_SIZE) \
				/ FL_DELTA + 1)

#define MAX_FLI		(ROUNDUP(NUM_FREE_LISTS,32) / 32)

/* End of user params */

#define ROUNDUP_ALIGN(x)	(((x) + XV_ALIGN_MASK) & ~XV_ALIGN_MASK)

#define BLOCK_FREE	0x1
#define PREV_FREE	0x2
#define FLAGS_MASK	XV_ALIGN_MASK
#define PREV_MASK	~FLAGS_MASK

typedef struct {
	u32 pageNum;
	u16 offset;
	u16 pad;
} FreeListEntry;

typedef struct {
	u32 prevPageNum;
	u32 nextPageNum;
	u16 prevOffset;
	u16 nextOffset;
} LinkFree;

typedef struct {
	union {
		// This common header must be ALIGN bytes
		u8 common[XV_ALIGN];
		struct {
			u16 size;
			u16 prev;
		};
	};
	LinkFree link;
} BlockHeader;

typedef struct {
	u32 flBitmap;
	u32 slBitmap[MAX_FLI];	
	spinlock_t lock;

	FreeListEntry FreeList[NUM_FREE_LISTS];
	
	// stats
#ifdef CONFIG_XV_STATS
	u64 totalPages;
#endif
} Pool;

#endif
