/*
 * xvmalloc.h
 *
 * Copyright (C) 2008  Nitin Gupta
 *
 * This code is released using a dual license strategy: GPL/LGPL
 * You can choose the licence that better fits your requirements.
 *
 * Released under the terms of the GNU General Public License Version 2.0
 * Released under the terms of the GNU Lesser General Public License Version 2.1
 */

#ifndef _XVMALLOC_H_
#define _XVMALLOC_H_

#include "xvmalloc_int.h"

#define INVALID_POOL_ID	NULL
#define INVALID_PGNUM	((u32)(-1))

typedef Pool * PoolID;

PoolID xvCreateMemPool(void);
void xvDestroyMemPool(PoolID pool);

int xvMalloc(PoolID pool, u32 size, u32 *pageNum, u32 *offset);
void xvFree(PoolID pool, u32 pageNum, u32 offset);

u32 xvGetObjectSize(void *obj);
u64 xvGetTotalSizeBytes(PoolID pool);

#endif
