/*
* This file is part of wxSmith plugin for Code::Blocks Studio
* Copyright (C) 2006-2007  Bartlomiej Swiecki
*
* wxSmith is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* wxSmith is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with wxSmith. If not, see <http://www.gnu.org/licenses/>.
*
* $Revision: 4850 $
* $Id: wxssizerparentqp.h 4850 2008-01-29 21:45:49Z byo $
* $HeadURL: svn://svn.berlios.de/codeblocks/tags/8.02/src/plugins/contrib/wxSmith/wxwidgets/wxssizerparentqp.h $
*/

#ifndef WXSSIZERPARENTQP_H
#define WXSSIZERPARENTQP_H

//(*Headers(wxsSizerParentQP)
#include <wx/sizer.h>
#include <wx/checkbox.h>
#include <wx/spinctrl.h>
#include <wx/radiobut.h>
#include <wx/panel.h>
//*)

#include "wxssizer.h"
#include "../wxsadvqppchild.h"

class wxsSizerParentQP: public wxsAdvQPPChild
{
	public:

		wxsSizerParentQP(wxsAdvQPP* parent,wxsSizerExtra* Extra,wxWindowID id = -1);
		virtual ~wxsSizerParentQP();

		//(*Identifiers(wxsSizerParentQP)
		static const long ID_CHECKBOX1;
		static const long ID_CHECKBOX2;
		static const long ID_CHECKBOX3;
		static const long ID_CHECKBOX4;
		static const long ID_SPINCTRL1;
		static const long ID_CHECKBOX7;
		static const long ID_RADIOBUTTON4;
		static const long ID_RADIOBUTTON5;
		static const long ID_RADIOBUTTON6;
		static const long ID_RADIOBUTTON7;
		static const long ID_RADIOBUTTON8;
		static const long ID_RADIOBUTTON9;
		static const long ID_RADIOBUTTON10;
		static const long ID_RADIOBUTTON11;
		static const long ID_RADIOBUTTON12;
		static const long ID_CHECKBOX6;
		static const long ID_CHECKBOX5;
		static const long ID_SPINCTRL2;
		//*)

	protected:

		//(*Handlers(wxsSizerParentQP)
		void OnBrdChange(wxCommandEvent& event);
		void OnBrdSizeChange(wxSpinEvent& event);
		void OnPlaceChange(wxCommandEvent& event);
		void OnProportionChange(wxSpinEvent& event);
		void OnBrdDlgChange(wxCommandEvent& event);
		//*)

		//(*Declarations(wxsSizerParentQP)
		wxRadioButton* PlaceCB;
		wxCheckBox* PlaceShp;
		wxCheckBox* BrdLeft;
		wxSpinCtrl* BrdSize;
		wxCheckBox* BrdTop;
		wxCheckBox* BrdRight;
		wxFlexGridSizer* FlexGridSizer3;
		wxRadioButton* PlaceRT;
		wxRadioButton* PlaceRC;
		wxCheckBox* PlaceExp;
		wxRadioButton* PlaceCT;
		wxCheckBox* BrdDlg;
		wxStaticBoxSizer* StaticBoxSizer3;
		wxCheckBox* BrdBottom;
		wxRadioButton* PlaceLB;
		wxRadioButton* PlaceRB;
		wxRadioButton* PlaceCC;
		wxBoxSizer* BoxSizer1;
		wxSpinCtrl* Proportion;
		wxFlexGridSizer* FlexGridSizer1;
		wxRadioButton* PlaceLT;
		wxRadioButton* PlaceLC;
		wxGridSizer* GridSizer2;
		//*)

        virtual void Update();

	private:

        void ReadData();
        void SaveData();

        wxsSizerExtra* m_Extra;

		DECLARE_EVENT_TABLE()
};

#endif
