#include <ccls.h>
#include <fx.h>
using namespace FX;
using namespace std;

#include "cclfox.h"
#include "ProductsFrame.h"
#include "CCLWin.h"

FXDEFMAP(ProductsFrame) ProductsFrameMap[] =
{
  FXMAPFUNC(SEL_COMMAND,ProductsFrame::ID_NEWPRODUCT,
	    ProductsFrame::onNewProduct),
  FXMAPFUNC(SEL_COMMAND,ProductsFrame::ID_DELPRODUCT,
	    ProductsFrame::onDelProduct),
  FXMAPFUNC(SEL_COMMAND,ProductsFrame::ID_EDITPRODUCT,
	    ProductsFrame::onEditProduct),
  FXMAPFUNC(SEL_COMMAND,ProductsFrame::ID_SELLPRODUCT,
	    ProductsFrame::onSellProduct),
  FXMAPFUNC(SEL_COMMAND,ProductsFrame::ID_SETSTOCK,
	    ProductsFrame::onSetStock),
  FXMAPFUNC(SEL_DOUBLECLICKED,ProductsFrame::ID_PRODLIST,
	    ProductsFrame::onAddProduct),
  FXMAPFUNC(SEL_DOUBLECLICKED,ProductsFrame::ID_CLPRODLIST,
	    ProductsFrame::onSubProduct)
};

FXIMPLEMENT(ProductsFrame,FXVerticalFrame,ProductsFrameMap,
	    ARRAYNUMBER(ProductsFrameMap))

extern CCLWin *mainwin;

int
pitemSortFunc(const FXFoldingItem * l,const FXFoldingItem * r)
{
  return compare(l->getText(),r->getText());
}

ProductsFrame::ProductsFrame(FXComposite * parent)
:FXVerticalFrame(parent,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN,
		0,0,0,0,0,0,0,0,0,0)
{
  ptoolbar = new FXToolBar(this,FRAME_RAISED|LAYOUT_TOP|LAYOUT_FILL_X);

  new FXButton(ptoolbar,_("New"),NULL,this,ID_NEWPRODUCT,
	       BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(ptoolbar,_("Delete"),NULL,this,ID_DELPRODUCT,
	       BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(ptoolbar,_("Edit"),NULL,this,ID_EDITPRODUCT,
	       BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(ptoolbar,_("Sell"),NULL,this,ID_SELLPRODUCT,
	       BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new FXButton(ptoolbar,_("Stock"),NULL,this,ID_SETSTOCK,
	       BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

  phsplitter = new FXSplitter(this,FRAME_SUNKEN|SPLITTER_VERTICAL|
			      SPLITTER_REVERSED|LAYOUT_FILL_X|LAYOUT_FILL_Y);

  FXVerticalFrame *treeframe =
    new FXVerticalFrame(phsplitter,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y,
			0,0,0,0,0,0,0,0,0,0);
  prodlist = new FXFoldingList(treeframe,this,ID_PRODLIST,
			       FOLDINGLIST_SHOWS_BOXES|FOLDINGLIST_SHOWS_LINES|
			       FOLDINGLIST_ROOT_BOXES|FOLDINGLIST_SINGLESELECT|
			       LAYOUT_FILL_X|LAYOUT_FILL_Y);

  prodlist->appendHeader(_("New"),NULL,180);
  prodlist->appendHeader(_("Price"),NULL,55);
  prodlist->appendHeader(_("Stock"),NULL,45);

  prodlist->setSortFunc(pitemSortFunc);

  FXVerticalFrame *listframe =
    new FXVerticalFrame(phsplitter,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y,
			0,0,0,0,0,0,0,0);

  clprodlist =
    new FXFoldingList(listframe,this,ID_CLPRODLIST,
		      FOLDINGLIST_SHOWS_BOXES|FOLDINGLIST_SHOWS_LINES|
		      FOLDINGLIST_ROOT_BOXES|FOLDINGLIST_SINGLESELECT|
		      LAYOUT_FILL_X|LAYOUT_FILL_Y);

  clprodlist->appendHeader(_("Name"),NULL,210);
  clprodlist->appendHeader(_("Amount"),NULL,60);
  prodlist->setSortFunc(pitemSortFunc);

  phsplitter->setSplit(1,200);
}

ProductsFrame::~ProductsFrame()
{
}

void
ProductsFrame::create()
{
  FXVerticalFrame::create();
}

void
ProductsFrame::loadProducts()
{
  int product = 0;

  for (FXuint i = 0; -1 != (product = CCL_product_get_nth(i)); i++)
    addProduct(product);
}
void
ProductsFrame::addProduct(int id)
{
  FXFoldingItem *prnt = NULL;
  char *category;
  char *name;
  FXuint price;
  int stock;

  if (!CCL_product_info_get(id,&category,&name,&price))
    return;

  stock = CCL_product_stock_get(id);
  char buf[256];

  snprintf(buf,256,"%s\t%.2f\t%d",name,price / 100.0,stock);

  prnt = prodlist->findItem(category);
  if (!prnt)
    prnt = prodlist->prependItem(NULL,category);

  if (!prodlist->findItem(buf,prnt->getFirst()))
    prodlist->prependItem(prnt,buf,NULL,NULL,(void *)id);

  prodlist->sortItems();
  CCL_free(name);
  CCL_free(category);
}

void
ProductsFrame::delProduct(int id)
{
  char *category;

  if (!(CCL_product_info_get(id,&category,NULL,NULL)))
    return;

  FXFoldingItem *parent = prodlist->findItem(category);
  FXFoldingItem *child = NULL;

  CCL_free(category);
  if (parent) {
    child = parent->getFirst();
    while (child) {
      if (((int) (child->getData())) == id) {
	prodlist->removeItem(child);
	child = NULL;
      } else
	child = child->getNext();
    }

    if (!parent->getFirst())
      prodlist->removeItem(parent);
  }
}

void
ProductsFrame::updateClientProducts(int client)
{
  clprodlist->clearItems();
  if (client) {
    char *category;
    char *name;
    int id;
    FXuint amount;

    for (int i = 0;
	 CCL_client_product_get_nth(client,i,&id,&amount); i++) {
      if (CCL_product_info_get(id,&category,&name,NULL)) {
	char buf[256];

	snprintf(buf,256,"%s::%s\t%u",category,name,amount);
	clprodlist->prependItem(NULL,buf,NULL,NULL,(void *)id);
	CCL_free(category);
	CCL_free(name);
      }
    }
  }
  clprodlist->sortItems();
}

long
ProductsFrame::onNewProduct(FXObject*,FXSelector,void*)
{
  FXString name;
  FXString category;
  double price = 0.0;
  FXFoldingItem *current = prodlist->getCurrentItem();

  if (current) {
    if (current->getParent())
      category = current->getParent()->getText();
    else
      category = current->getText();
  }
  FXDataTarget nametgt(name);
  FXDataTarget categorytgt(category);
  FXDataTarget pricetgt(price);

  FXDialogBox dlg(this,_("New Product"));
  FXVerticalFrame *vframe =
    new FXVerticalFrame(&dlg,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(vframe,_("Category:"));
  FXTextField *pcateg = new FXTextField(vframe,16,&categorytgt,
					FXDataTarget::ID_VALUE,
					FRAME_SUNKEN|FRAME_THICK);
  pcateg->setText(category);
  new FXLabel(vframe,_("Name:"));
  FXTextField *pname = new FXTextField(vframe,16,&nametgt,
				       FXDataTarget::ID_VALUE,
				       FRAME_SUNKEN|FRAME_THICK);
  new FXLabel(vframe,_("Price:"));
  FXRealSpinner *pprice = new FXRealSpinner(vframe,16,&pricetgt,
					    FXDataTarget::ID_VALUE,
					    FRAME_SUNKEN|FRAME_THICK);
  pprice->setRange(0,9999999.0);
  new FXHorizontalSeparator(vframe);
  FXHorizontalFrame *hframe = new FXHorizontalFrame(vframe,LAYOUT_FILL_X);
  new FXButton(hframe,_("Accept"),NULL,&dlg,FXDialogBox::ID_ACCEPT,
	       FRAME_RAISED|FRAME_THICK);
  new FXButton(hframe,_("Cancel"),NULL,&dlg,FXDialogBox::ID_CANCEL,
	       FRAME_RAISED|FRAME_THICK);
  if (dlg.execute() && category.length() && name.length() && price >= 0.0) {
    int id = CCL_product_new(category.text(),name.text(),
			       (int) (price * 100));

    addProduct(id);
  }

  return 1;
}

long
ProductsFrame::onEditProduct(FXObject*,FXSelector,void*)
{
  FXFoldingItem *current = prodlist->getCurrentItem();

  if (current && current->getParent()) {
    int id = (int) current->getData();
    FXuint current_price = 0;
    double price;

    CCL_product_info_get(id,NULL,NULL,&current_price);
    price = current_price / 100.0;

    if (FXInputDialog::getReal(price,this,_("Edit"),_("Insert the price:"),
			       NULL,0.0,9999999.0)) {
      CCL_product_price_set(id,(FXuint) (price * 100));
      delProduct(id);
      addProduct(id);
    }
  }

  return 1;
}

long
ProductsFrame::onSellProduct(FXObject*,FXSelector,void*)
{
  int pid;
  int amount;
  FXFoldingItem *current = prodlist->getCurrentItem();

  if (current && current->getParent()) {
    pid = (int) (current->getData());
    if (FXInputDialog::getInteger(amount,this,_("Sell a product"),
				  _("Insert the amount:")) && amount > 0) {
      CCL_product_sell(pid,amount);
      delProduct(pid);
      addProduct(pid);
    }
  }

  return 1;
}

long
ProductsFrame::onSetStock(FXObject*,FXSelector,void*)
{
  int pid;
  FXFoldingItem *current = prodlist->getCurrentItem();

  if (current && current->getParent()) {
    pid = (int) (current->getData());
    int oldamount = CCL_product_stock_get(pid);
    int amount = 0;

    if (FXInputDialog::getInteger(amount,this,_("Adjust stock"),
				  _("Insert the amount to add:"))) {
      double cash = 0.0;

      if (FXInputDialog::getReal(cash,this,_("Log expense"),
				 _("Insert the price (0 to not log):"),
				 NULL,0.0,999999.0)) {
	char description[128];
	char *pname = NULL;
	char *pcategory = NULL;

	// Register the action
	if (cash > 0.0) {
	  CCL_product_info_get(pid,&pcategory,&pname,NULL);
	  snprintf(description,128,_("Purchase: %s (%d)"),pname,oldamount);
	  CCL_log_expense(description,(FXuint) (cash * 100));
	}
	// Set the new stock and update the list
	CCL_product_stock_set(pid,oldamount + amount);
	delProduct(pid);
	addProduct(pid);

	CCL_free(pname);
	CCL_free(pcategory);
      }

    }
  }

  return 1;
}

long
ProductsFrame::onDelProduct(FXObject*,FXSelector,void*)
{
  FXFoldingItem *current = prodlist->getCurrentItem();
  FXFoldingItem *parent = current->getParent();

  if (current && parent) {
    int id = (int) current->getData();

    delProduct(id);
    CCL_product_delete(id);
  }

  return 1;
}

long
ProductsFrame::onAddProduct(FXObject*,FXSelector,void* ptr)
{
  FXFoldingItem *child = (FXFoldingItem *) ptr;
  FXFoldingItem *prnt = child->getParent();
  int amount = 0;
  int client = mainwin->getSelectedClient();

  if (!prnt || -1 == client)
    return 0;

  if (FXInputDialog::getInteger(amount,this,_("Add products"),
				_("Insert the amount:")) && amount >= 1) {
    int pid = (int) child->getData();

    CCL_client_product_add(client,pid,amount);
    updateClientProducts(client);
    delProduct(pid);
    addProduct(pid);
  }

  return 1;
}

long
ProductsFrame::onSubProduct(FXObject*,FXSelector,void* ptr)
{
  FXFoldingItem *item = (FXFoldingItem *) ptr;
  int amount = 0;
  int client = mainwin->getSelectedClient();

  if (-1 == client)
    return 0;

  if (FXInputDialog::getInteger(amount,this,_("Subtract products"),
				_("Insert the amount:")) && amount >= 1) {
    int pid = (int) item->getData();

    CCL_client_product_sub(client,pid,amount);
    updateClientProducts(client);
    delProduct(pid);
    addProduct(pid);
  }

  return 1;
}
