from tests import compatibility_issues

## PRIVATE CALDAV SERVER(S) TO RUN TESTS TOWARDS
## Make a list of your own servers/accounts that you'd like to run the
## test towards.  Running the test suite towards a personal account
## should generally be safe, it should not mess up with content there
## and it should clean up after itself, but don't sue me if anything
## goes wrong ...

## Define your primary caldav server here
caldav_servers = [
    {
        'url': "https://xandikos.tobixen.no/",
        "password": "kalenderfestøl",
        "username": "tobias",
        'incompatibilities': compatibility_issues.xandikos
    },
    #{
    #    'url': 'https://cloud.domainedessablons.fr/remote.php/dav/',
    #    'password': 'VeyshleewdmynJig7ob',
    #    'username': 'tobixen',
    #    'incompatibilities': compatibility_issues.nextcloud
    #},
    {
        ## This is all that is really needed - url, username and
        ## password.  (the URL may even include username and password)
        'url': 'https://ecloud.global/remote.php/dav/',
        'username': 'tobixen@e.email',
        'password': '/Test4Caldav.',

        ## skip ssl cert verification, for self-signed certificates
        ## (sort of moot nowadays with letsencrypt freely available)
        #'ssl_cert_verify': False

        ## incompatibilities is a list of flags that can be set for
        ## skipping (parts) of certain tests.  See
        ## tests/compatibility_issues.py for premade lists
        'incompatibilities': compatibility_issues.nextcloud
	#'incompatibilities': []
    },
    #{
     #   'url': 'https://demo2.nextcloud.com/remote.php/dav/',
      #  'username': 'RQ6PbYE6KaNpfmHY',
       # 'password': 'demo2',
       # 'incompatibilities': compatibility_issues.nextcloud
    #},
]
#caldav_servers.pop()
caldav_servers = caldav_servers[1:2]


## SOGo virtual test server
## I did roughly those steps to set up a SOGo test server:
## 1) I download the ZEG - "Zero Effort Groupware" - from https://sourceforge.net/projects/sogo-zeg/
## 2) I installed virtualbox on my laptop
## 3) "virtualbox ~/Downloads/ZEG-5.0.0.ova" (TODO: probably it's possible to launch it "headless"?)
## 4) I clicked on some buttons to get the file "imported" and started
## 5) I went to "tools" -> "preferences" -> "network" and created a NatNetwork
## 6) I think I went to ZEG -> Settings -> Network and chose "Host-only Adapter"
## 7) SOGo was then available at http://192.168.56.101/ from my laptop
## 8) I added the lines below to my conf_private.py
#caldav_servers.append({
#    'url': 'http://192.168.56.101/SOGo/dav/',
#    'username': 'sogo1'.
#    'password': 'sogo'
#})
#for i in (1, 2, 3):
#    sogo = caldav_servers[-1].copy()
#    sogo['username'] = 'sogo%i' % i
#    rfc6638_users.append(sogo)

## MASTER SWITCHES FOR TEST SERVER SETUP
## With those configuration switches, pre-configured test servers in conf.py
## can be turned on or off

## test_public_test_servers - Use the list of common public test
## servers from conf.py.  As of 2020-10 no public test servers exists, so this option
## is currently moot :-(
test_public_test_servers = False

## test_private_test_servers - test using the list configured above in this file.
test_private_test_servers = False

## test_xandikos and test_radicale ... since the xandikos and radicale caldav server implementation is
## written in python and can be instantiated quite easily, those will
## be the default caldav implementation to test towards.
test_xandikos = True
test_radicale = True

## For usage by ../examples/scheduling_examples.py.  Should typically
## be three different users on the same caldav server.
#rfc6638_users = [ caldav_servers[0], caldav_servers[1], caldav_servers[2] ]
