/* ccm-clone.c generated by valac, the Vala compiler
 * generated from ccm-clone.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2007-2010 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ccm.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <ccm-pixmap.h>
#include <ccm-screen.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <ccm-plugin.h>
#include <ccm-screen-plugin.h>
#include <valagee.h>
#include <ccm-debug.h>
#include <ccm-drawable.h>
#include <ccm-display.h>
#include <cairo.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define CCM_TYPE_OUTPUT (ccm_output_get_type ())
#define CCM_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_OUTPUT, CCMOutput))
#define CCM_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_OUTPUT, CCMOutputClass))
#define CCM_IS_OUTPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_OUTPUT))
#define CCM_IS_OUTPUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_OUTPUT))
#define CCM_OUTPUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_OUTPUT, CCMOutputClass))

typedef struct _CCMOutput CCMOutput;
typedef struct _CCMOutputClass CCMOutputClass;
typedef struct _CCMOutputPrivate CCMOutputPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _CCMParamSpecOutput CCMParamSpecOutput;

#define CCM_TYPE_CLONE (ccm_clone_get_type ())
#define CCM_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_CLONE, CCMClone))
#define CCM_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_CLONE, CCMCloneClass))
#define CCM_IS_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_CLONE))
#define CCM_IS_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_CLONE))
#define CCM_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_CLONE, CCMCloneClass))

typedef struct _CCMClone CCMClone;
typedef struct _CCMCloneClass CCMCloneClass;
typedef struct _CCMClonePrivate CCMClonePrivate;
typedef struct _CCMCloneClassPrivate CCMCloneClassPrivate;
static GQuark _vala_ccm_clone_class_private_quark = 0;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _ccm_output_unref0(var) ((var == NULL) ? NULL : (var = (ccm_output_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _CCMOutput {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CCMOutputPrivate * priv;
	CCMWindow* window;
	CCMPixmap* pixmap;
};

struct _CCMOutputClass {
	GTypeClass parent_class;
	void (*finalize) (CCMOutput *self);
};

struct _CCMParamSpecOutput {
	GParamSpec parent_instance;
};

struct _CCMClone {
	CCMPlugin parent_instance;
	CCMClonePrivate * priv;
};

struct _CCMCloneClass {
	CCMPluginClass parent_class;
};

struct _CCMClonePrivate {
	CCMScreen* screen;
	ValaArrayList* screen_outputs;
	ValaArrayList* window_outputs;
};


static gpointer ccm_output_parent_class = NULL;
static GType ccm_output_type_id = 0;
static gpointer ccm_clone_parent_class = NULL;
static CCMScreenPluginIface* ccm_clone_ccm_screen_plugin_parent_iface = NULL;
static CCMWindowPluginIface* ccm_clone_ccm_window_plugin_parent_iface = NULL;
static GType ccm_clone_type_id = 0;

gpointer ccm_output_ref (gpointer instance);
void ccm_output_unref (gpointer instance);
GParamSpec* ccm_param_spec_output (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ccm_value_set_output (GValue* value, gpointer v_object);
gpointer ccm_value_get_output (const GValue* value);
GType ccm_output_get_type (void);
GType ccm_output_register_type (GTypeModule * module);
enum  {
	CCM_OUTPUT_DUMMY_PROPERTY
};
CCMOutput* ccm_output_new (CCMScreen* screen, CCMWindow* window, Pixmap xpixmap, gint depth);
CCMOutput* ccm_output_construct (GType object_type, CCMScreen* screen, CCMWindow* window, Pixmap xpixmap, gint depth);
static void ccm_output_finalize (CCMOutput* obj);
GType ccm_clone_get_type (void);
GType ccm_clone_register_type (GTypeModule * module);
#define CCM_CLONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_CLONE, CCMClonePrivate))
struct _CCMCloneClassPrivate {
	Atom screen_enable_atom;
	Atom screen_disable_atom;
	Atom enable_atom;
	Atom disable_atom;
};

#define CCM_CLONE_GET_CLASS_PRIVATE(type) ((CCMCloneClassPrivate *) g_type_get_qdata (type, _vala_ccm_clone_class_private_quark))
enum  {
	CCM_CLONE_DUMMY_PROPERTY
};
static void ccm_clone_add_screen_output (CCMClone* self, CCMOutput* output);
static void ccm_clone_remove_screen_output (CCMClone* self, CCMOutput* output);
static void ccm_clone_on_composite_message (CCMClone* self, CCMWindow* client, CCMWindow* window, glong l1, glong l2, glong l3);
static void _ccm_clone_on_composite_message_ccm_screen_composite_message (CCMScreen* _sender, CCMWindow* client, CCMWindow* window, glong l1, glong l2, glong l3, gpointer self);
static void ccm_clone_real_screen_load_options (CCMScreenPlugin* base, CCMScreen* screen);
static gboolean ccm_clone_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* context, cairo_surface_t* surface, gboolean y_invert);
CCMClone* ccm_clone_new (void);
CCMClone* ccm_clone_construct (GType object_type);
static void ccm_clone_base_finalize (CCMCloneClass * klass);
static void ccm_clone_finalize (GObject* obj);
GType ccm_clone_get_plugin_type (GTypeModule* module);



CCMOutput* ccm_output_construct (GType object_type, CCMScreen* screen, CCMWindow* window, Pixmap xpixmap, gint depth) {
	CCMOutput* self;
	Visual* visual;
	CCMPixmap* _tmp0_;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (CCMOutput*) g_type_create_instance (object_type);
	visual = ccm_screen_get_visual_for_depth (screen, depth);
	self->window = window;
	self->pixmap = (_tmp0_ = ccm_pixmap_new_from_visual (screen, visual, xpixmap), _g_object_unref0 (self->pixmap), _tmp0_);
	ccm_pixmap_set_foreign (self->pixmap, TRUE);
	return self;
}


CCMOutput* ccm_output_new (CCMScreen* screen, CCMWindow* window, Pixmap xpixmap, gint depth) {
	return ccm_output_construct (CCM_TYPE_OUTPUT, screen, window, xpixmap, depth);
}


static void ccm_value_output_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ccm_value_output_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ccm_output_unref (value->data[0].v_pointer);
	}
}


static void ccm_value_output_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ccm_output_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ccm_value_output_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ccm_value_output_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		CCMOutput* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ccm_output_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ccm_value_output_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CCMOutput** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ccm_output_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ccm_param_spec_output (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CCMParamSpecOutput* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CCM_TYPE_OUTPUT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ccm_value_get_output (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CCM_TYPE_OUTPUT), NULL);
	return value->data[0].v_pointer;
}


void ccm_value_set_output (GValue* value, gpointer v_object) {
	CCMOutput* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CCM_TYPE_OUTPUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CCM_TYPE_OUTPUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ccm_output_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ccm_output_unref (old);
	}
}


static void ccm_output_class_init (CCMOutputClass * klass) {
	ccm_output_parent_class = g_type_class_peek_parent (klass);
	CCM_OUTPUT_CLASS (klass)->finalize = ccm_output_finalize;
}


static void ccm_output_instance_init (CCMOutput * self) {
	self->ref_count = 1;
}


static void ccm_output_finalize (CCMOutput* obj) {
	CCMOutput * self;
	self = CCM_OUTPUT (obj);
	_g_object_unref0 (self->pixmap);
}


GType ccm_output_get_type (void) {
	return ccm_output_type_id;
}


GType ccm_output_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { ccm_value_output_init, ccm_value_output_free_value, ccm_value_output_copy_value, ccm_value_output_peek_pointer, "p", ccm_value_output_collect_value, "p", ccm_value_output_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CCMOutputClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_output_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMOutput), 0, (GInstanceInitFunc) ccm_output_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	ccm_output_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CCMOutput", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ccm_output_type_id;
}


gpointer ccm_output_ref (gpointer instance) {
	CCMOutput* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ccm_output_unref (gpointer instance) {
	CCMOutput* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CCM_OUTPUT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ccm_clone_add_screen_output (CCMClone* self, CCMOutput* output) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (output != NULL);
	if (self->priv->screen_outputs == NULL) {
		ValaArrayList* _tmp0_;
		self->priv->screen_outputs = (_tmp0_ = vala_array_list_new (CCM_TYPE_OUTPUT, (GBoxedCopyFunc) ccm_output_ref, ccm_output_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->screen_outputs), _tmp0_);
	}
	vala_collection_add ((ValaCollection*) self->priv->screen_outputs, output);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = ccm_screen_get_windows (self->priv->screen);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			CCMWindow* window;
			window = _g_object_ref0 ((CCMWindow*) window_it->data);
			{
				if (window != output->window) {
					CCMClone* clone;
					clone = _g_object_ref0 (CCM_CLONE (_ccm_window_get_plugin (window, CCM_TYPE_CLONE)));
					if (clone->priv->screen_outputs == NULL) {
						ValaArrayList* _tmp1_;
						clone->priv->screen_outputs = (_tmp1_ = vala_array_list_new (CCM_TYPE_OUTPUT, (GBoxedCopyFunc) ccm_output_ref, ccm_output_unref, g_direct_equal), _vala_collection_object_unref0 (clone->priv->screen_outputs), _tmp1_);
					}
					vala_collection_add ((ValaCollection*) clone->priv->screen_outputs, output);
					_g_object_unref0 (clone);
				}
				_g_object_unref0 (window);
			}
		}
	}
}


static void ccm_clone_remove_screen_output (CCMClone* self, CCMOutput* output) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (output != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->screen_outputs, output);
	{
		GList* window_collection;
		GList* window_it;
		window_collection = ccm_screen_get_windows (self->priv->screen);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			CCMWindow* window;
			window = _g_object_ref0 ((CCMWindow*) window_it->data);
			{
				CCMClone* clone;
				clone = _g_object_ref0 (CCM_CLONE (_ccm_window_get_plugin (window, CCM_TYPE_CLONE)));
				vala_collection_remove ((ValaCollection*) clone->priv->screen_outputs, output);
				_g_object_unref0 (window);
				_g_object_unref0 (clone);
			}
		}
	}
}


static void ccm_clone_on_composite_message (CCMClone* self, CCMWindow* client, CCMWindow* window, glong l1, glong l2, glong l3) {
	Atom atom;
	Pixmap xpixmap;
	gint depth;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	g_return_if_fail (window != NULL);
	atom = (Atom) l1;
	xpixmap = (Pixmap) l2;
	depth = (gint) l3;
	if (atom == CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->enable_atom) {
		CCMClone* clone;
		CCMOutput* output;
		ccm_log ("ENABLE CLONE", NULL);
		clone = _g_object_ref0 (CCM_CLONE (_ccm_window_get_plugin (window, CCM_TYPE_CLONE)));
		output = ccm_output_new (ccm_drawable_get_screen ((CCMDrawable*) window), window, xpixmap, depth);
		if (clone->priv->window_outputs == NULL) {
			ValaArrayList* _tmp0_;
			clone->priv->window_outputs = (_tmp0_ = vala_array_list_new (CCM_TYPE_OUTPUT, (GBoxedCopyFunc) ccm_output_ref, ccm_output_unref, g_direct_equal), _vala_collection_object_unref0 (clone->priv->window_outputs), _tmp0_);
		}
		vala_collection_add ((ValaCollection*) clone->priv->window_outputs, output);
		ccm_window_set_no_undamage_sibling (client, TRUE);
		ccm_drawable_damage ((CCMDrawable*) window);
		_g_object_unref0 (clone);
		_ccm_output_unref0 (output);
	} else {
		if (atom == CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->disable_atom) {
			CCMClone* clone;
			ccm_log ("DISABLE CLONE", NULL);
			clone = _g_object_ref0 (CCM_CLONE (_ccm_window_get_plugin (window, CCM_TYPE_CLONE)));
			ccm_window_set_no_undamage_sibling (client, FALSE);
			{
				ValaIterator* _output_it;
				_output_it = vala_iterable_iterator ((ValaIterable*) clone->priv->window_outputs);
				while (TRUE) {
					CCMOutput* output;
					if (!vala_iterator_next (_output_it)) {
						break;
					}
					output = (CCMOutput*) vala_iterator_get (_output_it);
					if (ccm_drawable_get_xid ((CCMDrawable*) output->pixmap) == ((XID) xpixmap)) {
						vala_collection_remove ((ValaCollection*) clone->priv->window_outputs, output);
						_ccm_output_unref0 (output);
						break;
					}
					_ccm_output_unref0 (output);
				}
				_vala_collection_object_unref0 (_output_it);
			}
			_g_object_unref0 (clone);
		} else {
			if (atom == CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->screen_enable_atom) {
				CCMOutput* output;
				ccm_log ("ENABLE SCREEN CLONE", NULL);
				output = ccm_output_new (ccm_drawable_get_screen ((CCMDrawable*) window), window, xpixmap, depth);
				ccm_window_set_no_undamage_sibling (window, TRUE);
				ccm_clone_add_screen_output (self, output);
				_ccm_output_unref0 (output);
			} else {
				if (atom == CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->screen_disable_atom) {
					ccm_log ("DISABLE SCREEN CLONE", NULL);
					{
						ValaIterator* _output_it;
						_output_it = vala_iterable_iterator ((ValaIterable*) self->priv->screen_outputs);
						while (TRUE) {
							CCMOutput* output;
							if (!vala_iterator_next (_output_it)) {
								break;
							}
							output = (CCMOutput*) vala_iterator_get (_output_it);
							if (ccm_drawable_get_xid ((CCMDrawable*) output->pixmap) == ((XID) xpixmap)) {
								ccm_window_set_no_undamage_sibling (output->window, FALSE);
								ccm_clone_remove_screen_output (self, output);
								_ccm_output_unref0 (output);
								break;
							}
							_ccm_output_unref0 (output);
						}
						_vala_collection_object_unref0 (_output_it);
					}
				}
			}
		}
	}
}


static void _ccm_clone_on_composite_message_ccm_screen_composite_message (CCMScreen* _sender, CCMWindow* client, CCMWindow* window, glong l1, glong l2, glong l3, gpointer self) {
	ccm_clone_on_composite_message (self, client, window, l1, l2, l3);
}


static void ccm_clone_real_screen_load_options (CCMScreenPlugin* base, CCMScreen* screen) {
	CCMClone * self;
	self = (CCMClone*) base;
	g_return_if_fail (screen != NULL);
	self->priv->screen = screen;
	g_signal_connect_object (self->priv->screen, "composite-message", (GCallback) _ccm_clone_on_composite_message_ccm_screen_composite_message, self, 0);
	if (CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->screen_enable_atom == 0) {
		CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->screen_enable_atom = XInternAtom (ccm_display_get_xdisplay (ccm_screen_get_display (screen)), "_CCM_CLONE_SCREEN_ENABLE", FALSE);
		CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->screen_disable_atom = XInternAtom (ccm_display_get_xdisplay (ccm_screen_get_display (screen)), "_CCM_CLONE_SCREEN_DISABLE", FALSE);
		CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->enable_atom = XInternAtom (ccm_display_get_xdisplay (ccm_screen_get_display (screen)), "_CCM_CLONE_ENABLE", FALSE);
		CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (CCM_CLONE_CLASS (G_OBJECT_GET_CLASS (self))))->disable_atom = XInternAtom (ccm_display_get_xdisplay (ccm_screen_get_display (screen)), "_CCM_CLONE_DISABLE", FALSE);
	}
	ccm_screen_plugin_load_options (CCM_SCREEN_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), screen);
}


static gboolean ccm_clone_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* context, cairo_surface_t* surface, gboolean y_invert) {
	CCMClone * self;
	gboolean result;
	gboolean ret;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (CCMClone*) base;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (surface != NULL, FALSE);
	ret = FALSE;
	ret = ccm_window_plugin_paint (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window, context, surface, y_invert);
	if (self->priv->window_outputs != NULL) {
		_tmp2_ = vala_collection_get_size ((ValaCollection*) self->priv->window_outputs) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->priv->screen_outputs != NULL) {
			_tmp3_ = vala_collection_get_size ((ValaCollection*) self->priv->screen_outputs) > 0;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = ret;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		cairo_rectangle_t* area;
		cairo_rectangle_t _tmp4_ = {0};
		cairo_rectangle_t geometry;
		gboolean _tmp5_ = FALSE;
		area = ccm_window_get_area (window);
		geometry = (memset (&_tmp4_, 0, sizeof (cairo_rectangle_t)), _tmp4_);
		if (area != NULL) {
			_tmp5_ = ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) window, &geometry);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			if (self->priv->window_outputs != NULL) {
				{
					ValaIterator* _output_it;
					_output_it = vala_iterable_iterator ((ValaIterable*) self->priv->window_outputs);
					while (TRUE) {
						CCMOutput* output;
						cairo_rectangle_t _tmp6_ = {0};
						cairo_rectangle_t clipbox;
						if (!vala_iterator_next (_output_it)) {
							break;
						}
						output = (CCMOutput*) vala_iterator_get (_output_it);
						clipbox = (memset (&_tmp6_, 0, sizeof (cairo_rectangle_t)), _tmp6_);
						if (ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) output->pixmap, &clipbox)) {
							cairo_t* ctx;
							ctx = ccm_drawable_create_context ((CCMDrawable*) output->pixmap);
							if (ctx != NULL) {
								cairo_scale (ctx, clipbox.width / (*area).width, clipbox.height / (*area).height);
								cairo_translate (ctx, -(*area).x, -(*area).y);
								ccm_drawable_get_damage_path ((CCMDrawable*) window, ctx);
								cairo_clip (ctx);
								cairo_translate (ctx, (*area).x, (*area).y);
								cairo_set_source_surface (ctx, surface, (-(geometry.width - (*area).width)) / 2.0, (-(geometry.height - (*area).height)) / 2.0);
								cairo_paint (ctx);
							}
							_cairo_destroy0 (ctx);
						}
						_ccm_output_unref0 (output);
					}
					_vala_collection_object_unref0 (_output_it);
				}
			}
			if (self->priv->screen_outputs != NULL) {
				{
					ValaIterator* _output_it;
					_output_it = vala_iterable_iterator ((ValaIterable*) self->priv->screen_outputs);
					while (TRUE) {
						CCMOutput* output;
						cairo_rectangle_t _tmp7_ = {0};
						cairo_rectangle_t clipbox;
						gint width;
						gint height;
						gboolean _tmp8_ = FALSE;
						if (!vala_iterator_next (_output_it)) {
							break;
						}
						output = (CCMOutput*) vala_iterator_get (_output_it);
						clipbox = (memset (&_tmp7_, 0, sizeof (cairo_rectangle_t)), _tmp7_);
						width = ccm_screen_get_xscreen (ccm_drawable_get_screen ((CCMDrawable*) window))->width;
						height = ccm_screen_get_xscreen (ccm_drawable_get_screen ((CCMDrawable*) window))->height;
						if (output->window != window) {
							_tmp8_ = ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) output->pixmap, &clipbox);
						} else {
							_tmp8_ = FALSE;
						}
						if (_tmp8_) {
							cairo_t* ctx;
							ctx = ccm_drawable_create_context ((CCMDrawable*) output->pixmap);
							if (ctx != NULL) {
								cairo_matrix_t matrix = {0};
								cairo_matrix_t _tmp9_ = {0};
								matrix = (cairo_matrix_init (&_tmp9_, clipbox.width / width, (double) 0, (double) 0, clipbox.height / height, (-geometry.x) * (1 - (clipbox.width / width)), (-geometry.y) * (1 - (clipbox.height / height))), _tmp9_);
								cairo_set_matrix (ctx, &matrix);
								ccm_drawable_get_damage_path ((CCMDrawable*) window, ctx);
								cairo_clip (ctx);
								cairo_identity_matrix (ctx);
								ccm_drawable_push_matrix ((CCMDrawable*) window, "CCMClone", &matrix);
								ccm_window_plugin_paint (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window, ctx, surface, y_invert);
								ccm_drawable_pop_matrix ((CCMDrawable*) window, "CCMClone");
							}
							_cairo_destroy0 (ctx);
						}
						_ccm_output_unref0 (output);
					}
					_vala_collection_object_unref0 (_output_it);
				}
			}
		}
	}
	result = ret;
	return result;
}


CCMClone* ccm_clone_construct (GType object_type) {
	CCMClone * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMClone* ccm_clone_new (void) {
	return ccm_clone_construct (CCM_TYPE_CLONE);
}


static void ccm_clone_base_init (CCMCloneClass * klass) {
	{
		CCMCloneClassPrivate * priv;
		CCMCloneClassPrivate * parent_priv;
		GType parent_type;
		parent_priv = NULL;
		parent_type = g_type_parent (G_TYPE_FROM_CLASS (klass));
		if (parent_type) {
			parent_priv = CCM_CLONE_GET_CLASS_PRIVATE (parent_type);
		}
		priv = g_slice_new0 (CCMCloneClassPrivate);
		if (parent_priv) {
			memcpy (priv, parent_priv, sizeof (CCMCloneClassPrivate));
		}
		g_type_set_qdata (G_TYPE_FROM_CLASS (klass), _vala_ccm_clone_class_private_quark, priv);
	}
}


static void ccm_clone_class_init (CCMCloneClass * klass) {
	ccm_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMClonePrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_clone_finalize;
}


static void ccm_clone_base_finalize (CCMCloneClass * klass) {
	{
		CCMCloneClassPrivate * priv;
		priv = CCM_CLONE_GET_CLASS_PRIVATE (G_TYPE_FROM_CLASS (klass));
		g_slice_free (CCMCloneClassPrivate, priv);
	}
}


static void ccm_clone_ccm_screen_plugin_interface_init (CCMScreenPluginIface * iface) {
	ccm_clone_ccm_screen_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_clone_real_screen_load_options;
}


static void ccm_clone_ccm_window_plugin_interface_init (CCMWindowPluginIface * iface) {
	ccm_clone_ccm_window_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->paint = ccm_clone_real_window_paint;
}


static void ccm_clone_instance_init (CCMClone * self) {
	self->priv = CCM_CLONE_GET_PRIVATE (self);
	self->priv->screen_outputs = NULL;
	self->priv->window_outputs = NULL;
}


static void ccm_clone_finalize (GObject* obj) {
	CCMClone * self;
	self = CCM_CLONE (obj);
	_vala_collection_object_unref0 (self->priv->screen_outputs);
	_vala_collection_object_unref0 (self->priv->window_outputs);
	G_OBJECT_CLASS (ccm_clone_parent_class)->finalize (obj);
}


GType ccm_clone_get_type (void) {
	return ccm_clone_type_id;
}


GType ccm_clone_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMCloneClass), (GBaseInitFunc) ccm_clone_base_init, (GBaseFinalizeFunc) ccm_clone_base_finalize, (GClassInitFunc) ccm_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMClone), 0, (GInstanceInitFunc) ccm_clone_instance_init, NULL };
	static const GInterfaceInfo ccm_screen_plugin_info = { (GInterfaceInitFunc) ccm_clone_ccm_screen_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo ccm_window_plugin_info = { (GInterfaceInitFunc) ccm_clone_ccm_window_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	_vala_ccm_clone_class_private_quark = g_quark_from_string ("ValaCCMCloneClassPrivate");
	ccm_clone_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMClone", &g_define_type_info, 0);
	g_type_module_add_interface (module, ccm_clone_type_id, CCM_TYPE_SCREEN_PLUGIN, &ccm_screen_plugin_info);
	g_type_module_add_interface (module, ccm_clone_type_id, CCM_TYPE_WINDOW_PLUGIN, &ccm_window_plugin_info);
	return ccm_clone_type_id;
}


GType ccm_clone_get_plugin_type (GTypeModule* module) {
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_output_register_type (module);
	ccm_clone_register_type (module);
	result = CCM_TYPE_CLONE;
	return result;
}




