/* ccm-story-board.c generated by valac, the Vala compiler
 * generated from ccm-story-board.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2008 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ccm.h>
#include <ccm-screen.h>
#include <stdlib.h>
#include <string.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <ccm-display.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <float.h>
#include <math.h>
#include <ccm-debug.h>


#define CCM_TYPE_STORY_BOARD (ccm_story_board_get_type ())
#define CCM_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoard))
#define CCM_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))
#define CCM_IS_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_STORY_BOARD))
#define CCM_IS_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_STORY_BOARD))
#define CCM_STORY_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))

typedef struct _CCMStoryBoard CCMStoryBoard;
typedef struct _CCMStoryBoardClass CCMStoryBoardClass;
typedef struct _CCMStoryBoardPrivate CCMStoryBoardPrivate;

#define CCM_TYPE_ACTION (ccm_action_get_type ())
#define CCM_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION, CCMAction))
#define CCM_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION, CCMActionClass))
#define CCM_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION))
#define CCM_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION))
#define CCM_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION, CCMActionClass))

typedef struct _CCMAction CCMAction;
typedef struct _CCMActionClass CCMActionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

#define CCM_TYPE_ACTION_POINTER (ccm_action_pointer_get_type ())
#define CCM_ACTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER, CCMActionPointer))
#define CCM_ACTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER, CCMActionPointerClass))
#define CCM_IS_ACTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER))
#define CCM_IS_ACTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER))
#define CCM_ACTION_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER, CCMActionPointerClass))

typedef struct _CCMActionPointer CCMActionPointer;
typedef struct _CCMActionPointerClass CCMActionPointerClass;

#define CCM_TYPE_ACTION_POINTER_MOTION (ccm_action_pointer_motion_get_type ())
#define CCM_ACTION_POINTER_MOTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER_MOTION, CCMActionPointerMotion))
#define CCM_ACTION_POINTER_MOTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER_MOTION, CCMActionPointerMotionClass))
#define CCM_IS_ACTION_POINTER_MOTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER_MOTION))
#define CCM_IS_ACTION_POINTER_MOTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER_MOTION))
#define CCM_ACTION_POINTER_MOTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER_MOTION, CCMActionPointerMotionClass))

typedef struct _CCMActionPointerMotion CCMActionPointerMotion;
typedef struct _CCMActionPointerMotionClass CCMActionPointerMotionClass;

#define CCM_TYPE_ACTION_POINTER_PRESS (ccm_action_pointer_press_get_type ())
#define CCM_ACTION_POINTER_PRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER_PRESS, CCMActionPointerPress))
#define CCM_ACTION_POINTER_PRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER_PRESS, CCMActionPointerPressClass))
#define CCM_IS_ACTION_POINTER_PRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER_PRESS))
#define CCM_IS_ACTION_POINTER_PRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER_PRESS))
#define CCM_ACTION_POINTER_PRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER_PRESS, CCMActionPointerPressClass))

typedef struct _CCMActionPointerPress CCMActionPointerPress;
typedef struct _CCMActionPointerPressClass CCMActionPointerPressClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CCM_TYPE_ACTION_POINTER_RELEASE (ccm_action_pointer_release_get_type ())
#define CCM_ACTION_POINTER_RELEASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerRelease))
#define CCM_ACTION_POINTER_RELEASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerReleaseClass))
#define CCM_IS_ACTION_POINTER_RELEASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER_RELEASE))
#define CCM_IS_ACTION_POINTER_RELEASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER_RELEASE))
#define CCM_ACTION_POINTER_RELEASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerReleaseClass))

typedef struct _CCMActionPointerRelease CCMActionPointerRelease;
typedef struct _CCMActionPointerReleaseClass CCMActionPointerReleaseClass;

struct _CCMStoryBoard {
	GObject parent_instance;
	CCMStoryBoardPrivate * priv;
};

struct _CCMStoryBoardClass {
	GObjectClass parent_class;
};

struct _CCMStoryBoardPrivate {
	gboolean _hint_motion;
	CCMScreen* screen;
	char* name;
	GList* ignore;
	GList* actions;
	GTimeVal time;
};

typedef enum  {
	CCM_ACTION_ERROR_WINDOW_IGNORE,
	CCM_ACTION_ERROR_WINDOW_NOT_FOUND
} CCMActionError;
#define CCM_ACTION_ERROR ccm_action_error_quark ()

static gpointer ccm_story_board_parent_class = NULL;
static GType ccm_story_board_type_id = 0;

GType ccm_story_board_get_type (void);
GType ccm_story_board_register_type (GTypeModule * module);
GType ccm_action_get_type (void);
GType ccm_action_register_type (GTypeModule * module);
#define CCM_STORY_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_STORY_BOARD, CCMStoryBoardPrivate))
enum  {
	CCM_STORY_BOARD_DUMMY_PROPERTY,
	CCM_STORY_BOARD_HINT_MOTION
};
static void _g_list_free_g_object_unref (GList* self);
void ccm_story_board_set_hint_motion (CCMStoryBoard* self, gboolean value);
static void ccm_story_board_on_event (CCMStoryBoard* self, CCMDisplay* display, XEvent* event);
static void _ccm_story_board_on_event_ccm_display_event (CCMDisplay* _sender, XEvent* event, gpointer self);
CCMStoryBoard* ccm_story_board_new (CCMScreen* screen, const char* name, GList* ignore);
CCMStoryBoard* ccm_story_board_construct (GType object_type, CCMScreen* screen, const char* name, GList* ignore);
gboolean ccm_story_board_get_hint_motion (CCMStoryBoard* self);
GType ccm_action_pointer_get_type (void);
GType ccm_action_pointer_register_type (GTypeModule * module);
GType ccm_action_pointer_motion_get_type (void);
GType ccm_action_pointer_motion_register_type (GTypeModule * module);
void ccm_action_pointer_motion_set_event (CCMActionPointerMotion* self, XEvent* value);
void ccm_action_set_time (CCMAction* self, glong value);
CCMActionPointerMotion* ccm_action_pointer_motion_new (CCMScreen* screen, XEvent* event, glong time);
CCMActionPointerMotion* ccm_action_pointer_motion_construct (GType object_type, CCMScreen* screen, XEvent* event, glong time);
GQuark ccm_action_error_quark (void);
CCMActionPointerPress* ccm_action_pointer_press_new (CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
CCMActionPointerPress* ccm_action_pointer_press_construct (GType object_type, CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
GType ccm_action_pointer_press_get_type (void);
GType ccm_action_pointer_press_register_type (GTypeModule * module);
CCMActionPointerRelease* ccm_action_pointer_release_new (CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
CCMActionPointerRelease* ccm_action_pointer_release_construct (GType object_type, CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
GType ccm_action_pointer_release_get_type (void);
GType ccm_action_pointer_release_register_type (GTypeModule * module);
char* ccm_action_to_string (CCMAction* self, const char* format);
char* ccm_story_board_to_string (CCMStoryBoard* self, const char* format);
static void ccm_story_board_finalize (GObject* obj);
static void ccm_story_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void ccm_story_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _ccm_story_board_on_event_ccm_display_event (CCMDisplay* _sender, XEvent* event, gpointer self) {
	ccm_story_board_on_event (self, _sender, event);
}


CCMStoryBoard* ccm_story_board_construct (GType object_type, CCMScreen* screen, const char* name, GList* ignore) {
	CCMStoryBoard * self;
	CCMScreen* _tmp0_;
	char* _tmp1_;
	GList* _tmp2_;
	GTimeVal _tmp3_ = {0};
	GList* _tmp4_;
	CCMDisplay* display;
	g_return_val_if_fail (screen != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (CCMStoryBoard*) g_object_new (object_type, NULL);
	ccm_story_board_set_hint_motion (self, FALSE);
	self->priv->screen = (_tmp0_ = _g_object_ref0 (screen), _g_object_unref0 (self->priv->screen), _tmp0_);
	self->priv->name = (_tmp1_ = g_strdup (name), _g_free0 (self->priv->name), _tmp1_);
	self->priv->actions = (_tmp2_ = NULL, __g_list_free_g_object_unref0 (self->priv->actions), _tmp2_);
	self->priv->time = (g_get_current_time (&_tmp3_), _tmp3_);
	self->priv->ignore = (_tmp4_ = g_list_copy (ignore), _g_list_free0 (self->priv->ignore), _tmp4_);
	display = _g_object_ref0 (ccm_screen_get_display (screen));
	g_signal_connect_object (display, "event", (GCallback) _ccm_story_board_on_event_ccm_display_event, self, 0);
	_g_object_unref0 (display);
	return self;
}


CCMStoryBoard* ccm_story_board_new (CCMScreen* screen, const char* name, GList* ignore) {
	return ccm_story_board_construct (CCM_TYPE_STORY_BOARD, screen, name, ignore);
}


static void ccm_story_board_on_event (CCMStoryBoard* self, CCMDisplay* display, XEvent* event) {
	GError * _inner_error_;
	GTimeVal _tmp0_ = {0};
	GTimeVal current;
	glong diff;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	_inner_error_ = NULL;
	current = (g_get_current_time (&_tmp0_), _tmp0_);
	diff = ((current.tv_sec * 1000000) + current.tv_usec) - ((self->priv->time.tv_sec * 1000000) + self->priv->time.tv_usec);
	if ((*event).type == MotionNotify) {
		CCMAction* _tmp1_;
		CCMAction* action;
		gboolean insert;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = NULL;
		if (g_list_last (self->priv->actions) != NULL) {
			_tmp1_ = (CCMAction*) g_list_last (self->priv->actions)->data;
		} else {
			_tmp1_ = NULL;
		}
		action = _g_object_ref0 (_tmp1_);
		insert = TRUE;
		if (self->priv->_hint_motion) {
			_tmp2_ = action != NULL;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			if (CCM_IS_ACTION_POINTER_MOTION (action)) {
				ccm_action_pointer_motion_set_event (CCM_ACTION_POINTER_MOTION (action), event);
				ccm_action_set_time ((CCMAction*) CCM_ACTION_POINTER_MOTION (action), (glong) ((gint) (((double) diff) / ((double) 1000))));
				insert = FALSE;
			}
		}
		if (insert) {
			CCMAction* _tmp3_;
			action = (_tmp3_ = (CCMAction*) ccm_action_pointer_motion_new (self->priv->screen, event, diff), _g_object_unref0 (action), _tmp3_);
			self->priv->actions = g_list_append (self->priv->actions, _g_object_ref0 (action));
		}
		_g_object_unref0 (action);
	} else {
		if ((*event).type == ButtonPress) {
			{
				CCMActionPointerPress* action;
				action = ccm_action_pointer_press_new (self->priv->screen, event, diff, self->priv->ignore, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == CCM_ACTION_ERROR) {
						goto __catch0_ccm_action_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				self->priv->actions = g_list_append (self->priv->actions, _g_object_ref0 ((CCMAction*) action));
				_g_object_unref0 (action);
			}
			goto __finally0;
			__catch0_ccm_action_error:
			{
				GError * ex;
				ex = _inner_error_;
				_inner_error_ = NULL;
				{
					ccm_debug (ex->message, NULL);
					_g_error_free0 (ex);
				}
			}
			__finally0:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			if ((*event).type == ButtonRelease) {
				{
					CCMActionPointerRelease* action;
					action = ccm_action_pointer_release_new (self->priv->screen, event, diff, self->priv->ignore, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == CCM_ACTION_ERROR) {
							goto __catch1_ccm_action_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					self->priv->actions = g_list_append (self->priv->actions, _g_object_ref0 ((CCMAction*) action));
					_g_object_unref0 (action);
				}
				goto __finally1;
				__catch1_ccm_action_error:
				{
					GError * ex;
					ex = _inner_error_;
					_inner_error_ = NULL;
					{
						ccm_debug (ex->message, NULL);
						_g_error_free0 (ex);
					}
				}
				__finally1:
				if (_inner_error_ != NULL) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	self->priv->time = current;
}


char* ccm_story_board_to_string (CCMStoryBoard* self, const char* format) {
	char* result;
	char* val;
	char* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	val = g_strdup ("<story-board>\n");
	{
		GList* action_collection;
		GList* action_it;
		action_collection = self->priv->actions;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			CCMAction* action;
			action = _g_object_ref0 ((CCMAction*) action_it->data);
			{
				char* _tmp3_;
				char* _tmp2_;
				char* _tmp1_;
				char* _tmp0_;
				val = (_tmp3_ = g_strconcat (val, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("  ", _tmp0_ = ccm_action_to_string (action, "%ccma"), NULL), "\n", NULL), NULL), _g_free0 (val), _tmp3_);
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				_g_free0 (_tmp0_);
				_g_object_unref0 (action);
			}
		}
	}
	val = (_tmp4_ = g_strconcat (val, "</story-board>\n", NULL), _g_free0 (val), _tmp4_);
	result = val;
	return result;
}


gboolean ccm_story_board_get_hint_motion (CCMStoryBoard* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hint_motion;
	return result;
}


void ccm_story_board_set_hint_motion (CCMStoryBoard* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_hint_motion = value;
	g_object_notify ((GObject *) self, "hint-motion");
}


static void ccm_story_board_class_init (CCMStoryBoardClass * klass) {
	ccm_story_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMStoryBoardPrivate));
	G_OBJECT_CLASS (klass)->get_property = ccm_story_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = ccm_story_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = ccm_story_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CCM_STORY_BOARD_HINT_MOTION, g_param_spec_boolean ("hint-motion", "hint-motion", "hint-motion", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ccm_story_board_instance_init (CCMStoryBoard * self) {
	self->priv = CCM_STORY_BOARD_GET_PRIVATE (self);
}


static void ccm_story_board_finalize (GObject* obj) {
	CCMStoryBoard * self;
	self = CCM_STORY_BOARD (obj);
	_g_object_unref0 (self->priv->screen);
	_g_free0 (self->priv->name);
	_g_list_free0 (self->priv->ignore);
	__g_list_free_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (ccm_story_board_parent_class)->finalize (obj);
}


GType ccm_story_board_get_type (void) {
	return ccm_story_board_type_id;
}


GType ccm_story_board_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMStoryBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_story_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMStoryBoard), 0, (GInstanceInitFunc) ccm_story_board_instance_init, NULL };
	ccm_story_board_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "CCMStoryBoard", &g_define_type_info, 0);
	return ccm_story_board_type_id;
}


static void ccm_story_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CCMStoryBoard * self;
	self = CCM_STORY_BOARD (object);
	switch (property_id) {
		case CCM_STORY_BOARD_HINT_MOTION:
		g_value_set_boolean (value, ccm_story_board_get_hint_motion (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void ccm_story_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CCMStoryBoard * self;
	self = CCM_STORY_BOARD (object);
	switch (property_id) {
		case CCM_STORY_BOARD_HINT_MOTION:
		ccm_story_board_set_hint_motion (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




