# BZFlag rpm spec file
#
# Copyright (c) 1993-2011 Tim Riker
#
# This package is free software;  you can redistribute it and/or
# modify it under the terms of the license found in the file
# named COPYING that should have accompanied this file.
#
# THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

%define name	bzflag
%define version	2.4.0
%define release	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:0}

%define prefix	/usr
%define bzbindir	/usr/bin
%define bzdatadir	/usr/share/%{name}/
%define bzmandir	/usr/man

name:		%{name}
version:	%{version}
release:	%{release}
group:		Recreation/Action
copyright:	Copyright (c) 1993-2011 Tim Riker
packager:	Tim Riker <Tim@Rikers.org>
url:		http://BZFlag.org/
summary:	multiplayer 3D tank battle game
source:		http://download.SourceForge.net/bzflag/%{name}-%{version}.tar.gz
buildroot:	/var/tmp/%{name}-%{version}-%{release}

# all we want here is to remove glide, but RPM does not provide a way. ;-(
# [crs -- mesa 3.1 now uses libGL.so.1 and libGLU.so.1.  also, linking
#  against a mesa built without glide support avoids the glide dependency.]
#autoreqprov: no
#requires: ld-linux.so.2 libMesaGL.so.3 libMesaGLU.so.3 libX11.so.6
#requires: libXext.so.6 libc.so.6 libm.so.6 libstdc++.so.2.9

%description
BZFlag is a networked multiplayer 3D tank battle game, combining
both fast action and strategy.  Free-for-all and capture-the-flag
styles are available.

%prep
%setup -q

%build
%ifarch i386 i486 i586 i686
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"	\
	./configure --prefix=%{prefix} --enable-robots	\
	--host=i386-pc-linux-gnu
%else
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"	\
	./configure --prefix=%{prefix} --enable-robots
%endif

make

%install
make DESTDIR=$RPM_BUILD_ROOT install-strip

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}

# note -- bzflag must be setuid root to use 3Dfx drivers without /dev/3dfx
%files
%defattr(-,root,root)
%dir %{bzdatadir}
%{bzdatadir}/*
%doc %{bzmandir}/man6/*
%doc %{bzmandir}/man5/*
%attr(755,root,root) %{bzbindir}/*
