/*-----------------------------------------------------------*/
/* Block Sorting, Lossless Data Compression Library.         */
/* Static tables of constant values                          */
/*-----------------------------------------------------------*/

/*--

This file is a part of bsc and/or libbsc, a program and a library for
lossless, block-sorting data compression.

   Copyright (c) 2009-2021 Ilya Grebnov <ilya.grebnov@gmail.com>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

Please see the file LICENSE for full copyright information and file AUTHORS
for full list of contributors.

See also the bsc and libbsc web site:
  http://libbsc.com/ for more information.

--*/

#ifndef _LIBBSC_CODER_TABLES_H
#define _LIBBSC_CODER_TABLES_H

#include "../../platform/platform.h"

static const short bsc_stretch_table[4097] =
{
    -2047,-2047,-1952,-1848,-1774,-1717,-1670,-1631,-1597,-1566,-1539,-1515,-1492,-1472,-1453,-1435,
    -1419,-1403,-1388,-1374,-1361,-1349,-1337,-1325,-1314,-1304,-1294,-1284,-1275,-1266,-1257,-1248,
    -1240,-1232,-1224,-1217,-1210,-1203,-1196,-1189,-1182,-1176,-1170,-1164,-1158,-1152,-1146,-1141,
    -1135,-1130,-1125,-1120,-1115,-1110,-1105,-1100,-1095,-1091,-1086,-1082,-1077,-1073,-1069,-1065,
    -1061,-1057,-1053,-1049,-1045,-1041,-1037,-1034,-1030,-1026,-1023,-1019,-1016,-1012,-1009,-1006,
    -1002, -999, -996, -993, -990, -987, -984, -981, -978, -975, -972, -969, -966, -963, -960, -958,
     -955, -952, -949, -947, -944, -941, -939, -936, -934, -931, -929, -926, -924, -921, -919, -917,
     -914, -912, -910, -907, -905, -903, -901, -898, -896, -894, -892, -890, -887, -885, -883, -881,
     -879, -877, -875, -873, -871, -869, -867, -865, -863, -861, -859, -857, -855, -853, -852, -850,
     -848, -846, -844, -842, -841, -839, -837, -835, -834, -832, -830, -828, -827, -825, -823, -822,
     -820, -818, -817, -815, -813, -812, -810, -808, -807, -805, -804, -802, -801, -799, -798, -796,
     -794, -793, -791, -790, -788, -787, -785, -784, -783, -781, -780, -778, -777, -775, -774, -773,
     -771, -770, -768, -767, -766, -764, -763, -762, -760, -759, -757, -756, -755, -754, -752, -751,
     -750, -748, -747, -746, -744, -743, -742, -741, -739, -738, -737, -736, -734, -733, -732, -731,
     -730, -728, -727, -726, -725, -724, -722, -721, -720, -719, -718, -717, -715, -714, -713, -712,
     -711, -710, -709, -707, -706, -705, -704, -703, -702, -701, -700, -699, -698, -696, -695, -694,
     -693, -692, -691, -690, -689, -688, -687, -686, -685, -684, -683, -682, -681, -680, -679, -678,
     -677, -676, -675, -674, -673, -672, -671, -670, -669, -668, -667, -666, -665, -664, -663, -662,
     -661, -660, -659, -658, -657, -656, -655, -654, -653, -652, -652, -651, -650, -649, -648, -647,
     -646, -645, -644, -643, -642, -642, -641, -640, -639, -638, -637, -636, -635, -634, -634, -633,
     -632, -631, -630, -629, -628, -628, -627, -626, -625, -624, -623, -622, -622, -621, -620, -619,
     -618, -617, -617, -616, -615, -614, -613, -613, -612, -611, -610, -609, -608, -608, -607, -606,
     -605, -604, -604, -603, -602, -601, -601, -600, -599, -598, -597, -597, -596, -595, -594, -594,
     -593, -592, -591, -590, -590, -589, -588, -587, -587, -586, -585, -584, -584, -583, -582, -582,
     -581, -580, -579, -579, -578, -577, -576, -576, -575, -574, -574, -573, -572, -571, -571, -570,
     -569, -569, -568, -567, -566, -566, -565, -564, -564, -563, -562, -562, -561, -560, -559, -559,
     -558, -557, -557, -556, -555, -555, -554, -553, -553, -552, -551, -551, -550, -549, -549, -548,
     -547, -547, -546, -545, -545, -544, -543, -543, -542, -541, -541, -540, -539, -539, -538, -538,
     -537, -536, -536, -535, -534, -534, -533, -532, -532, -531, -531, -530, -529, -529, -528, -527,
     -527, -526, -526, -525, -524, -524, -523, -522, -522, -521, -521, -520, -519, -519, -518, -518,
     -517, -516, -516, -515, -515, -514, -513, -513, -512, -512, -511, -510, -510, -509, -509, -508,
     -507, -507, -506, -506, -505, -504, -504, -503, -503, -502, -502, -501, -500, -500, -499, -499,
     -498, -498, -497, -496, -496, -495, -495, -494, -494, -493, -492, -492, -491, -491, -490, -490,
     -489, -489, -488, -487, -487, -486, -486, -485, -485, -484, -484, -483, -483, -482, -481, -481,
     -480, -480, -479, -479, -478, -478, -477, -477, -476, -475, -475, -474, -474, -473, -473, -472,
     -472, -471, -471, -470, -470, -469, -469, -468, -468, -467, -467, -466, -465, -465, -464, -464,
     -463, -463, -462, -462, -461, -461, -460, -460, -459, -459, -458, -458, -457, -457, -456, -456,
     -455, -455, -454, -454, -453, -453, -452, -452, -451, -451, -450, -450, -449, -449, -448, -448,
     -447, -447, -446, -446, -445, -445, -444, -444, -443, -443, -442, -442, -441, -441, -440, -440,
     -439, -439, -438, -438, -437, -437, -436, -436, -436, -435, -435, -434, -434, -433, -433, -432,
     -432, -431, -431, -430, -430, -429, -429, -428, -428, -427, -427, -427, -426, -426, -425, -425,
     -424, -424, -423, -423, -422, -422, -421, -421, -421, -420, -420, -419, -419, -418, -418, -417,
     -417, -416, -416, -415, -415, -415, -414, -414, -413, -413, -412, -412, -411, -411, -411, -410,
     -410, -409, -409, -408, -408, -407, -407, -407, -406, -406, -405, -405, -404, -404, -403, -403,
     -403, -402, -402, -401, -401, -400, -400, -399, -399, -399, -398, -398, -397, -397, -396, -396,
     -396, -395, -395, -394, -394, -393, -393, -393, -392, -392, -391, -391, -390, -390, -390, -389,
     -389, -388, -388, -387, -387, -387, -386, -386, -385, -385, -385, -384, -384, -383, -383, -382,
     -382, -382, -381, -381, -380, -380, -380, -379, -379, -378, -378, -377, -377, -377, -376, -376,
     -375, -375, -375, -374, -374, -373, -373, -373, -372, -372, -371, -371, -370, -370, -370, -369,
     -369, -368, -368, -368, -367, -367, -366, -366, -366, -365, -365, -364, -364, -364, -363, -363,
     -362, -362, -362, -361, -361, -360, -360, -360, -359, -359, -359, -358, -358, -357, -357, -357,
     -356, -356, -355, -355, -355, -354, -354, -353, -353, -353, -352, -352, -351, -351, -351, -350,
     -350, -350, -349, -349, -348, -348, -348, -347, -347, -346, -346, -346, -345, -345, -345, -344,
     -344, -343, -343, -343, -342, -342, -342, -341, -341, -340, -340, -340, -339, -339, -338, -338,
     -338, -337, -337, -337, -336, -336, -335, -335, -335, -334, -334, -334, -333, -333, -333, -332,
     -332, -331, -331, -331, -330, -330, -330, -329, -329, -328, -328, -328, -327, -327, -327, -326,
     -326, -326, -325, -325, -324, -324, -324, -323, -323, -323, -322, -322, -322, -321, -321, -320,
     -320, -320, -319, -319, -319, -318, -318, -318, -317, -317, -316, -316, -316, -315, -315, -315,
     -314, -314, -314, -313, -313, -313, -312, -312, -311, -311, -311, -310, -310, -310, -309, -309,
     -309, -308, -308, -308, -307, -307, -307, -306, -306, -305, -305, -305, -304, -304, -304, -303,
     -303, -303, -302, -302, -302, -301, -301, -301, -300, -300, -300, -299, -299, -299, -298, -298,
     -298, -297, -297, -296, -296, -296, -295, -295, -295, -294, -294, -294, -293, -293, -293, -292,
     -292, -292, -291, -291, -291, -290, -290, -290, -289, -289, -289, -288, -288, -288, -287, -287,
     -287, -286, -286, -286, -285, -285, -285, -284, -284, -284, -283, -283, -283, -282, -282, -282,
     -281, -281, -281, -280, -280, -280, -279, -279, -279, -278, -278, -278, -277, -277, -277, -276,
     -276, -276, -275, -275, -275, -274, -274, -274, -273, -273, -273, -272, -272, -272, -271, -271,
     -271, -270, -270, -270, -269, -269, -269, -268, -268, -268, -267, -267, -267, -266, -266, -266,
     -265, -265, -265, -265, -264, -264, -264, -263, -263, -263, -262, -262, -262, -261, -261, -261,
     -260, -260, -260, -259, -259, -259, -258, -258, -258, -257, -257, -257, -257, -256, -256, -256,
     -255, -255, -255, -254, -254, -254, -253, -253, -253, -252, -252, -252, -251, -251, -251, -250,
     -250, -250, -250, -249, -249, -249, -248, -248, -248, -247, -247, -247, -246, -246, -246, -245,
     -245, -245, -245, -244, -244, -244, -243, -243, -243, -242, -242, -242, -241, -241, -241, -241,
     -240, -240, -240, -239, -239, -239, -238, -238, -238, -237, -237, -237, -236, -236, -236, -236,
     -235, -235, -235, -234, -234, -234, -233, -233, -233, -233, -232, -232, -232, -231, -231, -231,
     -230, -230, -230, -229, -229, -229, -229, -228, -228, -228, -227, -227, -227, -226, -226, -226,
     -226, -225, -225, -225, -224, -224, -224, -223, -223, -223, -223, -222, -222, -222, -221, -221,
     -221, -220, -220, -220, -220, -219, -219, -219, -218, -218, -218, -217, -217, -217, -217, -216,
     -216, -216, -215, -215, -215, -214, -214, -214, -214, -213, -213, -213, -212, -212, -212, -212,
     -211, -211, -211, -210, -210, -210, -209, -209, -209, -209, -208, -208, -208, -207, -207, -207,
     -207, -206, -206, -206, -205, -205, -205, -204, -204, -204, -204, -203, -203, -203, -202, -202,
     -202, -202, -201, -201, -201, -200, -200, -200, -200, -199, -199, -199, -198, -198, -198, -197,
     -197, -197, -197, -196, -196, -196, -195, -195, -195, -195, -194, -194, -194, -193, -193, -193,
     -193, -192, -192, -192, -191, -191, -191, -191, -190, -190, -190, -189, -189, -189, -189, -188,
     -188, -188, -187, -187, -187, -187, -186, -186, -186, -185, -185, -185, -185, -184, -184, -184,
     -183, -183, -183, -183, -182, -182, -182, -181, -181, -181, -181, -180, -180, -180, -180, -179,
     -179, -179, -178, -178, -178, -178, -177, -177, -177, -176, -176, -176, -176, -175, -175, -175,
     -174, -174, -174, -174, -173, -173, -173, -172, -172, -172, -172, -171, -171, -171, -171, -170,
     -170, -170, -169, -169, -169, -169, -168, -168, -168, -167, -167, -167, -167, -166, -166, -166,
     -166, -165, -165, -165, -164, -164, -164, -164, -163, -163, -163, -162, -162, -162, -162, -161,
     -161, -161, -161, -160, -160, -160, -159, -159, -159, -159, -158, -158, -158, -158, -157, -157,
     -157, -156, -156, -156, -156, -155, -155, -155, -155, -154, -154, -154, -153, -153, -153, -153,
     -152, -152, -152, -152, -151, -151, -151, -150, -150, -150, -150, -149, -149, -149, -149, -148,
     -148, -148, -147, -147, -147, -147, -146, -146, -146, -146, -145, -145, -145, -144, -144, -144,
     -144, -143, -143, -143, -143, -142, -142, -142, -141, -141, -141, -141, -140, -140, -140, -140,
     -139, -139, -139, -139, -138, -138, -138, -137, -137, -137, -137, -136, -136, -136, -136, -135,
     -135, -135, -135, -134, -134, -134, -133, -133, -133, -133, -132, -132, -132, -132, -131, -131,
     -131, -131, -130, -130, -130, -129, -129, -129, -129, -128, -128, -128, -128, -127, -127, -127,
     -127, -126, -126, -126, -125, -125, -125, -125, -124, -124, -124, -124, -123, -123, -123, -123,
     -122, -122, -122, -121, -121, -121, -121, -120, -120, -120, -120, -119, -119, -119, -119, -118,
     -118, -118, -118, -117, -117, -117, -116, -116, -116, -116, -115, -115, -115, -115, -114, -114,
     -114, -114, -113, -113, -113, -113, -112, -112, -112, -111, -111, -111, -111, -110, -110, -110,
     -110, -109, -109, -109, -109, -108, -108, -108, -108, -107, -107, -107, -107, -106, -106, -106,
     -105, -105, -105, -105, -104, -104, -104, -104, -103, -103, -103, -103, -102, -102, -102, -102,
     -101, -101, -101, -101, -100, -100, -100,  -99,  -99,  -99,  -99,  -98,  -98,  -98,  -98,  -97,
      -97,  -97,  -97,  -96,  -96,  -96,  -96,  -95,  -95,  -95,  -95,  -94,  -94,  -94,  -94,  -93,
      -93,  -93,  -92,  -92,  -92,  -92,  -91,  -91,  -91,  -91,  -90,  -90,  -90,  -90,  -89,  -89,
      -89,  -89,  -88,  -88,  -88,  -88,  -87,  -87,  -87,  -87,  -86,  -86,  -86,  -86,  -85,  -85,
      -85,  -85,  -84,  -84,  -84,  -83,  -83,  -83,  -83,  -82,  -82,  -82,  -82,  -81,  -81,  -81,
      -81,  -80,  -80,  -80,  -80,  -79,  -79,  -79,  -79,  -78,  -78,  -78,  -78,  -77,  -77,  -77,
      -77,  -76,  -76,  -76,  -76,  -75,  -75,  -75,  -75,  -74,  -74,  -74,  -74,  -73,  -73,  -73,
      -72,  -72,  -72,  -72,  -71,  -71,  -71,  -71,  -70,  -70,  -70,  -70,  -69,  -69,  -69,  -69,
      -68,  -68,  -68,  -68,  -67,  -67,  -67,  -67,  -66,  -66,  -66,  -66,  -65,  -65,  -65,  -65,
      -64,  -64,  -64,  -64,  -63,  -63,  -63,  -63,  -62,  -62,  -62,  -62,  -61,  -61,  -61,  -61,
      -60,  -60,  -60,  -60,  -59,  -59,  -59,  -59,  -58,  -58,  -58,  -57,  -57,  -57,  -57,  -56,
      -56,  -56,  -56,  -55,  -55,  -55,  -55,  -54,  -54,  -54,  -54,  -53,  -53,  -53,  -53,  -52,
      -52,  -52,  -52,  -51,  -51,  -51,  -51,  -50,  -50,  -50,  -50,  -49,  -49,  -49,  -49,  -48,
      -48,  -48,  -48,  -47,  -47,  -47,  -47,  -46,  -46,  -46,  -46,  -45,  -45,  -45,  -45,  -44,
      -44,  -44,  -44,  -43,  -43,  -43,  -43,  -42,  -42,  -42,  -42,  -41,  -41,  -41,  -41,  -40,
      -40,  -40,  -40,  -39,  -39,  -39,  -39,  -38,  -38,  -38,  -38,  -37,  -37,  -37,  -37,  -36,
      -36,  -36,  -36,  -35,  -35,  -35,  -35,  -34,  -34,  -34,  -34,  -33,  -33,  -33,  -33,  -32,
      -32,  -32,  -32,  -31,  -31,  -31,  -31,  -30,  -30,  -30,  -30,  -29,  -29,  -29,  -29,  -28,
      -28,  -28,  -28,  -27,  -27,  -27,  -27,  -26,  -26,  -26,  -26,  -25,  -25,  -25,  -25,  -24,
      -24,  -24,  -24,  -23,  -23,  -23,  -23,  -22,  -22,  -22,  -22,  -21,  -21,  -21,  -21,  -20,
      -20,  -20,  -20,  -19,  -19,  -19,  -19,  -18,  -18,  -18,  -18,  -17,  -17,  -17,  -17,  -16,
      -16,  -16,  -16,  -15,  -15,  -15,  -15,  -14,  -14,  -14,  -14,  -13,  -13,  -13,  -13,  -12,
      -12,  -12,  -12,  -11,  -11,  -11,  -11,  -10,  -10,  -10,  -10,   -9,   -9,   -9,   -9,   -8,
       -8,   -8,   -8,   -7,   -7,   -7,   -7,   -6,   -6,   -6,   -6,   -5,   -5,   -5,   -5,   -4,
       -4,   -4,   -4,   -3,   -3,   -3,   -3,   -2,   -2,   -2,   -2,   -1,   -1,   -1,    0,    0,
        0,    0,    0,    1,    1,    1,    1,    2,    2,    2,    3,    3,    3,    3,    4,    4,
        4,    4,    5,    5,    5,    5,    6,    6,    6,    6,    7,    7,    7,    7,    8,    8,
        8,    8,    9,    9,    9,    9,   10,   10,   10,   10,   11,   11,   11,   11,   12,   12,
       12,   12,   13,   13,   13,   13,   14,   14,   14,   14,   15,   15,   15,   15,   16,   16,
       16,   16,   17,   17,   17,   17,   18,   18,   18,   18,   19,   19,   19,   19,   20,   20,
       20,   20,   21,   21,   21,   21,   22,   22,   22,   22,   23,   23,   23,   23,   24,   24,
       24,   24,   25,   25,   25,   25,   26,   26,   26,   26,   27,   27,   27,   27,   28,   28,
       28,   28,   29,   29,   29,   29,   30,   30,   30,   30,   31,   31,   31,   31,   32,   32,
       32,   32,   33,   33,   33,   33,   34,   34,   34,   34,   35,   35,   35,   35,   36,   36,
       36,   36,   37,   37,   37,   37,   38,   38,   38,   38,   39,   39,   39,   39,   40,   40,
       40,   40,   41,   41,   41,   41,   42,   42,   42,   42,   43,   43,   43,   43,   44,   44,
       44,   44,   45,   45,   45,   45,   46,   46,   46,   46,   47,   47,   47,   47,   48,   48,
       48,   48,   49,   49,   49,   49,   50,   50,   50,   50,   51,   51,   51,   51,   52,   52,
       52,   52,   53,   53,   53,   53,   54,   54,   54,   54,   55,   55,   55,   55,   56,   56,
       56,   56,   57,   57,   57,   57,   58,   58,   58,   59,   59,   59,   59,   60,   60,   60,
       60,   61,   61,   61,   61,   62,   62,   62,   62,   63,   63,   63,   63,   64,   64,   64,
       64,   65,   65,   65,   65,   66,   66,   66,   66,   67,   67,   67,   67,   68,   68,   68,
       68,   69,   69,   69,   69,   70,   70,   70,   70,   71,   71,   71,   71,   72,   72,   72,
       72,   73,   73,   73,   74,   74,   74,   74,   75,   75,   75,   75,   76,   76,   76,   76,
       77,   77,   77,   77,   78,   78,   78,   78,   79,   79,   79,   79,   80,   80,   80,   80,
       81,   81,   81,   81,   82,   82,   82,   82,   83,   83,   83,   83,   84,   84,   84,   85,
       85,   85,   85,   86,   86,   86,   86,   87,   87,   87,   87,   88,   88,   88,   88,   89,
       89,   89,   89,   90,   90,   90,   90,   91,   91,   91,   91,   92,   92,   92,   92,   93,
       93,   93,   94,   94,   94,   94,   95,   95,   95,   95,   96,   96,   96,   96,   97,   97,
       97,   97,   98,   98,   98,   98,   99,   99,   99,   99,  100,  100,  100,  101,  101,  101,
      101,  102,  102,  102,  102,  103,  103,  103,  103,  104,  104,  104,  104,  105,  105,  105,
      105,  106,  106,  106,  107,  107,  107,  107,  108,  108,  108,  108,  109,  109,  109,  109,
      110,  110,  110,  110,  111,  111,  111,  111,  112,  112,  112,  113,  113,  113,  113,  114,
      114,  114,  114,  115,  115,  115,  115,  116,  116,  116,  116,  117,  117,  117,  118,  118,
      118,  118,  119,  119,  119,  119,  120,  120,  120,  120,  121,  121,  121,  121,  122,  122,
      122,  123,  123,  123,  123,  124,  124,  124,  124,  125,  125,  125,  125,  126,  126,  126,
      127,  127,  127,  127,  128,  128,  128,  128,  129,  129,  129,  129,  130,  130,  130,  131,
      131,  131,  131,  132,  132,  132,  132,  133,  133,  133,  133,  134,  134,  134,  135,  135,
      135,  135,  136,  136,  136,  136,  137,  137,  137,  137,  138,  138,  138,  139,  139,  139,
      139,  140,  140,  140,  140,  141,  141,  141,  141,  142,  142,  142,  143,  143,  143,  143,
      144,  144,  144,  144,  145,  145,  145,  146,  146,  146,  146,  147,  147,  147,  147,  148,
      148,  148,  149,  149,  149,  149,  150,  150,  150,  150,  151,  151,  151,  152,  152,  152,
      152,  153,  153,  153,  153,  154,  154,  154,  155,  155,  155,  155,  156,  156,  156,  156,
      157,  157,  157,  158,  158,  158,  158,  159,  159,  159,  159,  160,  160,  160,  161,  161,
      161,  161,  162,  162,  162,  162,  163,  163,  163,  164,  164,  164,  164,  165,  165,  165,
      166,  166,  166,  166,  167,  167,  167,  167,  168,  168,  168,  169,  169,  169,  169,  170,
      170,  170,  171,  171,  171,  171,  172,  172,  172,  172,  173,  173,  173,  174,  174,  174,
      174,  175,  175,  175,  176,  176,  176,  176,  177,  177,  177,  178,  178,  178,  178,  179,
      179,  179,  180,  180,  180,  180,  181,  181,  181,  181,  182,  182,  182,  183,  183,  183,
      183,  184,  184,  184,  185,  185,  185,  185,  186,  186,  186,  187,  187,  187,  187,  188,
      188,  188,  189,  189,  189,  189,  190,  190,  190,  191,  191,  191,  191,  192,  192,  192,
      193,  193,  193,  193,  194,  194,  194,  195,  195,  195,  195,  196,  196,  196,  197,  197,
      197,  197,  198,  198,  198,  199,  199,  199,  200,  200,  200,  200,  201,  201,  201,  202,
      202,  202,  202,  203,  203,  203,  204,  204,  204,  204,  205,  205,  205,  206,  206,  206,
      207,  207,  207,  207,  208,  208,  208,  209,  209,  209,  209,  210,  210,  210,  211,  211,
      211,  212,  212,  212,  212,  213,  213,  213,  214,  214,  214,  214,  215,  215,  215,  216,
      216,  216,  217,  217,  217,  217,  218,  218,  218,  219,  219,  219,  220,  220,  220,  220,
      221,  221,  221,  222,  222,  222,  223,  223,  223,  223,  224,  224,  224,  225,  225,  225,
      226,  226,  226,  226,  227,  227,  227,  228,  228,  228,  229,  229,  229,  229,  230,  230,
      230,  231,  231,  231,  232,  232,  232,  233,  233,  233,  233,  234,  234,  234,  235,  235,
      235,  236,  236,  236,  236,  237,  237,  237,  238,  238,  238,  239,  239,  239,  240,  240,
      240,  241,  241,  241,  241,  242,  242,  242,  243,  243,  243,  244,  244,  244,  245,  245,
      245,  245,  246,  246,  246,  247,  247,  247,  248,  248,  248,  249,  249,  249,  250,  250,
      250,  250,  251,  251,  251,  252,  252,  252,  253,  253,  253,  254,  254,  254,  255,  255,
      255,  256,  256,  256,  257,  257,  257,  257,  258,  258,  258,  259,  259,  259,  260,  260,
      260,  261,  261,  261,  262,  262,  262,  263,  263,  263,  264,  264,  264,  265,  265,  265,
      265,  266,  266,  266,  267,  267,  267,  268,  268,  268,  269,  269,  269,  270,  270,  270,
      271,  271,  271,  272,  272,  272,  273,  273,  273,  274,  274,  274,  275,  275,  275,  276,
      276,  276,  277,  277,  277,  278,  278,  278,  279,  279,  279,  280,  280,  280,  281,  281,
      281,  282,  282,  282,  283,  283,  283,  284,  284,  284,  285,  285,  285,  286,  286,  286,
      287,  287,  287,  288,  288,  288,  289,  289,  289,  290,  290,  290,  291,  291,  291,  292,
      292,  292,  293,  293,  293,  294,  294,  294,  295,  295,  295,  296,  296,  296,  297,  297,
      298,  298,  298,  299,  299,  299,  300,  300,  300,  301,  301,  301,  302,  302,  302,  303,
      303,  303,  304,  304,  304,  305,  305,  305,  306,  306,  307,  307,  307,  308,  308,  308,
      309,  309,  309,  310,  310,  310,  311,  311,  311,  312,  312,  313,  313,  313,  314,  314,
      314,  315,  315,  315,  316,  316,  316,  317,  317,  318,  318,  318,  319,  319,  319,  320,
      320,  320,  321,  321,  322,  322,  322,  323,  323,  323,  324,  324,  324,  325,  325,  326,
      326,  326,  327,  327,  327,  328,  328,  328,  329,  329,  330,  330,  330,  331,  331,  331,
      332,  332,  333,  333,  333,  334,  334,  334,  335,  335,  335,  336,  336,  337,  337,  337,
      338,  338,  338,  339,  339,  340,  340,  340,  341,  341,  342,  342,  342,  343,  343,  343,
      344,  344,  345,  345,  345,  346,  346,  346,  347,  347,  348,  348,  348,  349,  349,  350,
      350,  350,  351,  351,  351,  352,  352,  353,  353,  353,  354,  354,  355,  355,  355,  356,
      356,  357,  357,  357,  358,  358,  359,  359,  359,  360,  360,  360,  361,  361,  362,  362,
      362,  363,  363,  364,  364,  364,  365,  365,  366,  366,  366,  367,  367,  368,  368,  368,
      369,  369,  370,  370,  370,  371,  371,  372,  372,  373,  373,  373,  374,  374,  375,  375,
      375,  376,  376,  377,  377,  377,  378,  378,  379,  379,  380,  380,  380,  381,  381,  382,
      382,  382,  383,  383,  384,  384,  385,  385,  385,  386,  386,  387,  387,  387,  388,  388,
      389,  389,  390,  390,  390,  391,  391,  392,  392,  393,  393,  393,  394,  394,  395,  395,
      396,  396,  396,  397,  397,  398,  398,  399,  399,  399,  400,  400,  401,  401,  402,  402,
      403,  403,  403,  404,  404,  405,  405,  406,  406,  407,  407,  407,  408,  408,  409,  409,
      410,  410,  411,  411,  411,  412,  412,  413,  413,  414,  414,  415,  415,  415,  416,  416,
      417,  417,  418,  418,  419,  419,  420,  420,  421,  421,  421,  422,  422,  423,  423,  424,
      424,  425,  425,  426,  426,  427,  427,  427,  428,  428,  429,  429,  430,  430,  431,  431,
      432,  432,  433,  433,  434,  434,  435,  435,  436,  436,  436,  437,  437,  438,  438,  439,
      439,  440,  440,  441,  441,  442,  442,  443,  443,  444,  444,  445,  445,  446,  446,  447,
      447,  448,  448,  449,  449,  450,  450,  451,  451,  452,  452,  453,  453,  454,  454,  455,
      455,  456,  456,  457,  457,  458,  458,  459,  459,  460,  460,  461,  461,  462,  462,  463,
      463,  464,  464,  465,  465,  466,  467,  467,  468,  468,  469,  469,  470,  470,  471,  471,
      472,  472,  473,  473,  474,  474,  475,  475,  476,  477,  477,  478,  478,  479,  479,  480,
      480,  481,  481,  482,  483,  483,  484,  484,  485,  485,  486,  486,  487,  487,  488,  489,
      489,  490,  490,  491,  491,  492,  492,  493,  494,  494,  495,  495,  496,  496,  497,  498,
      498,  499,  499,  500,  500,  501,  502,  502,  503,  503,  504,  504,  505,  506,  506,  507,
      507,  508,  509,  509,  510,  510,  511,  512,  512,  513,  513,  514,  515,  515,  516,  516,
      517,  518,  518,  519,  519,  520,  521,  521,  522,  522,  523,  524,  524,  525,  526,  526,
      527,  527,  528,  529,  529,  530,  531,  531,  532,  532,  533,  534,  534,  535,  536,  536,
      537,  538,  538,  539,  539,  540,  541,  541,  542,  543,  543,  544,  545,  545,  546,  547,
      547,  548,  549,  549,  550,  551,  551,  552,  553,  553,  554,  555,  555,  556,  557,  557,
      558,  559,  559,  560,  561,  562,  562,  563,  564,  564,  565,  566,  566,  567,  568,  569,
      569,  570,  571,  571,  572,  573,  574,  574,  575,  576,  576,  577,  578,  579,  579,  580,
      581,  582,  582,  583,  584,  584,  585,  586,  587,  587,  588,  589,  590,  590,  591,  592,
      593,  594,  594,  595,  596,  597,  597,  598,  599,  600,  601,  601,  602,  603,  604,  604,
      605,  606,  607,  608,  608,  609,  610,  611,  612,  613,  613,  614,  615,  616,  617,  617,
      618,  619,  620,  621,  622,  622,  623,  624,  625,  626,  627,  628,  628,  629,  630,  631,
      632,  633,  634,  634,  635,  636,  637,  638,  639,  640,  641,  642,  642,  643,  644,  645,
      646,  647,  648,  649,  650,  651,  652,  652,  653,  654,  655,  656,  657,  658,  659,  660,
      661,  662,  663,  664,  665,  666,  667,  668,  669,  670,  671,  672,  673,  674,  675,  676,
      677,  678,  679,  680,  681,  682,  683,  684,  685,  686,  687,  688,  689,  690,  691,  692,
      693,  694,  695,  696,  698,  699,  700,  701,  702,  703,  704,  705,  706,  707,  709,  710,
      711,  712,  713,  714,  715,  717,  718,  719,  720,  721,  722,  724,  725,  726,  727,  728,
      730,  731,  732,  733,  734,  736,  737,  738,  739,  741,  742,  743,  744,  746,  747,  748,
      750,  751,  752,  754,  755,  756,  757,  759,  760,  762,  763,  764,  766,  767,  768,  770,
      771,  773,  774,  775,  777,  778,  780,  781,  783,  784,  785,  787,  788,  790,  791,  793,
      794,  796,  798,  799,  801,  802,  804,  805,  807,  808,  810,  812,  813,  815,  817,  818,
      820,  822,  823,  825,  827,  828,  830,  832,  834,  835,  837,  839,  841,  842,  844,  846,
      848,  850,  852,  853,  855,  857,  859,  861,  863,  865,  867,  869,  871,  873,  875,  877,
      879,  881,  883,  885,  887,  890,  892,  894,  896,  898,  901,  903,  905,  907,  910,  912,
      914,  917,  919,  921,  924,  926,  929,  931,  934,  936,  939,  941,  944,  947,  949,  952,
      955,  958,  960,  963,  966,  969,  972,  975,  978,  981,  984,  987,  990,  993,  996,  999,
     1002, 1006, 1009, 1012, 1016, 1019, 1023, 1026, 1030, 1034, 1037, 1041, 1045, 1049, 1053, 1057,
     1061, 1065, 1069, 1073, 1077, 1082, 1086, 1091, 1095, 1100, 1105, 1110, 1115, 1120, 1125, 1130,
     1135, 1141, 1146, 1152, 1158, 1164, 1170, 1176, 1182, 1189, 1196, 1203, 1210, 1217, 1224, 1232,
     1240, 1248, 1257, 1266, 1275, 1284, 1294, 1304, 1314, 1325, 1337, 1349, 1361, 1374, 1388, 1403,
     1419, 1435, 1453, 1472, 1492, 1515, 1539, 1566, 1597, 1631, 1670, 1717, 1774, 1848, 1952, 2047,
     2047
};

static const short bsc_squash_table[4097] =
{
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    4,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
        7,    7,    7,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,   11,   12,   12,   12,   12,
       12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   14,   14,   14,   14,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   16,   16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   18,   18,   18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,   20,
       20,   20,   20,   20,   20,   20,   20,   20,   20,   20,   20,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   23,   23,   23,   23,   23,   23,   23,   23,   23,   23,   23,   24,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   28,   28,   28,   28,   28,   28,   28,   28,   28,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   30,   30,   30,   30,   30,   30,   30,   30,   30,
       31,   31,   31,   31,   31,   31,   31,   31,   32,   32,   32,   32,   32,   32,   32,   32,
       33,   33,   33,   33,   33,   33,   33,   33,   34,   34,   34,   34,   34,   34,   34,   35,
       35,   35,   35,   35,   35,   35,   36,   36,   36,   36,   36,   36,   36,   37,   37,   37,
       37,   37,   37,   37,   38,   38,   38,   38,   38,   38,   38,   39,   39,   39,   39,   39,
       39,   39,   40,   40,   40,   40,   40,   40,   41,   41,   41,   41,   41,   41,   42,   42,
       42,   42,   42,   42,   43,   43,   43,   43,   43,   43,   44,   44,   44,   44,   44,   44,
       45,   45,   45,   45,   45,   45,   46,   46,   46,   46,   46,   47,   47,   47,   47,   47,
       47,   48,   48,   48,   48,   48,   49,   49,   49,   49,   49,   50,   50,   50,   50,   50,
       51,   51,   51,   51,   51,   52,   52,   52,   52,   52,   53,   53,   53,   53,   53,   54,
       54,   54,   54,   54,   55,   55,   55,   55,   55,   56,   56,   56,   56,   57,   57,   57,
       57,   57,   58,   58,   58,   58,   59,   59,   59,   59,   59,   60,   60,   60,   60,   61,
       61,   61,   61,   62,   62,   62,   62,   63,   63,   63,   63,   64,   64,   64,   64,   65,
       65,   65,   65,   66,   66,   66,   66,   67,   67,   67,   67,   68,   68,   68,   68,   69,
       69,   69,   69,   70,   70,   70,   71,   71,   71,   71,   72,   72,   72,   72,   73,   73,
       73,   74,   74,   74,   74,   75,   75,   75,   76,   76,   76,   76,   77,   77,   77,   78,
       78,   78,   79,   79,   79,   79,   80,   80,   80,   81,   81,   81,   82,   82,   82,   83,
       83,   83,   84,   84,   84,   85,   85,   85,   86,   86,   86,   87,   87,   87,   88,   88,
       88,   89,   89,   89,   90,   90,   90,   91,   91,   91,   92,   92,   92,   93,   93,   93,
       94,   94,   95,   95,   95,   96,   96,   96,   97,   97,   97,   98,   98,   99,   99,   99,
      100,  100,  100,  101,  101,  102,  102,  102,  103,  103,  104,  104,  104,  105,  105,  106,
      106,  106,  107,  107,  108,  108,  108,  109,  109,  110,  110,  111,  111,  111,  112,  112,
      113,  113,  114,  114,  114,  115,  115,  116,  116,  117,  117,  118,  118,  118,  119,  119,
      120,  120,  121,  121,  122,  122,  123,  123,  123,  124,  124,  125,  125,  126,  126,  127,
      127,  128,  128,  129,  129,  130,  130,  131,  131,  132,  132,  133,  133,  134,  134,  135,
      135,  136,  136,  137,  137,  138,  138,  139,  139,  140,  140,  141,  142,  142,  143,  143,
      144,  144,  145,  145,  146,  146,  147,  148,  148,  149,  149,  150,  150,  151,  152,  152,
      153,  153,  154,  154,  155,  156,  156,  157,  157,  158,  159,  159,  160,  160,  161,  162,
      162,  163,  163,  164,  165,  165,  166,  166,  167,  168,  168,  169,  170,  170,  171,  172,
      172,  173,  174,  174,  175,  175,  176,  177,  177,  178,  179,  179,  180,  181,  181,  182,
      183,  184,  184,  185,  186,  186,  187,  188,  188,  189,  190,  191,  191,  192,  193,  193,
      194,  195,  196,  196,  197,  198,  199,  199,  200,  201,  201,  202,  203,  204,  205,  205,
      206,  207,  208,  208,  209,  210,  211,  211,  212,  213,  214,  215,  215,  216,  217,  218,
      219,  219,  220,  221,  222,  223,  224,  224,  225,  226,  227,  228,  229,  229,  230,  231,
      232,  233,  234,  235,  235,  236,  237,  238,  239,  240,  241,  242,  242,  243,  244,  245,
      246,  247,  248,  249,  250,  251,  252,  252,  253,  254,  255,  256,  257,  258,  259,  260,
      261,  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
      277,  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
      293,  294,  295,  296,  297,  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,  310,
      311,  312,  313,  314,  315,  316,  317,  319,  320,  321,  322,  323,  324,  326,  327,  328,
      329,  330,  331,  333,  334,  335,  336,  337,  339,  340,  341,  342,  344,  345,  346,  347,
      348,  350,  351,  352,  353,  355,  356,  357,  359,  360,  361,  362,  364,  365,  366,  368,
      369,  370,  371,  373,  374,  375,  377,  378,  379,  381,  382,  384,  385,  386,  388,  389,
      390,  392,  393,  395,  396,  397,  399,  400,  402,  403,  404,  406,  407,  409,  410,  412,
      413,  414,  416,  417,  419,  420,  422,  423,  425,  426,  428,  429,  431,  432,  434,  435,
      437,  438,  440,  441,  443,  444,  446,  448,  449,  451,  452,  454,  455,  457,  459,  460,
      462,  463,  465,  467,  468,  470,  471,  473,  475,  476,  478,  480,  481,  483,  485,  486,
      488,  490,  491,  493,  495,  496,  498,  500,  501,  503,  505,  507,  508,  510,  512,  514,
      515,  517,  519,  521,  522,  524,  526,  528,  530,  531,  533,  535,  537,  539,  541,  542,
      544,  546,  548,  550,  552,  553,  555,  557,  559,  561,  563,  565,  567,  569,  571,  572,
      574,  576,  578,  580,  582,  584,  586,  588,  590,  592,  594,  596,  598,  600,  602,  604,
      606,  608,  610,  612,  614,  616,  618,  620,  622,  624,  626,  628,  631,  633,  635,  637,
      639,  641,  643,  645,  647,  650,  652,  654,  656,  658,  660,  663,  665,  667,  669,  671,
      673,  676,  678,  680,  682,  685,  687,  689,  691,  694,  696,  698,  700,  703,  705,  707,
      709,  712,  714,  716,  719,  721,  723,  726,  728,  730,  733,  735,  737,  740,  742,  745,
      747,  749,  752,  754,  757,  759,  761,  764,  766,  769,  771,  774,  776,  778,  781,  783,
      786,  788,  791,  793,  796,  798,  801,  803,  806,  809,  811,  814,  816,  819,  821,  824,
      826,  829,  832,  834,  837,  839,  842,  845,  847,  850,  853,  855,  858,  860,  863,  866,
      868,  871,  874,  877,  879,  882,  885,  887,  890,  893,  896,  898,  901,  904,  907,  909,
      912,  915,  918,  920,  923,  926,  929,  932,  934,  937,  940,  943,  946,  949,  951,  954,
      957,  960,  963,  966,  969,  972,  975,  977,  980,  983,  986,  989,  992,  995,  998, 1001,
     1004, 1007, 1010, 1013, 1016, 1019, 1022, 1025, 1028, 1031, 1034, 1037, 1040, 1043, 1046, 1049,
     1052, 1055, 1058, 1061, 1064, 1067, 1070, 1073, 1077, 1080, 1083, 1086, 1089, 1092, 1095, 1098,
     1102, 1105, 1108, 1111, 1114, 1117, 1120, 1124, 1127, 1130, 1133, 1136, 1140, 1143, 1146, 1149,
     1153, 1156, 1159, 1162, 1165, 1169, 1172, 1175, 1179, 1182, 1185, 1188, 1192, 1195, 1198, 1202,
     1205, 1208, 1212, 1215, 1218, 1222, 1225, 1228, 1232, 1235, 1238, 1242, 1245, 1249, 1252, 1255,
     1259, 1262, 1266, 1269, 1272, 1276, 1279, 1283, 1286, 1290, 1293, 1296, 1300, 1303, 1307, 1310,
     1314, 1317, 1321, 1324, 1328, 1331, 1335, 1338, 1342, 1345, 1349, 1352, 1356, 1360, 1363, 1367,
     1370, 1374, 1377, 1381, 1384, 1388, 1392, 1395, 1399, 1402, 1406, 1410, 1413, 1417, 1420, 1424,
     1428, 1431, 1435, 1439, 1442, 1446, 1450, 1453, 1457, 1461, 1464, 1468, 1472, 1475, 1479, 1483,
     1486, 1490, 1494, 1497, 1501, 1505, 1509, 1512, 1516, 1520, 1524, 1527, 1531, 1535, 1539, 1542,
     1546, 1550, 1554, 1557, 1561, 1565, 1569, 1572, 1576, 1580, 1584, 1588, 1591, 1595, 1599, 1603,
     1607, 1610, 1614, 1618, 1622, 1626, 1630, 1633, 1637, 1641, 1645, 1649, 1653, 1656, 1660, 1664,
     1668, 1672, 1676, 1680, 1683, 1687, 1691, 1695, 1699, 1703, 1707, 1711, 1715, 1718, 1722, 1726,
     1730, 1734, 1738, 1742, 1746, 1750, 1754, 1758, 1761, 1765, 1769, 1773, 1777, 1781, 1785, 1789,
     1793, 1797, 1801, 1805, 1809, 1813, 1817, 1820, 1824, 1828, 1832, 1836, 1840, 1844, 1848, 1852,
     1856, 1860, 1864, 1868, 1872, 1876, 1880, 1884, 1888, 1892, 1896, 1900, 1904, 1908, 1912, 1916,
     1920, 1924, 1928, 1932, 1936, 1940, 1944, 1948, 1952, 1956, 1960, 1964, 1968, 1972, 1976, 1980,
     1984, 1988, 1992, 1996, 2000, 2004, 2008, 2012, 2016, 2020, 2024, 2028, 2032, 2036, 2040, 2044,
     2048, 2052, 2056, 2059, 2063, 2067, 2071, 2075, 2079, 2083, 2087, 2091, 2095, 2099, 2103, 2107,
     2111, 2115, 2119, 2123, 2127, 2131, 2135, 2139, 2143, 2147, 2151, 2155, 2159, 2163, 2167, 2171,
     2175, 2179, 2183, 2187, 2191, 2195, 2199, 2203, 2207, 2211, 2215, 2219, 2223, 2227, 2231, 2235,
     2239, 2243, 2247, 2251, 2255, 2259, 2263, 2267, 2271, 2275, 2279, 2282, 2286, 2290, 2294, 2298,
     2302, 2306, 2310, 2314, 2318, 2322, 2326, 2330, 2334, 2338, 2341, 2345, 2349, 2353, 2357, 2361,
     2365, 2369, 2373, 2377, 2381, 2384, 2388, 2392, 2396, 2400, 2404, 2408, 2412, 2416, 2419, 2423,
     2427, 2431, 2435, 2439, 2443, 2446, 2450, 2454, 2458, 2462, 2466, 2469, 2473, 2477, 2481, 2485,
     2489, 2492, 2496, 2500, 2504, 2508, 2511, 2515, 2519, 2523, 2527, 2530, 2534, 2538, 2542, 2545,
     2549, 2553, 2557, 2560, 2564, 2568, 2572, 2575, 2579, 2583, 2587, 2590, 2594, 2598, 2602, 2605,
     2609, 2613, 2616, 2620, 2624, 2627, 2631, 2635, 2638, 2642, 2646, 2649, 2653, 2657, 2660, 2664,
     2668, 2671, 2675, 2679, 2682, 2686, 2689, 2693, 2697, 2700, 2704, 2707, 2711, 2715, 2718, 2722,
     2725, 2729, 2732, 2736, 2739, 2743, 2747, 2750, 2754, 2757, 2761, 2764, 2768, 2771, 2775, 2778,
     2782, 2785, 2789, 2792, 2796, 2799, 2803, 2806, 2809, 2813, 2816, 2820, 2823, 2827, 2830, 2833,
     2837, 2840, 2844, 2847, 2850, 2854, 2857, 2861, 2864, 2867, 2871, 2874, 2877, 2881, 2884, 2887,
     2891, 2894, 2897, 2901, 2904, 2907, 2911, 2914, 2917, 2920, 2924, 2927, 2930, 2934, 2937, 2940,
     2943, 2946, 2950, 2953, 2956, 2959, 2963, 2966, 2969, 2972, 2975, 2979, 2982, 2985, 2988, 2991,
     2994, 2997, 3001, 3004, 3007, 3010, 3013, 3016, 3019, 3022, 3026, 3029, 3032, 3035, 3038, 3041,
     3044, 3047, 3050, 3053, 3056, 3059, 3062, 3065, 3068, 3071, 3074, 3077, 3080, 3083, 3086, 3089,
     3092, 3095, 3098, 3101, 3104, 3107, 3110, 3113, 3116, 3118, 3121, 3124, 3127, 3130, 3133, 3136,
     3139, 3142, 3144, 3147, 3150, 3153, 3156, 3159, 3161, 3164, 3167, 3170, 3173, 3175, 3178, 3181,
     3184, 3186, 3189, 3192, 3195, 3197, 3200, 3203, 3206, 3208, 3211, 3214, 3216, 3219, 3222, 3225,
     3227, 3230, 3233, 3235, 3238, 3240, 3243, 3246, 3248, 3251, 3254, 3256, 3259, 3261, 3264, 3267,
     3269, 3272, 3274, 3277, 3279, 3282, 3284, 3287, 3290, 3292, 3295, 3297, 3300, 3302, 3305, 3307,
     3310, 3312, 3315, 3317, 3319, 3322, 3324, 3327, 3329, 3332, 3334, 3336, 3339, 3341, 3344, 3346,
     3348, 3351, 3353, 3356, 3358, 3360, 3363, 3365, 3367, 3370, 3372, 3374, 3377, 3379, 3381, 3384,
     3386, 3388, 3390, 3393, 3395, 3397, 3399, 3402, 3404, 3406, 3408, 3411, 3413, 3415, 3417, 3420,
     3422, 3424, 3426, 3428, 3430, 3433, 3435, 3437, 3439, 3441, 3443, 3446, 3448, 3450, 3452, 3454,
     3456, 3458, 3460, 3462, 3465, 3467, 3469, 3471, 3473, 3475, 3477, 3479, 3481, 3483, 3485, 3487,
     3489, 3491, 3493, 3495, 3497, 3499, 3501, 3503, 3505, 3507, 3509, 3511, 3513, 3515, 3517, 3519,
     3521, 3523, 3525, 3526, 3528, 3530, 3532, 3534, 3536, 3538, 3540, 3542, 3544, 3545, 3547, 3549,
     3551, 3553, 3555, 3556, 3558, 3560, 3562, 3564, 3566, 3567, 3569, 3571, 3573, 3575, 3576, 3578,
     3580, 3582, 3583, 3585, 3587, 3589, 3590, 3592, 3594, 3596, 3597, 3599, 3601, 3602, 3604, 3606,
     3607, 3609, 3611, 3612, 3614, 3616, 3617, 3619, 3621, 3622, 3624, 3626, 3627, 3629, 3630, 3632,
     3634, 3635, 3637, 3638, 3640, 3642, 3643, 3645, 3646, 3648, 3649, 3651, 3653, 3654, 3656, 3657,
     3659, 3660, 3662, 3663, 3665, 3666, 3668, 3669, 3671, 3672, 3674, 3675, 3677, 3678, 3680, 3681,
     3683, 3684, 3685, 3687, 3688, 3690, 3691, 3693, 3694, 3695, 3697, 3698, 3700, 3701, 3702, 3704,
     3705, 3707, 3708, 3709, 3711, 3712, 3713, 3715, 3716, 3718, 3719, 3720, 3722, 3723, 3724, 3726,
     3727, 3728, 3729, 3731, 3732, 3733, 3735, 3736, 3737, 3738, 3740, 3741, 3742, 3744, 3745, 3746,
     3747, 3749, 3750, 3751, 3752, 3753, 3755, 3756, 3757, 3758, 3760, 3761, 3762, 3763, 3764, 3766,
     3767, 3768, 3769, 3770, 3771, 3773, 3774, 3775, 3776, 3777, 3778, 3780, 3781, 3782, 3783, 3784,
     3785, 3786, 3787, 3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796, 3797, 3798, 3800, 3801, 3802,
     3803, 3804, 3805, 3806, 3807, 3808, 3809, 3810, 3811, 3812, 3813, 3814, 3815, 3816, 3817, 3818,
     3819, 3820, 3821, 3822, 3823, 3824, 3825, 3826, 3827, 3828, 3829, 3830, 3831, 3832, 3833, 3834,
     3835, 3836, 3837, 3838, 3839, 3840, 3841, 3842, 3843, 3843, 3844, 3845, 3846, 3847, 3848, 3849,
     3850, 3851, 3852, 3853, 3853, 3854, 3855, 3856, 3857, 3858, 3859, 3860, 3860, 3861, 3862, 3863,
     3864, 3865, 3866, 3866, 3867, 3868, 3869, 3870, 3871, 3871, 3872, 3873, 3874, 3875, 3876, 3876,
     3877, 3878, 3879, 3880, 3880, 3881, 3882, 3883, 3884, 3884, 3885, 3886, 3887, 3887, 3888, 3889,
     3890, 3890, 3891, 3892, 3893, 3894, 3894, 3895, 3896, 3896, 3897, 3898, 3899, 3899, 3900, 3901,
     3902, 3902, 3903, 3904, 3904, 3905, 3906, 3907, 3907, 3908, 3909, 3909, 3910, 3911, 3911, 3912,
     3913, 3914, 3914, 3915, 3916, 3916, 3917, 3918, 3918, 3919, 3920, 3920, 3921, 3921, 3922, 3923,
     3923, 3924, 3925, 3925, 3926, 3927, 3927, 3928, 3929, 3929, 3930, 3930, 3931, 3932, 3932, 3933,
     3933, 3934, 3935, 3935, 3936, 3936, 3937, 3938, 3938, 3939, 3939, 3940, 3941, 3941, 3942, 3942,
     3943, 3943, 3944, 3945, 3945, 3946, 3946, 3947, 3947, 3948, 3949, 3949, 3950, 3950, 3951, 3951,
     3952, 3952, 3953, 3953, 3954, 3955, 3955, 3956, 3956, 3957, 3957, 3958, 3958, 3959, 3959, 3960,
     3960, 3961, 3961, 3962, 3962, 3963, 3963, 3964, 3964, 3965, 3965, 3966, 3966, 3967, 3967, 3968,
     3968, 3969, 3969, 3970, 3970, 3971, 3971, 3972, 3972, 3972, 3973, 3973, 3974, 3974, 3975, 3975,
     3976, 3976, 3977, 3977, 3977, 3978, 3978, 3979, 3979, 3980, 3980, 3981, 3981, 3981, 3982, 3982,
     3983, 3983, 3984, 3984, 3984, 3985, 3985, 3986, 3986, 3987, 3987, 3987, 3988, 3988, 3989, 3989,
     3989, 3990, 3990, 3991, 3991, 3991, 3992, 3992, 3993, 3993, 3993, 3994, 3994, 3995, 3995, 3995,
     3996, 3996, 3996, 3997, 3997, 3998, 3998, 3998, 3999, 3999, 3999, 4000, 4000, 4000, 4001, 4001,
     4002, 4002, 4002, 4003, 4003, 4003, 4004, 4004, 4004, 4005, 4005, 4005, 4006, 4006, 4006, 4007,
     4007, 4007, 4008, 4008, 4008, 4009, 4009, 4009, 4010, 4010, 4010, 4011, 4011, 4011, 4012, 4012,
     4012, 4013, 4013, 4013, 4014, 4014, 4014, 4015, 4015, 4015, 4016, 4016, 4016, 4016, 4017, 4017,
     4017, 4018, 4018, 4018, 4019, 4019, 4019, 4019, 4020, 4020, 4020, 4021, 4021, 4021, 4021, 4022,
     4022, 4022, 4023, 4023, 4023, 4023, 4024, 4024, 4024, 4024, 4025, 4025, 4025, 4026, 4026, 4026,
     4026, 4027, 4027, 4027, 4027, 4028, 4028, 4028, 4028, 4029, 4029, 4029, 4029, 4030, 4030, 4030,
     4030, 4031, 4031, 4031, 4031, 4032, 4032, 4032, 4032, 4033, 4033, 4033, 4033, 4034, 4034, 4034,
     4034, 4035, 4035, 4035, 4035, 4036, 4036, 4036, 4036, 4036, 4037, 4037, 4037, 4037, 4038, 4038,
     4038, 4038, 4038, 4039, 4039, 4039, 4039, 4040, 4040, 4040, 4040, 4040, 4041, 4041, 4041, 4041,
     4041, 4042, 4042, 4042, 4042, 4042, 4043, 4043, 4043, 4043, 4043, 4044, 4044, 4044, 4044, 4044,
     4045, 4045, 4045, 4045, 4045, 4046, 4046, 4046, 4046, 4046, 4047, 4047, 4047, 4047, 4047, 4048,
     4048, 4048, 4048, 4048, 4048, 4049, 4049, 4049, 4049, 4049, 4050, 4050, 4050, 4050, 4050, 4050,
     4051, 4051, 4051, 4051, 4051, 4051, 4052, 4052, 4052, 4052, 4052, 4052, 4053, 4053, 4053, 4053,
     4053, 4053, 4054, 4054, 4054, 4054, 4054, 4054, 4055, 4055, 4055, 4055, 4055, 4055, 4056, 4056,
     4056, 4056, 4056, 4056, 4056, 4057, 4057, 4057, 4057, 4057, 4057, 4057, 4058, 4058, 4058, 4058,
     4058, 4058, 4058, 4059, 4059, 4059, 4059, 4059, 4059, 4059, 4060, 4060, 4060, 4060, 4060, 4060,
     4060, 4061, 4061, 4061, 4061, 4061, 4061, 4061, 4062, 4062, 4062, 4062, 4062, 4062, 4062, 4062,
     4063, 4063, 4063, 4063, 4063, 4063, 4063, 4063, 4064, 4064, 4064, 4064, 4064, 4064, 4064, 4064,
     4065, 4065, 4065, 4065, 4065, 4065, 4065, 4065, 4065, 4066, 4066, 4066, 4066, 4066, 4066, 4066,
     4066, 4066, 4067, 4067, 4067, 4067, 4067, 4067, 4067, 4067, 4067, 4068, 4068, 4068, 4068, 4068,
     4068, 4068, 4068, 4068, 4069, 4069, 4069, 4069, 4069, 4069, 4069, 4069, 4069, 4069, 4070, 4070,
     4070, 4070, 4070, 4070, 4070, 4070, 4070, 4070, 4071, 4071, 4071, 4071, 4071, 4071, 4071, 4071,
     4071, 4071, 4072, 4072, 4072, 4072, 4072, 4072, 4072, 4072, 4072, 4072, 4072, 4073, 4073, 4073,
     4073, 4073, 4073, 4073, 4073, 4073, 4073, 4073, 4073, 4074, 4074, 4074, 4074, 4074, 4074, 4074,
     4074, 4074, 4074, 4074, 4074, 4075, 4075, 4075, 4075, 4075, 4075, 4075, 4075, 4075, 4075, 4075,
     4075, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4076, 4077, 4077,
     4077, 4077, 4077, 4077, 4077, 4077, 4077, 4077, 4077, 4077, 4077, 4077, 4078, 4078, 4078, 4078,
     4078, 4078, 4078, 4078, 4078, 4078, 4078, 4078, 4078, 4078, 4078, 4079, 4079, 4079, 4079, 4079,
     4079, 4079, 4079, 4079, 4079, 4079, 4079, 4079, 4079, 4079, 4079, 4080, 4080, 4080, 4080, 4080,
     4080, 4080, 4080, 4080, 4080, 4080, 4080, 4080, 4080, 4080, 4080, 4081, 4081, 4081, 4081, 4081,
     4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4081, 4082, 4082, 4082,
     4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082, 4082,
     4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083, 4083,
     4083, 4083, 4083, 4083, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084,
     4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4084, 4085, 4085, 4085, 4085, 4085,
     4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085, 4085,
     4085, 4085, 4085, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086,
     4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4086, 4087, 4087,
     4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087,
     4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4087, 4088, 4088, 4088,
     4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088,
     4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4088, 4089,
     4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089,
     4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089, 4089,
     4089, 4089, 4089, 4089, 4089, 4089, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090,
     4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090,
     4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090, 4090,
     4090, 4090, 4090, 4090, 4090, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091,
     4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091,
     4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091,
     4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4091, 4092, 4092,
     4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092,
     4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092,
     4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092,
     4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092,
     4092, 4092, 4092, 4092, 4092, 4092, 4092, 4092, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093, 4093,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094,
     4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4094, 4095,
     4095
};

static const unsigned char model_rank_state_table[32768] =
{
 224,   0,   0,   0,   0,   0,   0,   0, 205,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   6, 176,  18,  11,  35,  46, 124, 159,   6,  75, 207, 180, 229,  24,   0, 234,   6, 176, 124, 231,  53, 209,   0, 110,  62, 176, 243,  53,  41,  38,
   0, 140,   6, 176, 241, 109,  42,  65, 120, 234,   6,  44,  92, 156, 183,  20,   0, 234, 206,  75,  18, 165, 253, 190,   0,  62,  62, 176,  99,  99, 198,  20,
   0,  54,  62, 176, 109,  42, 111, 244,   0,  74,  62, 176, 219, 170,  42,   0,   0,  21,  62, 241, 138,   5, 167,  12,   0, 107, 110, 176,   5, 218, 111, 183,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 234,  74, 254, 161, 180,   0,   0,   0,  16, 228, 176, 127, 232, 197, 166,   0, 141,  21, 197,   5, 212, 182,   0,   0, 246,  21,   3, 211,  92,  35, 150,
   0, 185,  52, 176,   1, 235,  10, 253,   0, 191,  54, 197,   3, 216, 219,  46,   0,  45,  47, 197,  73,  35,   0,  50,   0, 230,   6,   5, 243,  42,  76,  60,
   0,  82,  47, 115, 204,  31, 126, 164,   0, 172,   2, 176, 161,   4,  23,   0,   0,  57,  74,  30, 222,   0,  53,   0,   0,  62,  62, 176,   5, 128, 109, 190,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 159,  26,  89, 192,  99,  62, 187,   0,  47,  74, 176, 194, 156, 216, 218,   0, 234,  62, 207, 153, 166, 167, 180,  23,  62,  62, 176, 122, 170, 231, 120,
   0, 172,  74, 151, 241, 109,  99,  23,   0, 139, 110, 237, 203,  92, 251,  14,   0, 172,  74,   3,  75,  11,   5,   0,   0,  39,  62,  89, 251,  23,  92, 163,
  17, 238, 123,  56, 161,  92, 165, 165,   0,   6, 110, 127, 122,  23, 170,  50,   0,  54,  54, 177, 122, 194,  11, 120,  35, 110, 110, 176,   5,  42, 167, 163,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 118,   0,   0,   0,   0,   0,   0,   0, 233,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  29,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 136,   0,   0,   0,   0,   0,   0,   0, 162,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  16,  71, 189,  18, 138,  12, 233,   0,  22, 214,  75, 153,  28,   0,   0,   0, 159,   2,  44,  99, 181, 243,  68,   0, 238,  30, 202, 128, 132,  46, 221,
   0, 141, 119,  91, 115, 124,  65, 159,   0,  16, 135,  94,  74,  17,   0,   0,   0, 191, 106, 110, 166,   0, 116, 108,   0, 136,  22,  75, 119, 208, 244,   0,
   0,  47,   6, 176, 156, 180, 231, 112,  78, 103,   6, 254, 194,  18, 153,   0,   0,  58, 206,   3, 217, 188,   0, 229,   0,   6,  74, 241,  18, 157, 204, 252,
 238,   0,   0,   0,   0,   0,   0,   0, 136,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 145,  74,  62, 241, 255, 107,   0,   0, 159, 110,  49, 176,  86,  92,  49,   0,  22, 223, 240, 194, 178,  56, 168, 108,  54,  74, 176, 194,  28,  28, 180,
   0, 140,  74, 241,   3, 157, 221, 120,   0,  10,   2, 127, 106, 165, 239,   0,   0,   8, 117,  91,  18,  96, 112,  46,   0,  74,  62,  69, 174, 218, 224,  73,
   0, 238, 110, 176, 232, 144,  28,  46,   0, 110,  62,  32, 199, 194, 221, 254,   0,  52,   2, 176,   5,  35,  42,  50,  12, 110,  62, 176, 138,  53,  60,  24,
 238,   0,   0,   0,   0,   0,   0,   0,  84,   0,   0,   0,   0,   0,   0,   0,  87,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 185, 234,  40, 161, 198, 220, 203,   0,  16, 234,  49, 237, 197, 239,  19,   0,  87,  57,  85, 126, 195,  62,   0,   0,  96, 235, 148, 210, 219,   0,   0,
   0, 185,   6,  75, 219, 232, 250, 218,   0, 141,   6,  49, 129, 243, 195,   0,   0,  58,   2, 219, 195, 233,   0,   0, 231, 201,  85,  79,  73, 206,   0, 253,
   0,  19, 110,   3, 219,  42,  20,   0,   0,  54,  74,  31, 122, 198,  32, 253,   0,  58,   6, 169, 176,  94,  53,   0,   0, 172,  62, 176,   5, 109, 231, 168,
  64,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  34,   0,   0,   0,   0,   0,   0,   0,  34,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 226,   0,   0,   0,   0,   0,   0,
   0,  16,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 162,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  45,   0,   0,   0,   0,   0,   0,   0, 136,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 162,   0,   0,   0,   0,   0,   0,   0, 119,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 228,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 175,   0,   0,   0,   0,   0,   0,   0, 118,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
   0,  54,  62, 176, 216,  42, 100, 221,   0,   8,  74, 176,  18,  86,  12, 244,   0,   6,   6, 217, 156, 128, 149, 231,   0, 238, 110, 176, 109, 218, 231, 111,
   0,  54,  74, 176, 192, 144, 232,  20,   0,  57,  74,  62,  31,  42,   0,   0,   0, 141,  22, 192, 208,  42,   0,  20,   0, 107,  62, 176,  99,  18, 126, 128,
 180,  74,  62, 176,   5, 128, 144,  17,  12,  47,  74, 176, 219, 170, 168,  20, 179,  74,  62,  13,   5, 166, 187, 167,   0, 110, 110, 176,   5, 144, 126, 120,
   1,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  83,   0,   0,   0,   0,   0,   0,   0, 233,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  33,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,  26,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   1,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 139,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  82,  94, 204, 141,   0,   0,   0,   0, 237, 174, 240, 180, 203,   0,   0,   0, 134, 110, 204,  92,   0,   0,   0,   0,  62, 176, 161,  42,  76, 198,
  76,   0, 172,  91,  13, 189,  34,   0,   0,   0,   9, 100,  25, 243, 244,   0,   0,   0,   2, 142, 151,  45, 196,  91, 179,   0,  62, 110,   5,  53, 172,  11,
   0,   0,  54,  90, 216, 109, 176, 168,   0,   0,  71,  75, 153, 251,  50, 209,   0,   0, 110,  56,   5, 229,  20,  28, 247,   0, 110, 176, 219,  12, 229, 163,
   1,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 107,  56,  18, 166,  72,   0,  72,   0, 172, 217,   5, 180, 208,  18,   0,   0,  47,  30,  42, 161,  50,   0, 199,   0,  62, 176,  99,  42,  76, 231,
   0,   0, 172, 107, 138, 128,   6, 183,   0,   0,   6,  91, 241, 198, 219, 170,  30,   0,   6, 240,  56,  11, 126, 170,  58,   0,  62, 176,  18, 211,  42,  65,
  53,   0, 233,  56, 161, 166,  35,  17,   0,   0, 110, 176,  99,  92,  28,  50,   0,   0,  62,  62,  99,  72,  76,  46, 221,   0, 110, 241,   5, 218,  17,  17,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   6, 176,   5,  11, 168, 111,   0, 159,   6,  75, 207, 195, 231, 163,  68, 234,   6, 176, 241,  92, 111, 126, 203,  74,  62, 176,   5,  11,  38,   0,
   0, 234,   6, 176,  99, 194, 231, 209,   0, 234, 206, 176,  99, 198, 190, 244,   0, 234, 206, 176,  49, 194,  53, 231,   0, 110,  62, 176,   5,  42, 168, 112,
   0, 110,  62, 176,   5,  42, 198,  28,   0,  47,  62, 176,   5, 109, 165, 137,   0,   6,  62, 176, 153,  72, 187, 231,   0, 110, 110, 176,   5,  42, 168,  24,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,   3, 176,  23,  50,   0,   0, 140,   6,   3, 194, 170, 161, 211,   0, 140,   6, 179, 122,  11,  42, 253,   0, 145,   6, 176, 156, 144,  76,  65,
   0, 234,   6,  40,  72,  23,  53,  30,   0, 234,   6,  69, 219,   5,   7, 211,  85, 141,  22,  30, 219, 203,  81,  86,   0,  47,   6, 176, 207,   5, 231, 108,
   0,  54, 110,  69, 153, 166, 218, 138,   0, 159,   6, 176, 207, 168, 231,   6,   0, 110,  62,  91, 127,   2, 168,  46,   0,  62,  62, 176, 156, 166, 229, 120,
  51,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 246, 110,  89,  56, 109, 109, 203,   0, 246, 110, 176, 219, 144, 218, 111,   0,  54,  62, 176,   5,  42, 157, 221,  20,  54,  62, 176,   5, 218, 168, 190,
   0, 172,  62, 176, 204, 218,  24,   5,   0, 172,  62,  75,  31,  48, 229, 170,   0,  74,   6,  69, 176,  12, 231,  24,   0, 110,  62, 176, 156,  53, 120,   0,
   0,  19, 110,  56, 192, 166, 166, 168,   0,  62, 110, 176, 138, 218, 111, 112,   0,   6, 110, 176, 161, 203, 168, 157,  18, 110, 110, 176,   5, 218, 167, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0,  29,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 254,  71,  48,   0, 152,   0, 136, 228,  69, 148,  28,  56,   0,   0, 162,   2,  10, 146,   0,   0, 219,   0,  57,  21,  94,  85, 245,   0,   0,
   0,  45,   6, 197, 197,  72, 111,   0,   0, 242,  71,   4, 147, 112,   0,  30,   0,  58, 129, 197, 164,   0,   0,   0,   0, 234,  21, 240, 198,  74, 189,  48,
   0, 222,  62,  75, 180,  23, 203,  18,   0, 172,  62,  40, 122, 156, 120,  28,   0,   6,  62,  31,  32,   0,   0,  53,   0,  62, 139,  49,  86,  42, 108, 218,
 181,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  47, 254, 139,   5,   5, 253,  18,   0,  74,  62, 235, 138, 111,  17,  17,   0, 101,  21, 219, 192,   5, 211, 190,   0, 107,  62, 176, 156,  72, 195, 168,
 252, 118,   6, 176,  11,  28,  60, 241,   0,  16,  62,   3, 232, 232,   0, 253,   0, 242, 206,  44, 115,   3, 153, 181,   0, 123,   6,  30,  31, 232,  55,  50,
  23, 172, 110, 176,   5, 109, 111,  38,   0, 172,  62, 176,  99, 144, 167,  50,   0, 139,   6, 176, 122, 231, 108,   8,   0,  62, 176, 176,   5, 128, 168, 209,
  51,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,   4,   5,   2,  31,   0,   0, 140,  52, 204,  73, 136,  38,   0,   0,  87, 206, 179, 128,  23, 105, 192,   0, 228,   6, 241,  18,  72,  53,   0,
   0, 140,   6,  40, 237, 177, 209,   0,   0, 141,   6, 219, 130, 203, 194,   0,   0, 141,  54, 147, 243, 179, 190, 168,   0,  74,  62, 240,  18,  69, 231,  20,
   0, 140,  74,   3, 156,  17,  35, 172,   0, 246,   2, 134, 122, 142, 115,  73,   0, 234,  74,   3, 243, 204,  44,   0,   0, 123,  62, 176, 243, 124,  35,  28,
 181,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 181,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 181,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
   0,  47,   6, 176,  18, 249,  86,  38,   0,  47,  74, 176, 219, 195, 211, 108,   0,  74,  74,  30,  91, 251, 108, 108,   0,  21,  62, 176,  99,  53, 126, 221,
   0, 123,  62,  89, 124, 240, 221, 194,   0,   6,  62, 176,  12,  11, 176,  37,   0,   6, 215,  75,  99, 194,  46, 244,   0,  47, 110,  75,   5,  35,  65,  17,
   0, 123, 110, 176,   5,  53, 111, 112,   0, 254, 110, 176,  31, 109, 126,  28,   0,  74,  62, 176,   5,  20,  76, 190,   0, 110,  62, 176,   5,  11, 111,  17,
  51,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 119,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  54,  89, 166, 145,  45,   0,   0,   0,   6,  75, 132,  20, 212,   0,   0,   0,   6,  30, 195, 195, 211,   0,   0,   0,  62, 176,  99,  72, 187,  20,
   0,   0,  62, 100, 109,  47,   0, 251,   0,   0,  62,  10, 243, 170, 136,   0,   0,   0,  62,  18, 242, 237,  73,   0,   0,   0,  62, 176, 195, 144, 170, 144,
   0,   0,  74,  89, 166,   3, 209,   1,   0,   0, 110,  85, 161, 166, 221, 221,   0,   0,  21,  91, 211, 180, 203, 237,   0,   0, 110, 176,   5, 218, 168, 221,
   1,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  62,  89,   5, 166,  38, 183,   0,   0,  62,  91, 219,  23, 208, 116,   0,   0, 110, 176,  18, 128,  99, 231,   0,   0, 110, 176,   5,  11, 187,  17,
   0,   0,  74, 176, 216,  23, 178, 253,   0,   0,  74,  30, 208, 180,   5,  65,   0,   0, 206, 176, 127, 176, 126, 251,  13,   0,  62, 176,   5, 198, 167, 112,
 211,   0, 110,  56, 161, 166,  35, 168, 100,   0,  62, 176,  18,  11, 168, 168,   0,   0, 110, 176, 122,  42,  72,  24, 214,   0, 110, 176,   5, 218, 167,  50,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  28, 159,   6, 176,  31,  11,  35, 253,   0, 159,   6,  75,   5, 109, 229, 111,   0, 234,   6,  30, 249, 195, 112, 126, 221, 110,  62, 176, 208, 198, 157, 108,
   0, 140,   6, 176,  99, 195,  35, 112,   0, 234,   6, 176, 156,  53, 112,  46,   0, 234,   6,  75,  18,  42,  20, 253,   0,  74,  62, 176, 219,  53,  24,  20,
 238,  54,  62, 176,   5, 109,  28, 190,  74,  74,  62, 176,   5,  42, 120,   0,  12, 110,  62, 176,  18, 198, 163, 231,  98, 110, 110, 176,   5, 218, 183,  50,
 150,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  84,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  16, 133,  89, 161, 214, 198,  20,   0,  57,  21,  44, 192, 177, 187, 231,   0, 141,   6,  91, 208,  33,  20,  99,   0,  54,   6,  30,  23,  53, 218, 112,
 196,  67,   6,  13,  18,  99, 111,  20,   0,  58,  52,  44,  53, 148,   0, 128,   0, 234, 110,  44,   3, 194, 100,  21,   0,  47,   6,  75, 138,  92, 253, 211,
   0, 172,  74, 127,  56,  31,   1,   0,   0,  96,  62, 207,  11, 229, 160,   0,   0, 134, 110,  75, 176, 180,  62,  20, 211, 107,  62, 176, 122, 210, 203,  74,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62,  89, 251, 229, 229, 107,   0,   6,   6,  91,  92, 216, 219, 142,   0,  57,  56, 176,  99,  53,   0, 203,  73, 107,  62, 176, 122, 180, 168,  73,
   0, 172, 233, 176, 161,  56, 157, 126,   0, 110, 110,   5,  99, 132,  18,  88,   0, 134,  62,  75,  73,   0, 180, 116,   0,   2,  74, 176,   5,  28,  17, 157,
   0,  54, 110,  62, 204, 109, 166, 111,   0,  62,  62, 176, 249, 180,  35, 244,   0,   6,  62, 176, 161,  72,  72,  84,   0, 222,  62, 176, 156, 218,  17,  17,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 191,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  62,  75,  99,  56,  28, 221,   0,  45, 215, 100, 211, 147, 144, 104,   0,  45,  22, 217, 211, 219, 140, 143,   0,  26,  62, 100, 174,  72, 220, 120,
   0, 140,  74, 179, 251,  11, 128,  65,   0, 141,   6,  75, 208,  92, 209, 211,   0, 214,  74, 176,  73,  38,  35,  24,   0, 123,   2, 176, 122,  72,  22,  60,
   0, 246,  74, 176, 138, 210,  35, 209,   0,  47,   6,  75,   5,  42,  20,  60,   0,  74,   6, 176, 177, 221,  38, 227,   0, 110,  62, 176,   5, 180,  17, 244,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 159,  74, 176,  99, 198, 157, 221,   0,  47,   6,  30, 122,  92,  23,  25,   0, 230,  62,   4,   5, 170, 127,  50,   0, 254,  62,  30, 208, 198, 218, 120,
 187, 238,  62,  75,  99,  12,  35, 253,   0,  71,   6,  69, 207, 216,  23,  24,   0, 234,  22, 200, 124,  12, 216,  60,  50, 110,  62, 200,   5,  42, 163, 253,
   0, 238,  62, 176,   5, 198,  35, 108,   0,  54,  62, 176,   5, 180, 229,   0,   0,  74,  62, 176, 156, 218, 168, 111,   0,  62, 110, 176,   5, 218, 167, 108,
 238,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  74, 176,  99, 198, 109,  65,   0, 141,   6,  30, 170, 216,  11, 163,   0, 234,   6, 176, 219,  69,   0,  46,   0,  52,  62,  62, 170, 166, 216, 190,
   0, 140,   6, 176,  31, 124,  28, 116,   0, 141,   6,  75,   5, 218, 120, 174,   0, 140,   6,  75, 124,  22,  35,   0,   0,  54,   6,  30,   5, 195,  53, 233,
  46, 246,  74, 176,   5, 195,  35, 221,   0,  47,   6, 176,   5,  12,  50, 137,   0, 110,  62, 176, 208, 128, 120,   0, 237, 110,  62,   3, 122,  42, 198, 168,
  82,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0,  67,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  36,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
 103,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 119,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0,  96,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,  19,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62, 176,  31, 166, 229,  35,   0,  47,  62,  75,  18,  11,  53,  50,   0,  74,   6, 176, 124,  99,  28,  72,   0, 110,  62, 176,   5,  92, 168,  46,
   0,  54,  62, 176,  99,  11, 187, 253,   0,  47,  62, 176,  31,  53,  76, 120,   0,  54,   6, 176,  99, 161,  20, 111,   0, 110,  62, 176, 156, 128, 128,   0,
 212, 110, 110, 176,   5,  42, 168,   0, 187,  74,  62, 176,   5,  11, 231,  65,   0, 110,  62, 176,   5,  11,  76, 190, 167, 110, 110, 176,   5, 144, 167, 190,
 238,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 123,  62, 122,  79, 124,   0,   0,   0,  47,   3,  86, 139,  34,   0,   0,   0,   8, 197,   4, 185, 191,  16,   0,   0,   6,  30, 251, 187, 128, 153,
   0,   0, 110, 123, 232,  18,   6,   2,   0,   0,   6,  89, 153, 198,  65, 196,   0,   0,   6, 235,  40, 220,  97,   0,   0,   0,   6, 115, 211,  42, 241, 167,
   0,   0, 110,  56,  31, 109, 111, 229,   0,   0,   6, 176, 208, 218, 203, 168,   0,   0,  62,  75, 243, 195, 183, 108,   0,   0,  62, 176,   5, 218,  38, 112,
 238,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  62,  56, 161, 166,  35,  48,   0,   0,   6,  89,  90,  42, 110, 176,   0,   0, 110, 241, 249,   5, 168, 128,   0,   0, 110, 176,   5,  42,  53,   0,
   0,   0, 110, 176,  99, 170, 198,  30,   0,   0,   6, 179, 241, 180,  16, 110,   0,   0,  62, 127, 156, 219, 164,  72,   0,   0, 110, 176,   5, 194, 231,  35,
   0,   0, 110,  56, 192, 166, 229,  46,   0,   0, 110, 176,  99,  11, 231, 209, 133,   0, 110, 176,  99,  92, 168, 209, 244,   0, 110, 176,   5, 218, 167,  60,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  25, 159,   6, 176, 207,  42, 231, 221,   0, 159,   6, 176, 207, 203,  28,  46,   0, 140,   6, 176,   5,  92, 111,   0,   0, 110,  62, 176,   5, 170, 167, 244,
   0, 140,   6, 176,  18, 180,  20, 126, 223, 234,   6, 176,  18,  12, 231, 209,   0, 234,   6, 176, 153, 194, 253, 244,   0,  74,  62, 176, 156, 128,  35,  20,
 101, 110,  62, 176,   5,  42, 111, 209, 140, 110,  62, 176,   5, 249,  11,  35,  75,  74,  62, 176, 208, 198, 187,   0, 168, 110,  62, 176,   5, 218, 112, 190,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 103,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  62, 179,   5, 198, 166, 167,   0, 140,  74,  75, 207,  38, 203,  16,   0, 141,   6,  91, 164, 126,  50, 120,   0,  47,   6, 176,  99, 198, 137,   0,
   0, 234,   6, 176, 192, 166, 180, 187,   0, 234,   6, 217,  75, 243, 244, 109,   0, 140,   6,  75,   3, 124,  56, 111,   0,  47,  74, 176,   5,  42,  23, 120,
   0,  62,  62, 176,  18,  53, 108, 163,   0, 119,   6, 176, 153, 210, 120, 190,   0, 110,   6, 100,  30,   5,  50,  20,   0, 110, 110, 176,   5, 144, 168, 221,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  74, 176,   5, 166, 161, 166,   0,  47,  62, 176, 138, 195, 168, 190,   0, 123, 110, 176,   5, 198,  11, 221,   0, 123,  62, 176,   5,  42, 168, 244,
   0, 110,  62, 176,  86, 124,  20, 137,   0,  62,  62, 176, 219, 170,  38,   3,   0,  52, 110,  91,  99, 128, 142, 153, 144,   6,  62, 176,   5, 218, 165,   0,
   0, 107, 110, 176,  99,  92,  28, 167,   0,  74, 110, 176, 243,  42, 126, 209,   0,  74,  62, 176,  99, 195, 218, 116,   0, 110, 110, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,
   0, 150,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
 105, 140,   6, 176,  73,  92,  35,  35,   0, 234,   6, 142, 251, 220,  46, 225,   0, 140,   6,   4,  32, 210, 136, 163,   0,  47,   6,  30,   5,  42,  72, 153,
   0, 141,   6, 176,  18, 177,  35, 190,   0, 141,   6, 174,  92,  72, 253, 221,   0, 234,   6,  30, 243, 137,  50,   0,   0,  54,  62, 176, 124,  72, 229, 180,
   0,  47,  74, 176,   5, 198,  53, 221,   0,  47,   6, 176,   5,  11,  35,  46,   0,  52,  62, 176, 216,  12, 120,  72,   0, 110,  62, 176, 122,  92,  41,  28,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 172,  74, 176, 122,  30,  35,  65,   0,  47,   6, 176, 208,  23,  46,  60,   0,  74,   6,  30, 122,  76, 195,  35,   0, 107,  62, 176,  99,  42,  35,  24,
   0, 123,  62, 176, 156,  12, 209, 245,   0,  74,  62, 100,  99,   5, 231, 224,   0, 234,  62,  75, 208, 128,  28,  24,   0,  47,  62, 176,   5, 194,  35, 168,
   0,  54, 110, 176,   5,  42,  35, 108,   0, 110,  62, 176,   5, 128, 168, 209,   0,  54,  62, 176, 156, 218,  76, 244,   0, 110, 110, 176,   5, 218, 120, 244,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
  46, 140,   6,  75,  18, 180, 165, 163,   0, 234,   6, 176,  31, 122, 168,   0,   0, 234,   6, 179, 208, 170, 208, 163,   0,  74,  62,  75, 161, 187, 229,   0,
   0, 140,   6,  75,  75, 194,  12, 221,   0, 141,   6,  75, 156, 249, 167, 166,   0, 141,   6,   3, 199,   3,  42,  72,   0,   6,  62,  30, 122, 109, 118,  38,
   0,  47,  74, 176,   5, 109,  35, 112,   0,  47,   6, 176, 156,  42, 157,   0,   0, 140,  62, 176,   5,  42,  28,  12,   0, 110,  62, 176,   5,  11,  35,  46,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62, 176,  99,  11, 229, 229,   0,  47,   6,  75, 207,  42, 109,  89,   0, 246,  62, 176, 122, 203, 161,   0,   0, 110,  62, 176,   5, 195, 229,  23,
   0,  54,  62, 176, 176,  11, 165, 111,   0,   6,  74, 176, 207,  12,  38, 108,   0,  74,  62,  30,   5, 192,  20, 221,   0,  47,  62, 176,  99,  42,  76, 183,
 231, 110, 110, 176,   5,  42,  35, 209,  22,  47,  62, 176,   5,  11, 229,  24, 157, 110,  62, 176,   5,  42,  20, 209, 133, 110, 110, 176,   5, 218,  28, 190,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  62,  89, 249, 109, 172,  16,   0,   0,  74, 142,  96, 211, 165, 109,   0,   0,   6,   3, 127,  11, 126, 111,   0,   0, 110, 176,   5, 198,  35,  20,
   0,   0, 110, 176, 153,  23, 166,   1,   0,   0,   6,  56,  75,  99, 108, 183,   0,   0,   6, 176, 207, 203, 116,   0,   0,   0, 110, 176,   5, 180, 167, 108,
   0,   0, 110, 176, 161,  42, 120, 229,   0,   0,   6, 176, 207,  11, 229, 112,   0,   0, 110, 176,   5, 194,  20, 120,  13,   0, 110, 176,   5, 218, 168, 190,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110,  56, 176, 194,  42, 187,   0,   0,  74, 176,  99, 216, 231,  53,   0,   0, 110, 176,   5, 232, 195,  46,  65,   0, 110, 176,   5, 218, 231, 108,
   0,   0, 110, 176,   5,  11, 170, 120,   0,   0, 110,  75, 207,  31,  53, 220,   0,   0,  62,  30,   5,  42, 166, 126, 232,   0, 110, 176,   5, 218, 168, 112,
 194,   0, 110, 176, 192,  42,  35,  46,  80,   0, 110, 176,  18,  42, 229, 116,  19,   0,  62, 176,   5,  42,  38,  60, 120,   0, 110, 176,   5, 218, 120, 190,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 170, 159,   6, 176,  99,  11, 229, 112,   0, 159,   6, 176, 207, 195, 111, 116,   0, 234,   6, 176,  99,  42,  42, 112,   0,  54,  62, 176, 243,   5,  20, 168,
   0, 140,  62, 176,  99, 198, 157, 203,   0, 234,   6,  75,   5,  11,  76, 112,   0, 234,  62, 176,  99, 218,  46, 112,   0,  62,  62, 176, 219,  42,  20, 168,
 237, 238,  62, 176,  18,  42,  42, 183,   0,  54,  62, 176,  99, 168, 120,  60,   0,  62,  62, 176, 156,  42,  11, 244,   0, 110,  62, 176, 156, 128, 231,  65,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 140, 110, 235, 192, 161,  35,  65,   0, 140,  74, 176,   5,  53,  42, 120,   0, 140,  62,   4,  75, 138, 167,  76, 108,  62,  62, 176,   5,  72, 203, 244,
   0, 140,  74,  89, 204,  11, 187,   0,   0,  16,   8,  44, 208,  36, 125,  28,   0, 234,   6,  30,   5, 199,  28,  24,  36,  74,  62, 176,  99, 218, 229, 219,
   0, 172, 107,  89, 161, 128,  56, 244,   0, 123,  62, 176,  18, 128, 168, 157,   0,  62,  62,  69, 156,  12, 168, 126,   0, 233,  62,  69,   5, 218, 221,  46,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 170,  47, 110, 176, 192, 109, 165, 111,  90,  47,  74, 176,   5,  42,  35,  65,   0,  47,   6, 176,  86,  11, 218, 231, 163, 110,  62, 176,   5,  23, 168,  65,
   0,  54, 110, 176, 192, 161, 165,  35,   0,  47,  62, 176,  99, 198,  72, 111,   0,  62,   6,  30,   5,  11,  38, 190,   0,  74,  62, 176, 243, 218,  17, 163,
   0, 238, 110,  56, 192, 166, 165, 183, 240,  47, 110, 176,  31, 180, 165,  46,   0,  54, 110, 176, 156,  72, 180,  65, 163, 110, 110, 176,   5, 218,  38, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  29,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 224,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,   4, 243, 144, 229, 187,   0, 141,   6, 100, 174, 180, 190, 119,   0,  16,   2, 164,  99, 231,   0,   0,   0,   6,  62,  30, 216, 164,   0, 244,
   0, 140,  21, 176,  32,  28, 168, 231,   0, 234,  22, 176, 197, 100, 229, 241,   0,   6,  22, 179,   5,  18,  31,   0,   0,  74, 110, 241,  73,   0, 116,   0,
   0, 172, 110, 176, 219, 218,  92, 231,   0,  47, 110,  30, 156, 180, 253, 244,   0,   2, 110,  49,  11,  50, 170, 174,   0, 172,  62, 176,   5, 194, 128, 108,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 246, 110, 200, 192, 128,  72, 116,   0,  47,  74,  30,   5, 144, 168,  46,   0,   2,  62,  40, 219, 144, 221,  24,   0, 110,  62, 176,  86, 232, 168, 163,
   0, 246, 110, 176, 122, 170, 218,  20,   0,  47, 134, 176,   5, 218, 192, 218,   0,  10,  22, 176,   5, 231,  38,  60,   0,  62, 110, 241,   5,  42, 167,  48,
  65, 238,  62, 176,   5,  42, 168,   0,   0,   6,  62,  75,   5,  92, 229,  24,   0,  74,  62, 176,   5,  72,  42, 209,   0, 110,  62, 176,   5,  12, 167,  65,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  47,  81, 243, 128, 161,  28,   0, 246,   6, 179,  69, 129, 168, 126,   0, 234,  22, 179, 240,   0,   0,   0,   0,  62, 107,   3,  73,  99, 181,  24,
   0,  47,  74,  22, 122, 124,  99, 235,   0, 140,  62,   3, 113,   2,   0,   0,   0,  45,  57,  30, 167, 220,  38,  65,   0,  45, 254, 215, 148,   0,  76,   0,
   0,  19,  62, 176,  18,  23,  46,   1,   0,  74,  22, 176,   5, 111, 190,  46,   0,  62,  62,  75, 179,   0,  60,  20,   0, 110, 176, 176,  99,  23, 209, 157,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 182,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 141,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0,  52,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 246,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 185,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 119,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 136,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0,  10,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 181,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  74, 127, 176, 203,  12, 163,   0, 119,  74,  32, 153, 170,  65, 128,   0, 131,  62,  79, 211,  42,  35,   0,   0, 123,  74, 176,   5, 251, 209,  24,
   0,  54, 228, 115,   5, 109, 249,  41,   0,  21,   6,  91, 198,  49,   0, 209, 249,  62,   6,  75, 127, 170,   0,  38,   0,  54,  62,  89,  86,  18, 231, 120,
   0, 238, 110, 176,   5, 166, 229, 157,   0,   6,  62,  30, 208, 195,  53,  24,   0,  21,  56, 176, 156, 144, 128, 244,   0, 110,  62, 176,   5,  42, 111,  65,
 181,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 107,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  71, 107, 219, 151,  48, 203,   0,   0,   8, 164, 208,  96,  38, 128,   0,   0, 189, 220,  21, 144,   8,   0,   0,   0, 110,  40,   5,  72, 157, 231,
   0,   0,  62, 179, 248, 192,  65, 203,   0,   0, 134, 176, 192, 195,   0,   0,   0,   0,  62, 254, 198,   0, 157,   0,   0,   0,  62, 176, 180, 138, 116,  61,
   0,   0,  74, 107, 122, 109,  76, 228,   0,   0,  74, 127, 219, 198,  11,   0,   0,   0,  74,  75, 241,  23,  73,  38,   0,   0,  62, 176,   5, 144, 157,  17,
 181,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74,  56,  31, 166, 166,  76,   0,   0,  74, 176, 249, 237, 218, 231,   0,   0, 110, 176, 176,   5,  38,  32,  11,   0,  62, 176,   5,  11, 157,  65,
   0,   0,  54,  56, 161, 109, 229,  35,   0,   0, 110,  62, 208,  42,  65,  25,   0,   0,   6,  75, 177,  31,  20, 111,   0,   0, 110, 176,   5, 144, 170, 209,
   0,   0, 233,  56, 192, 166, 165,  17,   0,   0, 110, 176,  31, 195, 112,  65,   0,   0, 110, 176,  99, 170,  11, 183,  77,   0, 110, 176,   5, 218, 167, 190,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
  12, 159,   6,  75,   5,  11,  35, 116,  43, 159,   6, 176, 207,  11, 229, 221,   0, 140,   6, 176,   5,  42,  35, 137,   0,  54,  62, 176,   5,  42,  35, 221,
   0, 234,   6, 176,   5,  12, 157,  38,   0, 234,   6, 176,   5,  11, 120,  50,   0, 234,   6, 176,   5,  92, 231,  50, 126,  47,  62, 176,   5,  42,  38, 253,
   0,  54,  62, 176,   5, 198,  28,   0,   0, 110,  62, 176,   5, 218, 231, 108,   0,  74,  62, 176,   5,  12, 157,  46,  64, 110,  62, 176,   5, 218, 120, 190,
  63,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,   0,   0,  63,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 107,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  53, 111, 187,   0, 140,   6, 176, 219, 170,  35,  50,   0, 140,   6, 176, 207,  11, 165, 111, 199, 246,  74, 176,   5, 218,  35, 209,
   0, 234,  62, 176,  99, 170,  11, 107,   0, 234,   6, 176,   5,  42, 168,  20,   0, 141,   6, 176,   5,  11,  20, 111, 231,  47,   6, 176,   5, 218,  35, 112,
   0,  74,  62, 176, 161, 166, 165, 111,   0,  74,  62, 176,   5, 198, 231, 111,   0,  74,  62, 176, 243,  92,  35,  11,   0, 110,  62, 176,   5, 218, 167,  50,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 166,  47,  74, 176,   5,  92, 165,  28,  98, 246,  74, 176,   5,  42,  35, 112, 232, 172,  74, 176,  99, 198, 187,  46, 221, 172,  62, 176,   5,  42, 168, 209,
 216,  74,  62, 176,  99,  42,  35,  46,   0,  74,  62, 176,   5, 198,  35, 112, 111,  47,   6, 176,   5, 198,  38,  28,  38,  74,  62, 176,   5,  42, 168, 253,
  42, 172, 110, 176, 161,  42, 165,  28, 180, 110, 110, 176,   5,  42,  35,  28,   0, 110,  62, 176,   5,  11, 157, 112, 244, 110, 110, 176,   5, 218, 167, 190,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,  99, 195, 126, 112,   0, 141,   6, 176,   5,   3, 112, 108,   0, 234,   6,  75, 156, 128,  38, 206,   0, 123,  62,  75,  31, 157,   0,   0,
   0, 140,   6, 176, 243, 249, 126, 161,   0, 234,   6, 174, 156,  42, 112,  76,   0, 234,   6,  75,  49,  72,  60, 203,   0,  62,   6,  91, 153, 204,  50, 243,
   0, 172,  62, 176,  99,  53,   0, 120,   0, 123,   6, 176,   5,  11,  12, 231, 186,  52,  62, 176, 211,   5, 214,  60,   0,  62,  62, 176,   5, 166, 198, 203,
 224,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 210,  47,  74, 176,  99, 194,  76, 111,   0, 159,  62, 176,  99, 198, 168,   0,   0,  54,   6,  75,   5, 211,  28, 190,   0, 110,  62, 176,   5, 218, 229, 221,
   0,  54,  62, 176,   5,  53,   0,   0,   0, 246,  62, 176, 156, 120, 221, 204,   0,  22,   6, 176, 208,   5,  50, 221,   0,  74, 110, 176, 219,  72, 198, 126,
   0, 123, 110, 176,   5,  42,  28, 209,   0, 123,  62, 176,   5, 128, 167,   0,   0, 110, 110, 176,   5,  11,  76,  65,   0, 110,  62, 176,   5, 218, 167, 163,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 234,   6, 176,   5, 116,  76,  46,   0, 140,   6,  69, 161, 176, 255,   1,   0, 234,   6,  30, 176, 238,  89,  24,   0,  47,  74, 176, 243,  35, 221, 206,
   0, 141,   6, 117, 219, 155,   0, 249,   0, 140,   6, 217, 177,  17, 194,  38,   0, 234,   6, 179, 122, 109,  72,  50,   0,  47,  62,  75,  18, 243,  35, 179,
   0,  74,  62, 176,   5,  42, 120, 111,   0,  54,   6,  75,  99, 157, 166, 128,   0, 110,   6, 176,  11, 170,  38, 195,   0, 107, 110, 176,   5, 180, 168,  35,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 246,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  67,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62,  75, 122,  12, 157, 209,   0,  47,   6, 176,  99, 211,  28, 190,   0, 140,  62, 176,  56,  72,  53, 229, 153, 123,  62, 176,   5,  92,  38,  46,
   0,  62,  62, 176, 208,   5, 112, 213,   0,   6,   6,  91, 122, 203,  92,  28,   0, 214,   6, 176,  86,  53, 209,  42,   0,  74,  62, 176, 156,  11, 229, 163,
   0,  54,  62, 176,   5, 170,  38, 209,   0,  74,  62, 176,   5, 198, 229, 190,   0,  62,  62, 176,   5, 218,  28, 120,   2, 107,  62, 176,   5, 218, 120, 190,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 181,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110,  74, 251, 126, 168,   0,   0,   0,  74,  69, 249, 248, 221,  30,   0,   0,  62, 176,  18,  42,  11,  77,  23,   0,  62,  30,   5,  72, 109,  46,
   0,   0,   6, 176, 217,  35, 198,  53,   0,   0,   6,  94, 208, 198, 231,  32,   0,   0,   6, 100, 210, 120, 127, 195,   0,   0,  62, 176,   5, 198,  38, 209,
   0,   0, 110, 176,  99, 128,  11, 163,   0,   0, 110, 179,  18, 192, 229, 168,   0,   0,  74, 176, 208,  11,  72,  76,   0,   0, 110, 176,   5, 218,  38, 244,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74,  62,  99,  42,  92, 183,   0,   0, 110, 176,  99, 218,  38, 168,   0,   0,  74, 176,   5,   5,  12, 111,   0,   0, 110, 176,   5, 218, 168,  65,
   0,   0, 110, 176, 161,  11,  38, 163,   0,   0,  74, 176,  31, 198, 203, 111,   0,   0,  74, 176, 219, 218,  11, 231,   0,   0,  62, 176,   5,  42, 167,  41,
 190,   0, 110, 176, 192, 166, 165,  28,   0,   0, 110, 176,   5,  42,  35,   0,   0,   0, 110, 176,   5,  11, 229, 137, 190,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   6, 176,   5, 218,  35, 221, 215, 159,   6,  75, 219,  11, 231,  60,   0, 234,   6, 176, 207, 198, 168, 244,   0,  54,  62, 176,   5,  42,  35, 108,
   0, 140,   6, 176,  99,  11, 111,  65, 157, 234,   6, 176, 124,  53,  76,  41,   0, 234,   6, 176,  73,  23, 120,  60,   0,  74,  62, 176,   5,  23,  60, 244,
   0, 110,  62, 176,  99, 218,  38, 112,   0,  74,  62, 176,   5, 218, 168,  65,   0, 110,  62, 176, 156,  42, 157, 183,   0, 110,  62, 176,   5,  72, 167,  65,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  74,  75, 122, 161,  72, 210,   0, 141,   6, 176,  99, 166,  86, 209,   0, 140,   6,  75, 122, 195, 210, 174,   0, 172,  74, 176,  99, 128, 168, 209,
   0, 234,   6, 176, 204,  72,  11,  76,   0, 140,   6, 176, 124,  40, 111,   2,   0, 140,   6,  75, 122,  53,   5,  75,   0,  47,  62, 176, 156, 243, 138,  50,
   0,  54,  74, 176, 161, 161, 157, 168,   0,   6,  62, 176, 211, 109,  54,  98,   0, 110,  62, 176,  86, 192,  30,  20,   0,  62,  62, 176,   5, 128, 109, 168,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 159,  74, 176, 161, 170, 111, 111,   0, 159,   6, 176,   5,  11,  60, 167,   0,  54,  62, 176,   5, 144, 167,   0,   0, 110,  62, 176,   5, 218, 168,  50,
   0,  54, 110, 176,   5,  42,  35, 209,   0,   6,  62, 176,   5, 128,  76,  28,   0, 234,   6, 176, 241,  12,  12,  76,   0,  74,  62, 176,   5, 218, 167,   0,
 138, 238, 110, 176, 161,  42,  35,  17,   0,  74,  62, 176,  99,  42,  42,  76,   0, 110,  62, 176,   5, 198,  23,  24,  81, 110, 110, 176,   5, 218, 167, 112,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
 125, 140,   6, 176, 124,  11, 168,   0,   0, 141,   6,  75,  99, 128, 187, 221,   0, 234,   6, 176,   5, 195, 231,  35,   0, 107,  62,  44,   5,  23, 180, 126,
   0, 140,   6,  75, 207,  12, 111,   0,   0, 141,   6,  75,   5, 195, 170,  38,   0, 234,   6, 176, 124, 170, 218,  76,   0,  54,  62, 176,  18,  41,  46,  53,
  24, 246,  74, 176,   5,  11, 168, 253,   0,  47,   6, 176,   5,  12,  35, 108,   0, 230,  62, 176,   5,  42,  38,  46,   0, 110,  62, 176,   5, 218, 168, 209,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 246,  74, 176,   5,  42,  38,   0,   0,  47,   6, 176,   5,  42,  38, 112, 129,   6,  62, 176,  99,  92,  42,  65,   0, 110,  62, 176,   5, 218,  76, 137,
 111,  54,  74, 176,   5, 195, 168, 112,   0,  47,  62, 176,   5,  12, 218,  41,   0,   6,  62, 176,   5,  42, 168, 209,   0,  62,  62, 176,   5,  42,  46,   0,
 231, 238, 110, 176,   5,  42, 168, 209,   0,  47,  62, 176,   5,  42, 168, 190, 168,  74,  62, 176,   5, 218, 168, 190,   0,  62,  62, 176,   5, 218, 167, 190,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176, 219, 109, 111, 111,   0, 234,   6,   4,   5, 180, 218, 163,   0, 234,   6,  75, 216,  76, 112, 168,   0,  47,  62, 176, 251,  99,  80,  34,
   0, 140,   6, 176,  99, 195,  20, 126,   0, 141,   6,  75, 153,  11, 219,   0,   0, 140,   6, 179, 156, 249, 112,  46,   0, 246,   6, 179,  30, 203,  65,   0,
   0,  47,  74, 176,   5, 128, 229,  46,   0,  47,   6, 176,  99, 198, 126, 167,   0,  74,   6, 176,   5,  12, 163, 190,   0, 110,  62, 176,   5,  92, 165, 253,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 246,  74, 176,  18, 166,  35,  24,   0, 159,   6, 176,  99,  72,  20, 116,   0,   6,  62, 176,  99,  42,  35, 231,   0, 107,  62, 176,   5, 198, 168, 253,
   0, 172,  62, 176,  99, 210, 168,  24,   0,   6,   6, 176,   5,  53, 187, 120,   0,   6,   2, 217, 153, 232, 231, 137,   0,   6,  62, 176,  99,  42, 167, 163,
  73, 110, 110, 176,   5,  42,  35, 112,   0,  47,  62, 176,   5, 194, 168,   0,   0,  74,  62, 176,   5,  42, 120,  50,   0,  62, 110, 176,   5, 218, 120, 209,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 176, 161,  38, 166,   0,   0,   0,   6, 176,  31,  24, 120, 123,   0,   0, 107, 241, 243,  17,  11, 231,   0,   0,  62, 176, 122, 180, 168,  35,
   0,   0,  74, 176, 192,  11,  65,  17,   0,   0,   6, 179,  31,  62,  20, 255,   0,   0,  62,  89,   3, 198,  85,   0,   0,   0,  62, 176,   5, 203,  92, 253,
   0,   0, 110, 176,   5,  42,  35, 167,   0,   0,  74, 176,   5,  53, 180,  28,   0,   0,  62, 176, 156,  42,  28, 244,   0,   0, 110, 176,   5,  42,  35,  65,
 238,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110, 176,  31, 166, 170,  35,   0,   0,   6, 176, 192,  92, 165,  35,   0,   0,  62, 176,   5, 198, 198,   0,   0,   0, 110, 176,   5, 170,  38,  46,
   0,   0, 110, 176, 161,  42,  35, 229,   0,   0,  74, 176, 138, 128,  35, 157,   0,   0,  62, 176,   5, 218, 126, 163, 231,   0, 110, 176,   5,  12, 229, 244,
 155,   0, 110, 176, 161, 166,  35,  46,  60,   0, 110, 176,   5,  42, 187,   0,   0,   0, 110, 176,   5, 198,  38, 112, 229,   0, 110, 176,   5, 218, 167, 190,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   4, 159,   6, 176,   5,  11, 229, 112, 253, 159,   6, 176,   5, 195,  35,  65,  38, 140,   6, 176,   5, 198, 229, 112,  42,  54,  62, 176,   5,  42,  35, 112,
 122, 140,   6, 176,   5,  11, 229, 126,   0, 234,   6, 176,   5,  42,  20,   0,   1, 234,   6, 176,   5,  11,  35, 137,   0,  74,  62, 176,   5, 218, 231, 112,
 236, 110,  62, 176,  99,  42, 231,  65,   0, 110,  62, 176,   5,  42,  35,  60,   0, 110,  62, 176,   5,  12, 229,   0, 126, 110,  62, 176,   5, 218, 168, 190,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,
 190, 141,   6, 176,  99, 195,  38,  60,   0, 140,   6, 176,   5,  11, 203,  17,   0, 140,   6, 176,   5, 195,  46, 111,   0,  47,  74, 176,   5,  42,  35, 253,
   0, 234,   6, 176, 122,  42,  72, 253,   0, 234,   6, 176,   5, 128, 168, 111,   0, 141,   6, 176,   5,  12,   0, 198,  91,  47,   6, 176,   5,  42, 231,  24,
   2,  74,  62, 176,   5, 203, 126, 187,   0,  74,  62, 176,   5,  42, 187, 120,   0, 110,  62, 176,   5,  11, 218, 187, 218, 110,  62, 176,   5, 218, 168, 190,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 241,  47,  62, 176,   5,  42, 165,  65,  42, 172,  74, 176,   5,  42, 229,  60,  20,  54,  74, 176,   5,  42,  35, 221, 187, 172,  62, 176,   5, 218, 168, 209,
   0,  54,  62, 176,   5,  42,  35, 187,   0,   6,   6, 176,   5, 194, 231, 190, 209,  47,   6, 176,   5,  12, 168, 209, 253,  47,  62, 176,   5, 218, 168, 190,
   0, 110, 110, 176,   5,  42,  35,  28, 180, 110,  62, 176,   5, 198, 231, 112,   0, 110,  62, 176,   5, 218, 229, 112,  20, 110,  62, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,  99,  12,  28,  60,   0, 141,   6, 176,  99, 198,  42, 111,   0, 234,   6, 176,   5, 124,  92,  24,   0,  54,  62, 176,   5, 198,  42, 209,
   0, 140,   6, 176,   5,  11, 111, 111,   0, 141,   6, 176,   5, 203,  76,  28,   0, 234,   6, 176, 219, 218,  23,  28,   0,  54,  62, 176,   5, 198, 120, 180,
   0, 172,  74, 176,   5,  42, 231,  65,  43,  47,   6, 176,   5,  12, 168,   0,   0,  54,  62, 176,   5,  11, 229,  28,   0, 110,  62, 176,   5,  42, 120, 209,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
  94, 172,  74, 176,   5,  42,  35, 209, 148,  47,   6, 176,   5, 198, 231,  46,   0,  54,   6, 176,   5,  42, 157,  65, 227, 110, 110, 176,   5, 218, 168, 112,
   0, 172,  74, 176,   5,  12, 168, 253,   0,  47,   6, 176,   5, 198, 168, 209, 154,   6,  62, 176,   5, 198,  35, 190,   0, 110,  62, 176,   5, 218,  28,   0,
 167, 172, 110, 176,   5,  42, 168, 209,  93,  47,  62, 176,   5, 218, 168, 209, 120,  74,  62, 176,   5, 218, 120,  24,   0, 110,  62, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,  18,  53,  20, 221,   0, 140,   6, 176,   5, 203, 232,   0,   0, 234,   6, 176, 208, 195,  46, 253,   0,  47,  62, 176,   5,  23,  46, 163,
   0, 140,   6, 176,   5, 195, 231, 111,   0, 141,   6, 176,   5, 198,  20, 111,   0, 140,   6, 176,   5,  72, 195, 112, 198, 172,  62, 176,   5,  42,  92, 111,
   0,  47,  62, 176,   5,  42, 229,  60,   0,  47,  74, 176,   5,  11,  35, 108,   0,  54,  62, 176,   5,  11, 187, 137,  42, 110, 110, 176,   5,  42, 167,  24,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 172,  74, 176,   5,  92,  35, 112,   0,  47,  74, 176,   5, 194, 229, 157,   0, 110,  62, 176,   5,  72, 109, 231,   0, 110,  62, 176,   5, 218, 168,  46,
   0,  54,  62, 176,  99,  11, 229, 187,   0,  74,  62, 176,   5,  11, 221,  46,   0,  74,  62, 176,  99,  42,  72,  28,   0, 110,  62, 176,   5,  42,  38, 231,
   0, 123, 110, 176,   5,  42, 168, 112,   0,  74,  62, 176,   5, 218,  38, 112,   0, 110,  62, 176,   5,  11, 120, 163, 166, 110, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 176, 161,  72, 229, 157,   0,   0,  74, 176, 219, 170, 161, 187,   0,   0,  74, 176,   5, 166, 192,   7,   0,   0, 110, 176,   5, 218, 168,  35,
   0,   0,  74, 176,  99, 198,  42,  76,   0,   0,  74, 176,  99, 194, 243, 231,   0,   0,   6, 176, 219, 203,  28, 126, 112,   0, 110, 176,   5,  12, 168, 112,
   0,   0, 110, 176,   5,  42, 231, 111,   0,   0, 110, 176,   5,  42,  35,  46,   0,   0, 110, 176,   5,  92, 229,  60, 168,   0, 110, 176,   5,  42, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110, 176,   5,  92,  38, 111,   0,   0,  74, 176,   5,  42, 229, 111,   0,   0, 110, 176,   5, 218, 120,  46,  12,   0, 110, 176,   5, 218, 168, 209,
   0,   0, 110, 176,  99,  42,  38,  38,   0,   0, 110, 176,   5, 218, 229, 111,   0,   0,  74, 176,   5,  11, 229,  46,  44,   0, 110, 176,   5, 218, 168, 209,
 120,   0, 110, 176,   5,  42, 168,  60, 231,   0, 110, 176,   5,  42, 168, 112, 112,   0, 110, 176,   5, 218, 168,   0,  28,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 207, 159,   6, 176,   5,  11,  35,  65,   0, 159,   6, 176,  31,  11,  28, 253,   0, 234,  22,  75,   5,  23, 194,  76,   0,  62,  62, 176, 216,  11, 244, 120,
 128, 140,   6, 176,  99, 180,  35,  35,   0, 234,  62, 176,   5, 203, 231,  24,   0, 234,   6,  75, 122,  99, 244, 190,   0,  74,  62,  30,   5,  42,  92,   0,
  28,  54,  62, 176,   5,  92,  35,  46,   0,  47,  62,  75,   5, 218, 120, 187,   0,  62,  62, 176,   5, 166, 120, 108,   0, 110, 110, 176,   5, 218,  35, 190,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 181,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0, 213,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  16, 107, 222, 207, 224, 168,   0,   0, 159,  21,  89,  18, 180, 224, 203,   0, 141,  21,  30,  66, 122,  73, 229,   0, 172,   6, 176, 241,  23, 165,  17,
   0,  58,  10, 176,  18,  92, 230,   0,   0,  58,   6, 174,   1, 213, 167,   0,   0, 234,   2, 237,   5,  11, 165,   0,   0,  26,   9,  91, 177,  42, 157,  53,
   0, 123,  54, 254,  56,  72, 170,  23,   0, 134,   6,  62,  11, 128, 195, 218,   0,   9,  21,  91, 251, 187,  76,  70,   0, 123, 254,  30,  99,  92,  23, 108,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 246,  62,  79,   5, 207, 198,  16,   0, 159,  74,  89,  18, 128, 124, 124,   0, 123,  62, 241, 170,  98,  62, 223,   0, 172,  74, 176,   5,  12, 112,  50,
   0,  47,  56, 233, 127, 180, 174, 111,   0, 215,  21,   4, 122,  92, 253,   0,   0, 133,  62,  44, 251, 219,  19,   0,   0, 107, 110, 176,   5, 203, 203,   0,
   0, 238,  62,  56, 192, 166,  35,  46,   0, 110,  62, 241, 122, 166, 128, 209,   0,  74,  62,  30,   5, 198,  76,  38,   0,  62, 110, 176,   5,  23,  35, 163,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 234,   6,  94, 177,  80, 202,   0,   0,  82,   6,  56,  32,  86,   0,   0,   0, 140, 134,  32, 232, 173,   0,   0,   0, 119,  74,  49, 219,   0,   0,   0,
   0, 234, 110, 142, 176, 124, 118, 190,   0, 234,  10, 164,  71, 153,   0,   0,   0, 140, 117, 174, 210,  83, 194,  70,   0,  62, 134,  30, 148, 107,   0,  88,
   0, 123, 123,  69,  18,  42, 110, 220,   0, 145,  74, 179,  75, 209,  72,   0,   0,  71, 223,  49,   5, 208,   0,   0,   0,  62, 110,  30, 218, 198,  38, 168,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  54, 110,  89, 170, 166,  86,   5,   0, 123,   6, 200, 243, 207,  32,  41,   0, 235, 110, 142,   5, 124,   3,   0,   0,  74,  62,  75, 156, 128, 218,   0,
   0, 118,  62,  30,  56, 153,  23, 151,   0,  62,   6, 100, 138, 218,   0,   0,   0,  21,   6, 240, 176,  32, 120, 198,   0,   6,   3, 176, 194,  99, 187, 126,
  35, 238, 110, 176,  18,  11, 231,  46, 126,  74,  62, 176, 122, 203, 244, 221,   0,  10,  74,  75, 251,  72,  76,  17,   0,  62,  62, 176,   5,  42, 120,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,  30,  18, 180,  35, 229,   0, 141,   6, 176, 207,  72,  38, 187,   0, 162,   2, 176,  73,  30, 114, 179,   0, 139, 110, 200,  31, 210,  46,  12,
 240, 140,   6,  91, 207, 128, 229,  76,   0, 141,   6, 179, 210,  85,  23, 209,   0, 214,   6,  30, 217, 218, 153, 209,   0, 123, 139, 177, 217,  28,  24,   0,
   0, 246,  74, 176,  18,  11,  28,  24,   0,  47,  62, 176,  99, 218,  99,   0,   0,   6,  62, 176,   3,  86, 167,  60,   0, 110,  74, 241,  56, 180, 168, 163,
 213,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0,  36,   0,   0,   0,   0,   0,   0,   0,  26,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,
   0, 213,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
 181,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 213,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 136,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
   0, 141,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 162,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 255,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 107,   0,   0,   0,   0,   0,   0,   0,   8,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 222,   0,   0,   0,   0,   0,   0,   0,
 216, 246,  74,  75,   5,  11, 111, 112,   0,  47,   6, 176,   5, 166,  76,  35,   0,   6,   6, 176,   5, 180,  35, 187,   0,  74,  62, 176,   5, 194, 198,  50,
   8,  54,  62, 176, 161,  42, 195,   0,  76,   6,   6, 176, 122,  11, 203,  28,   0,   6,   6, 179, 243, 180,  38,  24,  42,  74,  62, 176, 204, 203, 111,  65,
  50,  54,  74, 176,  99,  42, 168, 209, 117,  74,  62, 176,   5,  92, 229,  65, 221,  74,  62, 176,   5,  42, 157,   0,   0, 110, 110, 176,   5, 128, 120,  41,
 181,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  26, 110, 204, 216, 233, 180,   0,   0,  10,   6,  31, 153,  11, 228,   0,   0,  62,   9, 156,  18,  64,  96,   0,   0, 110, 176, 200, 198, 145, 221,
   0,   0,   6, 222, 169, 156, 170,   0,   0,   0,   2, 237,  75, 218,  53, 190,   0,   0,   6,  91,  30, 198,  10, 229,   0,   0,  62,  30, 156,  72, 203,  46,
   0,   0,  19, 176,  18, 165, 194,  42,   0,   0,  74,  30,  99,  62,  35, 218,   0,   0,   6, 217,  23, 218,  12, 190, 144,   0,  62, 176,   5, 144, 168, 221,
   1,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  62,  89, 192, 161, 166, 111,   0,   0,  74, 176, 216, 180, 198, 112, 121,   0,  62,  13,  31,  23,  11, 112,  21,   0,  62, 176, 243, 218, 231,  60,
   0,   0, 107,  13, 192, 166, 109, 187,   0,   0,   6,  74,  56,  75, 195, 144,   0,   0,   6, 176, 208,  99,  23, 231,   0,   0,  62, 176, 122,  23, 111, 163,
 236,   0, 233,  56, 161, 166, 165, 111,   0,   0,  62, 176,   5, 109,  35, 168,   0,   0, 110, 176,  18, 180,  38,  24,   0,   0, 110, 176,   5, 218, 168,  17,
 224,   0,   0,   0,   0,   0,   0,   0, 205,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   6, 176, 207, 195, 229, 253,   0, 159,   6, 176,   5, 198,  28, 221,   0, 140,   6, 176,   5, 195, 187, 157,   0, 110,  62, 176,   5,  11,  28,  46,
   0, 140,   6, 176,  99,  53, 244, 187,   0, 234,   6, 176, 207, 126, 203, 120,   0, 234,   6, 176,  99,  12,  99, 209,   0,  62,  62, 176,   5,  86, 157,  50,
   0,  54,  62, 176,   5,  42,  11,  24,   0,  74,  62, 176,  99,   5,  38, 221,   0,  74,  62,  30,   5,  72,  28,  35, 229, 110,  62, 176,   5, 128,  46,  65,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 141,   6, 176,  18, 161, 248,  65,   0, 140,  62, 217,   5, 203, 235,  65,   0, 141,   6,  75, 243,  92, 195,  28,   0,  47,  62, 176,   5,  11,  35, 253,
   0, 140,   6,   3, 138, 170, 253,  31,   0, 234,   6, 179, 122,  53,   0,  27,   0, 141,   6,  75, 219,  11,  35,  18,  66, 159,  62, 176,   5,  12,  24, 209,
   0, 123,  54, 176, 204, 210, 162,  12,   0,  62,   6,  69,   3,  92,  59,  46,   0,  54,  62,  91,  86,  42, 253, 182,   0,  74,  62, 176,   5,  72,  23, 108,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  74,   6, 176,   5,  92, 168, 231,   0,  47,  74, 176,   5, 156, 126,  41, 221,  74,  62, 176, 232,   5, 204,  11,   0,  74,  62, 176,   5,  42, 157, 190,
   0,  74,  62, 176, 156,  11,  92, 157,   0, 246,   6,  75, 251,  92, 248,  94,   0,   6, 110, 176, 138, 166,  35,  46,   0,  74,  62, 176,   5,  42,  35, 209,
   0,  62,  62, 176, 161,  92, 187, 190,   0,  62,  62, 176,   5,  11,  35, 108,   0, 110,  62, 176,   5,  42,  28, 116, 190,  62,  62, 176,   5, 218,  76, 190,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0,  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  45,   6, 100,   5,  11,  20,  60,   0, 141,  74, 197, 207,  76,  46, 167,   0, 140,   6,  91, 249, 153, 218,  27,   0,   6,  62, 237, 208, 122, 221,  79,
   0, 141,  74, 176, 241, 198, 120, 218,   0, 140,   6,  94, 166, 161, 157, 253,   0, 234,   6, 176,   3, 243,  26,  92,   0,   6,  74,  30, 208, 120, 226, 166,
   0, 123,  62,  75, 156, 218, 229,  50,   0,  74,  62, 176, 208,  42,  86, 229,   0,   6,  62, 179, 156, 218, 253, 221,   0,  54,  62, 176,   5,  72, 112, 221,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  14,  47,  74, 176,  99, 180,  50, 163,   0,  47,  62,  75, 207, 156, 187, 251,   0,   6, 110, 176, 124,   5, 180,  53,   0, 123,  62, 176,   5, 195, 167, 157,
   0, 140,  62,  75,   5,  53, 195, 180,   0,  62,  62,  75,  18,  12, 111, 190,   0, 234,   2, 176, 219, 120,  17, 209,   0,  74,  62, 176,   5,  12, 168, 190,
   0, 172,  62, 176,   5, 128, 168,  38,   0,  54, 110, 176,  99, 203, 157,  17,   0, 110,  62, 176,  31, 170, 167, 167, 243, 110,  62, 176,   5, 128, 167,  65,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,  75,  18,  92,  23, 194,   0, 159,   6, 100, 156, 243, 229, 228,   0, 234,   6,  44, 243, 180,   0,  97,   0, 107,  62, 176,   5, 166, 109,  18,
   0, 140,   6,  75, 243, 128,  60, 221,   0, 234,   6, 237,   5, 170, 100,   2,   0, 140,   6, 176, 194,  12,  49, 229,   0,  74,   6,  49, 211,   3, 243,  12,
   0,  54,  62, 176,   5, 198,  38,  35,   0,  47,  62,  30,   5, 194, 204, 203,   0,  74,  62,   3,  30,  38, 231, 218,   0,  74,  62, 176,  99, 195, 231, 166,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  74, 176,  99,  23,  35,  17, 209,  47,   6,  75,   5,  11,  23,  60,   0,  47,   6, 176, 207, 156,  38, 166, 193, 110,  62, 176,   5, 109, 231,  28,
   0,  54,  74, 176,  99, 218,  38,  46,   0, 140,   6, 176, 156,  42, 229,  60, 132,   6,  62,  75,   5,  92,  23,  76,   0, 110,  62, 176,   5,  42, 229, 120,
 102, 110,  62, 176,   5,  42,  35,   0, 214, 110,  62, 176,   5, 218, 168, 209,   0,  62,  62, 176,   5,  92, 231, 221,  69,  62,  62, 176,   5, 218, 167,  65,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74,  30, 124,  42,  23, 244,   0,   0,  74,  91, 161,  12, 229, 112,   0,   0,   6,  75,   5, 219,  46,  12,  38,   0, 110, 176,   5, 128,  76,  17,
   0,   0,  62, 176, 243, 208,   5, 253,   0,   0,   6,  75,   5,  72, 209, 253,   0,   0,   6,  75,   5,  76, 229,   0,   0,   0,  62, 176,   5, 170, 231, 163,
   0,   0, 110, 176,  99,  11,  35, 167,   0,   0, 110, 176,   5,  92, 180, 157,   0,   0, 110, 176,   5, 198, 203, 165, 229,   0,  62, 176,   5, 128,  20,  60,
 181,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
 143,   0,  74, 176,  99, 170, 166, 221, 214,   0,  74, 176,  99, 170, 111, 231,   0,   0,  74, 176,  99,  92, 195, 203, 171,   0, 110, 176,   5,  42, 187,  24,
   0,   0,  62, 176, 161, 109,  20, 187,   0,   0,  74, 176,   5, 194,  74,  76,   0,   0,  62, 176,  30,  35, 231, 111,  46,   0,  62, 176,   5,  42,  76,   0,
  20,   0, 110, 176, 192, 166,  35,  46,   0,   0, 110, 176,   5,  92,  38, 111,   0,   0, 110, 176,   5,  12, 126,  46, 229,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 187, 159,   6,  75, 207,  11,  35, 221,  24, 159,   6,  75, 207, 195,  35, 209, 144, 234,   6, 176,  99,  23, 180,  60,   0, 110,  62, 176,   5,  42, 168, 209,
 112, 140,   6, 176,   5,  11,  35, 221,  86, 234,   6, 176,   5, 195,  28,   0,  69, 234,   6, 176,   5, 203,  76,  46,   0,  74,  62, 176, 156, 128,  35, 209,
 168,  54,  62, 176,   5,  42,  35, 209,  92,  47,  62, 176,   5,  42,  35,  65,   0,  74,  62, 176,   5,  11, 231, 190, 187, 110,  62, 176,   5, 218, 167, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  16,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 100, 122,  92, 165, 112,   0, 234,   6,  69, 127,  16, 165, 194,   0, 234,   6, 254, 243,  38,  74,  20,   0,  47,  62, 176,   5,  53, 180,  11,
   0, 140,  62, 176,  99, 180, 251,  21,   0, 140,  62, 176,  91, 109, 111, 244,   0, 234,   6, 100,  31,  99,  12, 109,   0,  74,  62,  30, 243, 203,  46, 112,
   0, 238, 110, 176,  99,  99,  12,  28,   0,  47,   6, 176,   5, 195, 128,  76,   0,  47,  62, 179, 166,  12,  41, 108,   0,  74,  62, 176,   5, 198,  20,   0,
 238,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  54,  62,   3,  18,  42, 126, 108,   0,  47,  74, 176,  99, 170, 111,  28,   0, 110,  74, 176,   5, 128,  76, 244,   0,  74,  62, 176,  99, 128, 161, 187,
   0,  74, 110, 176,  31, 192, 198, 187,   0, 214,   6,  30,  31, 144, 174,   0,   0, 134,  62, 217, 249, 180,  42,  72,   0,  74,  62, 176, 156, 194, 249, 229,
   0, 172, 110, 176, 192, 166,  35, 221,   0, 123,  62, 176, 243,  92,  76,  24,   0,  74,  62,   3,  99,  72, 168, 209,   0, 110,  62, 176,   5, 218, 157, 221,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,  30, 177, 176, 180, 126, 169, 140,   6, 179, 124, 120,  99, 229,   0, 234,   6,  30,  13, 112,  34, 187,   0,  47,  74, 176, 243, 128,   0,  21,
   0, 140,   6, 176, 176,  11,  35,  35,   0, 141,   6, 179, 129,  23, 218,   3,   0, 140,   6, 174,   4, 192,  91,  60,   0,   6,   9,  30,  99,  23,   0, 157,
   0,  47,  74, 176, 156, 203,  38, 111,   0,  47,   6, 176,  99, 194, 229, 108,   0,  54,   6,  30,   5,  72,  72,  20,   0,  47,  62, 176, 243,  12, 218, 190,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,  54,  74, 176,  31, 109, 167,  24,   0,  47,  62,  91,   5, 211,  99,  50,   0, 107,  62, 176, 156, 161, 218,  29,   0,  74,  62, 176, 156,  12,  20,  20,
   0,  54, 110, 176,  73, 180, 144,  28,   0,  47,   6, 197, 207,  35, 244,  76,   0, 123,   6, 176, 122,   5,  60, 218,   0,   6,  62,  75,  99,  23, 168, 209,
   0, 172,  62, 176,   5,  42,  35, 209,   0,  47,  62,  75,   5, 198,  76, 209,  95,  74,  62, 176,   5, 198,  42, 120, 229, 110, 110, 176,   5,  42, 231,  50,
 238,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
 251, 140,   6, 176,   5,  11, 229, 111,  42, 141,   6, 176,   5,  11, 168,  65,   0, 234,   6, 217, 219, 210,  20,  11,   0,  74,  62, 176,  18,   5,  76, 108,
 194, 140,   6, 176,   5,  11,  35, 111,   0, 141,   6, 176, 219, 180, 229, 231, 209, 234,   6, 217, 249, 194, 109, 209,   0,  74,  62, 176,  99,  92, 144, 183,
 163, 246,  74, 176,   5,  42,  35, 209,   0,  47,   6, 176,   5,  42, 231, 112,   0,  74,  62, 176,   5,  12, 126, 112,   0, 110,  62, 176,   5,  12,  20,  65,
  82,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
 137, 246,  74, 176,   5,  42,  35, 221, 189,  47,   6, 176,   5,  11,  35,  65,  24,  74,   6, 176,   5,  42,  38,  60,   0, 110,  62, 176,   5,  42, 120,   0,
 244,  54,  74, 176,   5,  42,  35,  46,   0,  47,   6, 176,   5,  42,  38,  24,   0,   6,  62, 176,   5,  42,  42, 163,   0,  74,  62, 176,   5, 218,  35, 209,
 190, 238,  62, 176,   5,  42, 168, 209, 168,  47,  62, 176,   5,  42, 168, 209, 180,  62,  62, 176,   5,  42, 168,  50, 198, 110,  62, 176,   5, 218, 167,  50,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 176,  56, 203, 229,  38,   0,   0,  62, 176, 219,  42,  28,   7,   0,   0,  62, 179, 251,  42, 120, 163,   0,   0,  62, 176, 156,  53, 157,  38,
   0,   0,  74, 176,  18,  69,  46, 170,   0,   0,  74,  44,   5,  53,  11, 120,   0,   0,   6, 176, 156, 195, 120, 120, 195,   0,  74, 176, 156,   5, 218, 183,
   0,   0, 110, 176, 161,  42, 167, 209, 112,   0,  62, 176,  99,  42, 187, 187,   0,   0,   6, 176,  99, 198,  35,  24, 183,   0, 110, 176,   5, 218, 168, 190,
 238,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 176, 192,  42,  35, 165,   0,   0, 110, 176,   5, 180, 229, 157,   0,   0,  62,  75, 156,  12, 120, 112,   0,   0, 110, 176,   5,  92, 187, 112,
   0,   0,  74, 176, 192, 198, 111, 126,   0,   0,  62,  30, 208, 180, 157, 218,   0,   0,   6, 176,  99,  92, 187,  41,   0,   0, 110, 176,   5,  11, 231, 221,
   0,   0, 110, 176, 161, 166, 165, 183, 244,   0, 110, 176,   5,  42, 157,   0,   0,   0,  62, 176,  99,  42, 165,   0, 167,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 126, 159,   6, 176, 207, 195,  35, 221,  72, 159,   6, 176, 219,  11,  35,   0,   0, 234,   6, 176,   5,  12, 231, 112,  82, 110,  62, 176,   5, 218,  76, 111,
   0, 140,   6, 176,   5,  11, 231,  65, 244, 234,   6, 176,   5, 198, 168, 209, 183, 234,   6, 176,   5, 198, 157,  50,   0,  74,  62, 176,  99, 218,  76, 244,
 143,  54,  62, 176,   5,  42, 168,  50,   0,  74,  62, 176,   5,  42, 231,  65, 218,  74,  62, 176,   5, 218,  28, 209, 190, 110,  62, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176, 208,  23, 120, 111,   0, 140,   6, 176,  31,  42,  38, 190,   0, 141,   6, 176,   5,  12,  35, 111,   0,  47,   6, 176,   5, 218, 168,  24,
   0, 140,   6, 176,  99,  11, 251,  53,   0, 140,   6, 176, 156,  12,  38, 221,   0, 140,   6, 176,  99,  12,  35,  65,   0,  47,  62, 176,   5, 218, 111,  65,
   0,  47,  62, 176,   5,  42, 168, 209,   0,  47,  62, 176,   5, 194, 229,   0,   0,  54,  62, 176,  99, 218, 187,  28,   0, 110,  62, 176,   5, 218, 168, 112,
 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62, 176,   5, 218, 229, 183,   0,  47,  62, 176,   5, 195, 229,  41,   0,  74,  74, 176, 156,  11, 157,  46,   0, 110,  62, 176,   5,  42,  20,  65,
 207, 110,  62, 176,   5,  11, 229, 116,   1,   6,  62, 176,   5,  42, 229,  41,   0,  47,  62, 176,  99,  42, 229,  65, 168, 110,  62, 176,   5, 198,  76, 253,
 244, 123,  62, 176,   5,  42, 168,  46,   0, 110,  62, 176,   5,  42, 229, 168,   0, 110,  62, 176,   5,  12, 231,   0,  11, 110,  62, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176, 156, 198, 198, 137,   0, 234,   6, 176, 208,  92,   5,  28,   0, 140,   6,  75,   5, 166, 168, 183,   0,  47,  62, 176,   5, 195, 166,  65,
   0, 140,   6, 176,  99, 128,  28, 108,   0, 140,   6, 176, 208, 128, 111, 221,   0, 140,   6, 100,   5, 232, 126, 209,   0,  54,  62, 176,   5,  42, 231, 120,
   0,  47,  74, 176,   5,  42, 229, 112,   0,  47,   6, 176,   5, 218, 229, 244, 166,  54,  62, 176,   5, 218,  35, 221, 254, 110,  62, 176,   5, 218, 120, 244,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  62, 176,  99,  11, 231,  46,   0,  47,  62, 176,   5, 195, 168, 157, 110,  74,  62, 176,   5,  12, 157, 157,   0,  74, 110, 176,   5, 218,  38, 167,
   7,  54,  62, 176,   5, 218, 120,  28,   0,  74,  62, 176, 156,  92, 111,   0,   0,  74,  62, 176,   5, 218, 231,  60,   0,  74,  62, 176,   5, 198, 168, 137,
   0, 110,  62, 176,   5, 198,  35,  65,  37, 110,  62, 176,   5,  42, 187,  24,   0,  74,  62, 176,   5, 218, 120,  60,   0, 110,  62, 176,   5, 218, 120, 253,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5, 195, 229, 112,   0, 141,   6, 176,   5,  11, 229, 116,   0, 234,   6, 176,  86, 195, 120, 112,   0,  74,  62, 176,   5, 218, 198, 168,
  38, 140,   6, 176,   5,  42,  35, 137,   0, 141,   6, 176, 207,  72, 231, 244,   0, 234,   6, 176,   5,  42, 229, 187,   0, 110,  62, 176,   5, 198, 198,  28,
   0, 246,  74, 176,   5,  42, 168, 221,   0,  47,   6, 176,   5,  42, 168, 209,   0,  74,  62, 176,   5,  42, 167, 209,   0, 110,  62, 176,   5, 198,  76, 112,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
 126, 246,  74, 176,   5,  42, 229, 221,   0,  47,   6, 176,   5,  11, 231, 112,   0,  54,  62, 176,  99,  42,  28,  46,   0, 110,  62, 176,   5, 218, 168, 112,
   0,  54,  74, 176,   5,  42,  35, 112,   0,  47,   6, 176,   5,  42,  35,  60,   3,   6,   6, 176,   5, 218, 231,  41,   0, 110,  62, 176,   5,  42, 168,   0,
 209, 172,  62, 176,   5,  42, 168, 209, 194,  47,  62, 176,   5, 218, 168, 244, 207,  74,  62, 176,   5,  42, 168, 209,  92, 110,  62, 176,   5, 218, 168, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,
   0, 250,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 176,   5, 194, 167, 209,   0,   0,   6, 176,   5, 109, 231, 111,   0,   0,  74, 176, 124,  92,  72,  65,   0,   0,  74, 176,   5,  42,  28, 209,
   0,   0,  74, 176,   5,  42,  28,  24,   0,   0,  74, 176, 219, 194,  35,  35,   0,   0,  74, 176,   5,  12, 120, 209,  86,   0,  74, 176,   5,  42, 231,  60,
   0,   0, 110, 176,   5,  42, 167,  46,   0,   0, 110, 176,   5,  11, 168, 253,  65,   0, 110, 176,   5,  42, 231, 116,  20,   0, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110, 176,   5,  92, 166, 183,   0,   0, 110, 176,   5,  42, 229, 111,   0,   0, 110, 176,   5,  11,  38, 112,  23,   0, 110, 176,   5, 218, 168, 209,
   0,   0, 110, 176,   5,  42,  38,  46,   0,   0, 110, 176,   5,  11, 229, 111,   0,   0, 110, 176,   5,  11, 126, 116,  28,   0, 110, 176,   5, 218, 168, 112,
  48,   0, 110, 176,   5,  42, 165, 112,   0,   0, 110, 176,   5,  42, 229,   0, 229,   0, 110, 176,   5,  42,  38,  65, 120,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
 179, 159,   6, 176,   5,  11, 229, 137,   0, 159,   6, 176, 207, 195, 187, 229, 166, 234,   6, 176, 156, 218,  46, 221,   0,  74,  62, 176,  99, 170,  35,  60,
 128, 140,  62,  75,  99, 180,  38, 244,   0, 234,   6, 176, 124, 218,  53, 229,  84, 234,   6, 176,  99, 218,  50,   0,   0,  74,  62, 176, 156,  86, 168,   0,
 201,  54,  74, 176,  99,  42, 168, 112,   0,  74,  62, 176,   5,  42, 229,  65,   0,  74,  62, 176,   5, 180,  28, 190,   8, 110,  62, 176,   5, 218, 187, 190,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  62,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,  74, 176, 232,  12,  78, 156,   0, 141,   6,  30, 219, 192,  92, 190,   0, 141,   6,  49,  99,  92, 203, 165,   0,  47,  62,  30,   5, 218, 231,  76,
   0, 140,  74,  40, 232, 198,  76,  15,   0, 141,   6,  75, 207, 203,  23, 190,   0, 234,   6,  49, 138,  23, 215,   0,   0,  54,  62,  40, 192,  72,  92,  76,
   0,  54, 110, 176, 161,  11,  94,  60,   0,  47,  74, 237, 208,  12, 177, 151,   0, 123,   6,  32,  21,  12,  50, 166,   0, 110,  62, 176,   5,  92,  76, 244,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  47,  74, 176, 192, 166,  76, 163,   0,  47,  62, 176,  99,  12, 111, 190,   0,  74,  74, 176,  99, 166, 218,   0,   4,  54,  62, 176,   5,  42,  28, 209,
 198,  54,  62,  89, 192, 166,  46,  35,   0,   6,  62, 176, 207, 166, 165, 157,   0, 234,   6,  75, 156, 144,  12,  24,   0, 110,  62, 176,   5, 194,  28, 163,
 108, 110, 110,  89, 161, 166,  35, 111,   0,  74,  62, 176,  99,  92, 229, 163,  21,   6,  62, 176, 156,  53,  38,  65, 167, 110,  62, 176,   5, 218, 167, 253,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 234,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  34,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,  75,  99,  92,  11,  46,   0, 141,   6, 197,   5,  72, 187, 168,   0, 140,   6, 164, 232,  65, 190, 102,   0, 172,  74, 176, 153, 120, 244, 243,
   0, 141,   6,  30, 153, 161, 166, 221,   0, 140,   6,  30,  85, 180, 109,  76,   0, 140,  22,  75,  18, 166,  22,   0,   0,  74,  62,   3, 156, 219,  73, 157,
   0,  47,  62, 176,  99,  92, 167, 249,   0, 123,  62, 176, 243,  92,  11,   5,   0, 242,  22,  49, 100, 144, 168, 168, 144,   6,  62, 176,   5,  72, 120,  17,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172,  74, 176,   5, 128, 203, 190,   0,  47,   6, 176, 207, 194, 229, 221,   0, 234,  62, 176,  18,  11, 187, 108,   0,  74,  62, 176, 156, 144,  38, 190,
   0,  54,  62,   3,  99, 198, 229,  50,   0,   6,   6,  30, 153,  11,  92,  65,   0, 234,   2, 176,   5, 203, 229,  46,   0, 110,  62, 176, 243, 198, 111, 120,
   0, 172,  62, 176,   5,  42, 231,  17,   0,  47,  62, 176,   5, 170, 187,   0,   0,  74,  62, 176, 156,  23,  76,   0,   0, 110,  62, 176,   5, 218, 120,  60,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 103,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6,  75, 249, 195,  60,  60,   0, 141,   6,  75, 211,  92, 166, 249,   0, 234,   6, 237,  32,  12, 209, 111,   0,  47,  74, 176, 243, 161,   5, 142,
   0, 140,   6,   3, 207,  53, 194, 126,   0, 141,   6, 176, 124, 207, 204, 137,   0, 234,   6, 179, 241, 194, 184,  65,  18,   6,  62, 176,  49,  60,  28,  12,
   0, 246,  74, 176,  99,  11,  35,  60,   0,  47,  62, 176,  31, 195, 231, 112,   0,  21,  62,  75,  31, 122, 195,  89,   0, 123,  62, 176,   5, 218, 111,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 141,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0,  54,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 181,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 246,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 224,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 159,  74, 176,  99,  23,  35,  60,   0,  47,   6,  75,   5,  12, 231,   0, 104,  74,  62, 176, 153,  11,  76, 111,   0,  74,  62, 176,  99, 194,  53, 120,
   0, 140,  74, 176,  99,  53, 195, 209,   0,  47,   6, 176,   5, 170, 229, 209,   0,   6,   6, 176, 156,  53, 157,  50,   0,  74,  62, 176,   5,  53, 170, 209,
 163, 172,  62, 176,  99,  42,  35, 112,   0,  74,  62, 176,   5, 218,  38,   0,   0, 110,  62, 176,   5,  42,  28,  24,   0, 110,  62, 176,   5, 218, 120, 190,
  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,  74,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74, 200, 124, 195,  28, 229,   0,   0,   6, 176, 219,  60, 229,   0,   0,   0,  74,  75, 208,  56,  24, 255,   0,   0,  62, 176,  99, 109,  28,   0,
   0,   0,  74,  30,   5, 218, 120, 165,   0,   0,  74,  75, 153, 111, 207, 253,   0,   0,   6, 179, 243, 109,  22,  38,   0,   0,  62, 176,   5, 218, 167,  12,
   0,   0,  74, 176, 161, 109, 111,  50,   0,   0,  74,  75, 156,  92, 187, 170, 140,   0, 110,  91, 122, 194, 180,  35,  65,   0,  62, 176,   5,  23, 168,   0,
 181,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
  24,   0,  74, 176, 192,  92, 165,  60,   0,   0,  74, 176, 219, 195, 229, 111,   0,   0,  74, 176,  99,  53, 180,  24,  49,   0, 110, 176,   5,  42,  35, 112,
   0,   0,  62, 176,  99, 166, 111,  28,   0,   0,  62, 176,   5, 166, 180,  65,   0,   0,   6, 176,   5,  53, 229, 253,   2,   0, 110, 176,   5, 218, 168,  60,
  35,   0, 110, 176, 192, 166, 165, 183, 118,   0,  62, 176,   5,  42, 165,  46, 215,   0,  62, 176,   5,  42, 168, 116,  12,   0, 110, 176,   5, 218, 120, 190,
  63,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   6, 176, 207, 195, 229,  60,  11, 159,   6,  75, 207,  11, 229, 112,   0, 140,   6, 176,   5, 218, 111,  60,   0,  54,  62, 176,   5,  42, 168, 221,
   0, 140,   6, 176,  99,  92,  53, 190,   0, 234,   6, 176,   5,  11,  35,  28,   0, 234,   6, 176,   5,  92, 203, 126,  23,  74,  62, 176,   5,  42,  76, 190,
   0,  54,  62, 176,  99, 198,  35, 111,   0,  74,  62, 176,   5, 180,  38, 112,   0, 110,  62, 176,   5, 218, 231, 112, 221, 110,  62, 176,   5, 218, 120, 190,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  51,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 238,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  42,  46, 126,  50, 140,   6, 176,   5,  11,  42,  46,   0, 140,   6, 176,   5,  12, 229, 229, 253, 172, 110, 176,   5,  42,  35, 209,
   0, 234,   6, 176, 122, 211,  35, 210,   0, 140,   6, 176, 208,  42, 165, 112,   0, 141,   6, 176, 219, 198,  20, 253,   0,  47,   6, 176,   5,  42,  35, 209,
   0, 110, 110, 176,   5,  42,  35, 229,   0, 110, 110, 176,   5, 218, 229,  28,   0, 110, 110, 176,   5,  92,  92, 190,   0, 110, 110, 176,   5, 218, 168,  46,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 120,  47, 110, 176,   5,  42,  35, 221, 237, 172, 110, 176,   5,  11,  35,  60,   0, 172, 110, 176,   5,  42, 229, 221, 190, 172, 110, 176,   5, 218, 168, 209,
   0,  54, 110, 176,   5, 198, 168,  28,   0, 110,  62, 176,   5,  42, 187, 209,   0,  47,   6, 176,   5,  42, 229,  46, 137,  47,  62, 176,   5, 218, 120, 209,
  38, 110, 110, 176,   5,  42, 165, 112,   0, 110, 110, 176,   5,  92, 229, 221,  16, 110, 110, 176,   5,  42,  38,  60,  65, 110, 110, 176,   5, 218, 120, 190,
 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 159,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 150,   0,   0,   0,   0,   0,   0,   0, 150,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  11, 168, 231,   0, 140,   6, 176,   5,  12, 231,  38,   0, 140,   6, 176,   5,  12, 203, 157,   0,  47, 110, 176,   5,  42,  28, 112,
   0, 140,   6, 176,   5, 195,  12, 231,   0, 234,   6, 176, 176, 218, 111,  41,   0, 140,   6, 176,   5,  92, 229, 128,   0, 110, 110, 176,   5, 218, 126, 221,
   0, 172, 110, 176,   5,   5, 126, 221,   0, 172, 110, 176,   5,  72, 218, 221,   0, 123,  62, 176, 243,  11, 195,   0,   0, 110,  62, 176,   5, 218, 168, 112,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 209,  47,   6, 176,   5,  42, 111, 120,   0, 159,   6, 176,   5,  42, 229, 209,   0,  54, 110, 176,   5, 198,  38,   0,  10,  54, 110, 176,   5, 218, 168, 209,
   0,  54, 110, 176,   5,  42,  35, 253,   0,  54,   6, 176,   5,  12,  35,  41,   0, 110,   6, 176,   5, 218,  35,  46,   0, 110, 110, 176,   5,  42,  20, 244,
   0, 110, 110, 176,   5, 218, 167, 209,   0, 110, 110, 176,   5, 198,  35, 190,   0, 110, 110, 176,   5, 218, 120, 209, 198, 110, 110, 176,   5, 218, 168, 163,
  51,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
  28, 140,   6, 176,   5,  11, 168, 198,   0, 140,   6, 176, 208, 198, 229, 187,   0, 140,   6, 176, 211,  12, 229, 229,   0,  47,  62, 176,   5,  12,  38,  65,
   0, 140,   6, 176, 219, 176, 194, 221,   0, 234,   6, 176,   5, 156,  76,  65,   0, 234,   6, 176, 122,  72, 229,  65,   0,  47,  62, 176,   5,  11,  28,  65,
 190, 172, 110, 176,   5, 195,  42, 209,   0,  47, 110, 176,  99, 218,  38,  60,   0,  74,  62, 176,   5,  11, 209,   0,   0, 110,  62, 176,   5,  42, 231,  76,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 212,  47,   6, 176,   5,  11, 157,  46, 209,  47,   6, 176,   5,  42, 229,  60,   0, 140,   6, 176,   5,  12,  76,  46,   0,  54, 110, 176,   5,  42, 168, 209,
   0,  54, 110, 176,  99,  42, 168,   0,   0, 110,   6, 176,   5,  42, 229,   0,   0, 234,   6, 176,   5,  12,  38,  46,   0, 110, 110, 176,   5, 218, 187,  46,
   0, 172, 110, 176,   5,  42,  28, 244,   0, 110, 110, 176,   5,  42, 231,  50,   0, 110,  62, 176,   5,  11,  38, 244, 245, 110, 110, 176,   5, 218, 120, 190,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110, 176,   5,  11, 187,  53,   0,   0, 110, 176,   5, 195,  53, 126,   0,   0, 110, 176,   5,  11, 168, 253,   8,   0, 110, 176,   5,  42, 168,  46,
  46,   0, 110, 176,  99,  53,  42, 108,   0,   0, 110, 176,  99, 218, 168, 168,   0,   0,   6, 176,   5,  42, 180,  46,   0,   0, 110, 176,   5,  42, 231,  60,
   0,   0, 110, 176,   5,  42, 187,   0,   0,   0, 110, 176,   5,  12, 229, 111,   0,   0, 110, 176,   5,  42, 231, 229, 224,   0, 110, 176,   5, 218, 168, 190,
  51,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 250,   0,   0,   0,   0,   0,   0,   0,
 203,   0, 110, 176,  99,  42, 231, 183, 208,   0, 110, 176,   5,  42, 229, 111, 192,   0, 110, 176,   5,  11, 229, 221,  76,   0, 110, 176,   5,  42, 168, 209,
   0,   0, 110, 176,   5, 198,  35,  60,   0,   0, 110, 176,   5,  11, 229, 112, 213,   0, 110, 176,   5,  12,  38,  46, 168,   0, 110, 176,   5, 218, 120, 190,
 168,   0, 110, 176,   5,  42,  35, 183,  28,   0, 110, 176,   5,  42, 157, 112,  75,   0, 110, 176,   5,  42, 229, 137,  20,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
  35, 159,   6, 176,   5,  11,  35, 221,  25, 159,   6, 176,   5,  11,  35,  65,   0, 234,   6, 176,   5,  42,  28, 244,   0, 110,  62, 176,   5,  42,  28,   0,
 112, 140,   6, 176,   5,  42,  35,  46, 209, 234,   6, 176,   5,  11, 231, 112,   0, 234,   6, 176,   5, 198, 229,  46,   0, 110,  62, 176,   5,  42, 231,  24,
 163, 172,  62, 176,   5,  42, 168, 209, 198,  47,  62, 176,   5,  42, 168, 137,   0, 110,  62, 176,   5,  42, 165, 253,   0, 110, 110, 176,   5, 218, 168, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 173,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5, 198, 168, 168,   0, 140,   6, 176,  18, 194,  28, 168,   0, 140,   6, 176, 207,  12, 231,  35, 120,  47,   6, 176,   5, 218, 120, 190,
   0, 140,   6, 176, 161, 198,  76, 112,   0, 140,   6, 176,   5, 138, 116,  35,   0, 234,   6, 176,   5, 194, 126,  50,   0,  47,  62, 176,   5,  12, 229,  38,
   0, 172, 110, 176,   5,  11,  35,  76,   0,  47,  62, 176,   5,  42, 157, 163,   0, 110,   6, 176,   5, 218, 157,  35, 144, 110, 110, 176,   5, 218, 167,  17,
 173,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0,  47, 110, 176,  99,  42,  35, 209,   0,  47,   6, 176,   5,  42,  35,  60,   0,  54,  62, 176,   5, 194, 229,  65,   0, 110, 110, 176,   5, 218,  28, 209,
   0,  54, 110, 176,   5,  11,  35,  35, 144,   6,   6, 176,   5,  42, 168,  17,   0, 110, 110, 176,   5,  12, 167, 209, 194, 110, 110, 176,   5, 218, 168, 244,
 158, 172, 110, 176,   5,  42,  35, 209, 126, 110,  62, 176,   5,  42, 231,  65,   0, 110,  62, 176,   5,  42, 231,  65, 194, 110, 110, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  42, 168,  41,   0, 141,   6, 176,   5,  12, 126,  28,   0, 234,   6, 176, 243, 198,  46, 108,   0, 110,  62, 176,   5,  42,  35, 163,
  31, 140,   6, 176,   5,  11,  35, 108,   0, 141,   6, 176,  99, 198, 187,  76,   0, 234,   6, 217,   5,  12, 199,  65,   0, 110,  62, 176,   5,  42, 209, 116,
 112, 172, 110, 176,   5,  42,  35, 108,  35,  47,   6, 176,   5,  42, 167,   0,   0,  54,   6, 176,   5, 218, 168, 112,   0, 110, 110, 176,   5, 218, 168, 209,
 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 172, 110, 176,   5,  42,  35,   0, 112,  47,   6, 176,   5,  42, 168,  60,   0,  54,  62, 176,   5,  42, 231, 253,  16, 110,  62, 176,   5, 218,  35, 221,
   0, 172, 110, 176,   5,  42, 229,   0,   0,  47,   6, 176,  99, 218,  38, 112,   0,   6,   6, 176,   5,  42,  42, 221,   0, 110, 110, 176,   5, 218,  28,  65,
 120, 172, 110, 176,   5,  42, 168, 209,  46,  47,  62, 176,   5,  42, 168, 209, 104, 110,  62, 176,   5, 218, 168, 190, 190, 110, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
  46, 140,   6, 176,   5,  42, 126,  65,   0, 141,   6, 176,   5, 195, 157,  65,   0, 234,   6, 176,   5,  42,  23,  60,   0, 110,  62, 176,   5, 218,  20,  76,
  42, 140,   6, 176,   5,  42,  11, 116, 163, 141,   6, 176,   5,  12, 111,  53, 121, 234,   6, 176,   5,  31, 126, 244,   0,  74,  62, 176,   5,  42,  35, 168,
 244, 172, 110, 176,   5,  42, 168,  65, 157,  47,   6, 176,   5, 218, 231, 209,   0,  54,   6, 176,   5,  42, 231,  46,   0, 110, 110, 176,   5, 218, 168,  65,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,
 238,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0,
   0, 172,  74, 176,   5,  42, 168,  65,  65,  47,   6, 176,   5,  42,  35, 209,   0, 110,   6, 176,   5, 198, 231,  50,   0, 110,  62, 176,   5, 218, 120, 209,
 126, 172, 110, 176,   5,  42, 168, 209,   0,  47,   6, 176,   5, 198, 120, 112,   0,   6,   6, 176,   5,  42, 168,   0, 196, 110,  62, 176,   5, 218,  28,  60,
  20, 172, 110, 176,   5,  42, 168, 209, 112,  47,  62, 176,   5, 218, 168, 209, 108, 110,  62, 176,   5, 218, 168, 209, 144, 110, 110, 176,   5, 218, 167,  24,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0,  47,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 110,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 110, 176,   5,  12,  35, 112,   0,   0,   6, 176,   5,  11,  12,  65,   0,   0,   6, 176,   5,  11, 111,  28,   0,   0, 110, 176,   5,  42,  38, 137,
   0,   0, 110, 176,   5,  11, 111, 111,   0,   0, 110, 176,   5,  12, 218,  38,   0,   0, 110, 176,   5,  11, 187, 111, 213,   0, 110, 176,   5,  42, 111,  60,
 120,   0, 110, 176,   5,  42,  35,   0,   0,   0, 110, 176,   5,  42, 168, 209,   0,   0, 110, 176,   5, 218,  35,  65,  43,   0, 110, 176,   5, 218, 168,  60,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 128,   0, 110, 176,  99,  42,  35, 168,   0,   0, 110, 176,   5,  42, 229,  28,   0,   0, 110, 176,   5,  42, 168, 112,  25,   0, 110, 176,   5, 218, 168,  46,
   0,   0, 110, 176,   5,  42,  35, 183, 209,   0, 110, 176,   5,  42,  35, 221, 194,   0, 110, 176,   5,  11, 168,  46,  77,   0, 110, 176,   5, 218, 168, 190,
 168,   0, 110, 176,   5,  42,  35, 209,  38,   0, 110, 176,   5,  42, 168, 209, 157,   0, 110, 176,   5, 218, 168,  24, 220,   0, 110, 176,   5, 218, 120, 190,
 224,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
 120, 159,   6, 176,   5,  11,  35, 221,  91, 159,   6, 176,   5,  11, 229, 111,   0, 140,   6, 176,   5,  42, 231, 112,  11, 172, 110, 176,   5, 218, 168, 112,
 108, 140,   6, 176,   5,  11, 229,  60,   0, 140,   6, 176,   5,  42, 231, 221, 231, 140,   6, 176,   5,  42,  35,  65, 197, 110,  62, 176,   5,  42, 168, 209,
 200, 172, 110, 176,   5,  42, 168, 112,  24,  47,  62, 176,   5,  42, 168, 112, 109, 110,  62, 176,   5, 218, 167, 137, 209, 110, 110, 176,   5, 218, 120, 190,
  15,   0,   0,   0,   0,   0,   0,   0,  15,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0,
 210, 140,   6, 176,   5,  42, 229, 221,   0, 140,   6, 176,   5,  11, 229, 111,   0, 140,   6, 176,   5,  12, 126, 126,   0, 172, 110, 176,   5,  42, 231, 112,
   0, 140,   6, 176,   5,  42,  28,  60,   0, 140,   6, 176,   5,  42,  35,  60,   0, 140,   6, 176,   5,  11, 229, 111,   0,  47, 110, 176,   5,  42, 168, 112,
  38, 172, 110, 176,   5,  42,  35, 221, 112, 172, 110, 176,   5,  42, 168,   0, 251, 123, 110, 176,   5,  42, 168, 221, 190, 110, 110, 176,   5, 218, 168,  60,
 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 173,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,
   0, 172, 110, 176,   5,  42, 231, 112, 137, 172, 110, 176,   5,  12, 229,  46,   0, 172, 110, 176,   5,  12, 229,  46,  28, 172, 110, 176,   5, 218, 168, 190,
 187, 172, 110, 176,   5,  42,  35, 112,   0,  54, 110, 176,   5, 218, 168,   0,   0,  47, 110, 176,   5,  12,  35, 116, 218, 110, 110, 176,   5, 218, 120, 209,
  78, 110, 110, 176,   5, 218, 168,   0,  12, 110, 110, 176,   5, 218, 168, 112, 216, 110, 110, 176,   5, 218, 168, 190, 111, 110, 110, 176,   5, 218, 120, 190,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0, 159,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
  82,   0,   0,   0,   0,   0,   0,   0,  82,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0,  82,   0,   0,   0,   0,   0,   0,   0,  67,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  42, 126,  60,   0, 140,   6, 176,   5,  11, 231, 126,   0, 140,   6, 176,   5,  42, 111, 126,   0, 172, 110, 176,   5, 218, 229,   0,
   0, 140,   6, 176,   5,  11, 126, 111,   0, 140,   6, 176,   5,  12, 229, 111,   0, 140,   6, 176,   5,  11, 126, 126,   0, 123, 110, 176,   5,  12, 168, 221,
   0, 172, 110, 176,   5,  42, 231, 112,  72,  47, 110, 176,   5,  42, 229,  46,   0,  54, 110, 176,   5,  42, 229, 112,  76, 110, 110, 176,   5, 218, 120, 112,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 122, 172,  74, 176,   5,  42, 229, 209, 168, 172, 110, 176,   5,  42, 229, 112, 126, 172, 110, 176,   5,  42, 229, 112, 112, 123, 110, 176,   5, 218, 168, 112,
  20, 172, 110, 176,   5,  42,  35, 112,  53, 172, 110, 176,   5, 218, 229, 209, 106,  54, 110, 176,   5,  12, 229, 108, 108, 110, 110, 176,   5, 218, 120, 209,
  35, 172, 110, 176,   5, 218, 168, 190, 229, 123, 110, 176,   5, 218, 168, 190, 190,  54, 110, 176,   5, 218, 120, 190, 209, 110, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 140,   6, 176,   5,  42, 229, 221,   0, 140,   6, 176,   5, 218, 229, 221,   0, 140,   6, 176,   5,  12, 168,  65,  56, 123, 110, 176,   5, 218, 168, 190,
 143, 140,   6, 176,   5,  42, 231, 221,   0, 140,   6, 176,   5,  42, 229, 168,   0, 140,   6, 176,   5, 218,  35,  46,   0, 123, 110, 176,   5, 218, 168, 221,
 244, 172, 110, 176,   5,  42, 231, 112,   0,  47, 110, 176,   5,  42, 231, 112,  62,  54, 110, 176,   5,  42, 168, 112, 194, 110, 110, 176,   5, 218, 168, 112,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 140,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,  54,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
   3, 172, 110, 176,   5,  42, 231, 112, 157,  47, 110, 176,   5,  42, 229, 112, 190,  54,  62, 176,   5,  42, 231, 112, 168, 110, 110, 176,   5, 218, 168, 112,
  42, 172, 110, 176,   5,  42,  35,  60,  28,  47, 110, 176,   5,  12, 229, 108, 106,  54,  62, 176,   5,  42, 229,  46,   0, 110, 110, 176,   5, 218, 168, 209,
 209, 172, 110, 176,   5, 218, 168, 209, 163,  47, 110, 176,   5, 218, 168, 190, 253,  54, 110, 176,   5, 218, 168, 190,  76, 110, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,
   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,
 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0,
  42,   0, 110, 176,   5,  42, 229, 111,   0,   0, 110, 176,   5,  12, 229, 126, 107,   0, 110, 176,   5,  42, 229, 126, 231,   0, 110, 176,   5, 218, 168, 112,
   0,   0, 110, 176,   5,  42, 229,  35, 187,   0, 110, 176,   5,  12, 229, 116,   0,   0, 110, 176,   5,  12, 126, 116, 221,   0, 110, 176,   5,  42, 231, 112,
 218,   0, 110, 176,   5, 218, 168, 112,   3,   0, 110, 176,   5,  42, 168, 190, 190,   0, 110, 176,   5, 218, 231, 112, 167,   0, 110, 176,   5, 218, 120, 190,
 172,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 123,   0,   0,   0,   0,   0,   0,   0, 107,   0,   0,   0,   0,   0,   0,   0,
 169,   0, 110, 176,   5,  42, 229, 111, 120,   0, 110, 176,   5,  42, 229, 111,  16,   0, 110, 176,   5,  42, 229, 112, 168,   0, 110, 176,   5, 218, 120, 190,
  18,   0, 110, 176,   5,  42, 168, 112, 157,   0, 110, 176,   5,  42, 229, 111, 231,   0, 110, 176,   5,  12, 229, 116, 190,   0, 110, 176,   5, 218, 120, 190,
  28,   0, 110, 176,   5, 218, 168, 190, 187,   0, 110, 176,   5, 218, 168, 190, 190,   0, 110, 176,   5, 218, 120, 190, 190,   0, 110, 176,   5, 218, 120, 190,
};

static const unsigned char model_run_state_table[8192] =
{
      80, 168, 115,  59,  51,  58,  99, 250,  80,  80, 225,  59,  63,  99, 250, 250, 233,  80, 225,  23,  51,  63, 207,  99, 233,  80, 225,  23,  23, 249, 207,   1,
      20,  80, 225,  23,  23,  98, 104,  58,  20,  80, 225,  23,  23, 160, 108, 167,  20,  80,  65,  23,  23, 160, 207, 148,  80,  80,  65, 112, 160, 160, 207,   4,
     114, 114, 219, 247, 223, 222, 108, 108,  61, 128, 216, 202,  59, 100, 108,  12,  61, 128, 245,  25,  13, 103, 226, 132,  61,  20, 245, 251, 247, 231,  84, 104,
      61,  20, 245, 159, 239,  89, 251,  84,  61,  20,  20, 251,  72, 250, 103, 135,  34,  20,  20, 232, 100, 104, 251,  58,  34,  61,  20, 237, 103,  72, 125, 104,
     114, 145, 219, 247, 123,  63,  58,   4, 128, 245, 142, 247, 103,  58,  58, 250,  20, 190, 142,  13, 103, 100, 104, 218,  61, 190, 245, 146, 239, 119, 226, 108,
      61,  20, 237,  25, 226, 160, 224, 183,  61,  20, 245,  14, 199,   4, 108, 108,  34,  20,  20, 251,  72,  82,   1, 108,  34,  20,  20, 125, 125,  47, 226, 104,
     128, 151, 219, 247, 119,  63,  12, 108,  85, 156, 219, 219, 231, 100,  58, 108,  94, 137, 151, 219,   7, 100,  89, 108,  94, 128, 190,  25,  72, 231,  63, 104,
      61,  73, 151, 219,  14,  89, 224, 192,  50,  61, 151,  56,   6, 232, 104, 183,  50,  61, 151, 237,  72, 227, 104, 104, 153,  61,  20, 237, 232,  72, 104, 108,
     114, 145, 115, 155, 100, 226, 108, 108, 128, 245, 219, 231, 231,  47,  89,   4,  61, 245, 142,  74, 231, 104, 104, 255,  61,  20, 245, 142, 231,  82, 177, 192,
      61,  20, 245, 146,  47,  14, 140, 222,  61,  20,  20, 146,  89, 125, 207, 250,  61,  20,  20, 146, 100, 104, 207, 207,  34,  20,  20, 125, 125, 160, 226, 108,
     128, 114, 219, 183, 164, 100, 226, 250, 252, 128, 184,  25, 103,  47,  89, 104,  94, 128, 190,  25,  14,  47, 125, 104,  94,  85, 190,  26,  14,  47, 104,  72,
      50,  85,  20, 147,  14,  18,  14, 192,  50,  61, 144,  33,  26,  45,  14, 125,  50,  61, 144,  26,  14, 100, 252, 192, 153,  61,  20,  26,  18,  72, 192, 192,
     114, 151, 219, 247, 199,  98, 158, 250,  85, 190, 151,   6, 231,  89, 168,  89,  94, 128, 190, 142, 103,  89,  89, 104,  94, 128, 190,  25,  14,  14, 125, 104,
      94,  20, 190,  25,  14, 232, 232,  47,  50,  61, 190, 159,  14,  72,  25, 101,  50,  61,  20, 159, 232,  89, 125, 108, 153,  61,  20,  26, 125, 103, 192, 104,
     128, 151, 219, 247, 247,  63,  63, 108,  85, 156, 151, 219, 231, 100,  47, 108,  94, 137, 151, 219,  14,  14,  89,  89,  94,  85, 151,  33,  14,  89,  89, 232,
      50,  85, 190,  33,  14,  14,  89, 104,  50,  85, 190, 130,  14,  14, 135, 192,  50,  85,  73,  33,  14,  14, 104, 104, 153,  61,  20,  26, 232,  89, 192, 192,
     145, 219, 247, 155, 172, 110,  58, 162,  20, 245, 142,  59,  82,  99, 103,  58,  20, 245, 142,  25, 103,  89, 231, 207,  20, 245, 142, 142, 231, 160, 214, 108,
      20,  20, 142, 146, 125,  14, 167, 192,  20,  20, 142,  13, 103, 160, 207, 162,  20,  20,  20,  82, 125, 160, 207,   4,  34,  20,  20, 125, 160, 160, 226, 108,
     114, 151, 219, 247, 247,  63,  58, 250,  85, 156, 151, 219, 231, 227,  58, 108,  94, 128, 151, 219, 231,  47,  58, 192,  50, 128, 245, 244,  89,  47,  14, 108,
      50, 128, 190,  56, 103,  14,  14, 155,  61,  69, 190,   6, 103, 104, 135,  84,  61,  61,  20,  26,  14, 231, 104, 154, 153,  61,  20, 237, 232,  14,  89, 104,
     114, 219, 219, 247, 119,  79,  12,   4, 128, 151, 219, 219, 231,  51,  58,   4,  61, 190, 151, 219, 231, 100, 160,  84,  61, 128, 245,  25, 103, 232,  18,  80,
      61,  20, 245,  25, 103, 219,  99, 104,  61,  61, 245, 130, 146, 232,  89, 108,  61,  61, 190,  25,  89, 192, 104, 250,  34,  20,  20, 237, 232, 125, 226, 104,
     128, 151, 219, 247, 119,  79,  22,   4,  85, 151, 219, 247, 247,  63,  63, 226,  94, 137, 151, 219, 231, 100,  89, 226,  94, 137, 151, 219, 231,  47,  89,  89,
      50,  85, 151, 219, 103,  47,  58,  58,  50,  85, 151,  56, 232,  89,  89, 226,  50,  85, 151, 145,  14, 232,  47, 104, 153,  61,  20, 237, 232,  89,  11, 104,
     114, 145, 219, 155,  65,  47, 226, 158, 128, 114, 219,  13,  89, 125, 108, 179, 128,  20, 245, 251, 103,  89,  89,  14,  61,  20, 245, 142, 231, 231,  99,  20,
      61,  20, 245, 251,  14,  18,  58, 192,  61,  20,  20, 245,  45,  58,   4,   1,  61,  20,  20,  80, 231, 160, 207, 108,  34,  20,  20, 125, 125, 125,  99, 104,
     128, 151, 219,  13, 100, 100, 103, 108,  85, 128, 151, 237, 147, 103, 127, 192,  94, 128, 190,  33,  14,  47,  89, 227,  94,  85, 190,  33, 135, 135,  14,  16,
      50,  85, 190, 144,  14, 232, 201, 103,  50,  85,  73,  26,  14,  45, 103, 115,  50,  61,  20,  20,  14,  45,  89,  11, 153,  61,  20,  26, 135, 135, 201, 192,
     156, 151, 219,  13, 247, 100,  98, 162,  85, 156, 151, 142, 231, 103, 159, 104,  94, 128, 190,  56,  14,  72,  47, 226,  94, 128, 190,  33,  14,  47, 125, 104,
      50, 128, 190,  26,  14,  14,  33,  72,  50,  61, 190,  26,  14,  18, 100, 249,  50,  61, 190,  26,  45, 103,  33,  72, 153,  61,  20,  26, 135, 125, 192, 192,
     156, 151, 219, 219, 100, 100, 226, 108,  85, 137, 151, 219,  14, 232,  89, 104,  85, 137, 151,  33,  14,  14,  89,  72,  60,  85, 190,  33,  14,  14,  45,  72,
      49,  85,  73,  33,  14,  14, 125, 192,  49,  85,  73,  33,  14,  14,  14, 192,  49,  85,  73,  33,  14,  14,  45, 192, 153,  55,  32, 154, 135, 135, 192, 192,
      27,   8, 142,  44, 103,  51,  63,   4, 186,  20, 216,   6,   3, 103,  58,  58,  34, 144, 216,   8, 123, 255,  58, 181,  61, 190, 142,   6,  23, 226,  72,   4,
      88,  20,  56, 159,  51, 115,  67,   4,  28,   8,  80,  44,  25,  33,  12, 131,  34,  20,  42, 216,  93,  41,  25,  63,  34,  80,  20, 125,  72, 255, 231, 250,
     193, 213, 219, 219, 247, 127,  59, 162, 252, 213, 216, 124, 146, 237, 242, 125,  50, 190, 190, 179,  14, 251, 238,   6,  50,  85, 245, 245,  42, 159, 144, 113,
      50, 228, 245,   6,  59,  11, 108, 168,  61, 161,  20,  42, 134, 138, 225, 181,  94,  20,  26, 184,  55, 213, 238, 244,  34,  61,  20,  80, 159,  82, 104, 108,
      27,  97, 216,   6, 103, 102, 226, 104, 105,  97, 190, 130, 159,  82,   0,  41,  50,  69, 190, 147, 146,  14, 231, 219,  50,  20, 245, 237, 237,  75, 126, 100,
      50,  15, 252,  21, 146,  61, 250, 192,  50,  36,  73, 190, 175,  11, 251,   0,  88,  61, 233,   5, 232, 127,   0,  71,  34,  61,  20,  26,  18,  45,  44,  41,
     128, 151, 219, 247, 247,  51,  58, 226,  85,  97, 151, 219, 247, 247, 231, 155,  94,  97,   9, 184, 146, 104,   6,  99,  50,  37, 190,  25,  89,  63, 108, 147,
      50, 190, 190, 184, 159, 250, 144, 170,  88,  69,  97, 189, 135, 104,  33, 135, 153, 194,  35,  80, 103,  40, 125,  25, 153,  61, 190, 237,  25, 103, 250, 104,
      27, 128, 142, 146, 146,  80, 145, 226, 252, 228, 190,  80, 103, 232,  15, 147,  94,  61,   8,   6,   7,  44, 162, 139,  50,  61, 144, 179,  25, 191,  96,  12,
      61, 105, 235,  18, 146, 135, 111,  99,  50,  61,  20,  61, 183, 155, 231, 180,  88,  61, 197,  45, 240, 250, 219,  64,  34,  61,  20,  26,  89, 103, 125, 197,
     128, 151, 151, 219, 168,  47,  58, 158,  85, 128, 245, 151, 134, 232, 184, 192,  94, 128,   8, 235, 107,  47, 145,  72,  50, 194,  20,  20, 173,  26, 155, 144,
      50,  61,  36,  14,  82, 125, 237,  99,  50, 105,  20,  27,  14, 137, 167, 235,  50,  61, 175, 186, 190,  28, 108, 127, 153,  61,  54,  26, 129,  89,  26, 108,
     252,  97, 216,  25,   7,  11, 159, 226,  94, 252, 190, 245, 235, 135, 251,  18,  50, 252, 190,   8,  33, 125, 144, 226,  88,  94, 144,  42, 202,  13,  45, 253,
      88,  94,  97,  27,  14,  93, 153, 192,  88,  61,  61,   9, 103, 228, 250, 244,  88,  61, 144,  20,  14, 232,  18, 138, 153,  61,  61, 154,  26, 215,  18, 192,
     128, 156, 219, 219, 247, 100,  63, 108, 252,  97, 151, 151, 239, 103, 103, 231,  94,  85, 190, 244, 159, 141, 233,  18,  50,  85, 156,   8,  45,  14,  72, 133,
      50,  94, 190,  33,  14, 135, 159,  80,  50,  94,  73,  37,  20,  14, 155, 157, 153,  94,  37, 245,  26, 192, 153,  68, 153,  61,  32,  26, 129, 232,  18, 192,
      27, 235,  56,  56,  59, 249,  45, 226,  61, 190,  33,  25, 159,  47, 104, 231, 186,  54,  20,  26, 151,  80, 249, 146,  61,  61, 235,   6, 192,  72,  82,   4,
      34, 128,  73,  18, 192,  93, 232,   0,  50,   2, 237,  20, 230, 250,  52, 161,  19,  20,  20, 109, 231, 190,  49, 102,  34, 215,  20,  26, 244,  54, 183, 125,
     128, 151, 219, 247, 247, 249, 158, 108,  85, 137, 151, 121, 219, 232,  59,  80,  94, 190, 190, 142, 239, 232,   6,  76,  94,  73, 189,  26, 237, 247, 156,  90,
      50,  61, 149, 144,   5, 178,  49,  68,  36, 242, 221, 176, 159, 251,  10,   6,  50,  73,  26, 144, 190,  82,   0, 229,  34,  61,  20,  20, 103, 125,  47, 116,
     194, 213, 151, 219, 231, 231,  51, 104,  94, 161, 213, 151,   7, 146,   7, 249,  50,  35, 190, 245,  25,  18, 251, 165,  50,  69, 190, 245, 237, 146,  72, 120,
      50,  36,  73, 147,  25, 190,  34,  72, 153,  50,  73, 215,  89,  25, 120,  71, 153,  87, 144,  14, 189,  55,  36, 167, 153,  61,  20,  20, 129, 147,  57, 115,
     128, 151, 219, 247, 119, 119,  12, 250,  85, 156, 219, 219, 247,  63,  63, 249,  94, 137, 151, 219,  13, 100,  47,  72,  50, 137, 151,  70,  14,  89, 103, 247,
      49,  85, 190,  25, 125, 247, 192, 138,  50,  69, 190, 130,  14, 255, 227, 100,  49,  85, 190, 233,  14,  18,  89, 247, 153,  61,  20,  26, 129,  72,  14, 192,
      27,   9, 130, 146, 145, 125, 125, 226, 186,  27,   8,  33,  56, 145,  14, 104,  94,  61, 245,  33,  80, 199,  91, 192,  50, 186, 144, 103, 232, 194, 247, 194,
      50,  61,  54, 235, 152, 132, 244, 228,  61,  61, 144, 190, 180,  21, 196, 188,  50,  61, 144, 125,  51,  74,   0, 114, 153,  61,  20,  26,  72, 232, 154, 214,
     156, 151, 219, 219, 159, 100,   7,   7,  85, 137, 151,   8,  56, 245, 159, 183,  94,  85, 190, 245, 142,   9,  22,  13,  50,  85, 190,  21, 244, 114, 201,  45,
      50,  94, 190,  33,  72, 165, 104,  24,  50,  61,  20,  19,  80,  92,   9,  90,  50,  94,  32, 235, 197, 113, 234, 192, 153,  61,  61,  26, 129, 135,  18,  47,
     252, 156, 151, 237,  29, 103, 103, 104,  94, 128, 190, 237,  14, 135,  72, 223,  94, 252, 190,  26,  14,  26,  26, 104,  50,  94,  69,  20,  33,  47, 135,  72,
      50,  94,  73,  54,  14, 135, 114, 249,  88,  50,  20,   2, 245, 197, 188,  58,  88,  61,  61, 186, 135, 153, 136, 185, 153,  61,  61, 197, 135, 135, 201, 192,
     156, 151, 219, 219, 232, 232, 220, 108,  85, 137, 151,  21, 232, 232,  89, 232,  60, 137, 151,  33,  14, 232, 232, 135,  60,  85,  73,  33,  14, 232,  18, 104,
      49,  85,  73,  27,  14,  14,  33, 192,  49,  94,  73,  73, 135, 135, 135, 249,  49,  60,  73, 154,  33,  45, 125,  15, 153,  55,  32, 154, 135, 135, 135, 192,
       0, 111, 247, 119,  79,  62, 167,  90,   0, 130, 247,  59,  51,  62, 181, 101,   0, 117, 142, 247, 113, 160, 224,   1,   0, 130,   6,  59,  63, 148,  99, 181,
       0, 205,  74, 146,  59, 118, 104,  84,   0, 121,  65, 119, 146, 140, 168,   1,   0, 190,  44,  30,  62, 222, 101, 121,   0,  74,  65, 132, 112,  22, 181, 101,
       0, 219, 247, 119,  79,  22, 238,  90,   0, 151, 219, 247, 119,  62,  22, 214,   0, 151, 219, 247, 222,  63,  99,   1,   0,   5, 219, 247, 132,  99, 108, 181,
       0,  33, 219, 119, 148,  62, 207, 108,   0, 151, 219, 132, 100, 140, 226, 181,   0,  18,  44, 132,  63, 160, 226, 104,   0, 151, 182, 123, 224,  12, 238, 101,
     244, 247, 247,  79, 224,   0,   0,   0, 128, 219, 247, 199,   0,   0,   0,   0, 128,  48, 147, 148,   0,   0,   0,   0, 170,  48, 142, 124,   0,   0,   0,   0,
     128,  77, 159,  53,   0,   0,   0,   0, 186, 184, 183,   0,   0,   0,   0,   0,  32, 142,  83, 207,   0,   0,   0,   0,  20,  20, 247,  56,   0,   0,   0,   0,
     151, 247, 247, 162,   0,   0,   0,   0, 156, 219, 247, 255,  84,   0,   0,   0, 156, 151, 219, 224,  46,   0,   0,   0, 128, 151, 219, 115, 105,   0,   0,   0,
     128, 151, 219,  51,   0,   0,   0,   0,  85, 151, 219, 192,   0,   0,   0,   0, 128, 151, 111,   0,   0,   0,   0,   0,  61, 145, 219,  13,   0,   0,   0,   0,
       0, 219, 247, 119,  79,  62,  22, 214,   0,   5, 219, 247,  51, 148,  63, 250,   0, 137, 219, 239,  51,  58, 160,  63,   0, 216, 219, 247, 100, 158, 162, 181,
       0, 244, 179,   3,  51,  58,  62,  22,   0, 137, 219,   6, 119,  99,  62, 250,   0, 151, 130, 204, 100, 158, 158,  42,   0, 213, 202, 140, 132,  99,   4, 250,
       0, 219, 247, 119,  79,  22, 238,  90,   0, 219, 247, 247, 119,  79,  22, 214,   0, 151, 219, 247, 119,  79, 207,   4,   0, 151, 219, 247, 119,  12, 207,   4,
       0, 151, 219, 247, 113,  12,  12, 214,   0, 151, 219, 247,  53,  12, 207,   4,   0, 151, 234, 123,  79,  79,   4, 214,   0, 151, 247,  30, 222,  12,   4, 214,
     151, 247, 247,  62, 130,   0,   0,   0, 128, 151, 219,  53, 146,   0,   0,   0,  85, 151, 219, 224, 162,   0,   0,   0,  85, 151, 219, 253,   0,   0,   0,   0,
      94, 245,  41, 132,   0,   0,   0,   0,  94, 114, 142, 126,   0,   0,   0,   0,  61, 114, 219,  84,   0,   0,   0,   0,  61, 114, 219,  51,   0,   0,   0,   0,
     151, 247, 247,  22, 101,   0,   0,   0, 156, 219, 247, 158, 119,   0,   0,   0, 156, 219, 219, 224,   0,   0,   0,   0, 156, 151, 219, 255, 208,   0,   0,   0,
      85, 151, 219, 255, 160,   0,   0,   0,  85, 151, 219, 191,   0,   0,   0,   0,  85, 151, 219,  12,   0,   0,   0,   0,  85, 151, 247,  89,   0,   0,   0,   0,
       0, 219, 247, 119,  53,  22,  12, 181,   0, 219, 219, 247,  51, 118, 250,   4,   0,   5, 202, 155,  58, 231,  12,  99,   0,  77, 179,   6, 249, 115, 148,  18,
       0, 184,  42, 131, 127, 108,   4, 108,   0,  77, 145, 179,  63,  63,   4, 112,   0, 187,  74,   6,  89, 199,  99, 207,   0, 190, 145, 183, 249, 162, 113, 250,
       0, 219, 247, 119,  79,  22, 238,  90,   0, 151, 219, 247, 119,  98,  12, 250,   0, 151, 219, 247, 119, 224, 162,   1,   0, 151, 219, 247, 119, 226, 108, 108,
       0, 151, 219,  39, 119, 255,  62, 181,   0, 128, 134, 155, 155,  58, 181,  58,   0,   9, 111, 247, 113, 181, 108, 250,   0, 151, 219,  31,  95, 162, 108,  84,
     151, 219, 247,  32,   0,   0,   0,   0, 128, 151, 219,  45, 158,   0,   0,   0, 128, 114, 109,  79,   0,   0,   0,   0,  54, 114, 247,   0,   0,   0,   0,   0,
     194, 245,   8, 146,   0,   0,   0,   0, 194,  20, 219, 139,   0,   0,   0,   0, 194,  56,  72,   0,   0,   0,   0,   0,  61,  20, 151, 114,   0,   0,   0,   0,
     151, 219, 247, 255, 161,   0,   0,   0, 156, 151, 219,  30,   0,   0,   0,   0, 128, 156, 219, 196, 211,   0,   0,   0,  85, 156, 219, 226,   0,   0,   0,   0,
      85, 156, 219, 121,   0,   0,   0,   0,  85, 190, 151, 116,   0,   0,   0,   0,  85, 128, 190,  66,   0,   0,   0,   0,  94, 128, 151,  89, 142,   0,   0,   0,
       0, 219, 247, 247,  79, 118,  22,   4,   0, 151, 219, 247, 119,  63,  63, 250,   0, 151, 219, 219, 199, 249, 160, 226,   0, 151, 184, 239, 223, 222, 224, 207,
       0, 190, 130,   7, 231,  58,  63,   1,   0,  20, 219, 115, 100, 118, 162, 214,   0,  73, 244,  74,  59,  58, 192,  90,   0, 117, 145, 146, 140,  58, 162,   1,
       0, 219, 247, 119,  79,  22, 238,  90,   0, 151, 219, 247, 119,  79,  12, 250,   0, 151, 219, 247, 119,  12, 162, 181,   0, 151, 219, 247,  51,  79, 162,  84,
       0, 151, 219, 247, 113, 148,  12,  84,   0, 151, 219, 247, 222,  12,   4, 250,   0, 151, 219, 183, 119,  62,  99,   1,   0, 151, 219,  31, 222,  12, 250,  84,
     151, 219, 247, 255,   0,   0,   0,   0, 156, 151, 219, 191,   0,   0,   0,   0, 128, 156, 151,  53,   0,   0,   0,   0,  85, 190, 219, 160,   0,   0,   0,   0,
      85, 128,   5,  49,   0,   0,   0,   0,  85, 137, 245, 169,   0,   0,   0,   0,  94, 128, 190,   0,   0,   0,   0,   0,  61, 128, 219, 133,   0,   0,   0,   0,
     151, 219, 247,  58, 255,   0,   0,   0, 156, 151, 219, 220,  30,   0,   0,   0, 156, 151, 219, 219,   0,   0,   0,   0, 156, 151, 219, 155,  48,   0,   0,   0,
      85, 156, 219,  89,  90,   0,   0,   0,  85, 156, 219, 108,   0,   0,   0,   0,  85, 156, 151, 222,   0,   0,   0,   0,  60, 156, 219, 192,   0,   0,   0,   0,
       0, 200, 179,  82,  51,  63,  99, 250,   0, 117, 142, 239, 103, 223, 103, 250,   0,  97, 111,  13, 227,  47, 142,   4,   0, 116,  72,  59, 129, 199, 223, 181,
       0,  56, 212, 213,  44, 207, 126,   0,   0,  10, 184, 126, 107,  30,  51, 214,   0, 152,  20,  66, 232, 110, 230, 181,   0, 117, 146, 146, 227,  53,  99,   4,
       0, 219, 247, 119, 119,  62,  12, 214,   0, 151, 219, 247, 140, 119,  99, 108,   0, 187, 151, 247,  51,  63, 181, 199,   0, 212, 109, 219,  59, 158, 214, 207,
       0,   8,  52,  40, 118, 140, 238, 238,   0, 208, 219, 132, 100, 167, 133, 224,   0,  41, 211, 142,  25, 127, 100,   7,   0, 145,  96, 159, 110,  99,  51, 101,
     128, 244,  13,  59,   0,   0,   0,   0, 252,  75, 219, 232, 164,   0,   0,   0, 252, 245,   9,  57,   0,   0,   0,   0, 194, 128,  44, 220,   0,   0,   0,   0,
      87, 212, 125,   0,   0,   0,   0,   0,  85,  36,  20,   0,   0,   0,   0,   0,  50,  20, 228,   0,   0,   0,   0,   0, 186, 128,  80,  51,   0,   0,   0,   0,
     156, 219, 247, 220, 118,   0,   0,   0,  97, 151, 219, 168,   0,   0,   0,   0,  35, 190, 151, 100,   0,   0,   0,   0, 242, 170, 176, 202,   0,   0,   0,   0,
      94, 170, 151,  45,   0,   0,   0,   0,  85, 144,  52,   0,   0,   0,   0,   0,  85, 170, 145,   0, 113,   0,   0,   0,  34,  20, 244,  72,   0,   0,   0,   0,
       0, 213, 219,  82, 172, 249,  63, 250,   0,  97, 121, 202,  82,  51, 249,  58,   0,  97,   9, 145, 146, 159,  93, 192,   0,  97, 184,   6,  89,  20,  65,   0,
       0, 144, 130,  72,  82,  13,  45, 103,   0, 213,  26, 216, 231, 250,  58, 250,   0, 150,  20, 147,  89, 152,  13, 181,   0,  48,   9, 146, 103,  58, 104, 104,
       0, 219, 247, 119,  79,  62, 167, 214,   0, 151, 219, 247, 119,  79,  12, 250,   0,  43, 219, 247, 119,  53,  63,   1,   0, 151, 219, 183, 223,  63, 162, 238,
       0, 120, 219,  39, 172, 108, 158, 181,   0, 144, 229,  31, 123,  98, 249,   4,   0, 114, 109,  82,  58,  58, 160, 224,   0, 240, 219,  59,  51,  98,  99, 101,
     252, 216, 219, 219,   2,   0,   0,   0, 252, 190, 151, 156,   0,   0,   0,   0,  94, 128, 121,  13, 167,   0,   0,   0,  94,  54, 176,  86,   0,   0,   0,   0,
      88,  27,   8,   0,   0,   0,   0,   0,  87, 128, 134,  92,   0,   0,   0,   0, 153, 161, 117,   0,   0,   0,   0,   0,  50, 194, 245,  40,   0,   0,   0,   0,
     156, 219, 247,  62,   1,  89,   0,   0,  97, 219, 219, 249,   0,   0,   0,   0,  85, 151, 219, 230,   0,   0,   0,   0, 252, 189, 219,  70,   0,   0,   0,   0,
     252, 156,  77,  89,   0,   0,   0,   0,  94, 149, 120,  12,   0,   0,   0,   0,  55, 156, 124, 189,   0,   0,   0,   0,  94, 240, 219, 199,   0,   0,   0,   0,
       0,  70, 111,  82,  51,  51,  58, 250,   0,   9,  25, 239,   7,  82,  99,  14,   0,   9,  38,   7, 244,  28,  98,  58,   0, 235, 245, 121, 123, 181,  65,   1,
       0,  28, 245, 176, 146, 205, 186,   1,   0,  85, 237, 120, 192, 176, 175,   7,   0, 205,  20,   2, 100,  51,  42,  75,   0, 156, 145,  18,  98,  59,  59, 192,
       0, 219, 247, 119,  79,  12,   4, 214,   0, 151, 219, 247, 199, 222,  99, 162,   0, 151, 219, 168, 119,  47, 214, 167,   0, 156, 120, 247, 100, 119,  62, 101,
       0, 187, 200, 100,  63,   7, 143, 115,   0, 149, 151, 247,  58, 227,  46, 148,   0,  64,   5, 219, 137, 160, 214,   0,   0, 187, 219, 247, 158,  98,   4, 250,
     128, 213, 219, 104,   0,   0,   0,   0, 194,   9, 109, 195,  63,   0,   0,   0,  85, 190, 244,   0,   0,   0,   0,   0,  94,  97, 184,  40,   0,   0,   0,   0,
      94,  27,  94,   0,   0,   0,   0,   0,  19,  85, 151,   0,   0,   0,   0,   0,  50,  61, 237,   0,   0,   0,   0,   0, 105,  28, 145, 144,   0,   0,   0,   0,
     151, 219, 219, 119, 190,   0,   0,   0, 156, 151, 219, 160,   0,   0,   0,   0,  85, 137, 219,  51,   0,   0,   0,   0,  85, 156, 190,   0,   0,   0,   0,   0,
      85, 156,  97,   0,   0,   0,   0,   0,  94, 156, 159,   0,   0,   0,   0,   0,  94,  20,  96, 243,   0,   0,   0,   0,  60,  20, 219, 154,   0,   0,   0,   0,
       0, 151, 219, 239, 172, 249, 108, 250,   0, 189, 184, 202, 146, 123, 158, 108,   0,  97, 213,  74,   6, 115, 232, 108,   0,  97, 213,  25, 202,  47, 224, 118,
       0,  73, 235,  25, 146, 148,  58, 104,   0, 128,  20, 147,  51, 126,  46, 162,   0, 128, 243,  74, 176,  58, 250,  46,   0, 128, 245, 146,  59, 223, 250, 101,
       0, 219, 247, 247, 119,  62,   4, 214,   0, 151, 219, 247, 247, 222,  12,   1,   0, 151, 219, 247, 100,  98,  58,   4,   0, 151, 151, 247, 199, 224, 162, 181,
       0, 156, 219, 247, 155, 123, 181,  84,   0, 156, 219, 247, 199,  98, 158, 255,   0, 137, 151, 109, 172,  51,  43, 223,   0, 156, 219, 168, 222,  12, 250,  84,
      97, 213, 151, 108, 160,   0,   0,   0,  85,  97, 151, 189,   0,   0,   0,   0, 252,  97, 190,  43,   0,   0,   0,   0,  94,  97, 245,  76,   0,   0,   0,   0,
      94, 186, 201,   0,   0,   0,   0,   0,  94,  85, 170, 216,   0,   0,   0,   0,  50,  61, 184, 171,   0,   0,   0,   0,  50, 128, 147, 104,   0,   0,   0,   0,
     151, 219, 219, 100,  18,   0,   0,   0, 156, 151, 219, 247,   0,   0,   0,   0,  85, 156, 151, 114,   0,   0,   0,   0,  85, 156, 151,  64,   0,   0,   0,   0,
      85, 156, 151, 197,   0,   0,   0,   0,  85, 156, 151,  90,   0,   0,   0,   0,  60, 156, 151, 100,   0,   0,   0,   0,  60, 156, 151, 108,  22,   0,   0,   0,
      80, 145, 115, 100,  79, 222,  99, 101, 186,   8, 142, 159, 172,  58,   1, 108,  61,  20,  21,  59, 158,  47, 104, 108,  54, 144, 251,  59, 227, 103, 226, 214,
      34, 212,  20, 103, 113,  63, 250, 181,  20,   9, 142, 223,  72, 162,  84, 199,  20,  20, 184, 125, 112,  98, 111, 214,  34,  20, 142, 146, 125,  47, 158, 250,
     114, 114, 219,  44,  51,  99,  63,   4,  94, 128, 245,  70,  51,  47, 110, 201,  50,  61, 190,  74, 124, 199, 125,   8,  50,  27, 245, 235, 232, 121, 162, 226,
      50,  34,  20, 232, 124, 130,  19, 181,  61,  15, 130,  26, 231,  22, 120,   0,  61,  61, 144,  18,  54, 144, 166, 214,  34,  20,  20, 251,  89, 100, 232, 226,
     114, 145, 219, 247,  16,  98, 158,  84,  94, 190,  38, 145, 231, 103, 160, 104,  61,  20, 190,  25,  14, 103, 226, 104,  61, 161,   8,  74, 231,  51, 249, 160,
      61, 212, 184, 145,   7, 226, 123, 125,  50,  61, 235,  44, 168, 110, 215,   4,  34,  20,  20, 237,  24, 102, 125, 103,  34,  20,  20, 125, 103, 100, 104,  84,
     128, 151, 219, 247, 119, 158,  99,  63,  94, 161,  38, 234,   7, 103,  31,  72,  94, 128, 190,  25, 179, 126, 192,  89,  50, 242, 190,  25, 211, 192, 181,  72,
      50,  85, 190,  75,  72,  25, 118,  63,  50,  61,  73,   3,  18,  18, 166,  16,  50, 194, 245,   6,  89, 197, 203, 108, 153,  61,  20,  26,  72, 125,  66, 104,
     128, 145, 145, 247, 123, 148, 108, 207,  94, 144, 245,  42, 159, 103, 226, 158,  61,  20, 147, 159,  59, 146, 192,  72,  61,  61,  26, 216,  14, 109, 247, 249,
      61,  69, 120,  18, 219,   2,   7, 250,  61,  61, 190, 245, 175, 238, 207, 250,  61, 215,  25,  56, 125,  89, 238, 207,  34,  20,  20, 125,   7, 125, 100,  84,
     128, 114, 145, 247, 100, 249,  95,  84,  94, 128, 190,  25, 103,  25, 104, 250,  50, 252, 190,  33,  26, 103,  47,  47,  50,  61, 245, 237, 103, 125, 182, 192,
      88,  61, 245, 147, 172,  89, 198,  58,  50,  61, 190,  20, 103,  18,   7,  27, 153,  61,  20, 237, 144, 172, 135, 101, 153,  61,  20, 237,  18, 103, 103, 104,
     128, 151, 219, 247, 247,  63, 226,   4,  94, 128, 151, 142,  59, 232,  58, 108,  94, 144, 190,   6, 103, 249,  26, 155,  50,  94, 245, 134,  14,  82, 167, 250,
      50,  54,  20, 251,  42, 129,  63, 199,  50,  61, 190, 147, 125,   6, 125, 250,  50,  61, 117, 235, 115, 121, 192,  84, 153,  61,  20, 125, 100, 251, 108,  72,
     128, 151, 219, 247, 247, 119,  12,   4,  94, 156, 151, 219,  13, 103, 125, 108,  50,  69, 151,  25,  72, 232, 103,  12,  50,  85, 190,  21,  14,  89,  26, 160,
      50,  85, 190,  33,  14,  14,  14, 104,  50,  94,  73,  33,  14,  47,  18, 104, 153,  61, 190,  26,  14,  47, 129, 181, 153,  61,  20, 237,  14,  89,  89,  84,
     114, 145,  13, 126,  58,  99, 158, 162, 186, 190, 145,  42,  47,  18, 249, 108,  94, 144, 142, 237, 231, 226, 249, 203,  50,  20, 147, 237, 103, 226, 176, 207,
      61,  20,  20,  18,  18, 146, 186,  90,  61,  20,  20,   7,  76, 126, 232,   1,  34,  20, 216, 125,  83,  18, 179, 108,  34,  20,  20, 125,  80,  20, 181, 192,
     128, 244, 219,  65, 249, 251,  51,  47,  94, 128, 190,  33,  44, 192,  47,  72,  94, 252, 190, 184, 237,  16, 200,  80,  50,  61,  27,  26, 166, 192, 226, 119,
      50,  61, 128,  18, 100, 192, 153,  90,  50, 186,  20, 215, 125, 195,   0, 244,  50,  61,  20, 143,  24, 191,  79, 104, 153,  61,  20,  20, 129, 125, 232,  67,
     114, 145, 145, 155, 249,  98, 108,  84,  94, 128, 245, 237, 103, 103, 103,  59,  94, 128, 190, 159,  14, 227, 255, 192,  50,  61, 190,  26,  14,  89,  99, 162,
      50,  61,  20,   8,  72,  47,  45,   4,  50,  61,  20, 201,  14, 125,  89,  84,  50,  61, 190,  18, 237, 113,   1, 250, 153,  61,  20,  18,  18, 103,  47,  84,
     128, 151, 219, 247, 100,  58, 108, 226,  94, 128, 190, 237,  72,   7, 227, 104,  94,  85, 190,  33,  14,  72, 135,  89,  50,  94, 128,  33,  26,  18, 125, 103,
      50,  94, 144,  26,  45,  72, 192, 104,  50,  94,  73, 147, 159,  72,  26,  84, 153,  61,  20,  28,  26,  14, 192, 235, 153,  61,  20,  26,  18,  89, 103, 104,
     128, 151, 219, 247, 247, 226, 226,  84, 186, 243,   8,  25, 232,   7,  63,  72,  94,  27, 190,  45,   7, 251, 249, 231,  50,  73,  20,   3,  14, 242, 110, 193,
      50, 105, 190,  34,  14,  72, 250,  18,  50,  61,   8, 142, 249, 108, 104,  47,  50,  50, 154, 251,  95,  29,   0, 250,  34,  61,  20,  26, 125,  20, 224, 108,
     128, 156, 151,  44, 136, 103, 160, 108,  94, 128, 190, 245,  29,  47, 250, 108,  94,  85, 190,  33,  14, 231, 151, 205,  50,  94, 190,  26,  18,  89, 135,  89,
      50,  94, 190, 144,  26, 125, 191, 231,  50,  61, 144,  26,  18,  89,  14, 248, 153,  50, 190, 190,  72, 104,   9, 238, 153,  61,  20,  26,  18,  45, 192, 226,
     128, 151, 219, 247, 247, 226, 108,   4,  94, 128, 245,  48, 103,  47, 135,  47,  94,  85, 190, 147, 103, 103, 192, 192,  50,  85, 190,  26,  26,  14, 223, 108,
      50,  61,  20,  33,  14, 192,   7, 192,  50,  94,  20,  20,  14,  51,  23, 108,  50,  61,  73,  20,  47,  14, 181,  45, 153,  61,  20,  26,  18,  14, 125, 192,
     156, 151, 219, 247, 100, 100,  58, 250,  85, 137, 151,  21, 232, 232,  89, 104,  60, 137, 190,  21,  14, 232, 135, 104,  49,  85, 190,  33,  14,  14, 232, 135,
      49,  85,  73,  33,  14,  18,  89, 192,  49,  94,  73,  33,  18,  14, 192, 192,  49,  60,  73,  33,  14,  18, 232, 104, 153,  55,  32, 154, 135, 135, 135, 192,
     186, 144, 216, 159,  59,  58, 103, 250,  94,  54,   9, 146, 103, 255,  99,  99,  19,  85, 144, 146, 202,  13, 181,  47,  50, 161,  42, 115,  59,  63,  70,  83,
      88,  69,  25, 112, 231,  94, 219, 123,   2, 144,   3, 129,  58, 100, 177, 255,  61,  54,  25, 202, 160, 157,   0,   1,  34,  20,  20,  59, 160,  72,  47, 108,
     186,   8, 216, 239, 239,   7, 119, 155,  50,  27, 216, 245,  25,  82,  85, 109,  88,  61, 190, 147, 155, 242,  22, 192,  50, 150,  20,   5, 216, 144,   4, 143,
      88,  94, 144, 237, 103,  36, 209,  17, 163,  88,  36,  29, 232, 231, 148,  10, 163,  55,  28, 164,  15,  72,  74,  25,  34, 228, 235, 237, 129, 245, 101,  97,
     252,  97, 213, 237,   7, 103,  58, 104,  88, 252, 190,  56,  26, 146, 104, 108,  88,  94,  54,  33,  26,  14, 192, 104,  88,  94,  54,  54,  33,  45, 115, 202,
      88, 186,  27,  54,  14,  46,  18, 231,  88,  50,  20,  57,  18,  29, 100,  58,  10,  61,  20, 137, 120, 216, 104, 154, 163,  61,  54,  26,  26,  25, 104, 192,
     186,  97, 213, 121,   7, 102,  47, 250,  94,  85, 156,  25,  14,  72, 108, 104,  50, 105, 190, 235,  26, 245,   6, 101,  88,  19, 144, 130, 237, 192, 135,  67,
      50, 105,  61, 117, 117,  81, 195,  39,  88,  61, 144,  26, 241,  40, 166,   0,  88,  55,  34, 228, 146,  31,  75,  26, 153,  50,  54, 193, 103, 201, 146, 226,
     228, 235, 216,   6,  82, 103, 135, 104,  19, 186, 144,  25, 111, 235, 147, 103,  50,  50, 190, 251,  20,  47, 132, 232,  88, 242, 194, 235, 103, 154, 250,   0,
      50,  69,  67, 103, 162, 126, 191,  45,  50,   2, 147,  25,  44, 237, 159,   0, 153, 105, 184, 191, 144, 237, 227,  67, 163,  61, 190,  26,  47,  71, 104,   0,
     128, 216, 134, 239,  82,  47, 249,  47,  94,  35, 190, 144, 144, 237,  41, 232,  94,  94,  20, 144, 237, 103,  31, 240,  88, 105, 144, 235, 159,  22,  51, 224,
      50,  61, 235, 237, 103, 103, 159,  67,  49,   2,  20, 144, 237, 237, 141, 178, 153,  19, 144, 144, 103, 103, 159,   7, 153,  61, 144, 144, 103, 103,  51,  18,
     186,  97, 216, 124,  72,   7,   7, 226,  50, 252,   9,  38, 202,  72, 192,  58,  88,  94, 161,  56,  26, 115,  80, 146,  88,  36,  73,  54,  45, 197, 250, 255,
      88,  61, 190,  20, 251, 103, 147, 181, 153,  87,  73, 114, 180, 182,  45, 110, 153,  61,  54, 251, 251, 120, 126, 138, 153,  61,  27,  26, 147,  68, 135,  26,
      85, 156, 219, 219, 247,  51, 108, 108,  94, 165, 151, 219, 159, 102,  89, 226,  49,  85, 156, 245,  14, 146,  45,  14,  50, 105, 190,  21, 232,  72,  89, 212,
     153,  61, 243,  33, 237, 245,  82,  59,  88,  61,  69, 156,  18,  83, 102,  64, 153,  50, 190,   8,  18, 251, 242,   0, 153,  61,  20,  26,  18,  72, 142, 197,
     186, 144, 245,  56,  89, 125,  56, 127,  19, 186,   8,   8,  89, 132, 232, 158,  50, 186, 212, 147, 231, 237, 247, 104,  50,  61, 190,  45,  14,  79,  15,  20,
      50,  88, 194, 129,  34,  27, 202,  62,  88,  61, 190,  50, 128, 151,  73, 162,  88, 105, 215,  26,  26,  87, 143,  92, 163,  61, 215,  20, 197, 124,  14, 192,
     252, 128, 184, 121, 146, 232, 185,  63,  94,  94, 161, 233,  17, 227, 246,  34,  88,  94, 221,  28, 232,  22,  37, 215,  88,  69,  20,  75, 109, 192, 211, 193,
      50,  61, 190,  28, 134, 233, 151, 224,  50,  94,  61, 232, 119, 138,   0,   0,  88,  50, 194, 194, 252,  92,  10,   0, 153,  61,  20, 144,  25, 252, 197,  86,
     252, 252, 190,  56,  29, 103, 159, 104,  88, 252,  54,  54,  26, 129, 201, 192,  88,  94,  54,  26,  14, 196, 103, 192,  88,  50,  54,  54,  18,  45,  26, 192,
      88,  50,  54,  54,  26, 135, 197, 104,  88,  50,  61, 197,  54,  14, 166, 192,  10,  50,  61, 197, 192,  18,  88,  10,  10,  88,  61, 197, 135, 135, 192, 192,
     252, 128, 213, 237, 103,   7,  72, 192,  94,  85, 190, 235,  14,  89, 147,   8,  88,  94,  69,  54,  33,  72, 103, 108,  88,  94,  85,  54, 135, 135, 114,  85,
      88,  50,  69, 144, 135, 175, 147, 163,  88,  50,  61,  61,  26,  42, 155, 192, 153,  88,  94,  36,  56, 243, 158, 156,  10, 153,  61,  61, 210, 251, 135, 192,
     186, 240, 245, 235,  25, 154, 133,  78,  19, 186, 144,  20,  33, 103,  44, 192,  50, 252,  20,  80, 125, 134, 209,  30,  50,  50,  73,  26,  25, 125, 222, 125,
      50,  87, 194, 235,  50, 132, 151, 108, 153, 105, 212,  50, 201,  81,   0, 249, 153,  34,  69, 103,  61, 106,   0,   0, 153,  61, 186,  26,  20,  20,   7,  17,
     128, 156, 151, 202,  82, 104, 155, 145,  94,  85, 190, 216, 159, 144, 253, 108,  94,  94, 190, 147,  56, 146, 100, 103,  50,  94, 144, 212,  18, 177, 174, 200,
      50, 105, 144,  20, 100, 235, 122, 174,  88,  50, 144,  87, 216,  89, 159, 251, 153,  50, 144, 194,  20,   8, 181, 243, 153,  61,  61, 144, 144, 237,  18, 104,
     252,  97,   9, 237,  14,  72, 146, 104,  94, 252, 190,  54,  26,  45,  47, 104,  88,  94,  54,  26, 135,  26,  82, 192,  88,  94,  61, 154,  14,  72, 103, 103,
      88,  50,  61,   2,  26, 147,  88,  45,  88,  50,  61,  20,  14,   2, 254,  70, 153,  50,  50,  87, 125, 237, 137,  19,  10,  88,  61, 197,  26, 135,  26, 192,
      85, 156, 151, 219,  72,  72, 232, 108,  94, 242, 170,  21,  14,  18,  25, 103,  94,  85, 190,  33,  14,  45, 192, 104,  49,  94,  73,  33,  14, 232,  21,  47,
      49,  94,  69, 212,  14,  89,  14,  34,  49,  50, 194, 105, 135,  97,  45,  80, 153,  55,  61,  36,  33, 173,  21,  92, 153,  50,  61, 154, 135, 135, 135, 192,
       0,  44, 247, 119,  79,  22, 238, 250,   0, 216, 179,  59,  51,  12,  99, 250,   0, 184, 179,  59,  51, 148,  99, 250,   0,  97, 179, 100, 118, 181,   4, 162,
       0,  78, 191, 132,  62, 132, 238, 250,   0, 187, 179, 249,  53, 108, 214, 249,   0, 143,   7, 155, 224,  59, 207,  79,   0, 225,  65, 113,  99, 167, 214, 101,
       0, 219, 247, 119,  79,  22, 167, 214,   0, 151, 219, 247, 119, 148,  22, 214,   0,  77, 219, 247,  79,  12,   4,   4,   0, 151, 247, 126, 113, 148,   4, 118,
       0, 253, 168,  30,  79, 178, 101,  12,   0, 151, 191, 131, 222, 250,  70,   1,   0,   5, 131, 119,  62, 255, 111,   1,   0,  38, 247, 119, 224, 167, 181,  84,
     151, 247, 247,  98, 101,   0,   0,   0,  97, 216,  41, 118,   0,   0,   0,   0,  97,  38, 142,  98,  64,   0,   0,   0, 177, 244, 179, 224,   0,   0,   0,   0,
     128, 244, 179, 104,   0,   0,   0,   0,  61, 244,  65,   0,   0,   0,   0,   0,  34, 219, 223,   0,   0,   0,   0,   0,  20,   7,  82, 250,   0,   0,   0,   0,
     151, 247, 247,  22,   0,   0,   0,   0, 156, 219, 219, 160,   0,   0,   0,   0,  97, 151, 219,  12,   0,   0,   0,   0,  85, 219, 202,  12,   0,   0,   0,   0,
      27, 109, 115, 148,   0,   0,   0,   0,  15, 151,  82, 227,   4,   0,   0,   0, 128, 244, 191,   0,   0,   0,   0,   0,  20, 145, 247, 158, 160,   0,   0,   0,
       0, 219, 247, 119,  79,  62,  22, 101,   0, 120, 219, 247, 119,  51,  62, 250,   0, 151, 219, 247, 119,  98,  12, 226,   0, 244,  44,  68,  51, 108, 101, 162,
       0,  48, 247,  59, 231, 255, 231, 207,   0, 235, 179, 129, 119, 118, 207, 101,   0,  75, 247,  30, 222,  99, 238, 207,   0,   5, 182, 119,  79,  99, 207,   4,
       0, 219, 247, 119,  79,  22, 238,  90,   0, 151, 247, 119,  79,  62, 167, 214,   0, 151, 247, 119,  79,  62, 238, 101,   0, 151, 247, 119, 178,  22, 207,   1,
       0, 187, 247, 119,  79,  22,   4, 214,   0, 139, 191, 119,  79, 167,   4,  90,   0, 219, 191, 119,  79,  62, 238, 214,   0, 120, 247, 119, 118, 167,   4, 214,
     151, 247, 247,   4, 191,   0,   0,   0, 170, 219, 219, 226,   0,   0,   0,   0, 128, 121, 219, 189,   0,   0,   0,   0, 252,   6,  13,  84,   0,   0,   0,   0,
      97, 245, 225,  62,  28,   0,   0,   0, 128, 151, 168, 250,   0,   0,   0,   0, 252,  56, 225,  62,   0,   0,   0,   0,  15, 145, 202, 214,   0,   0,   0,   0,
     151, 247, 247, 238, 226,   0,   0,   0, 156, 219, 247, 162, 249,   0,   0,   0, 156, 219, 247, 226,   0,   0,   0,   0, 156, 219, 247,  22,   0,   0,   0,   0,
     128, 219, 247,  53,   0,   0,   0,   0,  85, 219, 247, 118,   0,   0,   0,   0,  85, 219, 247, 226,   0,   0,   0,   0, 128, 219, 191, 162,   0,   0,   0,   0,
       0, 219, 247, 247, 110,  79, 108, 101,   0, 213, 216, 239,  51,  63, 162, 108,   0,  97, 216, 239,  51,  63,  22, 192,   0, 243,  77,  25, 249,  58,  42, 101,
       0,  97,   6, 179,  63, 181, 158, 250,   0, 177, 184, 124, 158, 162, 101, 167,   0,  33, 109,  82, 100, 238, 214,  45,   0, 244, 142,  59,  51, 226, 101,   4,
       0, 219, 247, 119,  79,  22,   4,   1,   0, 213, 219, 247, 119,  58,   4, 250,   0, 213, 219, 247,  63, 255, 108,  12,   0, 128,  78, 182, 164, 224, 100, 104,
       0, 156, 219, 172,  16, 162, 108,  98,   0, 245, 219, 247, 119,  99,   4,  90,   0, 151, 121, 222,  16, 222,  98,  62,   0, 245, 219,  59,  53,  58, 181,   1,
     244, 219, 247,  47,   0,   0,   0,   0, 252,  97, 219, 120,   0,   0,   0,   0, 252, 128, 121, 230,   0,   0,   0,   0, 252,  97,   8, 193,   0,   0,   0,   0,
     252, 128, 124, 203,   0,   0,   0,   0, 252, 128,   3,   9,   0,   0,   0,   0,  94,  33, 103, 110,   0,   0,   0,   0,  61,  20,  41, 110,   0,   0,   0,   0,
     151, 219, 247, 226,   0,   0,   0,   0,  97, 213, 219,  33,   0,   0,   0,   0,  85, 156, 151,  61,   0,   0,   0,   0,  85, 156, 145,  55,   0,   0,   0,   0,
     252, 128, 219, 189,   0,   0,   0,   0,  94, 156, 142, 108,   0,   0,   0,   0, 252, 190, 219,   0,   0,   0,   0,   0,  61, 190,  52, 153, 125,   0,   0,   0,
       0, 219, 247, 247, 119,  22, 207,   1,   0, 151, 219, 219, 199, 119, 148, 250,   0, 213, 151, 229, 231, 239, 103,  51,   0, 151, 109, 202, 225,  23, 160, 111,
       0, 149, 142, 239,  59,   4,  33, 108,   0, 190, 142, 219,  23,  99,  34,   0,   0, 213, 219,  59,  13,  58,  70, 127,   0, 151, 145,  82, 158,  79,  53, 214,
       0, 219, 247, 119,  79,  62, 238,  90,   0, 219, 219, 247, 119,  79, 207,   4,   0, 151, 219, 247, 119,  58, 162, 250,   0, 151, 219, 247, 113, 160, 250, 250,
       0, 151, 219, 247, 110,  12,   1, 214,   0, 151, 219, 126,  58,  62, 214,  22,   0, 151, 219, 191, 255, 167,  63,  84,   0, 151, 219, 126, 222,  89,  90,  84,
     151, 219, 247,  68,   0,   0,   0,   0,  97, 213, 219, 102,   0,   0,   0,   0,  85, 213, 219, 109,   0,   0,   0,   0,  85, 128, 142, 226,   0,   0,   0,   0,
     252, 128, 159,  42,   0,   0,   0,   0, 252, 128, 134, 240,   0,   0,   0,   0,  61, 128, 142,   0,   0,   0,   0,   0,  61, 190, 120,  10,   0,   0,   0,   0,
     151, 219, 247, 224,  45,   0,   0,   0, 156, 151, 219, 227, 131,   0,   0,   0, 156, 151, 219, 111,   0,   0,   0,   0,  85, 156, 219, 218,   0,   0,   0,   0,
      85, 156, 219, 168,   0,   0,   0,   0,  85, 156, 219,  15,   0,   0,   0,   0,  85, 156, 219, 117,   0,   0,   0,   0,  85, 156, 219, 217,   0,   0,   0,   0,
       0, 213, 179,  59,  51,  63,  99, 250,   0, 213, 179,  59,  51,  51, 108,   1,   0,  97,  78, 202, 123,  63,  58,  84,   0,   5, 179, 202,  59,  58, 110, 250,
       0,  37, 134,  74, 112, 101, 101,   1,   0, 147, 145,   6, 103, 118,  82, 250,   0, 186, 179, 255,   4,  98, 158, 103,   0, 166,  74, 204,  51,  63,   4, 101,
       0, 121, 191, 191, 119,  62, 167, 214,   0, 176, 219, 191, 132,  79, 207, 108,   0, 221, 239, 239, 123, 224,  99, 162,   0, 221,  78, 239, 123, 167, 133, 255,
       0,  54,  13, 168, 119, 158, 225, 159,   0, 121, 142, 239, 227, 100, 213,  58,   0,  36,  48, 191, 178,  53, 172, 118,   0,  77, 109,  40, 224, 222, 249, 250,
      97, 216, 216, 227, 192,   0,   0,   0, 252,  97, 216, 212, 197,   0,   0,   0,  94, 150, 216, 135, 106,   0,   0,   0,  50, 144, 233, 162,   0,   0,   0,   0,
      87,  54,   9, 118,   0,   0,   0,   0,  88,  54, 114, 234,   0,   0,   0,   0,  49,  37, 225,  99,   0,   0,   0,   0,  88, 243, 235, 158,   0,   0,   0,   0,
      97, 121, 219, 127,  61,  92,   0,   0,  97, 213, 219,  72, 203,   0,   0,   0, 252, 213, 234,  52,   0,   0,   0,   0,  94, 240, 211, 236,   0,   0,   0,   0,
     252, 114,  75,  58,   0,   0,   0,   0,  15, 137, 145,   0,   0,   0,   0,   0, 252, 170,  24,   0,   0,   0,   0,   0,  64, 245, 185, 200,   0,   0,   0,   0,
       0, 121, 219, 191,  51,  63,  99, 250,   0,   5, 121, 219, 172, 249, 158, 108,   0, 156, 216, 179, 172, 103,   7, 250,   0,  97, 142, 145, 103, 123,  27, 227,
       0, 221, 130, 121,  40, 123,  59, 104,   0, 143, 245,  82, 222,  23, 100, 163,   0, 241, 202,  74, 159,  19, 122,  67,   0, 176, 121,  82, 103, 249, 250, 108,
       0, 169, 191, 119,  79,  62, 167, 214,   0, 219, 247, 247, 119,  62,  12, 214,   0,   5, 219, 247, 119,  63,  12,   1,   0, 213, 219, 119, 119, 148,  99,   1,
       0, 187, 191, 119, 140, 224,   4, 238,   0,  38, 219, 199,  63, 238,   1,   4,   0,  24, 239,  40,  22, 178,  58,  84,   0, 169, 191, 119, 178,  22, 181, 214,
      97, 121, 219, 249, 250,   0,   0,   0,  97, 213, 216,  47,   0,   0,   0,   0,  64,   9, 107,  45,   0,   0,   0,   0,  85, 213,  70, 196,   0,   0,   0,   0,
     252,  97, 134, 124,   0,   0,   0,   0,  60, 213, 120,  88,   0,   0,   0,   0,  64,  37,  77, 108,   0,   0,   0,   0, 252, 245, 213, 241,   0,   0,   0,   0,
     133, 191, 191,  62, 214,   0,   0,   0, 156, 219, 219, 172, 118,   0,   0,   0, 128, 151, 219, 255, 226,   0,   0,   0,  85, 151, 219, 107,   0,   0,   0,   0,
      85, 151, 234, 214,   0,   0,   0,   0, 194, 134, 219,  64,   0,   0,   0,   0, 252,  56, 168, 175,   0,   0,   0,   0, 186, 145, 168, 146, 227,   0,   0,   0,
       0,  97, 216,   6, 102, 227, 226, 108,   0,  97, 213,  25,  13, 227, 104, 192,   0, 252, 221, 237, 146, 199, 219, 108,   0, 252, 213,  80, 202,  30,  41,  84,
       0, 165, 235, 142, 126, 232, 187,   0,   0,  97,  48,  42,  31, 166, 184, 192,   0,  97, 193,   8, 132,  51, 181, 181,   0,  27, 245, 159, 103,  47,  99,   1,
       0, 107, 219, 191, 119,  12,  12, 101,   0, 213,  78, 219, 199, 224, 162, 250,   0, 213, 107,  44, 249, 232,  63, 250,   0, 213, 107,  13,  72, 118,  53, 167,
       0,  97,  70, 168,  16, 132, 101, 229,   0, 213, 142, 232, 222, 100, 198, 245,   0, 184, 244, 168,  47, 108,   0,   0,   0, 213, 145, 191, 199,  58, 249, 108,
     252,  97, 216,  45, 114,   8,   0,   0, 252, 252, 190, 166,   0,   0,   0,   0, 252, 252, 144, 113,   0,   0,   0,   0,  88, 252,  54, 166,   0,   0,   0,   0,
      88,  94, 190, 238,   0,   0,   0,   0,  88,  61, 245, 174,  10,   0,   0,   0,  88, 252,  54, 198,   0,   0,   0,   0,  88, 252,  54,  86, 202,   0,   0,   0,
      97, 213, 219,  39,  46,   0,   0,   0, 252,  97, 151,  17,   0,   0,   0,   0, 252,  97, 213,  52,   0,   0,   0,   0, 252,  97, 213,  60,   0,   0,   0,   0,
      94,  97, 156, 206,   0,   0,   0,   0,  94,  37, 142,   0,   0,   0,   0,   0,  94, 128, 133,   0,   0,   0,   0,   0,  94,  97, 190, 243,   0,   0,   0,   0,
       0, 213, 121, 219,  51,  63, 226, 108,   0,  97, 213, 121, 239, 231, 108, 104,   0,  97, 213,  25, 146,  47,  59,  25,   0, 128,   9, 139, 204, 232,  58, 177,
       0, 128, 216, 237, 103, 235, 145, 221,   0, 212, 245, 202,  45, 242, 108,   0,   0, 150,  33, 251, 153, 132,   0,   0,   0, 144, 216, 168,  65,  58,  82,  18,
       0, 219, 191, 191, 119,  62, 167, 214,   0, 151, 219, 247, 119,  63,  99,   4,   0, 151, 219, 247, 119, 227, 226, 226,   0, 156, 219,  39, 183,  58, 178, 148,
       0,  43, 151, 219,  98, 148, 140,  14,   0, 190, 219, 155, 112, 110,  22, 146,   0, 190,  78,  31, 100, 249,   6,  77,   0, 151, 219, 191, 223, 148,   4, 108,
      97, 213, 219,  13, 126,   0,   0,   0, 252,  97, 213, 171, 143,   0,   0,   0, 252, 252, 190,  49,   0,   0,   0,   0, 252,  85,  73,  74,   0,   0,   0,   0,
      94, 252,   9,   0,   0,   0,   0,   0,  94,  35, 159,   0,   0,   0,   0,   0,  94, 194,  70,   0,   0,   0,   0,   0,  94, 194, 184, 111,   0,   0,   0,   0,
      43, 219, 219, 127,  99,   0,   0,   0,  97, 151, 219, 195,   0,   0,   0,   0,  85, 156, 219, 182,   0,   0,   0,   0,  85, 156, 219, 146,   0,   0,   0,   0,
      85, 170, 219, 171,   0,   0,   0,   0,  94, 170, 219,   1,   0,   0,   0,   0,  94, 170, 219, 140,   0,   0,   0,   0,  94, 170, 219, 248,   0,   0,   0,   0,
};

static INLINE int bsc_stretch(const int p)
{
    return bsc_stretch_table[p];
}

static INLINE int bsc_squash(const int s)
{
    return bsc_squash_table[2048 + s];
}

static INLINE int model_rank_state(const int contextRank4, const int contextRun, const int rankSizeHistory)
{
    return model_rank_state_table[(contextRun << 11) | (contextRank4 << 3) | (rankSizeHistory)];
}

static INLINE int model_run_state(const int contextRank0, const int contextRun, const int rank, const int runSizeHistory)
{
    return model_run_state_table[(contextRank0 << 10) | (contextRun << 6) | ((rank < 7 ? rank : 7) << 3) | (runSizeHistory < 7 ? runSizeHistory : 7)];
}

#endif

/*-----------------------------------------------------------*/
/* End                                              tables.h */
/*-----------------------------------------------------------*/
