/*

 This file is part of the Brother MFC/DCP backend for SANE.

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 Place, Suite 330, Boston, MA  02111-1307  USA

*/
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//
//	Source filename: brother_mfcinfo.h
//
//		Copyright(c) 1997-2000 Brother Industries, Ltd.  All Rights Reserved.
//
//
//	Abstract:
//			ǥХ˴ؤ빽¤Ρܥ
//
//
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#ifndef _BROTHER_MFCINFO_H_
#define _BROTHER_MFCINFO_H_

#include "brother_dtype.h"

//
// MFCǥ롦
//
#define MODEL_YL1_1      0		// 4550
#define MODEL_YL1_2      1		// 6550,7550
#define MODEL_BY1_US     2		// 7000,7200
#define MODEL_BY1_EUR    3		// BY Eurlope
#define MODEL_BY1_3IN1   4		// MC3000
#define MODEL_YL2_US    10		// YL2 USA model
#define MODEL_YL2_EUR   11		// YL2 Eurlope model
#define MODEL_BY2_US    12		// BY2 USA Color model
#define MODEL_BY2_EUR   13		// BY2 Eurlope Color model
#define MODEL_YL3       14		// YL3 series
#define MODEL_BY4       15		// BY4 series
#define MODEL_YL4       16		// YL4 series
#define MODEL_ZLe       17		// ZLe series
#define MODEL_BHL       18		// BH-low series

#define BIT_YL		0x100		// YL bit
#define BIT_BY		0x200		// BY bit
#define BIT_YL2		0x400		// YL2 bit
#define BIT_BY2		0x800		// BY2 bit
#define BIT_3IN1	0x1000		// 3in1 bit
#define BIT_EUR		0x2000		// Eurlope

typedef struct tagMFCMODELINFO {
	WORD  wModelType;		// MFCǥ롦
	WORD  wDialogType;		// Dialog(UI)
	BOOL  bColorModel;		// 顼ʡǥ
	BOOL  b3in1Type;		// 3in1ǥ(MC3000)
	BOOL  bDither;			// Ditherݡȡǥ
	BOOL  bVideoCap;		// VideoCaptureݡȡǥ
	BOOL  bQcmdEnable;		// Q-commandݡȡǥ
} MFCMODELINFO, *LPMFCMODELINFO;

#define TWDSUI_YL    0
#define TWDSUI_3IN1  1
#define TWDSUI_BY    2
#define TWDSUI_NOVC  3


#pragma pack(1)
//
// ǥХݡȤ륫顼
//
typedef union tagMFCCOLORTYPE {
	struct {
		BYTE  bBlackWhite:1;	// ͡
		BYTE  bErrorDiffusion:1;// Ȼ
		BYTE  bTrueGray:1;	// 졼
		BYTE  b256Color:1;	// 256顼
		BYTE  b24BitColor:1;	// 24bit顼
		BYTE  b256IndexColor:1;	// 256顼MFCѥåȥơ֥
	} bit;
	BYTE val;
} MFCCOLORTYPE, *LPMFCCOLORTYPE;

#define MFCDEVINFMONO   0x07		// ǥΥǥեȥ顼
					//   (B&W, ErrorDiff, TrueGray)
#define MFCDEVINFCOLOR  0x1F		// 顼ǥΥǥեȥ顼
					//   (B&W, ErrorDiff, TrueGray, 256Color, 24bit)


//
// ǥХΥʡӥǥǽϾإå
//
typedef struct tagMFCDEVICEHEAD {
	WORD  wDeviceInfoID;		// ǥХID
	BYTE  nInfoSize;		// ǥХΥIDϥ˴ޤޤʤ
	BYTE  nProtcolType; 		// DS<->MFC֤Υץȥ
					// 00h=1999ǯǥ, 01h=2000ǯǥ
} MFCDEVICEHEAD, *LPMFCDEVICEHEAD;

#define MFCDEVICEINFOID  0x00C1		// ǥХID
#define MFCPROTCOL1998   0		// 1999ǯǥ롦ץȥ
#define MFCPROTCOL2000   1		// 2000ǯǥ롦ץȥ


//
// ǥХΥʡӥǥǽϾ
//
typedef struct tagMFCDEVICEINFO {
	BYTE          nVideoSignalType; // ӥǥο
					//   00h=Reserve, FFh=ӥǥ̵, 01h=NTSC, 02h=PAL
	MFCCOLORTYPE  nColorType;	// ʤб顼
					//   00h=Reserve, MSB|0:0:256ix:24c:256c:TG:ED:BW|LSB
	WORD          nVideoNtscSignal; // NTSC浬
					//   0=Reserve 1:B,2:G,3:H,4:I,5:D,6:K,7:K1,8:L,9:M,10:N
	WORD          nVideoPalSignal;	// PAL浬
					//   0=Reserve 1:B,2:G,3:H,4:I,5:D,6:K,7:K1,8:L,9:M,10:N
	WORD          nVideoSecamSignal;// SECAM浬
					//   0=Reserve 1:B,2:G,3:H,4:I,5:D,6:K,7:K1,8:L,9:M,10:N
	BYTE          nHardwareType;	// Ĥμ
					//   00h=Reserve, 01h=NTSC 02h=NTSC/Lexmark 81h=PAL
	BYTE          nHardwareVersion; // ĤΥС
					//   00h=Reserve, 01h=Сֹ
	BYTE          nMainScanDpi;	// ʼ٤ǽ
					//   00h=Reserve, 01h=200dpi, 02h=200,300dpi, 03h=100,200,300dpi
	BYTE          nPaperSizeMax;	// бѻ極
					//   00h=Reserve, 01h=A4, 02h=B4
} MFCDEVICEINFO, *LPMFCDEVICEINFO;

#define MFCVIDEONONE     0xFF		// ӥǥ̵
#define MFCVIDEONTSC     1		// ӥǥο̤NTSC
#define MFCVIDEOPAL      2		// ӥǥο̤PAL
#define MFCVIDEOSECAM    3		// ӥǥο̤Secam

#define MFCHARDNTSC      1		// ĤμNTSC
#define MFCHARDLEX       2		// ĤμNTSC/Lexmark
#define MFCHARDPAL       0x81		// ĤμPAL

#define MFCMAINSCAN200   1		// ٤ǽϤ200dpiΤ
#define MFCMAINSCAN300   2		// ٤ǽϤ200,300dpi
#define MFCMAINSCAN100   3		// ٤ǽϤ100,200,300dpi

#pragma pack()
//
// ǥХΥʡӥǥǽϾΥʥǥХIDϥ˴ޤޤʤ
//
#define MFCDEVINFOFULLSIZE  sizeof( BYTE ) * 2 + sizeof( MFCDEVICEINFO )


//
// ǥХΥʾ󡿥ѥ᡼
//
typedef struct tagDEVSCANINFO {
	WORD        wResoType;		// ٥ֹ
	WORD        wColorType;		// 󤹤륫顼
	RESOLUTION  DeviceScan; 	// 󤹤²
	WORD        wScanSource;	// 󥽡
	DWORD       dwMaxScanWidth; 	// ɤ߼0.1mmñ̡
	DWORD       dwMaxScanPixels;	// ɤ߼Pixel
	DWORD       dwMaxScanHeight;	// ɤ߼Ĺ0.1mmñ̡
	DWORD       dwMaxScanRaster;	// ɤ߼Ĺʥ饹
	AREARECT    ScanAreaDot;	// ϰϻdotñ̡
	AREASIZE    ScanAreaSize;	// ɤ߼ϰϡʥɥåȿ
	AREASIZE    ScanAreaByte;	// ɤ߼ϰϡʥХȿ
} DEVSCANINFO, *LPDEVSCANINFO;

#define MFCSCANSRC_ADF  1		// 󥽡ADF
#define MFCSCANSRC_FB   2		// 󥽡FB
#define MFCSCANSRC_ADF_DUP  3           //06/02/27 󥽡ADFξ

#define MFCSCANMAXWIDTH      2080	// ɤ߼0.1mmñ̡
#define MFCSCAN200MAXPIXEL   1664	// ɤ߼ɥåȿ200dpi
#define MFCSCAN300MAXPIXEL   2464	// ɤ߼ɥåȿ300dpi
#define MFCSCANMAXHEIGHT     3476	// ADFɤ߼Ĺ0.1mmñ̡
#define MFCSCAN400MAXRASTER  5474	// ADFɤ߼饹400dpi
#define MFCSCAN600MAXRASTER  8210	// ADFɤ߼饹600dpi
#define MFCSCANFBHEIGHT      2910	// FBɤ߼Ĺ0.1mmñ̡
#define MFCSCAN400FBRASTER   4582	// FBɤ߼饹400dpi
#define MFCSCAN600FBRASTER   6874	// FBɤ߼饹600dpi

#endif //_BROTHER_MFCINFO_H_

//////// end of brother_mfcinfo.h ////////
