/*

 This file is part of the Brother MFC/DCP backend for SANE.

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 Place, Suite 330, Boston, MA  02111-1307  USA

*/
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//
//	Source filename: brother_mfccmd.c
//
//		Copyright(c) 1997-2000 Brother Industries, Ltd.  All Rights Reserved.
//
//
//	Abstract:
//			MFCʡޥɽ⥸塼
//
//
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
#include <usb.h>

#include "brother.h"

#include "brother_devinfo.h"
#include "brcolor.h"
#include "brother_devaccs.h"
#include "brother_misc.h"
#include "brother_log.h"

#include "brother_mfccmd.h"


extern BOOL  bTxScanCmd;


//
// CancelޥѤߥե饰
//
BOOL  bTxCancelCmd = FALSE;


//-----------------------------------------------------------------------------
//
//	Function name:	SendCancelCommand
//
//
//	Abstract:
//		󥻥륳ޥɤ
//
//
//	Parameters:
//		ʤ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//
void
SendCancelCommand( usb_dev_handle *hScanner, int seriesNo )
{
	if( bTxScanCmd ){
		//
		// Device OpenƤơScanޥѤ
		//
		if( !bTxCancelCmd ){
			WriteDeviceCommand( hScanner, MFCMD_CANCELSCAN, strlen( MFCMD_CANCELSCAN ), seriesNo );
			bTxCancelCmd = TRUE;

			WriteLogScanCmd( "Send CANCEL command", MFCMD_CANCELSCAN );
		}else{
			WriteLog( "Already sending CANCEL command" );
		}
	}else{
		//
		// Device OpenƤʤScanޥƤʤ
		//
		WriteLog( "Not need to send CANCEL command" );
	}
}


//-----------------------------------------------------------------------------
//
//	Function name:	MakeupScanQueryCmd
//
//
//	Abstract:
//		I-CommandΥޥʸ
//
//
//	Parameters:
//		lpszCmdStr
//			ޥʸؤΥݥ
//
//
//	Return values:
//		ޥʸĹ
//
//-----------------------------------------------------------------------------
//
int
MakeupScanQueryCmd( Brother_Scanner *this, LPSTR lpszCmdStr )
{
	char  szCmdStrTemp[ 16 ];


	//
	// ޥʸΥå
	//
	strcpy( lpszCmdStr, MFCMD_QUERYSCANINFO );

	//
	// ٥ѥ᡼Υå
	//
	strcat( lpszCmdStr, MFCMD_RESOLUTION );

	// ٤Υå
	WordToStr( this->scanInfo.UserSelect.wResoX, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );
	strcat( lpszCmdStr, MFCMD_SEPARATOR );

	// ٤Υå
	WordToStr( this->scanInfo.UserSelect.wResoY, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );
	strcat( lpszCmdStr, MFCMD_LF );

	//
	// ɤ߼⡼ɤΥå
	//
	MakeupColorTypeCommand( this->devScanInfo.wColorType, lpszCmdStr );

	//
	// TerminaterΥå
	//
	strcat( lpszCmdStr, (LPSTR)MFCMD_TERMINATOR );
	WriteLog("Resolution Command : %s",lpszCmdStr);
	return strlen( lpszCmdStr );
}


//-----------------------------------------------------------------------------
//
//	Function name:	MakeupScanStartCmd
//
//
//	Abstract:
//		X-CommandΥޥʸ
//
//
//	Parameters:
//		lpszCmdStr
//			ޥʸؤΥݥ
//
//
//	Return values:
//		ޥʸĹ
//
//-----------------------------------------------------------------------------
//	MakeupScanStartCmdʵMakeScanCom
int
MakeupScanStartCmd( Brother_Scanner *this, LPSTR lpszCmdStr )
{
	char  szCmdStrTemp[ 16 ];


	//
	// ޥʸΥå
	//
	strcpy( lpszCmdStr, MFCMD_STARTSCANNING );

	//
	// ٥ѥ᡼Υå
	//
	strcat( lpszCmdStr, MFCMD_RESOLUTION );

	// ٤Υå
	WordToStr( this->devScanInfo.DeviceScan.wResoX, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );
	strcat( lpszCmdStr, MFCMD_SEPARATOR );

	// ٤Υå
	WordToStr( this->devScanInfo.DeviceScan.wResoY, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );
	strcat( lpszCmdStr, MFCMD_LF );

	//
	// ɤ߼⡼ɤΥå
	//
	MakeupColorTypeCommand( this->devScanInfo.wColorType, lpszCmdStr );

	//
	// ̥⡼ɤΥå
	//
	strcat( lpszCmdStr, MFCMD_COMPRESSION );
	if( this->modelConfig.bCompressEnbale ){
		// PackBits̤
		strcat( lpszCmdStr, MFCMD_COMP_PACKBITS );
	}else{
		// ̵
		strcat( lpszCmdStr, MFCMD_COMP_NONE );
	}

	//
	// Brightnessѥ᡼Υå
	//
	strcat( lpszCmdStr, MFCMD_BRIGHTNESS );
	MakePercentStr( this->uiSetting.nBrightness, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );

	//
	// Contrastѥ᡼Υå
	//
	strcat( lpszCmdStr, MFCMD_CONTRAST );
	MakePercentStr( this->uiSetting.nContrast, szCmdStrTemp );
	strcat( lpszCmdStr, szCmdStrTemp );

	//
	// ̾ɥ⡼ɤΥå
	//
	strcat( lpszCmdStr, MFCMD_BUSINESS_OFF );

	//
	// Photo⡼ɤΥå
	//
	strcat( lpszCmdStr, MFCMD_PHOTOMODE_OFF );

	//
	// ɤ߼ϰϤΥå
	//
	strcat( lpszCmdStr, MFCMD_SCANNIGAREA );
	MakeDotStr( this->devScanInfo.ScanAreaDot.left, szCmdStrTemp, TRUE );
	strcat( lpszCmdStr, szCmdStrTemp );
	MakeDotStr( this->devScanInfo.ScanAreaDot.top,  szCmdStrTemp, TRUE);
	strcat( lpszCmdStr, szCmdStrTemp );

	MakeDotStr( this->devScanInfo.ScanAreaDot.right,  szCmdStrTemp, TRUE );
	strcat( lpszCmdStr, szCmdStrTemp );
	MakeDotStr( this->devScanInfo.ScanAreaDot.bottom, szCmdStrTemp, FALSE );
	strcat( lpszCmdStr, szCmdStrTemp );

	//06/02/28
	//Duplex command
	//
	if(this->modelConfig.SupportScanSrc.bit.ADF_DUP){
	  if(this->uiSetting.nSrcType ==  SCANSRC_ADF_DUP)
	    strcat(lpszCmdStr, MFCMD_SCANDUPLEX);
	  else
	    strcat(lpszCmdStr, MFCMD_SCANSINGLE);
	}

	//
	// TerminaterΥå
	//
	strcat( lpszCmdStr, (LPSTR)MFCMD_TERMINATOR );

	return strlen( lpszCmdStr );
}


//-----------------------------------------------------------------------------
//
//	Function name:	MakeupColorTypeCommand
//
//
//	Abstract:
//		顼סޥʸ
//
//
//	Parameters:
//		nColorType
//			顼ֹ
//
//		lpszColorCmd
//			顼סޥʸؤΥݥ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//
void
MakeupColorTypeCommand( WORD nColorType, LPSTR lpszColorCmd )
{
	strcat( lpszColorCmd, MFCMD_COLORTYPE );

	switch( nColorType ){
		case COLOR_BW:
			strcat( lpszColorCmd, MFCMD_CTYPE_TEXT );
			break;

		case COLOR_ED:
			strcat( lpszColorCmd, MFCMD_CTYPE_ERRDIF );
			break;

		case COLOR_TG:
			strcat( lpszColorCmd, MFCMD_CTYPE_GRAY64 );
			break;

		case COLOR_256:
			strcat( lpszColorCmd, MFCMD_CTYPE_8BITC );
			break;

		case COLOR_FUL:
			strcat( lpszColorCmd, MFCMD_CTYPE_24BITC );
			break;

		case COLOR_FUL_NOCM:
			strcat( lpszColorCmd, MFCMD_CTYPE_24BITC );
			break;
	}
}


//-----------------------------------------------------------------------------
//
//	Function name:	MakePercentStr
//
//
//	Abstract:
//		Brightness/ContrastΥѥ᡼ʸ
//
//
//	Parameters:
//		nPercent
//			Brightness/Contrastѥ᡼
//
//		lpszStr
//			ѥ᡼ʸХåեؤΥݥ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//	MakePercentStrʵMakeContrastStr
void
MakePercentStr( int nPercent, LPSTR lpszStr )
{
	int  nLength;


	//
	// -50+500%100%Ѵ
	//
	nPercent += 50;
	if( nPercent < 0 ){
		nPercent = 0;
	}else if( nPercent > 100 ){
		nPercent = 100;
	}
	//
	//ޥʸѴ
	//
	WordToStr( (WORD)nPercent, lpszStr );
	nLength = strlen( lpszStr );
	lpszStr += nLength;
	*lpszStr++ = MFCMD_LFCHR;
	*lpszStr   = '\0';
}


//-----------------------------------------------------------------------------
//
//	Function name:	MakeDotStr
//
//
//	Abstract:
//		ϰϥѥ᡼ʸ
//
//
//	Parameters:
//		nPosition
//			ϰϤκɸ
//
//		lpszStr
//			ѥ᡼ʸХåեؤΥݥ
//
//		bSeparator
//			ѥ졼ղåե饰
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//
void
MakeDotStr( int nPosition, LPSTR lpszStr, BOOL bSeparator )
{
	int  nLength;


	WordToStr( (WORD)nPosition, lpszStr );
	nLength = strlen( lpszStr );
	lpszStr += nLength;
	if( bSeparator ){
		*lpszStr++ = MFCMD_SEPARATORCHR;
	}else{
		*lpszStr++ = MFCMD_LFCHR;
	}
	*lpszStr   = '\0';
}


//////// end of brother_mfccmd.c ////////
