/*

 This file is part of the Brother MFC/DCP backend for SANE.

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 Place, Suite 330, Boston, MA  02111-1307  USA

*/
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
//
//	Source filename: brother_log.c
//
//		Copyright(c) 1997-2000 Brother Industries, Ltd.  All Rights Reserved.
//
//
//	Abstract:
//			ե⥸塼
//
//
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

#include "brother_dtype.h"

#include "brother_devaccs.h"
#include "brother_misc.h"
//#include "brother.h"

#include "brother_log.h"


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdarg.h>

//
// ե롦⥸塼ѿ
//
static int  nLogFile = 1;
static int  nNewLog  = 1;

static HANDLE  hLogFile = 0;

#define MAX_PATH 256

#define BROTHER_SANE_DIR "/usr/local/Brother/sane/"


//-----------------------------------------------------------------------------
//
//	Function name:	WriteLogFileString
//
//
//	Abstract:
//		ʸե˽Ϥ
//
//
//	Parameters:
//		lpszLogStr
//			ʸؤΥݥ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//	WriteLogFileStringʵLogString_file
void
WriteLogFileString( LPSTR lpszLogStr )
{
#if 1

	if( hLogFile == 0 ){
		//
		// ե뤬ޤץ󤵤Ƥʤ
		//
		char  szLogFile[ MAX_PATH ];

		//
		// ե̾
		//

		strcpy( szLogFile, BROTHER_SANE_DIR );

		strcat( szLogFile, LOGFILENAME );
		if( nNewLog == 0 ){
			//
			// եΥץ
			//

			hLogFile = fopen(szLogFile,"a");
		}else{
			//
			// եΥꥨ
			//

		hLogFile = fopen(szLogFile,"w");
		}
    }


	if( hLogFile != NULL){
		//
		// եϥץ󤵤Ƥ
		//
		char   szStrBuff[ LOGSTRMAXLEN ];
		DWORD  dwStrLen;

		time_t ltime;
		struct tm *sysTime;
		void *b_sysTime;
#if 1
		if(NULL != (sysTime = malloc(sizeof(struct tm))))
#else
		if(NULL != (sysTime = MALLOC(sizeof(struct tm))))
#endif
		{
			b_sysTime = sysTime;
			if( lpszLogStr != NULL ){
				//
				// ߤΥ
				//
	
				time(&ltime);
				sysTime = localtime(&ltime);

				//
				// ʸ˸ߤλɲ
				//
	
				dwStrLen = sprintf(szStrBuff,
								"%02d:%02d:%02d.%03d  %s\n",
								sysTime->tm_hour,
								sysTime->tm_min,
								sysTime->tm_sec,
								(ltime%1000),
								lpszLogStr
							);
			}else{
	
				strcpy( szStrBuff, "\n" );
				dwStrLen = 2;
			}
#if 1
			free(b_sysTime);
#else
			FREE(b_sysTime);
#endif
		}
		//
		// ʸΥ饤
		//

		fwrite( szStrBuff, sizeof(char), dwStrLen, hLogFile);
	}
	CloseLogFile();
#endif
}


//-----------------------------------------------------------------------------
//
//	Function name:	WriteLog
//
//
//	Abstract:
//		ʸϤ
//
//
//	Parameters:
//		ʸʽա
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//	OutputLogStringʵLogString
void WriteLog( LPSTR first, ... )
{
#if 1
	if( nLogFile ){
		//
		// ͭ
		//
		va_list  marker;
		char  szStrBuff[ LOGSTRMAXLEN ];

		va_start( marker, first );		// ѰꥹȤؤΥݥ


		vsprintf( 						// 񼰤ˤäƥʸ
			(LPSTR)szStrBuff, 			// ʸǼХåե
			first, 						// ʸؤΥݥ
			marker 						// Ѱꥹ
		);

		va_end( marker );				// ѰꥹȽνλ


		WriteLogFileString( (LPSTR)szStrBuff );
	}

	return;
#endif
}


//-----------------------------------------------------------------------------
//
//	Function name:	WriteLogScanCmd
//
//
//	Abstract:
//		ʥޥɤ˽
//
//
//	Parameters:
//		lpszId
//			ղʸؤΥݥ
//
//		lpszCmd
//			ޥʸؤΥݥ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//	WriteLogScanCmdʵWriteLogBidiCmd
void
WriteLogScanCmd( LPSTR lpszId, LPSTR lpszCmd )
{
#if 1
	if( nLogFile ){
		//
		// ͭ
		//
		int   nCmdLen, i;
		char  szStrBuff[ LOGSTRMAXLEN ];
		LPSTR lpCmdStr;


		nCmdLen = strlen( lpszCmd );

		lpCmdStr = szStrBuff;


		strcpy( szStrBuff, "[" );
		lpCmdStr++;

		if( nCmdLen > 0 && *lpszCmd == 0x1B ){
			//
			// ESCɤʸѴ
			//

			strcat( szStrBuff, "ESC+" );
			nCmdLen--;
			lpszCmd++;
			lpCmdStr += 4;
		}
		for( i = 0 ; i < nCmdLen ; i++, lpszCmd++ ){
			if( *lpszCmd == '\n'){
				//
				// LFɤ򥹥ڡѴ
				//
				*lpCmdStr++ = ' ';
			}else if( (BYTE)*lpszCmd == (BYTE)0x80 ){
				//
				// Scanner Command Terminatorʤ롼׽λ
				//
				break;
			}else if( ' ' <= *lpszCmd && *lpszCmd < 0x80 ){
				//
				// Printable
				//
				*lpCmdStr++ = *lpszCmd;
			}else{
				//
				// ¾Υ
				//
				*lpszCmd++ = '.';
			}
		}
		*lpCmdStr++ = ']';
		*lpCmdStr   = '\0';

		//
		// ʸ
		//
		WriteLog( "%s %s", lpszId, szStrBuff );
	}
#endif
}


//-----------------------------------------------------------------------------
//
//	Function name:	CloseLogFile
//
//
//	Abstract:
//		ե򥯥
//
//
//	Parameters:
//		ʤ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//
void
CloseLogFile( void )
{
#if 1

	if( hLogFile != NULL){
		//
		// ե뤬ץ󤵤Ƥ
		//

		fclose( hLogFile );

		hLogFile = NULL;
	}
	return;
#endif
}


//-----------------------------------------------------------------------------
//
//	Function name:	GetLogSwitch
//
//
//	Abstract:
//		̵ͭINIե뤫
//
//
//	Parameters:
//		ʤ
//
//
//	Return values:
//		ʤ
//
//-----------------------------------------------------------------------------
//
void
GetLogSwitch( Brother_Scanner *this )
{
	nLogFile = this->modelConfig.bLogFile;
	nNewLog  = 1;
}


//////// end of brother_log.c ////////

