// distribution boxbackup-0.11.1 (svn version: 2821_2827)
// Box Backup, http://www.boxbackup.org/
// 
// Copyright (c) 2003-2010, Ben Summers and contributors.
// All rights reserved.
// 
// Note that this project uses mixed licensing. Any file with this license
// attached, or where the code LICENSE-GPL appears on the first line, falls
// under the "Box Backup GPL" license. See the file COPYING.txt for more
// information about this license.
// 
// ---------------------------------------------------------------------
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
// 
// [http://www.gnu.org/licenses/old-licenses/gpl-2.0.html#SEC4]
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any software that can be downloaded from
// the OpenSSL website [http://www.openssl.org] under either the
// "OpenSSL License" or the "Original SSLeay License", and to distribute
// the linked executables under the terms of the "Box Backup GPL" license.
// 
// As a special exception to the GPLv2, the Box Backup Project gives
// permission to link any code falling under this license (the Box Backup
// GPL) with any version of Microsoft's Volume Shadow Copy Service 7.2 SDK
// or Microsoft Windows Software Development Kit (SDK), including
// vssapi.lib, that can be downloaded from the Microsoft website
// [*.microsoft.com], and to distribute the linked executables under the
// terms of the "Box Backup GPL" license.
// --------------------------------------------------------------------------
//
// File
//		Name:    bbackupobjdump.cpp
//		Purpose: Dump contents of backup objects
//		Created: 3/5/04
//
// --------------------------------------------------------------------------

#include "Box.h"

#include <cstdio>
#include <cstring>

#include "MainHelper.h"
#include "FileStream.h"
#include "BackupStoreDirectory.h"
#include "BackupStoreFile.h"
#include "BackupStoreObjectMagic.h"

#include "MemLeakFindOn.h"

// --------------------------------------------------------------------------
//
// Function
//		Name:    int main(int, const char *[])
//		Purpose: Main fn for bbackupobjdump
//		Created: 3/5/04
//
// --------------------------------------------------------------------------
int main(int argc, const char *argv[])
{
	MAINHELPER_START

	if(argc != 2)
	{
		::printf("Input file not specified.\nUsage: bbackupobjdump <input file>\n");
		return 1;
	}

	// Open file
	FileStream file(argv[1]);
	
	// Read magic number
	uint32_t signature;
	if(file.Read(&signature, sizeof(signature)) != sizeof(signature))
	{
		// Too short, can't read signature from it
		return false;
	}
	// Seek back to beginning
	file.Seek(0, IOStream::SeekType_Absolute);
	
	// Then... check depending on the type
	switch(ntohl(signature))
	{
	case OBJECTMAGIC_FILE_MAGIC_VALUE_V1:
#ifndef BOX_DISABLE_BACKWARDS_COMPATIBILITY_BACKUPSTOREFILE
	case OBJECTMAGIC_FILE_MAGIC_VALUE_V0:
#endif
		BackupStoreFile::DumpFile(stdout, false, file);
		break;

	case OBJECTMAGIC_DIR_MAGIC_VALUE:
		{
			BackupStoreDirectory dir;
			dir.ReadFromStream(file, IOStream::TimeOutInfinite);
			dir.Dump(stdout, false);
			if(dir.CheckAndFix())
			{
				::printf("Directory didn't pass checking\n");
			}
		}
		break;

	default:
		::printf("File does not appear to be a valid box backup object.\n");
		break;
	}

	MAINHELPER_END
}

