/*
 * $Id: BKE_exotic.h 34962 2011-02-18 13:05:18Z jesterking $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL LICENSE BLOCK *****
 */

#ifndef BKE_EXOTIC_H
#define BKE_EXOTIC_H

/** \file BKE_exotic.h
 *  \ingroup bke
 *  \brief dxf/vrml/stl external file io function prototypes.
 *  \attention is this used still? Candidate for removal?
 */
struct Mesh;
struct Scene;

/**
 * Reads all 3D fileformats other than Blender fileformat
 * @retval 0 The file could not be read.
 * @retval 1 The file was read succesfully.
 * @attention Used in filesel.c
 */
int BKE_read_exotic(struct Scene *scene, const char *name);

/* return codes */
#define BKE_READ_EXOTIC_FAIL_PATH		-3 /* file format is not supported */
#define BKE_READ_EXOTIC_FAIL_FORMAT		-2 /* file format is not supported */
#define BKE_READ_EXOTIC_FAIL_OPEN		-1 /* Can't open the file */
#define BKE_READ_EXOTIC_OK_BLEND		 0 /* .blend file */
#define BKE_READ_EXOTIC_OK_OTHER		 1 /* other supported formats */

void write_dxf(struct Scene *scene, char *str);
void write_stl(struct Scene *scene, char *str);

#endif

