/*
 * $Id: AUD_LimiterReader.cpp 35141 2011-02-25 10:21:56Z jesterking $
 *
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * Copyright 2009-2011 Jörg Hermann Müller
 *
 * This file is part of AudaSpace.
 *
 * Audaspace is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * AudaSpace is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Audaspace; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * ***** END GPL LICENSE BLOCK *****
 */

/** \file audaspace/FX/AUD_LimiterReader.cpp
 *  \ingroup audfx
 */


#include "AUD_LimiterReader.h"
#include "AUD_Buffer.h"

#include <iostream>

AUD_LimiterReader::AUD_LimiterReader(AUD_IReader* reader,
									 float start, float end) :
		AUD_EffectReader(reader),
		m_start(int(start * reader->getSpecs().rate)),
		m_end(int(end * reader->getSpecs().rate))
{
	if(m_start > 0)
	{
		if(m_reader->isSeekable())
			m_reader->seek(m_start);
		else
		{
			// skip first m_start samples by reading them
			int length = AUD_DEFAULT_BUFFER_SIZE;
			sample_t* buffer;
			for(int len = m_start;
				length == AUD_DEFAULT_BUFFER_SIZE;
				len -= AUD_DEFAULT_BUFFER_SIZE)
			{
				if(len < AUD_DEFAULT_BUFFER_SIZE)
					length = len;
				m_reader->read(length, buffer);
			}
		}
	}
}

void AUD_LimiterReader::seek(int position)
{
	m_reader->seek(position + m_start);
}

int AUD_LimiterReader::getLength() const
{
	int len = m_reader->getLength();
	if(len < 0 || (len > m_end && m_end >= 0))
		len = m_end;
	return len - m_start;
}

int AUD_LimiterReader::getPosition() const
{
	int pos = m_reader->getPosition();
	return AUD_MIN(pos, m_end) - m_start;
}

void AUD_LimiterReader::read(int & length, sample_t* & buffer)
{
	if(m_end >= 0)
	{
		int position = m_reader->getPosition();
		if(position + length > m_end)
			length = m_end - position;
		if(length < 0)
		{
			length = 0;
			return;
		}
	}
	m_reader->read(length, buffer);
}
