/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** msgbar.c
**
** Author<s>:     Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
**                Michael Terry <mterry@fastmail.fm>
** Latest update: Wed May  3 04:27:37 2000
** Description:   Beaver message bar manipulation source
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>
#include <sys/stat.h>
#include "conf.h"
#include "editor.h"
#include "struct.h"
#include "tools.h"
#include "prefs.h"
#include "msgbar.h"

extern GtkWidget *MainNotebook;
extern GArray *FileProperties;
extern t_settings Settings;
extern gint OpenedFilesCnt;
static GtkWidget *MsgBar;
static GtkWidget *MsgLabel;
static GtkWidget *LCLabel;
static gboolean MessagesCnt = 0;
static gchar *LastMessage;


/**************************** PUBLIC FUNCTIONS *******************************/


void init_msgbar (GtkBox *ParentBox)
{
  GtkWidget *MsgBox; 
  GtkWidget *ViewPort;

  MsgBar = gtk_hbox_new (FALSE, 0);
  ViewPort = gtk_viewport_new (NULL, NULL);
  gtk_box_pack_start (GTK_BOX(MsgBar), ViewPort, TRUE, TRUE, 0);
  MsgBox = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER(ViewPort), MsgBox);
  MsgLabel = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX(MsgBox), MsgLabel, FALSE, FALSE, 0);
  LCLabel = gtk_label_new ("");
  gtk_box_pack_end (GTK_BOX(MsgBox), LCLabel, FALSE, FALSE, 5);
  gtk_box_pack_end (ParentBox, MsgBar, FALSE, FALSE, 0); 
  g_signal_connect (G_OBJECT (MsgBar), "delete-event", G_CALLBACK (gtk_widget_destroyed), &MsgBar);
  g_timeout_add (80, (GSourceFunc)display_line_column, NULL);
}


void hide_msgbar (void)
{
  gtk_widget_hide (MsgBar);
}


void show_msgbar (void)
{
  gtk_widget_show (MsgBar);
}


void clear_msgbar (void)
{
  if (!MSGBAR_DISPLAY) return;
  LastMessage = g_strdup("");
  gtk_label_set_text (GTK_LABEL(MsgLabel), "");
}


void print_msg (gchar *Message)
{
  gint *TimeOutId;

  if (!MSGBAR_DISPLAY) return;
  TimeOutId = g_malloc(sizeof (gint));
  LastMessage = g_strdup (Message);
  gtk_label_set_text (GTK_LABEL(MsgLabel), g_strconcat ("  ", Message, NULL));
  *TimeOutId = gtk_timeout_add (MSGBAR_INTERVAL, (GtkFunction)end_msg,
				TimeOutId);
  MessagesCnt++;
}


gint get_line (void)
{
  GtkWidget *Editor;
  GtkTextIter current;
  GtkTextBuffer *EditorBuffer;

  Editor = FPROPS(gtk_notebook_get_current_page(GTK_NOTEBOOK(MainNotebook)),
		  Text);
  EditorBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Editor));
  gtk_text_buffer_get_iter_at_mark (EditorBuffer, &current, 
                  gtk_text_buffer_get_insert(EditorBuffer));
  
  return gtk_text_iter_get_line(&current) + 1;
}


gint get_column (void)
{
  GtkWidget *Editor;
  GtkTextIter current;
  GtkTextBuffer *EditorBuffer;

  Editor = FPROPS(gtk_notebook_get_current_page(GTK_NOTEBOOK(MainNotebook)),
		  Text);
  EditorBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Editor));
  gtk_text_buffer_get_iter_at_mark (EditorBuffer, &current, 
                  gtk_text_buffer_get_insert(EditorBuffer));
  
  return gtk_text_iter_get_line_offset(&current) + 1;
}


gint get_percent (void)
{
  GtkWidget *Editor;
  GtkTextIter current;
  GtkTextBuffer *EditorBuffer;
  gint i, j;

  Editor = FPROPS(gtk_notebook_get_current_page(GTK_NOTEBOOK(MainNotebook)),
		  Text);
  EditorBuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(Editor));
  gtk_text_buffer_get_iter_at_mark (EditorBuffer, &current, 
                  gtk_text_buffer_get_insert(EditorBuffer));
  
  i = 100 * gtk_text_iter_get_offset (&current);
  if ((j = get_num_characters(GTK_TEXT_VIEW(Editor))) == 0)
    return 0;
  else
    return i/j;
}


gint get_selection_size (void)
{
  gint CurrentPage;
  gint rv;
	
  CurrentPage = gtk_notebook_get_current_page(GTK_NOTEBOOK(MainNotebook));
  rv = max_from_selection (GTK_TEXT_VIEW(FPROPS(CurrentPage, Text))) -
    min_from_selection (GTK_TEXT_VIEW(FPROPS(CurrentPage, Text)));
  
  return rv;
}


gboolean display_line_column (gboolean data)
{
  gchar *line_column;
  gint sel_size;

  if (!MsgBar)
    return FALSE;
  if (!MSGBAR_DISPLAY) return TRUE;
  if (!OpenedFilesCnt)
    {
      gtk_label_set_text (GTK_LABEL(LCLabel), "");
      return TRUE;
    }
  while (gtk_events_pending ())
    gtk_main_iteration ();
  if ((sel_size = get_selection_size ()))
    line_column = g_strdup_printf ("Selected %d   Line %d   Column %d   %d%%",
				   sel_size, get_line (), get_column (),
				   get_percent ());
  else
    line_column = g_strdup_printf ("Line %d   Column %d   %d%%",
				   get_line (), get_column (), get_percent ());
  gtk_label_set_text (GTK_LABEL(LCLabel), line_column);
  g_free (line_column);
  return TRUE;
}


/************************ AUTHORIZED PERSONAL ONLY ***************************/


void end_msg (gint *TimeOutId)
{
  if (MessagesCnt <= 1) gtk_label_set_text (GTK_LABEL(MsgLabel), "");
  else gtk_label_set_text (GTK_LABEL(MsgLabel),
			   g_strconcat ("  ", LastMessage, NULL));
  gtk_timeout_remove (*TimeOutId);
  MessagesCnt--;
}
