/*$
Copyright (C) 2013-2016 Azel.

This file is part of AzPainter.

AzPainter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

AzPainter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/
/*
    レイヤ関連ダイアログ
*/


#include "dialog_layer.h"

#include "AXLayout.h"
#include "AXLabel.h"
#include "AXLineEdit.h"
#include "AXComboBox.h"
#include "AXCheckButton.h"
#include "AXColorButton.h"
#include "AXApp.h"

#include "global.h"
#include "drawdat.h"
#include "strid.h"



//*****************************************
// CNewLayerDlg : 新規レイヤダイアログ
//*****************************************


CNewLayerDlg::CNewLayerDlg(AXWindow *pOwner,INFO *pInfo)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl,*pl2;
    int i;

    m_pInfo = pInfo;

    setTitle(_string(strid::GROUP_LAYER, strid::LAYER_NEWDLG_TITLE));

    //

    setLayout(plTop = new AXLayoutVert);
    plTop->setSpacing(10);

    //---------

    _trgroup(strid::GROUP_WORD);

    plTop->addItem(pl = new AXLayoutMatrix(2, LF_EXPAND_W));

    //名前

    pl->addItem(new AXLabel(this, 0, LF_CENTER_Y|LF_RIGHT, MAKE_DW4(0,0,6,7), strid::WORD_NAME));
    pl->addItem(m_peditName = new AXLineEdit(this, 0, LF_EXPAND_W|LF_CENTER_Y, 0, MAKE_DW4(0,0,0,7)));

    //合成モード

    pl->addItem(new AXLabel(this, 0, LF_CENTER_Y|LF_RIGHT, MAKE_DW4(0,0,6,7), strid::WORD_BLENDMODE));
    pl->addItem(m_pcbBlend = new AXComboBox(this, 0, LF_EXPAND_W|LF_CENTER_Y, 0, MAKE_DW4(0,0,0,7)));

    //カラータイプ

    pl->addItem(new AXLabel(this, 0, LF_CENTER_Y|LF_RIGHT, MAKE_DW4(0,0,6,0), strid::WORD_COLORTYPE));
    pl->addItem(pl2 = new AXLayoutVert(0, 5));

    pl2->setPaddingBottom(7);

    _trgroup(strid::GROUP_LAYER);

    for(i = 0; i < 4; i++)
    {
        pl2->addItem(new AXCheckButton(this, AXCheckButton::CBS_RADIO, 0, WID_COLTYPE + i, 0,
                strid::LAYER_COLTYPE_TOP + i, (i == 0)));
    }

    //色

    pl->addItem(new AXLabel(this, 0, LF_CENTER_Y|LF_RIGHT, MAKE_DW4(0,0,6,0), _string(strid::GROUP_WORD, strid::WORD_COLOR)));
    pl->addItem(m_pbtCol = new AXColorButton(this, WS_DISABLE|AXColorButton::CBTS_CHOOSE, LF_CENTER_Y));

    //------- 初期設定

    //名前

    m_peditName->setText(pInfo->strName);
    m_peditName->setMinWidth(200);

    //合成モード

    _trgroup(strid::GROUP_BLENDNAME);

    m_pcbBlend->addItemMulTr(0, draw::BLENDMODE_NUM);
    m_pcbBlend->setAutoWidth();
    m_pcbBlend->setCurSel(0);

    //

    m_pbtCol->setColor(0);

    //

    createOKCancelAndShow();
}

//! 通知

BOOL CNewLayerDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    UINT id = pwin->getItemID();

    if(id >= WID_COLTYPE && id < WID_COLTYPE + 4)
    {
        //カラータイプ変更

        m_pbtCol->enable((id >= WID_COLTYPE + 2));
        return TRUE;
    }

    switch(pwin->getItemID())
    {
        //OK
        case 1:
            m_peditName->getText(&m_pInfo->strName);

            m_pInfo->nBlendMode = m_pcbBlend->getCurSel();
            m_pInfo->nColType   = ((AXCheckButton *)getWidget(WID_COLTYPE))->getGroupSel();
            m_pInfo->dwCol      = m_pbtCol->getColor();

            endDialog(TRUE);
            break;
        //キャンセル
        case 2:
            endDialog(FALSE);
            break;
    }

    return TRUE;
}


//*********************************************
// CLayerColTypeDlg : カラータイプ変更ダイアログ
//*********************************************


CLayerColTypeDlg::CLayerColTypeDlg(AXWindow *pOwner,int nInitType)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl;
    int i;

    m_nInitType = nInitType;

    _trgroup(strid::GROUP_LAYER);

    setTitle(strid::LAYER_COLTYPEDLG_TITLE);

    //

    setLayout(plTop = new AXLayoutVert);
    plTop->setSpacing(10);

    plTop->addItem(pl = new AXLayoutVert(0, 5));

    //カラータイプ

    for(i = 0; i < 4; i++)
    {
        m_pckType[i] = new AXCheckButton(this,
                    AXCheckButton::CBS_RADIO | ((i == nInitType)? WS_DISABLE: 0),
                    0, WID_TYPE + i, 0, strid::LAYER_COLTYPE_TOP + i, FALSE);

        pl->addItem(m_pckType[i]);
    }

    m_pckType[(nInitType == 0)]->setCheck(TRUE);

    //輝度をアルファ値に

    pl->addItem(m_pckLum = new AXCheckButton(this, WS_DISABLE, 0, 0, MAKE_DW4(0,7,0,0), strid::LAYER_LUMTOALPHA, FALSE));

    //

    createOKCancelAndShow();
}

//! 通知

BOOL CLayerColTypeDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    UINT id = pwin->getItemID();

    if(id >= WID_TYPE && id < WID_TYPE + 4)
        m_pckLum->enable((m_nInitType < 2 && id >= WID_TYPE + 2));
    else if(id == 1)
        endDialog(m_pckType[0]->getGroupSel() | (m_pckLum->isChecked()? 0x80: 0));
    else if(id == 2)
        endDialog(-1);

    return TRUE;
}


//*********************************************
// CLayerCombineSomeDlg : 複数レイヤ結合ダイアログ
//*********************************************


CLayerCombineSomeDlg::CLayerCombineSomeDlg(AXWindow *pOwner,INFO *pInfo)
    : AXDialog(pOwner, WS_DIALOG_NORMAL | WS_BK_FACE)
{
    AXLayout *plTop,*pl;
    int i;

    m_pinfo = pInfo;

    _trgroup(strid::GROUP_LAYER);

    setTitle(strid::LAYER_COMBINESOMEDLG_TITLE);

    //

    setLayout(plTop = new AXLayoutVert);
    plTop->setSpacing(10);

    //タイプ

    for(i = 0; i < 3; i++)
    {
        m_pckType[i] = new AXCheckButton(this,
                    AXCheckButton::CBS_RADIO | ((i == 2 || (i == 0 && !pInfo->bFolder))? WS_DISABLE: 0), 0,
                    WID_TYPE + i, MAKE_DW4(0,0,0,4), strid::LAYER_COMBINESOME_TYPE_TOP + i, FALSE);

        plTop->addItem(m_pckType[i]);
    }

    m_pckType[(pInfo->bFolder)? 0: 1]->setCheck(TRUE);

    //新規レイヤに結合

    plTop->addItem(m_pckNewLayer = new AXCheckButton(this, 0, 0, WID_NEWLAYER, MAKE_DW4(0,3,0,8), strid::LAYER_COMBINE_NEWLAYER, FALSE));

    //結合イメージのカラータイプ

    plTop->addItem(pl = new AXLayoutHorz(0, 6));

    pl->addItem(new AXLabel(this, 0, LF_CENTER_Y, 0, strid::LAYER_COMBINE_COLTYPE));
    pl->addItem(m_pcbColType = new AXComboBox(this, 0, 0));

    m_pcbColType->addItemMulTr(strid::LAYER_COLTYPE_TOP, 4);
    m_pcbColType->setAutoWidth();
    m_pcbColType->setCurSel(0);

    //ヘルプ

    plTop->addItem(new AXLabel(this, AXLabel::LS_BORDER, LF_EXPAND_W, MAKE_DW4(0,15,0,0), strid::LAYER_COMBINE_HELP));

    //

    createOKCancelAndShow();
}

//! 通知

BOOL CLayerCombineSomeDlg::onNotify(AXWindow *pwin,UINT uNotify,ULONG lParam)
{
    UINT id = pwin->getItemID();

    switch(id)
    {
        //新規レイヤに結合
        case WID_NEWLAYER:
            if(m_pinfo->bCheckExist)
            {
                m_pckType[2]->enable(m_pckNewLayer->isChecked());

                if(!m_pckNewLayer->isChecked() && m_pckType[0]->getGroupSel() == 2)
                    m_pckType[1]->setCheck(TRUE);
            }
            break;
        //OK
        case 1:
            m_pinfo->type       = m_pckType[0]->getGroupSel();
            m_pinfo->bNewLayer  = m_pckNewLayer->isChecked();
            m_pinfo->coltype    = m_pcbColType->getCurSel();

            endDialog(TRUE);
            break;
        //キャンセル
        case 2:
            endDialog(FALSE);
            break;
    }

    return TRUE;
}
